/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.elements;

import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.elements.ManifestInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FileDescriptor {
    static final int FILE_DESC_VERSION = 1;
    static final int FILE_DESC_LENGTH = 68;
    static final byte FILE_DESCRIPTOR = 0;
    static final byte FILE_SYNC_INFO = 1;
    private static final int CHUNK_SIZE = 32768;
    private ByteBuffer data;
    private Inflater inflater;
    private CharsetDecoder decoder;
    int fdesc_length;
    byte fdesc_version;
    byte fdesc_type;
    byte fdesc_chkp_candidate;
    byte fdesc_sync_dir;
    int fdesc_sequence;
    int fdesc_atime;
    int fdesc_mtime;
    int fdesc_ex_attributes;
    long fdesc_size;
    long fdesc_inode;
    int fdesc_mode;
    short fdesc_nlinks;
    int fdesc_device_id;
    int fdesc_crc;
    short fdesc_linkdata_offset;
    short fdesc_owner_offset;
    short fdesc_group_offset;
    short fdesc_dacl_offset;
    short fdesc_sacl_offset;
    short fdesc_dirinfo_offset;
    int fdesc_dirinfo_len;
    String fdesc_name;

    public FileDescriptor(FileTransfer ft) throws DataFormatException {
        this();
        this.fdesc_version = 1;
        this.fdesc_length = 68;
        this.fdesc_chkp_candidate = 1;
        this.fdesc_sync_dir = 0;
        this.fdesc_sequence = ft.getSequence();
        this.fdesc_atime = (int)ft.getLastModifiedAt();
        this.fdesc_mtime = (int)ft.getLastModifiedAt();
        this.fdesc_ex_attributes = 0;
        this.fdesc_size = ft.getSize();
        this.fdesc_inode = 0L;
        this.fdesc_mode = ft.getMode();
        this.fdesc_nlinks = 1;
        this.fdesc_device_id = 0;
        this.fdesc_crc = 0;
        this.fdesc_linkdata_offset = 0;
        this.fdesc_owner_offset = 0;
        this.fdesc_group_offset = 0;
        this.fdesc_dacl_offset = 0;
        this.fdesc_sacl_offset = 0;
        this.fdesc_dirinfo_offset = 0;
        this.fdesc_dirinfo_len = 0;
        this.setName(ft.getPathHandledName());
    }

    public FileDescriptor(ManifestInfo mi) throws DataFormatException {
        this();
        this.inflater = new Inflater();
        this.data = this.deflate(mi.getData().array());
    }

    public FileDescriptor() {
        Charset ch = Charset.forName("utf8");
        this.decoder = ch.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.IGNORE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
    }

    public void append(ManifestInfo mi) throws DataFormatException {
        int remaining = this.data.remaining();
        ByteBuffer more = this.deflate(mi.getData().array());
        byte[] merged = new byte[remaining + more.limit()];
        this.data.get(merged, 0, remaining);
        more.get(merged, remaining, more.limit());
        this.data = ByteBuffer.wrap(merged);
    }

    protected ByteBuffer deflate(byte[] compressed) throws DataFormatException {
        this.inflater.setInput(compressed);
        byte[] buffer = new byte[32768];
        int length = this.inflater.inflate(buffer);
        while (!this.inflater.finished()) {
            byte[] biggerBuffer = new byte[length + 32768];
            System.arraycopy(buffer, 0, biggerBuffer, 0, length);
            buffer = biggerBuffer;
            int nextChunk = this.inflater.inflate(buffer, length, 32768);
            if (nextChunk == 0) break;
            length += nextChunk;
        }
        return ByteBuffer.wrap(buffer, 0, length);
    }

    public boolean getNextDescriptor() throws CharacterCodingException {
        int length;
        if (this.data.remaining() < 4) {
            return false;
        }
        this.data.mark();
        this.fdesc_length = this.data.getInt();
        if (this.data.remaining() < this.fdesc_length - 4) {
            this.data.reset();
            return false;
        }
        this.fdesc_version = this.data.get();
        this.fdesc_type = this.data.get();
        this.fdesc_chkp_candidate = this.data.get();
        this.fdesc_sync_dir = this.data.get();
        this.fdesc_sequence = this.data.getInt();
        this.fdesc_atime = this.data.getInt();
        this.fdesc_mtime = this.data.getInt();
        this.fdesc_ex_attributes = this.data.getInt();
        this.fdesc_size = this.data.getLong();
        this.fdesc_inode = this.data.getLong();
        this.fdesc_mode = this.data.getShort();
        this.fdesc_nlinks = this.data.getShort();
        this.fdesc_device_id = this.data.getInt();
        this.fdesc_crc = this.data.getInt();
        this.fdesc_linkdata_offset = this.data.getShort();
        this.fdesc_owner_offset = this.data.getShort();
        this.fdesc_group_offset = this.data.getShort();
        this.fdesc_dacl_offset = this.data.getShort();
        this.fdesc_sacl_offset = this.data.getShort();
        this.fdesc_dirinfo_offset = this.data.getShort();
        this.fdesc_dirinfo_len = this.data.getInt();
        byte[] name = new byte[this.fdesc_length - 68];
        this.data.get(name);
        for (length = 0; length < name.length && name[length] != 0; ++length) {
        }
        this.fdesc_name = this.decoder.decode(ByteBuffer.wrap(name, 0, length)).toString();
        return true;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] decodedName = (this.fdesc_name + "\u0000").getBytes("UTF-8");
        int roundedLength = this.fdesc_length = 68 + decodedName.length;
        roundedLength = roundedLength + 7 & 0xFFFFFFF8;
        dos.writeInt(roundedLength);
        dos.write(this.fdesc_version);
        dos.write(this.fdesc_type);
        dos.write(this.fdesc_chkp_candidate);
        dos.write(this.fdesc_sync_dir);
        dos.writeInt(this.fdesc_sequence);
        dos.writeInt(this.fdesc_atime);
        dos.writeInt(this.fdesc_mtime);
        dos.writeInt(this.fdesc_ex_attributes);
        dos.writeLong(this.fdesc_size);
        dos.writeLong(this.fdesc_inode);
        dos.writeShort(this.fdesc_mode);
        dos.writeShort(this.fdesc_nlinks);
        dos.writeInt(this.fdesc_device_id);
        dos.writeInt(this.fdesc_crc);
        dos.writeShort(this.fdesc_linkdata_offset);
        dos.writeShort(this.fdesc_owner_offset);
        dos.writeShort(this.fdesc_group_offset);
        dos.writeShort(this.fdesc_dacl_offset);
        dos.writeShort(this.fdesc_sacl_offset);
        dos.writeShort(this.fdesc_dirinfo_offset);
        dos.writeInt(this.fdesc_dirinfo_len);
        dos.write(decodedName);
        int paddingSize = roundedLength - this.fdesc_length;
        byte[] padding = new byte[paddingSize];
        dos.write(padding);
        dos.flush();
        dos.close();
        return bos.toByteArray();
    }

    public int getLength() {
        return this.fdesc_length;
    }

    public byte getVersion() {
        return this.fdesc_version;
    }

    public void setVersion(byte fdesc_version) {
        this.fdesc_version = fdesc_version;
    }

    public byte getType() {
        return this.fdesc_type;
    }

    public void setType(byte fdesc_type) {
        this.fdesc_type = fdesc_type;
    }

    public byte getChkp_candidate() {
        return this.fdesc_chkp_candidate;
    }

    public void setChkp_candidate(byte fdesc_chkp_candidate) {
        this.fdesc_chkp_candidate = fdesc_chkp_candidate;
    }

    public byte getSync_dir() {
        return this.fdesc_sync_dir;
    }

    public void setSync_dir(byte fdesc_sync_dir) {
        this.fdesc_sync_dir = fdesc_sync_dir;
    }

    public int getSequence() {
        return this.fdesc_sequence;
    }

    public void setSequence(int fdesc_sequence) {
        this.fdesc_sequence = fdesc_sequence;
    }

    public int getAtime() {
        return this.fdesc_atime;
    }

    public void setAtime(int fdesc_atime) {
        this.fdesc_atime = fdesc_atime;
    }

    public int getMtime() {
        return this.fdesc_mtime;
    }

    public void setMtime(int fdesc_mtime) {
        this.fdesc_mtime = fdesc_mtime;
    }

    public int getEx_attributes() {
        return this.fdesc_ex_attributes;
    }

    public void setEx_attributes(int fdesc_ex_attributes) {
        this.fdesc_ex_attributes = fdesc_ex_attributes;
    }

    public long getSize() {
        return this.fdesc_size;
    }

    public void setSize(long fdesc_size) {
        this.fdesc_size = fdesc_size;
    }

    public long getInode() {
        return this.fdesc_inode;
    }

    public void setInode(long fdesc_inode) {
        this.fdesc_inode = fdesc_inode;
    }

    public int getMode() {
        return this.fdesc_mode;
    }

    public void setMode(short fdesc_mode) {
        this.fdesc_mode = fdesc_mode;
    }

    public short getNlinks() {
        return this.fdesc_nlinks;
    }

    public void setNlinks(short fdesc_nlinks) {
        this.fdesc_nlinks = fdesc_nlinks;
    }

    public int getDevice_id() {
        return this.fdesc_device_id;
    }

    public void setDevice_id(int fdesc_device_id) {
        this.fdesc_device_id = fdesc_device_id;
    }

    public int getCrc() {
        return this.fdesc_crc;
    }

    public void setCrc(int fdesc_crc) {
        this.fdesc_crc = fdesc_crc;
    }

    public short getLinkdata_offset() {
        return this.fdesc_linkdata_offset;
    }

    public void setLinkdata_offset(short fdesc_linkdata_offset) {
        this.fdesc_linkdata_offset = fdesc_linkdata_offset;
    }

    public short getOwner_offset() {
        return this.fdesc_owner_offset;
    }

    public void setOwner_offset(short fdesc_owner_offset) {
        this.fdesc_owner_offset = fdesc_owner_offset;
    }

    public short getGroup_offset() {
        return this.fdesc_group_offset;
    }

    public void setGroup_offset(short fdesc_group_offset) {
        this.fdesc_group_offset = fdesc_group_offset;
    }

    public short getDacl_offset() {
        return this.fdesc_dacl_offset;
    }

    public void setDacl_offset(short fdesc_dacl_offset) {
        this.fdesc_dacl_offset = fdesc_dacl_offset;
    }

    public short getSacl_offset() {
        return this.fdesc_sacl_offset;
    }

    public void setSacl_offset(short fdesc_sacl_offset) {
        this.fdesc_sacl_offset = fdesc_sacl_offset;
    }

    public short getDirinfo_offset() {
        return this.fdesc_dirinfo_offset;
    }

    public void setDirinfo_offset(short fdesc_dirinfo_offset) {
        this.fdesc_dirinfo_offset = fdesc_dirinfo_offset;
    }

    public int getDirinfo_len() {
        return this.fdesc_dirinfo_len;
    }

    public void setDirinfo_len(int fdesc_dirinfo_len) {
        this.fdesc_dirinfo_len = fdesc_dirinfo_len;
    }

    public String getName() {
        return this.fdesc_name;
    }

    public void setName(String fdesc_name) {
        this.fdesc_name = fdesc_name;
    }

    public String toString() {
        Field[] fields;
        StringBuilder sb = new StringBuilder("file_header:");
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                sb.append(" " + field.getName() + "=");
                sb.append(field.get(this));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }
}

