/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.elements;

import com.signiant.interactivetransfer.engine.elements.Abort;
import com.signiant.interactivetransfer.engine.elements.AckAbort;
import com.signiant.interactivetransfer.engine.elements.ActivateManifest;
import com.signiant.interactivetransfer.engine.elements.DataElement;
import com.signiant.interactivetransfer.engine.elements.DataTerminator;
import com.signiant.interactivetransfer.engine.elements.FileComplete;
import com.signiant.interactivetransfer.engine.elements.InvalidDataElement;
import com.signiant.interactivetransfer.engine.elements.KeepAlive;
import com.signiant.interactivetransfer.engine.elements.ManifestInfo;
import com.signiant.interactivetransfer.engine.elements.ManifestResponse;
import com.signiant.interactivetransfer.engine.elements.ManifestTerminator;
import com.signiant.interactivetransfer.engine.elements.SetLocation;
import com.signiant.interactivetransfer.engine.elements.StreamActivate;
import com.signiant.interactivetransfer.engine.elements.StreamData;
import com.signiant.interactivetransfer.engine.elements.StreamSend;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ElementType {
    ACTIVATE_MANIFEST(1),
    DATA(2),
    DATA_TERMINATOR(3),
    ABORT(4),
    PURGE(5),
    SETLOC(6),
    ATTRIBUTES(7),
    COMMAND(8),
    MESSAGE(9),
    RESPONSE(10),
    STATS(11),
    PROTOCOL(12),
    RSYNC_DATA(13),
    FILE_INFO(14),
    STREAM_ACTIVATE(15),
    FILE_COMPLETE(16),
    STREAM_DONE(17),
    STREAM_SEND(18),
    STREAM_SKIP(19),
    STREAM_SKIPERROR(20),
    STREAM_DELETED(21),
    STREAM_RSYNC_CHKSUMS(22),
    STREAM_RSYNC_INFO(23),
    STREAM_RSYNC_ERROR(24),
    ACKABORT(25),
    COMPRESSED_DATA(26),
    COMPRESSED_RSYNC_DATA(27),
    STREAM_ABANDON(28),
    COMPRESSED_ATTRIBUTES(29),
    RESTORE_DATA_COMPLETE(30),
    KEEP_ALIVE(31),
    MANIFEST_INFO(32),
    MANIFEST_RESP(33),
    MANIFEST_TERMINATOR(34),
    TNLCHN_INPUT_SHUTDN(40),
    TNLCHN_OUTPUT_SHUTDN(41),
    IND_EOF(241),
    IND_ERROR(255);

    private byte type;

    public static ElementType getType(byte type) throws InvalidDataElement {
        ElementType[] values;
        for (ElementType t : values = ElementType.values()) {
            if (t.type != type) continue;
            return t;
        }
        throw new InvalidDataElement("Invalid data element received from agent [" + type + "]");
    }

    static DataElement factory(ElementType type, byte handle, ByteBuffer data) throws InvalidDataElement {
        switch (type) {
            case ABORT: {
                return new Abort(handle, data);
            }
            case ACKABORT: {
                return new AckAbort(handle, data);
            }
            case DATA: {
                return new StreamData(handle, data);
            }
            case DATA_TERMINATOR: {
                return new DataTerminator(handle, data);
            }
            case ACTIVATE_MANIFEST: {
                return new ActivateManifest(handle, data);
            }
            case KEEP_ALIVE: {
                return new KeepAlive(handle, data);
            }
            case MANIFEST_INFO: {
                return new ManifestInfo(handle, data);
            }
            case MANIFEST_RESP: {
                return new ManifestResponse(handle, data);
            }
            case MANIFEST_TERMINATOR: {
                return new ManifestTerminator(handle, data);
            }
            case STREAM_ACTIVATE: {
                return new StreamActivate(handle, data);
            }
            case FILE_COMPLETE: {
                return new FileComplete(handle, data);
            }
            case STREAM_SEND: {
                return new StreamSend(handle, data);
            }
            case SETLOC: {
                return new SetLocation(handle, data);
            }
        }
        throw new InvalidDataElement(type);
    }

    public byte getTypeCode() {
        return this.type;
    }

    private ElementType(int code) {
        this.type = (byte)code;
    }
}

