/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.elements;

import com.signiant.interactivetransfer.engine.elements.ElementType;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.Stream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class DataElement {
    protected ElementType type;
    protected byte handle;
    protected ByteBuffer data;

    public static DataElement read(Stream stream) throws IOException, InterruptedException, TransferException {
        ByteBuffer headerBuffer = ByteBuffer.wrap(new byte[4]);
        do {
            headerBuffer.put(stream.get(headerBuffer.remaining()));
        } while (headerBuffer.hasRemaining());
        headerBuffer.flip();
        ElementType type = ElementType.getType(headerBuffer.get());
        byte handle = headerBuffer.get();
        int length = headerBuffer.getShort() & 0xFFFF;
        ByteBuffer buffer = ByteBuffer.wrap(new byte[length]);
        if (length > 0) {
            do {
                buffer.put(stream.get(buffer.remaining()));
            } while (buffer.hasRemaining());
        }
        buffer.flip();
        DataElement result = ElementType.factory(type, handle, buffer);
        if (stream.getLogger().isLoggable(Level.FINEST)) {
            stream.getLogger().finest("Read " + result);
        }
        return result;
    }

    public static DataElement expect(Stream stream, ElementType type) throws IOException, InterruptedException, TransferException {
        DataElement result;
        while ((result = DataElement.read(stream)).getType().equals((Object)ElementType.KEEP_ALIVE)) {
        }
        if (!result.getType().equals((Object)type)) {
            throw new Stream.UnexpectedResponseException(result.getType().toString(), type.toString());
        }
        return result;
    }

    protected DataElement(ElementType type, byte handle, ByteBuffer data) {
        this.type = type;
        this.handle = handle;
        this.data = data;
    }

    protected DataElement(ElementType type, byte handle) {
        this.type = type;
        this.handle = handle;
        this.data = null;
    }

    public ElementType getType() {
        return this.type;
    }

    public int getHandle() {
        return this.handle;
    }

    protected void setStringData(String value) {
        byte[] bytes = value.getBytes();
        this.data = ByteBuffer.allocate(bytes.length + 1);
        this.data.put(bytes);
        this.data.put((byte)0);
    }

    protected String getStringData() {
        byte[] raw = this.data.array();
        for (int i = 0; i < raw.length; ++i) {
            if (raw[i] != 0) continue;
            return new String(raw, 0, i);
        }
        return new String(raw);
    }

    public void write(Stream stream) throws Exception {
        this.write(stream, null);
    }

    public void write(Stream stream, AcknowledgeFeedback feedback) throws Exception {
        if (this.data.position() > 0) {
            this.data.flip();
        }
        ByteBuffer header = ByteBuffer.allocate(4 + this.data.remaining());
        header.put(this.type.getTypeCode());
        header.put(this.handle);
        header.putShort((short)this.data.limit());
        header.put(this.data);
        header.flip();
        if (stream.getLogger().isLoggable(Level.FINE)) {
            stream.getLogger().fine("Writing " + this.toString());
        }
        stream.put(header, feedback);
        if (stream.getLogger().isLoggable(Level.FINE)) {
            stream.getLogger().fine("Wrote " + this.toString());
        }
    }

    public String toString() {
        return "Data Element [type=" + (Object)((Object)this.type) + " handle=" + this.handle + " length=" + this.data.limit() + "]";
    }
}

