/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.ControlStream;
import com.signiant.interactivetransfer.engine.JavaVersionedPropertyFetcher;
import com.signiant.interactivetransfer.engine.Java_15_PropertyFetcher;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.Transport;
import com.signiant.interactivetransfer.engine.exceptions.CannotConnectException;
import com.signiant.interactivetransfer.engine.exceptions.TCPConnectException;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.mobilize.ddsclient.connection.Http;
import com.signiant.mobilize.ddsclient.connection.Port;
import com.signiant.mobilize.ddsclient.connection.Stream;
import com.signiant.mobilize.ddsclient.connection.Tcp;
import com.signiant.mobilize.ddsclient.connection.Udp;
import com.signiant.mobilize.ddsclient.connection.udp.UdpSession;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferInstance {
    private static final String propertyBase = "com.signiant.interactivetransfer.connection";
    private TransferEngine engine;
    private URL url;
    protected InetAddress itcAddress;
    protected InetAddress agentAddress;
    protected int agentPort;
    protected InetAddress relayAddress;
    protected int relayPort;
    protected Transport transport;
    private String sessionID;
    private boolean fallback;
    private int restarted;
    private boolean relayHasBeenSet;
    private UdpSession dataSession;
    private UdpSession controlSession;
    private int udpTraceMask;
    private Boolean controlSessionShutdown = new Boolean(false);
    private boolean httpTransfer;

    protected TransferInstance(TransferEngine engine, URL url) throws UnknownHostException {
        this.engine = engine;
        this.url = url;
        this.initializeTargetAgentParameters(url);
        this.sessionID = "";
        this.fallback = false;
        this.restarted = 0;
        this.dataSession = null;
    }

    protected void initializeTargetAgentParameters(URL url) throws UnknownHostException {
        this.httpTransfer = url.getProtocol().equalsIgnoreCase("http");
        if (url.getUserInfo() != null && url.getUserInfo().length() > 0) {
            this.agentAddress = InetAddress.getByAddress(url.getUserInfo(), new byte[]{127, 0, 0, 1});
            this.setRelayAddress(this.httpTransfer ? InetAddress.getByAddress(url.getHost(), new byte[]{127, 0, 0, 1}) : InetAddress.getByName(url.getHost()));
        } else {
            this.relayAddress = this.agentAddress = this.httpTransfer ? InetAddress.getByAddress(url.getHost(), new byte[]{127, 0, 0, 1}) : InetAddress.getByName(url.getHost());
        }
        this.relayPort = this.agentPort = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        this.transport = url.getProtocol().equals("mxwan") ? Transport.UDP : Transport.TCP;
        try {
            this.itcAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.itcAddress = null;
        }
    }

    TransferInstance(TransferEngine engine, InetAddress agentAddress, int agentPort, Transport transport) {
        this.engine = engine;
        this.agentAddress = agentAddress;
        this.agentPort = agentPort;
        this.relayAddress = agentAddress;
        this.relayPort = agentPort;
        this.transport = transport;
        try {
            this.itcAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.itcAddress = null;
        }
        this.sessionID = "";
        this.fallback = false;
        this.restarted = 0;
        this.dataSession = null;
        this.httpTransfer = false;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUrlName() {
        String proto = this.url.getProtocol();
        if (proto.equalsIgnoreCase("mxtcp")) {
            proto = "parallel streams";
        }
        if (proto.equalsIgnoreCase("mxwan")) {
            proto = "WAN accelerator";
        }
        return proto;
    }

    public String toString() {
        String protocol = this.url.getProtocol();
        if (protocol.equalsIgnoreCase("mxtcp") || protocol.equalsIgnoreCase("mxwan")) {
            return (Object)((Object)this.transport) + " " + this.getAgentAddress() + ":" + this.getAgentPort() + (this.isRelaySet() ? " relayed via " + this.getRelayAddress() + ":" + this.getRelayPort() : "");
        }
        return protocol + "://" + this.url.getHost();
    }

    InetAddress getAgentAddress() {
        return this.agentAddress;
    }

    void setAgentAddress(InetAddress agent) {
        this.agentAddress = agent;
    }

    int getAgentPort() {
        return this.agentPort;
    }

    void setAgentPort(int value) {
        this.agentPort = value;
    }

    InetAddress getRelayAddress() {
        return this.relayAddress;
    }

    void setRelayAddress(InetAddress value) {
        this.relayAddress = value;
        this.relayHasBeenSet = true;
    }

    int getRelayPort() {
        return this.relayPort;
    }

    void setRelayPort(int value) {
        this.relayPort = value;
        this.relayHasBeenSet = true;
    }

    boolean isRelaySet() {
        return this.relayHasBeenSet;
    }

    String getSessionID() {
        return this.sessionID;
    }

    void setSessionID(String value) {
        this.sessionID = value;
    }

    Properties getProperties(Stream stream) {
        String str;
        JavaVersionedPropertyFetcher fetcher;
        try {
            Class<?> javaVersionedPropertyFetcher = Class.forName("com.signiant.interactivetransfer.engine.Java_16_PropertyFetcher");
            fetcher = (JavaVersionedPropertyFetcher)javaVersionedPropertyFetcher.newInstance();
        }
        catch (Throwable discard) {
            fetcher = new Java_15_PropertyFetcher();
        }
        Properties result = fetcher.getProperties();
        Properties boundProperties = fetcher.getProperties(stream.getPort().getLocalInetAddress());
        result.putAll((Map<?, ?>)boundProperties);
        result.setProperty("com.signiant.interactivetransfer.connection.agent", this.agentAddress.getHostName());
        result.setProperty("com.signiant.interactivetransfer.connection.port", Integer.toString(this.agentPort));
        if (this.relayAddress != null) {
            result.setProperty("com.signiant.interactivetransfer.connection.relay_address", this.relayAddress.getHostAddress());
            result.setProperty("com.signiant.interactivetransfer.connection.relay_port", Integer.toString(this.relayPort));
        }
        if (this.itcAddress != null) {
            result.setProperty("com.signiant.interactivetransfer.connection.itc_host", this.itcAddress.getHostName());
            result.setProperty("com.signiant.interactivetransfer.connection.itc_ip", this.itcAddress.getHostAddress());
        }
        switch (this.transport) {
            case TCP: {
                str = "TCP";
                break;
            }
            case UDP: {
                str = "UDP";
                break;
            }
            case UDP_THEN_TCP: {
                str = this.fallback ? "TCP" : "UDP";
                break;
            }
            default: {
                str = "missing";
            }
        }
        result.setProperty("com.signiant.interactivetransfer.connection.transport", str);
        result.setProperty("com.signiant.interactivetransfer.connection.session_id", this.sessionID);
        result.setProperty("com.signiant.interactivetransfer.connection.control_stream", Boolean.toString(stream instanceof ControlStream));
        result.setProperty("com.signiant.interactivetransfer.connection.fallback", Boolean.toString(this.fallback));
        result.setProperty("com.signiant.interactivetransfer.connection.restarted", Integer.toString(this.restarted));
        return result;
    }

    public boolean isTcpTransfer() {
        switch (this.transport) {
            case TCP: {
                return true;
            }
            case UDP_THEN_TCP: {
                return this.fallback;
            }
        }
        return false;
    }

    public boolean isUdpTransfer() {
        switch (this.transport) {
            case UDP: {
                return true;
            }
            case UDP_THEN_TCP: {
                return !this.fallback;
            }
        }
        return false;
    }

    public boolean isHttpTransfer() {
        return this.httpTransfer;
    }

    void newUdpDataSession(int port, int timeout) throws IOException, TransferException {
        int burstQuantum;
        this.dataSession = this.newUdpSession(port, timeout, "Data");
        int traceMask = this.engine.getUdpTraceMask();
        if (traceMask != 0) {
            this.engine.addInfo(String.format("Using a UDP trace mask of %x", traceMask));
        }
        if ((burstQuantum = this.engine.getUdpBurstQuantum()) != -1) {
            this.engine.addInfo(String.format("Using a UDP burst quantum of %d milliseconds", burstQuantum));
        }
        this.dataSession.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("exception")) {
                    TransferInstance.this.engine.addError((Exception)evt.getNewValue());
                }
            }
        });
    }

    private UdpSession newUdpSession(int port, int timeout, String id) throws IOException, TransferException {
        int effectivePort = port;
        if (this.relayHasBeenSet) {
            effectivePort = this.relayPort;
        }
        this.udpTraceMask = this.engine.getUdpTraceMask();
        UdpSession session = UdpSession.initialize(this.engine.getNumberOfStreams(), this.engine.getLogInstance(), id, this.udpTraceMask);
        session.setRequestedPayload(this.engine.getUdpPayloadSize() - 8);
        session.setMaximumBandwidth(this.engine.getTargetRate());
        session.setMinimumBandwidth(this.engine.getMinimumRate());
        session.setAggressiveness(this.engine.getAggressiveness());
        session.setRelay(new InetSocketAddress(this.relayAddress, effectivePort));
        session.setLocalUdpPortNumber(this.engine.getUdpLocalPort());
        session.setLocalUdpPortRange(this.engine.getUdpPortRange());
        session.setTickleInterval(this.engine.getUdpReprobeInterval());
        session.setTickleThreshold(this.engine.getUdpReprobeThreshold());
        session.setBurstQuantum(this.engine.getUdpBurstQuantum() * 1000);
        session.connect(new InetSocketAddress(this.agentAddress, port), timeout);
        return session;
    }

    Port newControlPort() throws IOException, TransferException {
        String protocol = this.url.getProtocol();
        InetSocketAddress address = new InetSocketAddress(this.relayAddress, this.relayPort);
        if (protocol.equalsIgnoreCase("http")) {
            try {
                Http httpConn = new Http(address, this.engine.getLogInstance());
                httpConn.setValidateCertificate(this.engine.isValidateCertificate());
                return httpConn;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new CannotConnectException("HTTP Protocol Not Available", new Exception[]{e});
            }
        }
        if (protocol.equalsIgnoreCase("mxwan") && !this.engine.isTcpControlChannelEnabled().booleanValue()) {
            this.controlSession = this.newUdpSession(this.relayPort, 20000000, "Control");
            this.controlSession.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("exception")) {
                        TransferInstance.this.engine.addError((Exception)evt.getNewValue());
                    }
                }
            });
            Udp udpConn = new Udp(0, 0, this.engine.getLogInstance(), this.controlSession);
            udpConn.setValidateCertificate(this.engine.isValidateCertificate());
            return udpConn;
        }
        try {
            Tcp tcpConn = new Tcp(address, this.engine.getLogInstance());
            tcpConn.setValidateCertificate(this.engine.isValidateCertificate());
            return tcpConn;
        }
        catch (IOException cannotConnect) {
            throw new TCPConnectException("Failed to connect", cannotConnect, address.toString());
        }
    }

    Port newDataPort(byte handle, int id) throws IOException, TransferException {
        String protocol = this.url.getProtocol();
        if (protocol.equalsIgnoreCase("http")) {
            try {
                Http httpConn = new Http(new InetSocketAddress(this.relayAddress, this.relayPort), this.engine.getLogInstance());
                httpConn.setValidateCertificate(this.engine.isValidateCertificate());
                return httpConn;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new CannotConnectException("HTTP Protocol Not Available", new Exception[]{e});
            }
        }
        if (this.isUdpTransfer()) {
            Udp udpConn = new Udp(handle, id, this.engine.getLogInstance(), this.dataSession);
            udpConn.setValidateCertificate(this.engine.isValidateCertificate());
            return udpConn;
        }
        Tcp tcpConn = new Tcp(new InetSocketAddress(this.relayAddress, this.relayPort), this.engine.getLogInstance());
        tcpConn.setValidateCertificate(this.engine.isValidateCertificate());
        return tcpConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateUDPControlSession() throws IOException {
        Boolean bl = this.controlSessionShutdown;
        synchronized (bl) {
            if (!this.controlSessionShutdown.booleanValue()) {
                if (this.controlSession != null) {
                    Logger log = this.controlSession.getSessionLog();
                    if (log != null && log.isLoggable(Level.FINER)) {
                        log.finer("TransferInstance UDP Control Session terminate");
                    }
                    if (this.udpTraceMask != 0) {
                        File traceFileName = new File(this.engine.getLocalUdpLogfile());
                        try {
                            FileWriter traceFile = new FileWriter(traceFileName, true);
                            try {
                                this.controlSession.dumpTrace(traceFile, "control");
                            }
                            catch (Exception e) {
                                traceFile.write("Exception in UDP dumpTrace: \n");
                                PrintWriter pw = new PrintWriter(traceFile);
                                e.printStackTrace(pw);
                            }
                            traceFile.close();
                        }
                        catch (IOException discard) {
                            // empty catch block
                        }
                    }
                    this.controlSession.terminate();
                }
                this.controlSession = null;
                this.controlSessionShutdown = true;
            }
        }
    }

    void terminateUDPDataSession() throws IOException {
        if (this.dataSession != null) {
            if (this.udpTraceMask != 0) {
                File traceFileName = new File(this.engine.getLocalUdpLogfile());
                try {
                    FileWriter traceFile = new FileWriter(traceFileName, true);
                    try {
                        this.dataSession.dumpTrace(traceFile, "data");
                    }
                    catch (Exception e) {
                        traceFile.write("Exception in UDP dumpTrace: \n");
                        PrintWriter pw = new PrintWriter(traceFile);
                        e.printStackTrace(pw);
                    }
                    traceFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.dataSession.terminate();
        }
        this.dataSession = null;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public void doFallback() {
        this.fallback = true;
    }

    UdpSession getUdpSession() {
        return this.dataSession;
    }

    UdpSession getUdpControlSession() {
        return this.controlSession;
    }
}

