/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.ComponentQueuedStatusEvent;
import com.signiant.interactivetransfer.engine.ControlStream;
import com.signiant.interactivetransfer.engine.ControlStreamFactory;
import com.signiant.interactivetransfer.engine.DataStream;
import com.signiant.interactivetransfer.engine.FTPStream;
import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.HTTPStream;
import com.signiant.interactivetransfer.engine.StatusEvent;
import com.signiant.interactivetransfer.engine.TransferBandwidthStatusEvent;
import com.signiant.interactivetransfer.engine.TransferEngineEncryptionInterface;
import com.signiant.interactivetransfer.engine.TransferEngineInterface;
import com.signiant.interactivetransfer.engine.TransferEventListener;
import com.signiant.interactivetransfer.engine.TransferInstance;
import com.signiant.interactivetransfer.engine.TransferListener;
import com.signiant.interactivetransfer.engine.TransferMode;
import com.signiant.interactivetransfer.engine.Transport;
import com.signiant.interactivetransfer.engine.TransportProtocol;
import com.signiant.interactivetransfer.engine.converters.PropertyConverter;
import com.signiant.interactivetransfer.engine.exceptions.AutomaticReconnectionWarning;
import com.signiant.interactivetransfer.engine.exceptions.CannotConnectException;
import com.signiant.interactivetransfer.engine.exceptions.CannotResolveHostnameWarning;
import com.signiant.interactivetransfer.engine.exceptions.CertificateLoadException;
import com.signiant.interactivetransfer.engine.exceptions.ConfigurationException;
import com.signiant.interactivetransfer.engine.exceptions.ConnectionWarning;
import com.signiant.interactivetransfer.engine.exceptions.DirectoryWithSameNameExistsException;
import com.signiant.interactivetransfer.engine.exceptions.InsufficientMemoryException;
import com.signiant.interactivetransfer.engine.exceptions.InvalidConfigurationValueException;
import com.signiant.interactivetransfer.engine.exceptions.LogfileConfigurationException;
import com.signiant.interactivetransfer.engine.exceptions.MaximumRetriesExceededException;
import com.signiant.interactivetransfer.engine.exceptions.MediaExchangeServerDisabledException;
import com.signiant.interactivetransfer.engine.exceptions.MissingConfigurationException;
import com.signiant.interactivetransfer.engine.exceptions.MoreThanOneTransferAttemptWarning;
import com.signiant.interactivetransfer.engine.exceptions.NoHeartbeatException;
import com.signiant.interactivetransfer.engine.exceptions.ObfuscatedPropertiesException;
import com.signiant.interactivetransfer.engine.exceptions.RelayedServerUnreachableException;
import com.signiant.interactivetransfer.engine.exceptions.RetryableSituationWarning;
import com.signiant.interactivetransfer.engine.exceptions.ServerUnreachableException;
import com.signiant.interactivetransfer.engine.exceptions.StreamConnectionTimeoutException;
import com.signiant.interactivetransfer.engine.exceptions.TargetLessThenMinimumRateException;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferFallbackWarning;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import com.signiant.interactivetransfer.engine.resourcemanagement.ResourceNotDefinedException;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResource;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResourceFactory;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.ResourceBandwidthMap;
import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionResetException;
import com.signiant.interactivetransfer.engine.udp.exceptions.PacketResentCountExceededException;
import com.signiant.interactivetransfer.engine.udp.exceptions.TimedOutException;
import com.signiant.interactivetransfer.engine.udp.exceptions.UdpSessionTerminatedException;
import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.event.Event;
import com.signiant.jsf.services.event.EventListener;
import com.signiant.jsf.services.event.EventMask;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.protocoltunnel.ProtocolService;
import com.signiant.jsf.services.resourcepool.ResourcePoolService;
import com.signiant.mobilize.ddsclient.connection.Port;
import com.signiant.mobilize.ddsclient.messagebus.DdsBandwidthCommandType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.logging.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferEngine
implements TransferEngineInterface,
TransferEngineEncryptionInterface {
    private String buildNumber = "10.6.0.59156";
    private boolean versionLogged;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String packageid;
    private String jobNamePrefix;
    private String jobGroup;
    private AtomicLong agentStatUpdateInterval;
    private TransferMode mode;
    private Transport transport;
    private String agentList;
    private String urlList;
    private String fullUrlList;
    protected String[] fallbackUrls;
    private int fallbackPosition;
    private String user;
    private String hostname;
    private char[] password;
    private List<String> files;
    private String destination;
    private String token;
    private boolean isFileEncryptionEnabled = false;
    private List<String> filesToExcludeFromEncryption;
    private String fileEncryptionPassword;
    private String sandbox;
    private Boolean useTcpControlChannel;
    private String serviceData;
    private String sessionID;
    private String certificate;
    private Certificate cert = null;
    private boolean certificateless = false;
    private boolean validateCertificate = false;
    private int retries;
    private int restarts;
    private int restartCounter;
    private AtomicLong bandwidthThrottle;
    private boolean throttlable;
    private Port.SSLMode encryption;
    private int numStreams;
    private boolean followSymlinks;
    protected TransferInstance transferInstance;
    private TransportProtocol transportProtocol;
    private Object transportProtocolLock;
    private Thread transportProtocolThread;
    private FileTransfer.DirectoryHandlingMode directoryHandlingMode;
    private boolean directoryHandlingModeHasEverBeenSet;
    static final int UDP_DEFAULT_TRANSFER_TIME_THRESHOLD = 2;
    static final int UDP_DEFAULT_TRANSFER_RATE_THRESHOLD = 64000;
    private AtomicLong targetRate;
    private AtomicLong minRate;
    private int udpLocalPort = 49221;
    private int udpPortRange = 100;
    private int aggressiveness;
    private int udpPayloadSize = 1024;
    private long udpTransferTimeThreshold = 2L;
    private long udpTransferRateThreshold = 64000L;
    private int udpReprobeInterval = 16;
    private int udpReprobeThreshold = 5000;
    private int udpTraceMask = 0;
    private int udpBurstQuantum = -1;
    private boolean java16HTTPSAllow;
    private String logging;
    private String logEventListenerLevel;
    private String trace;
    private Logger logger;
    private String logbase;
    private String locallogfile;
    private String localUdpLogfile;
    private String logInstance;
    private FileHandler logFileHandler;
    private ConsoleHandler consoleHandler;
    private AtomicBoolean cancelled;
    private boolean completed;
    private Object completionEvent;
    private Properties configSettings;
    private Thread automaticReconnector;
    private List<TransferListener> eventSink;
    private boolean initialConnectionWasSuccessful = false;
    protected boolean readyToHandleErrors;
    protected TransferListener.ConnectionStatus connectionStatus;
    protected TransferListener.CompletionStatus completionStatus;
    protected AtomicLong bytesSkipped;
    protected AtomicLong bytesTransferred;
    private AtomicLong filesSkipped;
    private AtomicLong filesTransferred;
    private AtomicLong totalBytesToTransfer;
    private AtomicLong totalFilesToTransfer;
    private ConcurrentHashMap<String, Long> directoriesToTransfer;
    private ConcurrentHashMap<String, Long> directoriesTransferred;
    private ConcurrentHashMap<String, Long> directoriesSkipped;
    private AtomicLong timeofFileDetermination;
    private AtomicLong transferRate;
    private long[] transferRateAverages;
    private long[] transferRateTimestamps;
    private long[] transferRateByteCounts;
    private int transferRateAverageIndex;
    private static int transferRateSampleSize = 30;
    private AtomicLong startedTime;
    private AtomicLong lastAckedTime;
    private AtomicLong finishedTime;
    private AtomicLong previousRunTime;
    private Queue<Exception> errorList;
    private Queue<Exception> warningList;
    private Thread fileProgressEventThread;
    private BlockingQueue<FileProgressEvent> fileProgressQueue;
    private Queue<FileProgressEvent> fileProgressEventPool;
    private Object fileProgressEventPoolLock;
    private BootStrap bootstrap;
    private EventListener eventListener;
    private EventService es;
    private Timer timer;
    private boolean timerNameSet;
    private static final int DEF_FINER_UDP_TRACE_MASK = 41044;
    private static final int DEF_FINEST_UDP_TRACE_MASK = 41052;
    protected ResourceBandwidthMap resourceBandwidthMap;
    long throttleTime = 0L;
    AtomicLong throttledAmount = new AtomicLong(0L);
    long lastTransferRateTime = 0L;
    long lastTransferRateBytes = 0L;
    private Object startupAndInitializeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferEngine() {
        this.startedTime = new AtomicLong();
        this.lastAckedTime = new AtomicLong();
        this.finishedTime = new AtomicLong();
        this.previousRunTime = new AtomicLong();
        this.bytesSkipped = new AtomicLong();
        this.bytesTransferred = new AtomicLong();
        this.filesSkipped = new AtomicLong();
        this.filesTransferred = new AtomicLong();
        this.totalBytesToTransfer = new AtomicLong();
        this.totalFilesToTransfer = new AtomicLong();
        this.timeofFileDetermination = new AtomicLong();
        this.transferRate = new AtomicLong();
        this.directoriesToTransfer = new ConcurrentHashMap();
        this.directoriesTransferred = new ConcurrentHashMap();
        this.directoriesSkipped = new ConcurrentHashMap();
        this.transferRateAverages = new long[transferRateSampleSize];
        this.transferRateByteCounts = new long[transferRateSampleSize];
        this.transferRateTimestamps = new long[transferRateSampleSize];
        for (int i = 0; i < transferRateSampleSize; ++i) {
            this.transferRateAverages[i] = -1L;
            this.transferRateByteCounts[i] = 0L;
            this.transferRateTimestamps[i] = 0L;
        }
        this.connectionStatus = TransferListener.ConnectionStatus.DISCONNECTED;
        this.completionStatus = TransferListener.CompletionStatus.INCOMPLETE;
        this.transportProtocolLock = new Object();
        this.transportProtocolThread = null;
        this.transferInstance = null;
        this.eventSink = new CopyOnWriteArrayList<TransferListener>();
        this.completionEvent = new Object();
        this.completed = false;
        this.readyToHandleErrors = false;
        this.cancelled = new AtomicBoolean(false);
        this.errorList = new LinkedList<Exception>();
        this.warningList = new LinkedList<Exception>();
        this.fileProgressQueue = new LinkedBlockingQueue<FileProgressEvent>();
        this.fileProgressEventPool = new LinkedList<FileProgressEvent>();
        this.fileProgressEventPoolLock = new Object();
        try {
            this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception discard) {
            this.hostname = "localhost";
        }
        this.logger = Logger.getLogger(this.getClass().getName());
        this.consoleHandler = new ConsoleHandler();
        this.logInstance = "";
        this.loadPreviousSettings();
        this.java16HTTPSAllow = false;
        this.directoryHandlingMode = FileTransfer.DirectoryHandlingMode.FULL;
        this.directoryHandlingModeHasEverBeenSet = false;
        this.resourceBandwidthMap = new ResourceBandwidthMap("");
        this.filesToExcludeFromEncryption = new ArrayList<String>();
        BootStrap bootStrap = this.bootstrap = BootStrap.getInstance();
        synchronized (bootStrap) {
            if (this.bootstrap.getService(EventService.class) == null) {
                this.bootstrap.loadService(EventService.class.getName());
            }
            if (this.bootstrap.getService(ProtocolService.class) == null) {
                this.bootstrap.loadService(ProtocolService.class.getName());
            }
            if (this.bootstrap.getService(ResourcePoolService.class) == null) {
                this.bootstrap.loadService(ResourcePoolService.class.getName());
            }
            this.bootstrap.startServices();
        }
        this.eventListener = new EventListener(){

            public void eventOccured(Event event) {
                Level level = null;
                switch (event.getSeverity()) {
                    case ERROR: {
                        level = Level.SEVERE;
                        break;
                    }
                    case FINE: {
                        level = Level.FINE;
                        break;
                    }
                    case FINER: {
                        level = Level.FINER;
                        break;
                    }
                    case FINEST: {
                        level = Level.FINEST;
                        break;
                    }
                    case INFO: {
                        level = Level.INFO;
                        break;
                    }
                    case SEVERE: {
                        level = Level.SEVERE;
                        break;
                    }
                    case WARNING: {
                        level = Level.WARNING;
                    }
                }
                if (level == Level.SEVERE) {
                    TransferException oops = new TransferException(event.getBase().getSimpleName());
                    oops.setStackTrace(event.getBacktrace());
                }
                if (TransferEngine.this.logger.isLoggable(level) && TransferEngine.this.readyToHandleErrors) {
                    TransferEngine.this.logger.log(level, event.toString());
                }
            }
        };
    }

    @Override
    public String getBuildNumber() {
        return this.buildNumber;
    }

    protected void addInfo(String status) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(status);
        }
        for (TransferListener tl : this.eventSink) {
            tl.statusUpdate(new StatusEvent(this, status));
        }
    }

    protected void addStatusEvent(StatusEvent status) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Status event: " + status.getStatus());
        }
        for (TransferListener tl : this.eventSink) {
            tl.statusUpdate(status);
        }
    }

    protected void addComponentQueuedStatusEvent(ComponentQueuedStatusEvent statusEvent) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Status event: " + statusEvent.getStatus());
        }
        for (TransferListener tl : this.eventSink) {
            if (!(tl instanceof TransferEventListener)) continue;
            ((TransferEventListener)tl).connectionStatusComponentQueued(statusEvent);
        }
    }

    protected void addTransferBandwidthStatusEvent(TransferBandwidthStatusEvent statusEvent) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Status event: " + statusEvent.getStatus());
        }
        for (TransferListener tl : this.eventSink) {
            if (!(tl instanceof TransferEventListener)) continue;
            ((TransferEventListener)tl).connectionStatusSetBandwidth(statusEvent);
        }
    }

    protected void addWarning(Exception e) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.logger.warning(e.toString());
        }
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuffer b = new StringBuffer();
            for (StackTraceElement ste : e.getStackTrace()) {
                b.append(ste + "\n");
            }
            this.logger.fine("Warning: " + b.toString());
        }
        this.warningList.offer(e);
        for (TransferListener tl : this.eventSink) {
            tl.exception(e);
        }
    }

    protected void addError(Throwable t) {
        Exception e = new Exception(t);
        e.setStackTrace(t.getStackTrace());
        this.addError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addError(Exception e) {
        block17: {
            Object object = this.startupAndInitializeLock;
            synchronized (object) {
                if (this.isCancelled()) {
                    return;
                }
            }
            StringBuffer b = new StringBuffer();
            for (StackTraceElement ste : e.getStackTrace()) {
                b.append(ste + "\n");
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Examining: " + b.toString());
            }
            if (!this.readyToHandleErrors) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Discarded while not active: " + e);
                }
                return;
            }
            if (!(e instanceof DirectoryWithSameNameExistsException) && this.initialConnectionWasSuccessful && this.restarts > 0) {
                ++this.restartCounter;
                if (this.restartCounter > this.restarts) {
                    this.handleException(new MaximumRetriesExceededException(this.restartCounter, e));
                    break block17;
                } else {
                    if ((e instanceof TimedOutException || this.isTransferInstanceSet() && this.transferInstance.isHttpTransfer()) && this.handleFallback(true)) {
                        return;
                    }
                    RetryableSituationWarning warning = new RetryableSituationWarning(e);
                    this.addWarning(warning);
                    Object object2 = this.completionEvent;
                    synchronized (object2) {
                        long transferTime;
                        if (this.automaticReconnector != null) {
                            this.automaticReconnector.interrupt();
                            this.automaticReconnector = null;
                        }
                        int currentFallbackPosition = this.fallbackPosition;
                        this.cancelTransfer();
                        if (this.isTransferInstanceSet() && this.transferInstance.isUdpTransfer() && ((transferTime = (this.lastAckedTime.get() - this.startedTime.get()) / 1000L) < this.udpTransferTimeThreshold * 60L || this.transferRate.get() < this.udpTransferRateThreshold)) {
                            this.fallbackPosition = currentFallbackPosition;
                            if (!this.handleFallback(false) && this.restartCounter > this.restarts) {
                                return;
                            }
                        }
                        this.automaticReconnector = new Thread("Automatic reconnector"){

                            public void run() {
                                try {
                                    TransferEngine.this.addWarning(new AutomaticReconnectionWarning("Scheduling automatic restart in 1 minute", 60));
                                    TransferEngine.this.addInfo("Scheduling automatic restart in 1 minute");
                                    2.sleep(60000L);
                                    TransferEngine.this.restartTransfer();
                                }
                                catch (InterruptedException discard) {
                                }
                                catch (Exception cannotRestart) {
                                    TransferEngine.this.addError(cannotRestart);
                                }
                            }
                        };
                        this.automaticReconnector.start();
                        return;
                    }
                }
            }
            if (e instanceof TimedOutException && this.handleFallback(true)) {
                return;
            }
        }
        this.handleException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Exception e) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.logger.severe("Handled as severe: " + e.toString());
        }
        this.errorList.offer(e);
        for (TransferListener tl : this.eventSink) {
            tl.exception(e);
        }
        Object object = this.completionEvent;
        synchronized (object) {
            if (this.automaticReconnector != null) {
                this.automaticReconnector.interrupt();
                this.automaticReconnector = null;
            }
        }
        this.shutdownTransfer();
    }

    private boolean handleFallback(boolean scheduleStart) {
        if (++this.fallbackPosition < this.fallbackUrls.length) {
            if (this.transferInstance != null && this.transferInstance.isUdpTransfer()) {
                this.transferInstance.doFallback();
                this.transferInstance = null;
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Fallback attempt");
            }
            int currentFallbackPosition = this.fallbackPosition;
            this.cancelTransfer();
            this.fallbackPosition = currentFallbackPosition;
            this.addWarning(new TransferFallbackWarning("Error connecting, falling back next protocol in list", this.fallbackUrls[this.fallbackPosition - 1].split("\\|"), this.fallbackUrls[this.fallbackPosition].split("\\|")));
            if (!scheduleStart) {
                return true;
            }
            Thread fallbackReconnector = new Thread("Fallback reconnector"){

                public void run() {
                    try {
                        if (TransferEngine.this.transportProtocolThread != null) {
                            TransferEngine.this.transportProtocolThread.join();
                        }
                        Thread.sleep(1000L);
                        TransferEngine.this.createTransferThread();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            fallbackReconnector.start();
            return true;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Fallback list exhausted");
        }
        return false;
    }

    protected void preStreams() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Pre-transfer event");
        }
        this.setConnectionStatus(TransferListener.ConnectionStatus.AWAITING_DATA_STREAMS);
        this.addInfo("Setting up data streams");
    }

    protected void preTransfer() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Pre-transfer event");
        }
        this.setConnectionStatus(TransferListener.ConnectionStatus.CONNECTED);
        this.addInfo("Connected using " + this.transferInstance.getUrlName());
        this.initialConnectionWasSuccessful = true;
        for (TransferListener tl : this.eventSink) {
            tl.preTransfer();
        }
    }

    protected void fileHeader(FileTransfer ft) {
        Long total;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("File header: " + ft);
        }
        this.totalFilesToTransfer.incrementAndGet();
        this.totalBytesToTransfer.addAndGet(ft.getSize());
        this.timeofFileDetermination.set(System.currentTimeMillis() * 1000L);
        String parent = null;
        String handledName = ft.getPathHandledName();
        if (handledName != null) {
            parent = new File(handledName).getParent();
        }
        if (parent == null) {
            parent = ".";
        }
        if ((total = this.directoriesToTransfer.get(parent)) == null) {
            total = 0L;
        }
        Long l = total;
        Long l2 = total = Long.valueOf(total + 1L);
        this.directoriesToTransfer.put(parent, total);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Directory found: " + parent + " " + total);
        }
        for (TransferListener tl : this.eventSink) {
            tl.fileHeader(ft);
        }
    }

    protected void preFile(FileTransfer ft) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Pre file: " + ft);
        }
        for (TransferListener tl : this.eventSink) {
            tl.preFile(ft);
        }
    }

    protected void filePosition(FileTransfer ft, long position) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("File position: " + ft + " skipped=" + position);
        }
        this.bytesSkipped.addAndGet(position);
        for (TransferListener tl : this.eventSink) {
            tl.filePosition(ft, position);
        }
    }

    void throttle(int amount) {
        if (this.throttlable) {
            if (this.throttleTime == 0L) {
                this.throttleTime = System.currentTimeMillis();
            }
            long total = this.throttledAmount.addAndGet(amount);
            long elapsed = System.currentTimeMillis() - this.throttleTime + 1L;
            long rate = total * 1000L / elapsed;
            while (rate > this.bandwidthThrottle.get() && !this.isCancelled()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Bandwidth throttle: current=" + rate + " > " + this.bandwidthThrottle.get());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException discard) {
                    // empty catch block
                }
                elapsed = System.currentTimeMillis() - this.throttleTime;
                rate = total * 1000L / elapsed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileProgress(FileTransfer ft, long amount) {
        FileProgressEvent e;
        if (this.startedTime.get() == 0L) {
            if (this.finishedTime.get() == 0L) {
                this.startedTime.set(System.currentTimeMillis());
            } else {
                this.startedTime.set(this.finishedTime.get());
            }
        }
        this.bytesTransferred.addAndGet(amount);
        this.lastAckedTime.set(System.currentTimeMillis());
        Object object = this.fileProgressEventPoolLock;
        synchronized (object) {
            e = this.fileProgressEventPool.poll();
        }
        if (e == null) {
            e = new FileProgressEvent();
        }
        e.setAmount(amount);
        e.setFileTransfer(ft);
        this.fileProgressQueue.offer(e);
    }

    protected void skipFile(FileTransfer ft) {
        Long total;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Skipped : " + ft);
        }
        this.bytesSkipped.addAndGet(ft.getSize());
        this.filesSkipped.incrementAndGet();
        String parent = null;
        String handledName = ft.getPathHandledName();
        if (handledName != null) {
            parent = new File(handledName).getParent();
        }
        if (parent == null) {
            parent = ".";
        }
        if ((total = this.directoriesSkipped.get(parent)) == null) {
            total = 0L;
        }
        Long l = total;
        Long l2 = total = Long.valueOf(total + 1L);
        this.directoriesSkipped.put(parent, total);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Directory skipped: " + parent + " " + total);
        }
        for (TransferListener tl : this.eventSink) {
            tl.skipFile(ft);
        }
    }

    protected void postFile(FileTransfer ft) {
        Long total;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Post file: " + ft);
        }
        if (ft.getState() == FileTransfer.State.TRANSFERRED) {
            this.filesTransferred.incrementAndGet();
        }
        String parent = null;
        String handledName = ft.getPathHandledName();
        if (handledName != null) {
            parent = new File(handledName).getParent();
        }
        if (parent == null) {
            parent = ".";
        }
        if ((total = this.directoriesTransferred.get(parent)) == null) {
            total = 0L;
        }
        Long l = total;
        Long l2 = total = Long.valueOf(total + 1L);
        this.directoriesTransferred.put(parent, total);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Directory used: " + parent + " " + total);
        }
        for (TransferListener tl : this.eventSink) {
            tl.postFile(ft);
        }
    }

    protected long getTimeOfFileDetermination() {
        return this.timeofFileDetermination.get();
    }

    @Override
    public long getFilesSkipped() {
        return this.filesSkipped.get();
    }

    @Override
    public long getFilesTransferred() {
        return this.filesTransferred.get();
    }

    @Override
    public long getTotalBytesToTransfer() {
        return this.totalBytesToTransfer.get();
    }

    @Override
    public long getTotalFilesToTransfer() {
        return this.totalFilesToTransfer.get();
    }

    @Override
    public long getDirectoriesTransferred() {
        int skipped = 0;
        for (String skippedName : this.directoriesTransferred.keySet()) {
            if (this.directoriesSkipped.get(skippedName) == null) continue;
            ++skipped;
        }
        return this.directoriesTransferred.size() - skipped;
    }

    @Override
    public long getDirectoriesSkipped() {
        return this.directoriesSkipped.size();
    }

    @Override
    public long getTotalDirectoriesToTransfer() {
        return this.directoriesToTransfer.size();
    }

    @Override
    public long getBytesTransferred() {
        return this.bytesTransferred.get();
    }

    @Override
    public long getBytesSkipped() {
        return this.bytesSkipped.get();
    }

    private void calculateAverageTransferRate() {
        if (this.startedTime.get() == 0L) {
            return;
        }
        if (this.finishedTime.get() != 0L) {
            if (this.finishedTime.get() - this.startedTime.get() < 1000L) {
                this.transferRate.set(this.getBytesTransferred());
            } else {
                this.transferRate.set(this.getBytesTransferred() * 1000L / (this.finishedTime.get() - this.startedTime.get()));
            }
            return;
        }
        if (++this.transferRateAverageIndex >= transferRateSampleSize) {
            this.transferRateAverageIndex = 0;
        }
        this.transferRateTimestamps[this.transferRateAverageIndex] = System.currentTimeMillis();
        this.transferRateByteCounts[this.transferRateAverageIndex] = this.getBytesTransferred();
        int total = 0;
        long oldest = System.currentTimeMillis();
        long newest = 0L;
        long oldestBytes = 0L;
        long newestBytes = 0L;
        for (int i = 0; i < transferRateSampleSize; ++i) {
            if (this.transferRateTimestamps[i] <= 0L) continue;
            if (this.transferRateTimestamps[i] < oldest) {
                oldest = this.transferRateTimestamps[i];
                oldestBytes = this.transferRateByteCounts[i];
            }
            if (this.transferRateTimestamps[i] > newest) {
                newest = this.transferRateTimestamps[i];
                newestBytes = this.transferRateByteCounts[i];
            }
            ++total;
        }
        long elapsed = newest - oldest;
        long bytes = newestBytes - oldestBytes;
        if (elapsed == 0L) {
            return;
        }
        this.transferRate.set((this.transferRate.get() + bytes * 1000L / elapsed) / 2L);
    }

    @Override
    public long getTransferRate() {
        return this.transferRate.get();
    }

    @Override
    public TransferListener.ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    @Override
    public TransferListener.CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    private boolean isModeSet() {
        return this.mode != TransferMode.NONE;
    }

    @Override
    public TransferMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TransferMode value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Transfer mode: " + (Object)((Object)value));
        }
        this.mode = value;
        if (!this.directoryHandlingModeHasEverBeenSet) {
            this.directoryHandlingMode = value == TransferMode.SEND ? FileTransfer.DirectoryHandlingMode.PATH : FileTransfer.DirectoryHandlingMode.FULL;
        }
    }

    @Override
    public FileTransfer.DirectoryHandlingMode getDirectoryHandlingMode() {
        return this.directoryHandlingMode;
    }

    @Override
    public void setDirectoryHandlingMode(FileTransfer.DirectoryHandlingMode directoryHandlingMode) {
        this.directoryHandlingMode = directoryHandlingMode;
        this.directoryHandlingModeHasEverBeenSet = true;
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Directory handling mode: " + (Object)((Object)directoryHandlingMode));
        }
    }

    private boolean isTransportSet() {
        return this.transport != Transport.NONE;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public void setTransport(Transport value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Transport: " + (Object)((Object)value));
        }
        this.transport = value;
    }

    @Override
    public void setTransport(String value) throws ConfigurationException {
        if (value.length() == 0) {
            return;
        }
        if (value.equalsIgnoreCase("TCP")) {
            this.setTransport(Transport.TCP);
        } else if (value.equalsIgnoreCase("UDP")) {
            this.setTransport(Transport.UDP);
        } else if (value.equalsIgnoreCase("UDP_THEN_TCP")) {
            this.setTransport(Transport.UDP_THEN_TCP);
        } else {
            throw new InvalidConfigurationValueException("Invalid transport value for transfer engine.", "com.signiant.interactivetransfer.engine.transport", new String[]{"TCP", "UDP", "UDP_THEN_TCP"});
        }
    }

    public void setUseTcpControlChannel(Boolean value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Use TCP Control Channel: " + value);
        }
        this.useTcpControlChannel = value;
    }

    private void setUseTcpControlChannel(String value) throws ConfigurationException {
        if (!value.equalsIgnoreCase("TRUE") && !value.equalsIgnoreCase("FALSE")) {
            throw new InvalidConfigurationValueException("Invalid value for 'Use TCP control channel' setting.", "com.signiant.interactivetransfer.engine.use_tcp_control_channel", new String[]{"TRUE", "FALSE"});
        }
        this.setUseTcpControlChannel(Boolean.valueOf(value.toLowerCase()));
    }

    public Boolean isTcpControlChannelEnabled() {
        return this.useTcpControlChannel;
    }

    @Override
    public String getLogbase() {
        return this.logbase;
    }

    @Override
    public String getLocalLogfile() {
        if (System.getProperty("os.name").startsWith("Win")) {
            String name = this.locallogfile.replaceAll("/", "\\\\");
            try {
                name = new File(name).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return name;
        }
        return this.locallogfile;
    }

    public String getLocalUdpLogfile() {
        if (System.getProperty("os.name").startsWith("Win")) {
            String name = this.localUdpLogfile.replaceAll("/", "\\\\");
            try {
                name = new File(name).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return name;
        }
        return this.localUdpLogfile;
    }

    private boolean isAgentListSet() {
        return this.agentList != null && this.agentList.length() > 0 || this.urlList != null && this.urlList.length() > 0;
    }

    @Override
    public String getAgentList() {
        return this.agentList;
    }

    @Override
    public void setAgentList(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Agent list: " + value);
        }
        this.agentList = value;
        this.fullUrlList = null;
        this.transferInstance = null;
    }

    private boolean isUrlListSet() {
        return this.urlList != null && this.urlList.length() > 0;
    }

    @Override
    public String getUrlList() {
        return this.urlList;
    }

    @Override
    public void setUrlList(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("URL list: " + value);
        }
        this.urlList = value;
        this.fullUrlList = null;
        this.transferInstance = null;
    }

    private boolean isUserSet() {
        return this.user != null && this.user.length() > 0;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("User: " + value);
        }
        this.user = value;
    }

    private boolean isPasswordSet() {
        return this.password != null && this.password.length > 0;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(char[] value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Password set: ****");
        }
        this.password = value;
    }

    private boolean isFilesSet() {
        return this.files != null && this.files.size() > 0;
    }

    @Override
    public String[] getFiles() {
        if (this.isFilesSet()) {
            String[] result = new String[this.files.size()];
            return this.files.toArray(result);
        }
        String[] result = new String[]{};
        return result;
    }

    @Override
    public String getFile(int pos) {
        if (pos < 0 || pos >= this.files.size()) {
            return null;
        }
        return this.files.get(pos);
    }

    @Override
    public void setFiles(String[] value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            for (String file : value) {
                this.logger.config("File to transfer: " + file);
            }
        }
        this.files.clear();
        for (String s : value) {
            this.files.add(s);
        }
    }

    private boolean isDestinationSet() {
        return this.destination != null && this.destination.length() > 0;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Destination: " + value);
        }
        this.destination = value;
    }

    private boolean isTokenSet() {
        return this.token != null && this.token.length() > 0;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Token: " + value);
        }
        this.token = value;
    }

    @Override
    public boolean isFileEncryptionEnabled() {
        return this.isFileEncryptionEnabled;
    }

    @Override
    public void setFileEncryptionEnabled(boolean isFileEncryptionEnabled) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Setting file encryption: " + isFileEncryptionEnabled);
        }
        this.isFileEncryptionEnabled = isFileEncryptionEnabled;
    }

    @Override
    public boolean isFileIncludedForEncryption(String path) {
        String safePath = this.verifyFilePathForWindows(path);
        return !this.filesToExcludeFromEncryption.contains(safePath);
    }

    @Override
    public String[] getFilesToExcludeFromEncryption() {
        String[] arrayOfFiles = null;
        if (this.filesToExcludeFromEncryption != null) {
            arrayOfFiles = (String[])this.filesToExcludeFromEncryption.toArray();
        }
        return arrayOfFiles;
    }

    @Override
    public void setFilesToExcludeFromEncryption(String[] filesToExcludeFromEncryption) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Setting files to exclude from encryption: " + Arrays.toString(filesToExcludeFromEncryption));
        }
        if (filesToExcludeFromEncryption != null) {
            ArrayList<String> filenames = new ArrayList<String>();
            for (String filename : filesToExcludeFromEncryption) {
                filenames.add(this.verifyFilePathForWindows(filename));
            }
            this.filesToExcludeFromEncryption = filenames;
        }
    }

    protected String getFileEncryptionPassword() {
        return this.fileEncryptionPassword;
    }

    @Override
    public void setFileEncryptionPassword(String fileEncryptionPassword) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Setting file encryption password");
        }
        this.fileEncryptionPassword = fileEncryptionPassword;
    }

    private boolean isSandboxSet() {
        return this.sandbox != null && this.sandbox.length() > 0;
    }

    @Override
    public String getSandbox() {
        return this.sandbox;
    }

    @Override
    public void setSandbox(String sandbox) {
        this.sandbox = sandbox;
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Sandbox: " + sandbox);
        }
    }

    private boolean isServiceDataSet() {
        return this.serviceData != null && this.serviceData.length() > 0;
    }

    @Override
    public String getServiceData() {
        return this.serviceData;
    }

    @Override
    public void setServiceData(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Service data: " + value);
        }
        this.serviceData = value;
    }

    private boolean isSessionIDSet() {
        return this.sessionID != null && this.sessionID.length() > 0;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    void setSessionID(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Session ID: " + value);
        }
        this.sessionID = value;
    }

    private boolean isCertificateSet() {
        return this.certificate != null && this.certificate.length() > 0;
    }

    @Override
    public String getCertificate() {
        return this.certificate;
    }

    @Override
    public void setCertificate(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Certificate: " + value);
        }
        this.certificate = value;
    }

    @Override
    public void setValidateCertificate(boolean bSet) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Certificate validate: " + bSet);
        }
        this.validateCertificate = bSet;
    }

    @Override
    public boolean isValidateCertificate() {
        return this.validateCertificate;
    }

    @Override
    public boolean isCertificateless() {
        return this.certificateless;
    }

    @Override
    public void setCertificateless(boolean certificateless) {
        this.certificateless = certificateless;
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Certificateless: " + certificateless);
        }
    }

    private boolean isRetriesSet() {
        return this.retries != 3;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setRetries(int value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Retries: " + value);
        }
        this.retries = value;
    }

    private boolean isRestartsSet() {
        return this.restarts != 3;
    }

    @Override
    public int getRestarts() {
        return this.restarts;
    }

    @Override
    public void setRestarts(int value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Restarts: " + value);
        }
        this.restarts = value;
    }

    private boolean isBandwidthThrottleSet() {
        return this.bandwidthThrottle.get() > 0L;
    }

    @Override
    public long getBandwidthThrottle() {
        return this.bandwidthThrottle.get();
    }

    @Override
    public void setBandwidthThrottle(long value) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("TransferEngine adding runtime bandwidth throttle " + value);
        }
        if (value < 0L) {
            this.logger.severe("TransferEngine rejected invalid runtime bandwidth throttle " + value);
            return;
        }
        HashMap<String, String> map = this.getBandwidthCommandMap(DdsBandwidthCommandType.MANUAL_OVERRIDE);
        map.put("throttle", Long.toString(value));
        try {
            BandwidthResource bwResource = BandwidthResourceFactory.getInstance().getCTELocalManualOverride(map);
            this.applyLocalBandwidthThrottle(bwResource);
        }
        catch (Exception exception) {
            this.logger.severe("TransferEngine Failed to add runtime bandwidth throttle: " + exception.getMessage());
        }
    }

    protected void setConfigBandwidthThrottle(Long throttle) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("TransferEngine adding configuration property bandwidth " + throttle);
        }
        if (throttle < 0L) {
            this.logger.severe("TransferEngine rejected invalid configuration throttle " + throttle);
            return;
        }
        HashMap<String, String> map = this.getBandwidthCommandMap(DdsBandwidthCommandType.MANUAL_JOB);
        map.put("throttle", throttle.toString());
        try {
            BandwidthResource bwResource = BandwidthResourceFactory.getInstance().getBandwidthResource(map);
            this.applyLocalBandwidthThrottle(bwResource);
        }
        catch (Exception exception) {
            this.logger.severe("TransferEngine Failed to add configuration bandwidth throttle: " + exception.getMessage());
        }
    }

    protected void applyLocalBandwidthThrottle(BandwidthResource bwResource) throws Exception {
        this.addBandwidthResource(bwResource);
        this.applyBandwidthThrottle();
    }

    protected void addBandwidthResource(BandwidthResource resource) {
        if (resource == null) {
            this.logger.info("TransferEngine bandwidth resource will null value, discarded");
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("TransferEngine added a bandwidth resource with values " + resource);
            }
            this.resourceBandwidthMap.addBandwidthResource(resource);
        }
    }

    protected boolean removeBandwidthResource(BandwidthResource resource) {
        boolean bwHasBeenRemoved = false;
        if (resource == null) {
            this.logger.info("TransferEngine bandwidth resource will null value, discarded");
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("TransferEngine remove a bandwidth resource with initiator " + resource.getCommandInitiator());
            }
            bwHasBeenRemoved = this.resourceBandwidthMap.removeBandwidthResource(resource);
        }
        return bwHasBeenRemoved;
    }

    protected void applyBandwidthThrottle() {
        Long throttleValue = this.getPriorityBandwidth();
        long oldValue = this.bandwidthThrottle.getAndSet(throttleValue);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "com.signiant.interactivetransfer.engine.bandwidth_throttle", new Long(oldValue), throttleValue);
        this.pcs.firePropertyChange(propertyChangeEvent);
        this.throttleTime = 0L;
        this.throttledAmount.set(0L);
        if (this.isActive()) {
            this.throttlable = this.transferInstance.getUrl().getProtocol().startsWith("mx") ? this.mode == TransferMode.SEND && this.bandwidthThrottle.get() > 1L : this.bandwidthThrottle.get() > 1L;
        }
    }

    protected ResourceBandwidthMap getResourceBandwidthMap() {
        return this.resourceBandwidthMap;
    }

    protected BandwidthResource getPriorityBandwitdthRecord() throws ResourceNotDefinedException {
        return this.resourceBandwidthMap.getPriorityBandwidth();
    }

    protected Long getPriorityBandwidth() {
        Long throttleValue;
        block3: {
            throttleValue = 0L;
            try {
                BandwidthResource bwResource = this.resourceBandwidthMap.getPriorityBandwidth();
                throttleValue = bwResource.getBandwidthThrottle();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("TransferEngine applying a bandwidth resource with values " + bwResource);
                }
            }
            catch (Exception exception) {
                throttleValue = 0L;
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.fine("TransferEngine Failed to retrieve bandwidth resource, applying unlimited throttle");
            }
        }
        return throttleValue;
    }

    protected HashMap<String, String> getBandwidthCommandMap(DdsBandwidthCommandType type) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("managername", this.getHostname());
        map.put("issuername", this.getHostname());
        map.put("cmdsource", this.getHostname());
        map.put("commandtype", Integer.toString(type.ordinal()));
        return map;
    }

    @Override
    public Port.SSLMode getEncryption() {
        return this.encryption;
    }

    @Override
    public void setEncryption(Port.SSLMode value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Encryption: " + (Object)((Object)value));
        }
        this.encryption = value;
    }

    private boolean isLoggingSet() {
        return this.logging != null && this.logging.length() > 0;
    }

    @Override
    public String getLogInstance() {
        return this.logInstance;
    }

    @Override
    public void setLogLevel(String level) throws ConfigurationException {
        this.setLogLevel(level, false);
    }

    @Override
    public void setLogLevel(String level, boolean uniqueInstance) throws ConfigurationException {
        Handler[] handlers;
        if (!("OFF".equals(level = level.toUpperCase()) || "NONE".equals(level) || "INFO".equals(level) || "FINE".equals(level) || "FINER".equals(level) || "FINEST".equals(level))) {
            throw new InvalidConfigurationValueException("Invalid log level", "com.signiant.interactivetransfer.engine.logging", new String[]{"OFF", "NONE", "INFO", "FINE", "FINER", "FINEST"});
        }
        if ("NONE".equals(level)) {
            level = "OFF";
        }
        if (this.udpTraceMask == 0) {
            if ("FINER".equals(level)) {
                this.udpTraceMask = 41044;
            } else if ("FINEST".equals(level)) {
                this.udpTraceMask = 41052;
            }
        }
        if (uniqueInstance) {
            this.logInstance = "." + (int)(Math.random() * 1000000.0);
        }
        if (this.logFileHandler != null) {
            this.logFileHandler.close();
            this.logFileHandler = null;
        }
        if (this.locallogfile != null) {
            if (this.completionStatus == TransferListener.CompletionStatus.INCOMPLETE) {
                new File(this.locallogfile).delete();
            }
            this.locallogfile = null;
        }
        String parentName = this.getClass().getPackage().getName() + this.logInstance;
        String className = parentName + "." + this.getClass().getSimpleName();
        this.logger = Logger.getLogger(className);
        Logger parent = Logger.getLogger(parentName);
        parent.setUseParentHandlers(false);
        for (Handler h : handlers = parent.getHandlers()) {
            parent.removeHandler(h);
        }
        if ("OFF".equals(level)) {
            MemoryHandler devNull = new MemoryHandler(this.consoleHandler, 1, Level.OFF);
            parent.addHandler(devNull);
            parent.setLevel(Level.INFO);
            return;
        }
        this.logEventListenerLevel = level;
        this.setLogEventListener(level);
        parent.setLevel(Level.parse(level));
        parent.addHandler(this.consoleHandler);
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.locallogfile = System.getProperty("java.io.tmpdir");
        this.locallogfile = this.verifyFilePathForWindows(this.locallogfile);
        if (this.locallogfile.lastIndexOf(47) != this.locallogfile.length() - 1) {
            this.locallogfile = this.locallogfile + "/";
        }
        this.logbase = "sigitc-" + formatter.format("%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS-%1$tL", Calendar.getInstance()) + this.logInstance;
        this.localUdpLogfile = this.locallogfile + this.logbase + "_udp.log";
        this.locallogfile = this.locallogfile + this.logbase + ".log";
        try {
            this.logFileHandler = new FileHandler(this.locallogfile, true);
            this.logFileHandler.setLevel(Level.ALL);
            parent.addHandler(this.logFileHandler);
            this.logFileHandler.setFormatter(new java.util.logging.Formatter(){

                public String format(LogRecord record) {
                    StringBuilder line = new StringBuilder();
                    Date now = new Date(record.getMillis());
                    line.append(String.format("%1$TH:%1$TM:%1$TS.%1$TN", now));
                    line.append(" (");
                    line.append(record.getThreadID());
                    line.append(") ");
                    line.append(record.getLevel());
                    line.append(": ");
                    line.append(record.getMessage());
                    line.append("\n");
                    return line.toString();
                }
            });
        }
        catch (IOException e) {
            throw new LogfileConfigurationException(this.locallogfile, e);
        }
    }

    private String verifyFilePathForWindows(String filename) {
        String safeFilename = filename;
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            safeFilename = filename.replaceAll("\\\\", "/");
        }
        return safeFilename;
    }

    private void setLogEventListener(String level) {
        this.es = (EventService)this.bootstrap.getService(EventService.class);
        Level parsedLevel = Level.parse(level);
        Event.Severity severity = parsedLevel.equals(Level.ALL) || parsedLevel.equals(Level.FINEST) ? Event.Severity.FINEST : (parsedLevel.equals(Level.ALL) || parsedLevel.equals(Level.FINEST) ? Event.Severity.FINEST : (parsedLevel.equals(Level.FINER) ? Event.Severity.FINER : (parsedLevel.equals(Level.FINE) ? Event.Severity.FINE : (parsedLevel.equals(Level.INFO) ? Event.Severity.INFO : (parsedLevel.equals(Level.SEVERE) ? Event.Severity.SEVERE : (parsedLevel.equals(Level.WARNING) ? Event.Severity.WARNING : Event.Severity.INFO))))));
        this.es.subscribe(this.eventListener, new EventMask(severity));
    }

    @Override
    public String getLogging() {
        return this.logging;
    }

    protected String getLogEventListenerLevel() {
        return this.logEventListenerLevel;
    }

    @Override
    public void setLogging(String value) throws LogfileConfigurationException {
        if (value.length() == 0) {
            return;
        }
        try {
            this.setLogLevel(value, true);
            this.logging = value;
            return;
        }
        catch (ConfigurationException discard) {
            LogManager lm = LogManager.getLogManager();
            ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes());
            try {
                lm.readConfiguration(in);
                in.close();
            }
            catch (IOException e) {
                System.err.println("Invalid log manager configuration - logging settings have not been set.");
            }
            this.logging = value;
            String newlogfile = "";
            for (String l : this.logging.split("\n")) {
                if (!l.startsWith("java.util.logging.FileHandler.pattern=")) continue;
                newlogfile = l.replaceFirst("java.util.logging.FileHandler.pattern=", "").trim();
            }
            this.locallogfile = newlogfile;
            if (this.locallogfile.length() > 0) {
                this.logbase = this.locallogfile.substring(this.locallogfile.lastIndexOf(47) + 1).trim();
                if (this.logbase.indexOf(46) > 0) {
                    this.logbase = this.logbase.substring(0, this.logbase.lastIndexOf(46)).trim();
                }
                if (!this.logbase.startsWith("sigitc-")) {
                    this.logbase = "sigitc-" + this.logbase;
                }
                if (new File(this.locallogfile).getParentFile().exists()) {
                    if (!new File(this.locallogfile).getParentFile().canWrite()) {
                        throw new LogfileConfigurationException(this.locallogfile, new IOException("No write permission"));
                    }
                } else if (!new File(this.locallogfile).getParentFile().mkdirs()) {
                    throw new LogfileConfigurationException(this.locallogfile, new IOException("Cannot create path to log file"));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                Formatter formatter = new Formatter(sb, Locale.US);
                this.logbase = "sigitc-" + formatter.format("%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS-%1$tL", Calendar.getInstance());
            }
            return;
        }
    }

    private boolean isTraceSet() {
        return this.trace != null && this.trace.length() > 0;
    }

    @Override
    public String getTrace() {
        if (this.trace == null) {
            this.trace = "";
        }
        return this.trace;
    }

    @Override
    public void setTrace(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Trace: " + value);
        }
        this.trace = value;
    }

    private boolean isTargetRateSet() {
        return this.targetRate.get() != 0L;
    }

    @Override
    public long getTargetRate() {
        return this.targetRate.get();
    }

    @Override
    public void setTargetRate(long value) {
        this.setTargetRate(value, true);
    }

    protected void setTargetRate(long value, boolean userOriginated) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Target rate set to " + value + " by " + (userOriginated ? "sdk user" : "remote command"));
        }
        long oldValue = this.targetRate.getAndSet(value);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "com.signiant.interactivetransfer.engine.udp.target_rate", new Long(oldValue), new Long(value));
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    private boolean isMinimumRateSet() {
        return this.minRate.get() != 0L;
    }

    @Override
    public long getMinimumRate() {
        return this.minRate.get();
    }

    @Override
    public void setMinimumRate(long value) {
        this.setMinimumRate(value, true);
    }

    protected void setMinimumRate(long value, boolean userOriginated) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Minimum rate set to " + value + " by " + (userOriginated ? "sdk user" : "remote command"));
        }
        long oldValue = this.minRate.getAndSet(value);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "com.signiant.interactivetransfer.engine.udp.minimum_rate", new Long(oldValue), new Long(value));
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    private boolean isAggressivenessSet() {
        return this.aggressiveness != 2;
    }

    @Override
    public int getAggressiveness() {
        return this.aggressiveness;
    }

    @Override
    public void setAggressiveness(int value) throws ConfigurationException {
        if (value < 1 || value > 3) {
            throw new InvalidConfigurationValueException("Invalid aggressiveness value", "com.signiant.interactivetransfer.engine.udp.aggressiveness", new String[]{"1", "2", "3"});
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Aggressiveness: " + value);
        }
        this.aggressiveness = value;
    }

    @Override
    public int getUdpPayloadSize() {
        return this.udpPayloadSize + 8;
    }

    @Override
    public void setUdpPayloadSize(int payloadSize) throws ConfigurationException {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("UDP payload size: " + payloadSize);
        }
        this.udpPayloadSize = Math.min(1480, Math.max(300, payloadSize -= 8));
        if (payloadSize < 300 || payloadSize > 1480) {
            throw new InvalidConfigurationValueException("Invalid UDP payload size", "com.signiant.interactivetransfer.engine.udp.payloadsize", new String[]{"300", "1480"});
        }
    }

    public int getUdpReprobeInterval() {
        return this.udpReprobeInterval;
    }

    public void setUdpReprobeInterval(int reprobeInterval) throws ConfigurationException {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("UDP reprobe interval size: " + reprobeInterval);
        }
        this.udpReprobeInterval = reprobeInterval;
        if (this.udpReprobeInterval < 5) {
            this.udpReprobeInterval = 5;
        } else if (this.udpReprobeInterval > 60) {
            this.udpReprobeInterval = 60;
        }
        if (reprobeInterval < 5 || reprobeInterval > 60) {
            throw new InvalidConfigurationValueException("Invalid UDP reprobe interval", "com.signiant.interactivetransfer.engine.udp.reprobe_interval", new String[]{"5", "60"});
        }
    }

    public int getUdpReprobeThreshold() {
        return this.udpReprobeThreshold;
    }

    public void setUdpReprobeThreshold(int reprobeThreshold) throws ConfigurationException {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("UDP reprobe threshol size: " + reprobeThreshold);
        }
        this.udpReprobeThreshold = reprobeThreshold;
        if (this.udpReprobeThreshold < 1) {
            this.udpReprobeThreshold = 1;
        } else if (this.udpReprobeThreshold > 10000) {
            this.udpReprobeThreshold = 10000;
        }
        if (reprobeThreshold < 1 || reprobeThreshold > 10000) {
            throw new InvalidConfigurationValueException("Invalid UDP reprobe threshold", "com.signiant.interactivetransfer.engine.udp.reprobe_interval", new String[]{"1", "10000"});
        }
    }

    private boolean isUdpTransferTimeThresholdSet() {
        return this.udpTransferTimeThreshold != 2L;
    }

    @Override
    public long getUdpTransferTimeThreshold() {
        return this.udpTransferTimeThreshold;
    }

    @Override
    public void setUdpTransferTimeThreshold(int value) throws ConfigurationException {
        if (value < 0) {
            throw new InvalidConfigurationValueException("Invalid UDP transfer time threshold", "com.signiant.interactivetransfer.engine.udp.transfer_time_theshold", null);
        }
        if (value == 0) {
            this.udpTransferTimeThreshold = 2L;
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("UDP minimum transfer time threshold: " + value);
        }
        this.udpTransferTimeThreshold = value;
    }

    private boolean isUdpTransferRateThresholdSet() {
        return this.udpTransferRateThreshold != 64000L;
    }

    @Override
    public long getUdpTransferRateThreshold() {
        return this.udpTransferRateThreshold;
    }

    @Override
    public void setUdpTransferRateThreshold(int value) throws ConfigurationException {
        if (value < 0) {
            throw new InvalidConfigurationValueException("Invalid UDP transfer rate threshold", "com.signiant.interactivetransfer.engine.udp.transfer_rate_theshold", null);
        }
        if (value == 0) {
            this.udpTransferRateThreshold = 64000L;
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("UDP minimum transfer time threshold: " + value);
        }
        this.udpTransferRateThreshold = value;
    }

    private boolean isNumberOfStreamsSet() {
        return this.numStreams != 4;
    }

    @Override
    public int getNumberOfStreams() {
        return this.numStreams;
    }

    @Override
    public void setNumberOfStreams(int value) throws ConfigurationException {
        if (value < 1 || value > 6) {
            throw new InvalidConfigurationValueException("Invalid number of streams", "com.signiant.interactivetransfer.engine.streams", new String[]{"1", "2", "3", "4", "5", "6"});
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Number of streams: " + value);
        }
        this.numStreams = value;
    }

    public Boolean getFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(Boolean value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Follow symbolic links: " + value);
        }
        this.followSymlinks = value;
    }

    private boolean isFollowSymlinksSet() {
        return this.getFollowSymlinks();
    }

    public void setFollowSymlinks(String value) throws ConfigurationException {
        if (!value.equalsIgnoreCase("TRUE") && !value.equalsIgnoreCase("FALSE")) {
            throw new InvalidConfigurationValueException("Invalid value for 'Follow symbolic links' setting.", "com.signiant.interactivetransfer.engine.follow_symlinks", new String[]{"TRUE", "FALSE"});
        }
        this.setFollowSymlinks(Boolean.valueOf(value.toLowerCase()));
    }

    @Override
    public boolean getJava16HttpsAllow() {
        return this.java16HTTPSAllow;
    }

    protected boolean isUdpLocalPortSet() {
        return this.udpLocalPort != 0;
    }

    @Override
    public int getUdpLocalPort() {
        return this.udpLocalPort;
    }

    @Override
    public void setUdpLocalPort(int port) {
        this.udpLocalPort = port;
    }

    protected boolean isUdpTraceMaskSet() {
        return this.udpTraceMask != 0;
    }

    public int getUdpTraceMask() {
        return this.udpTraceMask;
    }

    public void setUdpTraceMask(int traceMask) {
        this.udpTraceMask = traceMask;
    }

    protected boolean isUdpBurstQuantumSet() {
        return this.udpBurstQuantum != -1;
    }

    public int getUdpBurstQuantum() {
        return this.udpBurstQuantum;
    }

    public void setUdpBurstQuantum(int burstQuantum) {
        this.udpBurstQuantum = burstQuantum < 0 ? -1 : (burstQuantum > 10000 ? 10000 : burstQuantum);
    }

    protected boolean isUdpPortRangeSet() {
        return this.udpPortRange != 0;
    }

    @Override
    public int getUdpPortRange() {
        return this.udpPortRange;
    }

    @Override
    public void setUdpPortRange(int range) {
        this.udpPortRange = range;
    }

    @Override
    public void setJava16HttpsAllow(boolean allow) {
        this.java16HTTPSAllow = allow;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.put("com.signiant.interactivetransfer.engine.stats.agentstatupdateinterval", String.valueOf(this.agentStatUpdateInterval.get()));
        if (this.isPackageIDSet()) {
            props.put("com.signiant.interactivetransfer.engine.header.packageid", this.packageid);
        }
        if (this.isJobNamePrefixSet()) {
            props.put("com.signiant.interactivetransfer.engine.header.jobnameprefix", this.jobNamePrefix);
        }
        if (this.isJobGroupSet()) {
            props.put("com.signiant.interactivetransfer.engine.header.jobgroup", this.jobGroup);
        }
        if (this.isModeSet()) {
            props.put("com.signiant.interactivetransfer.engine.mode", this.mode.toString());
        }
        props.put("com.signiant.interactivetransfer.engine.dir_handling_mode", this.directoryHandlingMode.toString());
        if (this.isUdpLocalPortSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.local_port", Integer.toString(this.udpLocalPort));
        }
        if (this.isUdpPortRangeSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.port_range", Integer.toString(this.udpPortRange));
        }
        if (this.isUdpTraceMaskSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.trace_mask", Integer.toString(this.udpTraceMask));
        }
        if (this.isUdpBurstQuantumSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.burst_quantum", Integer.toString(this.udpBurstQuantum));
        }
        if (this.isUdpTransferTimeThresholdSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.transfer_time_threshold", Long.toString(this.udpTransferTimeThreshold));
        }
        if (this.isUdpTransferRateThresholdSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.transfer_rate_threshold", Long.toString(this.udpTransferRateThreshold));
        }
        if (this.isTransportSet()) {
            props.put("com.signiant.interactivetransfer.engine.transport", this.transport.toString());
        }
        if (this.agentList != null && this.isAgentListSet()) {
            props.put("com.signiant.interactivetransfer.engine.agent_list", this.agentList);
        }
        if (this.isUrlListSet()) {
            props.put("com.signiant.interactivetransfer.engine.url_list", this.urlList);
        }
        if (this.isUserSet()) {
            props.put("com.signiant.interactivetransfer.engine.user", this.user);
        }
        if (this.isPasswordSet()) {
            props.put("com.signiant.interactivetransfer.engine.password", new String(this.password));
        }
        if (this.isFilesSet()) {
            StringBuilder list = new StringBuilder();
            for (String s : this.files) {
                if (s == null || s.length() <= 0) continue;
                if (list.length() > 0) {
                    list.append("\n");
                }
                list.append(s);
            }
            props.put("com.signiant.interactivetransfer.engine.files", list.toString());
        }
        if (this.isDestinationSet()) {
            props.put("com.signiant.interactivetransfer.engine.destination_dir", this.destination);
        }
        if (this.isTokenSet()) {
            props.put("com.signiant.interactivetransfer.engine.header.token", this.token);
        }
        if (this.isSandboxSet()) {
            props.put("com.signiant.interactivetransfer.engine.sandbox", this.sandbox);
        }
        if (this.isServiceDataSet()) {
            props.put("com.signiant.interactivetransfer.engine.service_data", this.serviceData);
        }
        if (this.isSessionIDSet()) {
            props.put("com.signiant.interactivetransfer.engine.session_id", this.sessionID);
        }
        if (this.isCertificateSet()) {
            props.put("com.signiant.interactivetransfer.engine.ca_certificate", this.certificate);
        }
        props.put("com.signiant.interactivetransfer.engine.certificateless", Boolean.toString(this.certificateless));
        props.put("com.signiant.interactivetransfer.engine.certificatevalidate", Boolean.toString(this.validateCertificate));
        if (this.isRetriesSet()) {
            props.put("com.signiant.interactivetransfer.engine.retries", Integer.toString(this.retries));
        }
        if (this.isRestartsSet()) {
            props.put("com.signiant.interactivetransfer.engine.restarts", Integer.toString(this.restarts));
        }
        if (this.isBandwidthThrottleSet()) {
            props.put("com.signiant.interactivetransfer.engine.bandwidth_throttle", Long.toString(this.bandwidthThrottle.get()));
        }
        props.put("com.signiant.interactivetransfer.engine.encrypt", this.encryption.name());
        if (this.isNumberOfStreamsSet()) {
            props.put("com.signiant.interactivetransfer.engine.streams", Integer.toString(this.numStreams));
        }
        if (this.isFollowSymlinksSet()) {
            props.put("com.signiant.interactivetransfer.engine.follow_symlinks", Boolean.toString(this.followSymlinks));
        }
        if (this.isLoggingSet()) {
            props.put("com.signiant.interactivetransfer.engine.logging", this.logging);
        }
        if (this.isTraceSet()) {
            props.put("com.signiant.interactivetransfer.engine.trace", this.trace);
        }
        if (this.isTargetRateSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.target_rate", Long.toString(this.targetRate.get()));
        }
        if (this.isMinimumRateSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.minimum_rate", Long.toString(this.minRate.get()));
        }
        if (this.isAggressivenessSet()) {
            props.put("com.signiant.interactivetransfer.engine.udp.aggressiveness", Integer.toString(this.aggressiveness));
        }
        props.put("com.signiant.interactivetransfer.engine.udp.payloadsize", Integer.toString(this.udpPayloadSize));
        if (this.getJava16HttpsAllow()) {
            props.put("com.signiant.interactivetransfer.engine.java16httpsallow", Boolean.toString(true));
        }
        Properties loggableProperties = new Properties();
        for (Object p : props.keySet()) {
            String key = (String)p;
            String val = (String)props.get(p);
            if (key.indexOf("password") > 0) {
                val = "********";
            }
            loggableProperties.setProperty(key, val);
        }
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("Properties: " + loggableProperties);
        }
        return props;
    }

    @Override
    public void setProperties(Properties props) throws ConfigurationException {
        if (props.containsKey("com.signiant.interactivetransfer.engine.logging")) {
            this.setLogging(props.getProperty("com.signiant.interactivetransfer.engine.logging"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.stats.agentstatupdateinterval")) {
            try {
                this.setAgentStatUpdateInterval(Long.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.stats.agentstatupdateinterval")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.header.packageid")) {
            this.setPackageID(props.getProperty("com.signiant.interactivetransfer.engine.header.packageid"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.header.jobnameprefix")) {
            this.setJobNamePrefix(props.getProperty("com.signiant.interactivetransfer.engine.header.jobnameprefix"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.header.jobgroup")) {
            this.setJobGroup(props.getProperty("com.signiant.interactivetransfer.engine.header.jobgroup"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.local_port")) {
            try {
                this.setUdpLocalPort(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.local_port")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.trace_mask")) {
            try {
                this.setUdpTraceMask(Integer.parseInt(props.getProperty("com.signiant.interactivetransfer.engine.udp.trace_mask"), 16));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.burst_quantum")) {
            try {
                this.setUdpBurstQuantum(Integer.parseInt(props.getProperty("com.signiant.interactivetransfer.engine.udp.burst_quantum")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.port_range")) {
            try {
                this.setUdpPortRange(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.port_range")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.mode")) {
            try {
                this.setMode(TransferMode.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.mode")));
            }
            catch (Exception discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.dir_handling_mode")) {
            try {
                this.setDirectoryHandlingMode(FileTransfer.DirectoryHandlingMode.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.dir_handling_mode")));
            }
            catch (Exception discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.transport")) {
            this.setTransport(props.getProperty("com.signiant.interactivetransfer.engine.transport"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.use_tcp_control_channel")) {
            this.setUseTcpControlChannel(props.getProperty("com.signiant.interactivetransfer.engine.use_tcp_control_channel"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.agent_list")) {
            this.setAgentList(props.getProperty("com.signiant.interactivetransfer.engine.agent_list"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.url_list")) {
            this.setUrlList(props.getProperty("com.signiant.interactivetransfer.engine.url_list"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.user")) {
            this.setUser(props.getProperty("com.signiant.interactivetransfer.engine.user"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.password")) {
            this.setPassword(props.getProperty("com.signiant.interactivetransfer.engine.password").toCharArray());
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.files")) {
            try {
                String line;
                ArrayList<String> files = new ArrayList<String>();
                BufferedReader rdr = new BufferedReader(new StringReader(props.getProperty("com.signiant.interactivetransfer.engine.files")));
                while ((line = rdr.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    files.add(line);
                }
                String[] filelist = new String[files.size()];
                files.toArray(filelist);
                this.setFiles(filelist);
            }
            catch (IOException ie) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.destination_dir")) {
            this.setDestination(props.getProperty("com.signiant.interactivetransfer.engine.destination_dir"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.header.token")) {
            this.setToken(props.getProperty("com.signiant.interactivetransfer.engine.header.token"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.sandbox")) {
            this.setSandbox(props.getProperty("com.signiant.interactivetransfer.engine.sandbox"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.service_data")) {
            this.setServiceData(props.getProperty("com.signiant.interactivetransfer.engine.service_data"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.session_id")) {
            this.setSessionID(props.getProperty("com.signiant.interactivetransfer.engine.session_id"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.ca_certificate")) {
            this.setCertificate(props.getProperty("com.signiant.interactivetransfer.engine.ca_certificate"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.certificatevalidate")) {
            this.setValidateCertificate(Boolean.parseBoolean(props.getProperty("com.signiant.interactivetransfer.engine.certificatevalidate")));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.certificateless")) {
            this.setCertificateless(Boolean.parseBoolean(props.getProperty("com.signiant.interactivetransfer.engine.certificateless")));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.retries")) {
            try {
                this.setRetries(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.retries")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.restarts")) {
            try {
                this.setRestarts(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.restarts")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.bandwidth_throttle")) {
            try {
                this.setConfigBandwidthThrottle(Long.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.bandwidth_throttle")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.encrypt")) {
            try {
                this.setEncryption(Port.SSLMode.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.encrypt")));
            }
            catch (Exception discard) {
                try {
                    Boolean legacy = Boolean.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.encrypt"));
                    if (legacy.booleanValue()) {
                        this.setEncryption(Port.SSLMode.STRONG);
                    } else {
                        this.setEncryption(Port.SSLMode.NONE);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.streams")) {
            try {
                this.setNumberOfStreams(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.streams")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.follow_symlinks")) {
            this.setFollowSymlinks(props.getProperty("com.signiant.interactivetransfer.engine.follow_symlinks"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.transfer_time_threshold")) {
            try {
                this.setUdpTransferTimeThreshold(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.transfer_time_threshold")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.transfer_rate_threshold")) {
            try {
                this.setUdpTransferRateThreshold(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.transfer_rate_threshold")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.trace")) {
            this.setTrace(props.getProperty("com.signiant.interactivetransfer.engine.trace"));
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.target_rate")) {
            try {
                this.setTargetRate(Long.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.target_rate")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.minimum_rate")) {
            try {
                this.setMinimumRate(Long.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.minimum_rate")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.aggressiveness")) {
            try {
                this.setAggressiveness(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.aggressiveness")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.payloadsize")) {
            try {
                this.setUdpPayloadSize(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.payloadsize")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.java16httpsallow")) {
            try {
                this.setJava16HttpsAllow(Boolean.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.java16httpsallow")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.reprobe_interval")) {
            try {
                this.setUdpReprobeInterval(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.reprobe_interval")));
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        if (props.containsKey("com.signiant.interactivetransfer.engine.udp.reprobe_threshold")) {
            try {
                this.setUdpReprobeThreshold(Integer.valueOf(props.getProperty("com.signiant.interactivetransfer.engine.udp.reprobe_threshold")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setObfuscatedProperties(String value) throws ConfigurationException {
        try {
            String clear = PropertyConverter.getClearText(value);
            this.loadSettings(clear);
        }
        catch (Throwable e) {
            this.logger.warning("Unable to set all obfuscated properties: " + e.getMessage());
            throw new ObfuscatedPropertiesException("Unable to load properties from obfuscated configuration", e);
        }
    }

    @Override
    public void setObfuscatedProperties(String value, Object key) throws ConfigurationException {
        try {
            String clear = PropertyConverter.getClearText(value, key);
            this.loadSettings(clear);
        }
        catch (Throwable e) {
            this.logger.warning("Unable to set all obfuscated properties: " + e.getMessage());
            throw new ObfuscatedPropertiesException("Unable to load properties from obfuscated configuration", e);
        }
    }

    @Override
    public long getStartedTime() {
        return this.startedTime.get();
    }

    @Override
    public long getPreviousRunTime() {
        return this.previousRunTime.get();
    }

    void setFinished() {
        this.connectionStatus = TransferListener.ConnectionStatus.DISCONNECTED;
        for (TransferListener tl : this.eventSink) {
            tl.connectionStatusChange(this.connectionStatus);
        }
    }

    void markTransferFinishedTime() {
        this.finishedTime.set(System.currentTimeMillis());
    }

    @Override
    public long getFinishedTime() {
        return this.finishedTime.get();
    }

    @Override
    public long getElapsedTime() {
        if (this.startedTime.get() > 0L) {
            if (this.finishedTime.get() > 0L) {
                return this.finishedTime.get() - this.startedTime.get() + this.previousRunTime.get();
            }
            return System.currentTimeMillis() - this.startedTime.get() + this.previousRunTime.get();
        }
        return 0L + this.previousRunTime.get();
    }

    @Override
    public boolean isActive() {
        return this.transportProtocol != null;
    }

    protected boolean isTransferInstanceSet() {
        return this.transferInstance != null;
    }

    List<TransferListener> getEventSink() {
        return this.eventSink;
    }

    @Override
    public void addTransferListener(TransferListener l) {
        this.eventSink.add(l);
    }

    @Override
    public void removeTransferListener(TransferListener l) {
        this.eventSink.remove(l);
    }

    @Override
    public void newSettings() {
        this.agentStatUpdateInterval = new AtomicLong(1000L);
        this.packageid = null;
        this.jobNamePrefix = null;
        this.jobGroup = null;
        this.mode = TransferMode.SEND;
        this.transport = Transport.UDP_THEN_TCP;
        this.useTcpControlChannel = false;
        this.agentList = null;
        this.urlList = null;
        this.user = null;
        this.password = null;
        this.files = new ArrayList<String>();
        this.destination = null;
        this.sandbox = null;
        this.token = null;
        this.serviceData = null;
        this.sessionID = null;
        this.certificate = null;
        this.retries = 3;
        this.restarts = 3;
        this.bandwidthThrottle = new AtomicLong();
        this.encryption = Port.SSLMode.UNSIGNED;
        this.numStreams = 4;
        this.followSymlinks = false;
        this.targetRate = new AtomicLong();
        this.minRate = new AtomicLong();
        this.aggressiveness = 2;
        this.fallbackPosition = 0;
        this.fallbackUrls = null;
        this.fullUrlList = null;
        this.java16HTTPSAllow = false;
        this.directoryHandlingMode = FileTransfer.DirectoryHandlingMode.FULL;
    }

    @Override
    public void loadSettings(String settings) throws Exception {
        String line;
        this.configSettings = new Properties();
        this.newSettings();
        LineNumberReader lnr = new LineNumberReader(new StringReader(settings));
        while ((line = lnr.readLine()) != null) {
            if (line.startsWith("#") || line.indexOf(61) == -1) continue;
            String[] parts = line.split("=", 2);
            String value = parts.length == 1 ? "" : parts[1];
            value = this.utfConvert(value);
            this.configSettings.setProperty(parts[0], value);
        }
        this.setProperties(this.configSettings);
    }

    @Override
    public void loadSettings(File file) throws Exception {
        byte[] holding = new byte[(int)file.length()];
        FileInputStream fis = new FileInputStream(file);
        fis.read(holding);
        String settings = new String(holding, "UTF-8");
        this.loadSettings(settings);
    }

    private String utfConvert(String encodedString) {
        int len = encodedString.length();
        StringBuffer holding = new StringBuffer(len);
        int i = 0;
        block8: while (i < len) {
            int c;
            if ((c = encodedString.charAt(i++)) == 92) {
                c = encodedString.charAt(i++);
                switch (c) {
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 117: {
                        holding.append((char)Integer.parseInt(encodedString.substring(i, i + 4), 16));
                        i += 4;
                        continue block8;
                    }
                }
            }
            holding.append((char)c);
        }
        return holding.toString();
    }

    @Override
    public void saveSettings(File file) throws IOException {
        Properties props = this.getProperties();
        FileOutputStream stream = new FileOutputStream(file);
        props.store(stream, "These settings are for the Web Client");
    }

    @Override
    public boolean isValidTransfer() {
        try {
            this.checkTransferParameters();
        }
        catch (TransferException x) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getShownProperties() {
        if (this.configSettings == null) {
            return null;
        }
        String value = this.configSettings.getProperty("com.signiant.interactivetransfer.applet.show_fields");
        if (value == null) {
            return null;
        }
        return value.split("\n");
    }

    @Override
    public String[] getEditableProperties() {
        if (this.configSettings == null) {
            return null;
        }
        String value = this.configSettings.getProperty("com.signiant.interactivetransfer.applet.edit_fields");
        if (value == null) {
            return null;
        }
        return value.split("\n");
    }

    private String agentListToUrl() {
        if (this.agentList == null || this.agentList.length() == 0) {
            return "";
        }
        HashMap agents = new HashMap();
        int scanpos = 0;
        int lastpos = 0;
        boolean inRelay = false;
        String agentName = "";
        String globalRelayAddress = null;
        int globalRelayPort = 49221;
        try {
            globalRelayAddress = System.getenv("SIGNIANT_RELAY_ADDRESS");
            globalRelayPort = Integer.parseInt(System.getenv("SIGNIANT_RELAY_PORT"));
        }
        catch (Exception discard) {
            // empty catch block
        }
        while (scanpos < this.agentList.length()) {
            char c = this.agentList.charAt(scanpos);
            ++scanpos;
            switch (c) {
                case '[': {
                    inRelay = true;
                    String agent = this.agentList.substring(lastpos, scanpos - 1).trim();
                    lastpos = scanpos;
                    if (agent.length() == 0) break;
                    agentName = agent;
                    agents.put(agentName, new ArrayList());
                    break;
                }
                case ']': {
                    String[] relays;
                    inRelay = false;
                    String relayList = this.agentList.substring(lastpos, scanpos - 1).trim();
                    for (String relay : relays = relayList.split(",")) {
                        ((List)agents.get(agentName)).add(relay.trim());
                    }
                    lastpos = scanpos;
                    break;
                }
                case ' ': 
                case ',': {
                    String agent;
                    if (inRelay || (agent = this.agentList.substring(lastpos, scanpos - 1).trim()).length() == 0) break;
                    agentName = agent;
                    agents.put(agentName, new ArrayList());
                    lastpos = scanpos;
                    break;
                }
            }
        }
        if (inRelay) {
            this.addError(new InvalidConfigurationValueException("Syntax error in agent list", "com.signiant.interactivetransfer.engine.url_list", null));
            agents.clear();
        } else {
            agentName = this.agentList.substring(lastpos, scanpos).trim();
            if (agentName.length() > 0) {
                agents.put(agentName, new ArrayList());
            }
        }
        ArrayList<TransferInstance> instances = new ArrayList<TransferInstance>();
        for (String agent : agents.keySet()) {
            List relaylist = (List)agents.get(agent);
            if (relaylist.isEmpty()) {
                try {
                    int port = 49221;
                    int portpos = agent.indexOf(40);
                    if (portpos >= 0) {
                        try {
                            String portstr = agent.substring(portpos + 1, agent.indexOf(41)).trim();
                            port = Integer.parseInt(portstr);
                        }
                        catch (NumberFormatException discard) {
                            // empty catch block
                        }
                        agent = agent.substring(0, portpos).trim();
                    }
                    TransferInstance instance = new TransferInstance(this, InetAddress.getByName(agent), port, this.transport);
                    if (globalRelayAddress != null) {
                        instance.setRelayAddress(InetAddress.getByName(globalRelayAddress));
                        instance.setRelayPort(globalRelayPort);
                    }
                    instances.add(instance);
                }
                catch (UnknownHostException uh) {
                    this.addWarning(new CannotResolveHostnameWarning("Cannot resolve hostname", agent, uh));
                }
                continue;
            }
            for (String relay : relaylist) {
                int port = 49221;
                int portpos = relay.indexOf(40);
                if (portpos >= 0) {
                    try {
                        String portstr = relay.substring(portpos + 1, relay.indexOf(41)).trim();
                        port = Integer.parseInt(portstr);
                    }
                    catch (NumberFormatException discard) {
                        // empty catch block
                    }
                    relay = relay.substring(0, portpos).trim();
                }
                byte[] lh = new byte[]{127, 0, 0, 1};
                try {
                    TransferInstance instance = new TransferInstance(this, InetAddress.getByAddress(agent, lh), port, this.transport);
                    if (globalRelayAddress != null) {
                        instance.setRelayAddress(InetAddress.getByName(globalRelayAddress));
                        instance.setRelayPort(globalRelayPort);
                    } else {
                        instance.setRelayAddress(InetAddress.getByName(relay));
                        instance.setRelayPort(port);
                    }
                    instances.add(instance);
                }
                catch (UnknownHostException uh) {
                    this.addWarning(new CannotResolveHostnameWarning("Cannot resolve hostname", relay, uh));
                }
            }
        }
        String fullUrlList = "";
        if (this.transport != Transport.TCP) {
            boolean first = true;
            for (TransferInstance instance : instances) {
                String url = "mxwan://";
                url = instance.isRelaySet() ? url + instance.getAgentAddress().getHostName() + "@" + instance.getRelayAddress().getHostAddress() + ":" + instance.getRelayPort() + "/" : url + instance.getAgentAddress().getHostName() + ":" + instance.getAgentPort() + "/";
                if (first) {
                    first = false;
                } else {
                    fullUrlList = fullUrlList + "|";
                }
                fullUrlList = fullUrlList + url;
            }
        }
        if (this.transport != Transport.UDP) {
            if (fullUrlList.length() > 0) {
                fullUrlList = fullUrlList + "\n";
            }
            boolean first = true;
            for (TransferInstance instance : instances) {
                String url = "mxtcp://";
                url = instance.isRelaySet() ? url + instance.getAgentAddress().getHostName() + "@" + instance.getRelayAddress().getHostAddress() + ":" + instance.getRelayPort() + "/" : url + instance.getAgentAddress().getHostName() + ":" + instance.getAgentPort() + "/";
                if (first) {
                    first = false;
                } else {
                    fullUrlList = fullUrlList + "|";
                }
                fullUrlList = fullUrlList + url;
            }
        }
        if (fullUrlList.length() > 0) {
            fullUrlList = fullUrlList + "\n";
        }
        return fullUrlList;
    }

    ArrayList<Connector> getConnectorList(String urlList) {
        String[] singles;
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        this.addInfo("Processing URL list: " + urlList);
        for (String url : singles = this.fallbackUrls[this.fallbackPosition].split("\\|")) {
            if ((url = url.trim()).length() <= 0) continue;
            URL customUrl = null;
            String protocol = url.substring(0, url.indexOf(58));
            if (protocol.equals("mxwan") || protocol.equals("mxtcp") || protocol.equals("plain") || protocol.equals("http") || protocol.equals("ftp")) {
                try {
                    customUrl = protocol.startsWith("mx") ? new URL((URL)null, url, new ControlStreamFactory().createURLStreamHandler(protocol)) : new URL(url);
                    TransferInstance instance = new TransferInstance(this, customUrl);
                    connectors.add(new Connector(instance));
                }
                catch (UnknownHostException uh) {
                    this.addInfo("Unable to resolve hostname: " + customUrl.getHost());
                }
                catch (MalformedURLException mal) {
                    this.addWarning(new InvalidConfigurationValueException(url + ": " + mal.getMessage(), "com.signiant.interactivetransfer.engine.url_list", null));
                }
                continue;
            }
            this.addWarning(new InvalidConfigurationValueException("Protocol not supported at this time", "com.signiant.interactivetransfer.engine.url_list", new String[]{"mxwan://", "mxtcp://", "http://", "https://", "ftp://"}));
        }
        if (connectors.size() == 0) {
            this.addWarning(new InvalidConfigurationValueException("No viable URL found", "com.signiant.interactivetransfer.engine.url_list", null));
        }
        return connectors;
    }

    private void findFastestTransportProtocol() {
        Thread seeker = new Thread("Transport Protocol Seeker"){

            public void run() {
                ArrayList<Connector> connectors = TransferEngine.this.getConnectorList(TransferEngine.this.fallbackUrls[TransferEngine.this.fallbackPosition]);
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Starting all connection attempts");
                }
                Collections.shuffle(connectors);
                for (Connector connector : connectors) {
                    connector.start();
                }
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Waiting for all connection attempts to complete");
                }
                for (Connector connector : connectors) {
                    try {
                        connector.join();
                    }
                    catch (InterruptedException discard) {}
                }
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Connection attempts completed");
                }
                if (TransferEngine.this.transportProtocol == null) {
                    int connected = 0;
                    for (Connector connector : connectors) {
                        if (!connector.successful) continue;
                        ++connected;
                    }
                    if (connected == 0) {
                        for (Connector connector : connectors) {
                            Throwable result = connector.getConnectionAttemptException();
                            if (result instanceof TransferWarning) {
                                TransferEngine.this.addWarning((TransferWarning)result);
                            }
                            TransferEngine.this.addWarning(new ConnectionWarning(connector.getConnectionAttemptResult(), result));
                        }
                        TransferEngine.this.transportProtocolConnectionReady(null, null);
                    }
                } else {
                    TransferEngine.this.addInfo("Connected to " + TransferEngine.this.transferInstance);
                }
            }
        };
        seeker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transportProtocolConnectionReady(TransportProtocol transportProtocol, TransferInstance transferInstance) {
        Object object = this.transportProtocolLock;
        synchronized (object) {
            if (this.transportProtocol != null) {
                try {
                    transportProtocol.close();
                }
                catch (Exception discard) {
                    // empty catch block
                }
                return;
            }
            if (this.logger.isLoggable(Level.FINE) && transferInstance != null) {
                this.logger.fine("Using connection to: " + transferInstance);
            }
            this.transportProtocol = transportProtocol;
            this.transferInstance = transferInstance;
            this.transportProtocolLock.notifyAll();
            if (transportProtocol == null) {
                return;
            }
            this.throttlable = transferInstance.getUrl().getProtocol().startsWith("mx") ? this.mode == TransferMode.SEND && this.bandwidthThrottle.get() > 1L : this.bandwidthThrottle.get() > 1L;
        }
    }

    protected void setConnectionStatus(TransferListener.ConnectionStatus status) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Connection status: " + (Object)((Object)status));
        }
        this.connectionStatus = status;
        for (TransferListener tl : this.eventSink) {
            tl.connectionStatusChange(this.connectionStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransfer() {
        try {
            Object object = this.startupAndInitializeLock;
            synchronized (object) {
                this.bytesSkipped.set(0L);
                this.bytesTransferred.set(0L);
                this.filesSkipped.set(0L);
                this.filesTransferred.set(0L);
                this.directoriesToTransfer.clear();
                this.directoriesTransferred.clear();
                this.directoriesSkipped.clear();
                this.totalBytesToTransfer.set(0L);
                this.totalFilesToTransfer.set(0L);
                this.timeofFileDetermination.set(0L);
                this.transferRate.set(0L);
                this.lastTransferRateBytes = 0L;
                this.lastTransferRateTime = 0L;
                for (int i = 0; i < transferRateSampleSize; ++i) {
                    this.transferRateAverages[i] = -1L;
                    this.transferRateTimestamps[i] = 0L;
                    this.transferRateByteCounts[i] = 0L;
                }
                if (this.timer == null) {
                    this.timerNameSet = false;
                    this.timer = new Timer();
                    TimerTask timertask = new TimerTask(){

                        public void run() {
                            if (!TransferEngine.this.timerNameSet) {
                                Thread.currentThread().setName("Transfer rate calculator timer");
                                TransferEngine.this.timerNameSet = true;
                            }
                            TransferEngine.this.calculateAverageTransferRate();
                        }
                    };
                    this.timer.scheduleAtFixedRate(timertask, 0L, 500L);
                }
                if (this.es != null && !this.es.isSubscribed(this.eventListener) && this.logEventListenerLevel != null) {
                    this.setLogEventListener(this.logEventListenerLevel);
                }
                this.fileProgressEventThread = new Thread("File Progress Event Thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int totalAmount = 0;
                        long lastUpdate = System.currentTimeMillis();
                        while (!7.interrupted()) {
                            try {
                                FileProgressEvent e = (FileProgressEvent)TransferEngine.this.fileProgressQueue.take();
                                FileTransfer ft = e.getFileTransfer();
                                totalAmount = (int)((long)totalAmount + e.getAmount());
                                Object object = TransferEngine.this.fileProgressEventPoolLock;
                                synchronized (object) {
                                    TransferEngine.this.fileProgressEventPool.offer(e);
                                }
                                if (ft.isFinished() || System.currentTimeMillis() - lastUpdate <= 500L) continue;
                                for (TransferListener tl : TransferEngine.this.eventSink) {
                                    tl.fileProgress(ft, totalAmount);
                                }
                                if (TransferEngine.this.logger.isLoggable(Level.FINEST)) {
                                    TransferEngine.this.logger.finest("File progress: " + ft + " progress=" + totalAmount);
                                }
                                totalAmount = 0;
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                    }
                };
                this.fileProgressEventThread.setDaemon(true);
                this.fileProgressEventThread.start();
                if (this.startedTime.get() > 0L) {
                    this.previousRunTime.addAndGet(this.finishedTime.get() - this.startedTime.get());
                }
                this.startedTime.set(0L);
                this.finishedTime.set(0L);
                this.setConnectionStatus(TransferListener.ConnectionStatus.DISCONNECTED);
                this.completionStatus = TransferListener.CompletionStatus.INCOMPLETE;
                this.completed = false;
                this.transportProtocol = null;
                this.readyToHandleErrors = false;
                this.errorList.clear();
                this.warningList.clear();
                if (this.fullUrlList == null) {
                    this.fullUrlList = this.agentListToUrl();
                    this.fullUrlList = this.fullUrlList.length() == 0 ? (this.urlList != null ? this.getUrlList() : "") : this.fullUrlList + (this.urlList != null ? this.getUrlList() : "");
                    this.fallbackUrls = this.fullUrlList.split("\n");
                    this.fallbackPosition = 0;
                }
                if (this.fallbackPosition >= this.fallbackUrls.length) {
                    this.fallbackPosition = 0;
                }
                this.cancelled.set(false);
                if (this.locallogfile != null && this.locallogfile.length() > 0 && this.logFileHandler == null) {
                    String parentName = this.getClass().getPackage().getName() + this.logInstance;
                    Logger parent = Logger.getLogger(parentName);
                    try {
                        this.logFileHandler = new FileHandler(this.locallogfile, true);
                        this.logFileHandler.setFormatter(new SimpleFormatter());
                        this.logFileHandler.setLevel(Level.ALL);
                        parent.addHandler(this.logFileHandler);
                    }
                    catch (IOException e) {
                        throw new LogfileConfigurationException(this.locallogfile, e);
                    }
                }
                if (this.locallogfile != null && this.locallogfile.length() > 0 && !this.logging.equalsIgnoreCase("INFO")) {
                    this.addInfo("A log file for this session can be found at: " + this.getLocalLogfile());
                }
                if (this.localUdpLogfile != null && this.localUdpLogfile.length() > 0 && this.udpTraceMask != 0) {
                    this.addInfo("A UDP log file for this session can be found at: " + this.getLocalUdpLogfile());
                }
                this.cert = this.loadCertificate(this.certificate);
                this.setConnectionStatus(TransferListener.ConnectionStatus.CONNECTING);
            }
            object = this.transportProtocolLock;
            synchronized (object) {
                if (this.transferInstance != null) {
                    this.transportProtocol = null;
                    Connector reconnector = new Connector(this.transferInstance);
                    reconnector.run();
                } else {
                    this.findFastestTransportProtocol();
                    try {
                        this.transportProtocolLock.wait();
                    }
                    catch (InterruptedException discard) {
                        // empty catch block
                    }
                }
            }
            this.readyToHandleErrors = true;
            if (this.transportProtocol == null) {
                this.setConnectionStatus(TransferListener.ConnectionStatus.DISCONNECTED);
                if (!this.handleFallback(true)) {
                    StringBuffer reason = new StringBuffer();
                    for (Exception w : this.warningList) {
                        reason.append(w.getMessage());
                    }
                    throw new CannotConnectException("Cannot connect to any remote system: " + reason, this.warningList.toArray(new Exception[0]));
                }
                return;
            }
            this.transportProtocol.transfer();
        }
        catch (Exception e) {
            this.addError(e);
        }
        catch (Throwable e) {
            this.addError(e);
        }
        while (this.fileProgressEventThread != null && this.fileProgressEventThread.isAlive() && this.fileProgressQueue.peek() != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException discard) {}
        }
        while (this.fileProgressEventPool.poll() != null) {
        }
        this.setConnectionStatus(TransferListener.ConnectionStatus.DISCONNECTED);
        if (this.cancelled.get()) {
            this.completionStatus = TransferListener.CompletionStatus.CANCELLED;
        } else {
            boolean warnings;
            if (this.restartCounter > 0) {
                this.addWarning(new MoreThanOneTransferAttemptWarning("Transfer attempts: " + this.restartCounter, this.restartCounter));
            }
            boolean successful = this.errorList.size() == 0;
            boolean bl = warnings = this.warningList.size() != 0;
            this.completionStatus = successful ? (warnings ? TransferListener.CompletionStatus.WARNING : TransferListener.CompletionStatus.SUCCESSFUL) : TransferListener.CompletionStatus.FAILURE;
        }
        Object object = this.completionEvent;
        synchronized (object) {
            if (this.automaticReconnector == null) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("Transfer completed: " + (Object)((Object)this.completionStatus));
                }
                if (this.es != null) {
                    this.es.unsubscribe(this.eventListener);
                }
                this.timer.cancel();
                this.timer = null;
                if (this.logFileHandler != null) {
                    this.logFileHandler.close();
                    this.logFileHandler = null;
                }
                this.completed = true;
            }
            this.fileProgressEventThread.interrupt();
            this.fileProgressEventThread = null;
            try {
                this.transportProtocol.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.gc();
            this.completionEvent.notifyAll();
        }
        if (TransferListener.CompletionStatus.SUCCESSFUL == this.completionStatus && "INFO".equalsIgnoreCase(this.logging) && this.locallogfile != null && this.locallogfile.length() > 0) {
            new File(this.locallogfile).delete();
        } else if (TransferListener.CompletionStatus.SUCCESSFUL != this.completionStatus && "INFO".equalsIgnoreCase(this.logging) && this.locallogfile != null && this.locallogfile.length() > 0) {
            this.addInfo("A log file for this session can be found at: " + this.getLocalLogfile());
        }
        this.postTransfer();
    }

    protected void postTransfer() {
        for (TransferListener tl : this.eventSink) {
            tl.postTransfer(this.completionStatus);
        }
    }

    @Override
    public synchronized void restartTransfer() throws Exception {
        if (this.transportProtocolThread != null) {
            return;
        }
        this.addInfo("Resuming");
        this.createTransferThread();
    }

    @Override
    public synchronized void startTransfer() throws Exception {
        if (this.transportProtocolThread != null) {
            return;
        }
        if (!this.versionLogged) {
            this.addInfo("Transfer engine: " + this.getBuildNumber());
            this.versionLogged = true;
        }
        long memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("System memory available: " + memory);
        }
        if (memory < 0x1000000L) {
            this.addError(new InsufficientMemoryException("Insufficient Memory to start transfer, only " + memory / 1024L + "kb remaining", memory));
            return;
        }
        this.restartCounter = 0;
        this.previousRunTime.set(0L);
        this.startedTime.set(0L);
        this.finishedTime.set(0L);
        this.createTransferThread();
    }

    private synchronized void createTransferThread() throws Exception {
        if (this.transportProtocolThread != null) {
            return;
        }
        this.completed = false;
        this.checkTransferParameters();
        if (this.automaticReconnector != null && Thread.currentThread() != this.automaticReconnector) {
            this.automaticReconnector.interrupt();
        }
        this.automaticReconnector = null;
        this.transportProtocolThread = new Thread("Transport Protocol"){

            public void run() {
                TransferEngine.this.doTransfer();
                TransferEngine.this.transportProtocolThread = null;
                TransferEngine.this.transportProtocol = null;
            }
        };
        this.transportProtocolThread.start();
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled != null ? this.cancelled.get() : true;
    }

    protected void setCancelled() {
        this.cancelled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTransfer() {
        Object object = this.startupAndInitializeLock;
        synchronized (object) {
            if (!this.cancelled.get()) {
                this.shutdownTransfer();
                this.setCancelled();
            } else {
                this.killAllConnectionAttempts();
            }
        }
        if (this.automaticReconnector != null) {
            this.automaticReconnector.interrupt();
            this.automaticReconnector = null;
            this.completionStatus = TransferListener.CompletionStatus.CANCELLED;
            for (TransferListener tl : this.eventSink) {
                tl.postTransfer(this.completionStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransferFailure() {
        Object object = this.startupAndInitializeLock;
        synchronized (object) {
            this.shutdownTransfer();
            this.completionStatus = TransferListener.CompletionStatus.FAILURE;
        }
        if (this.automaticReconnector != null) {
            this.automaticReconnector.interrupt();
            this.automaticReconnector.stop();
            this.automaticReconnector = null;
            this.completionStatus = TransferListener.CompletionStatus.FAILURE;
            for (TransferListener tl : this.eventSink) {
                tl.postTransfer(TransferListener.CompletionStatus.FAILURE);
            }
        }
        this.postTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAllConnectionAttempts() {
        Object object = this.startupAndInitializeLock;
        synchronized (object) {
            if (this.fallbackUrls != null) {
                this.fallbackPosition = this.fallbackUrls.length;
            }
            if (this.getConnectionStatus() == TransferListener.ConnectionStatus.CONNECTING) {
                this.transportProtocolConnectionReady(null, null);
            }
        }
    }

    @Override
    public void shutdownTransfer() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Shutting down transfer to " + this.transferInstance);
        }
        this.killAllConnectionAttempts();
        if (this.transportProtocol != null) {
            this.transportProtocol.shutdown();
        }
        this.finishedTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferListener.CompletionStatus waitForTransfer() {
        if (this.completed) {
            return this.completionStatus;
        }
        Object object = this.completionEvent;
        synchronized (object) {
            try {
                this.completionEvent.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.automaticReconnector == null) {
            return this.completionStatus;
        }
        return this.waitForTransfer();
    }

    @Override
    public synchronized void release() {
        if (this.logFileHandler != null) {
            this.logFileHandler.close();
        }
        this.logFileHandler = null;
        this.transferInstance = null;
        this.fullUrlList = null;
    }

    Certificate getCert() {
        return this.cert;
    }

    private void loadPreviousSettings() {
        try {
            this.loadSettings(new File(".dds_config"));
        }
        catch (Exception e) {
            this.newSettings();
        }
    }

    private void checkTransferParameters() throws ConfigurationException {
        if (!(this.agentList != null && this.agentList.length() != 0 || this.urlList != null && this.urlList.length() != 0)) {
            throw new MissingConfigurationException("No agents have been set", "com.signiant.interactivetransfer.engine.url_list");
        }
        if (this.agentList != null && this.agentList.length() > 0 && (this.user == null || this.user.length() == 0)) {
            throw new MissingConfigurationException("No user has been set", "com.signiant.interactivetransfer.engine.user");
        }
        if (this.agentList != null && this.agentList.length() > 0 && (this.password == null || this.password.length == 0)) {
            throw new MissingConfigurationException("No password has been set", "com.signiant.interactivetransfer.engine.password");
        }
        if (this.files == null || this.files.size() == 0) {
            throw new MissingConfigurationException("No files to transfer have been set", "com.signiant.interactivetransfer.engine.files");
        }
        if (this.mode == TransferMode.RECEIVE && (this.destination == null || this.destination.length() == 0)) {
            throw new MissingConfigurationException("No destination directory has been set", "com.signiant.interactivetransfer.engine.destination_dir");
        }
        if (!(this.agentList == null || this.agentList.length() <= 0 || this.certificateless || this.certificate != null && this.certificate.length() != 0)) {
            throw new MissingConfigurationException("No transfer manager certificate has been set", "com.signiant.interactivetransfer.engine.ca_certificate");
        }
        if (this.transport == Transport.NONE) {
            throw new MissingConfigurationException("No transport method for the transfer has been set", "com.signiant.interactivetransfer.engine.transport");
        }
        if ((this.transport == Transport.UDP || this.transport == Transport.UDP_THEN_TCP) && this.targetRate.get() > 0L && this.minRate.get() > this.targetRate.get()) {
            throw new TargetLessThenMinimumRateException(this.targetRate.get(), this.minRate.get());
        }
    }

    @Override
    public long getAgentStatUpdateInterval() {
        return this.agentStatUpdateInterval.get();
    }

    @Override
    public String getPackageID() {
        return this.packageid;
    }

    @Override
    public String getJobNamePrefix() {
        return this.jobNamePrefix;
    }

    @Override
    public String getJobGroup() {
        return this.jobGroup;
    }

    @Override
    public void setAgentStatUpdateInterval(long value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("agentStatUpdateInterval: " + value);
        }
        this.agentStatUpdateInterval.set(value);
    }

    @Override
    public void setPackageID(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("packageid: " + value);
        }
        this.packageid = value;
    }

    @Override
    public void setJobNamePrefix(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("jobNamePrefix: " + value);
        }
        this.jobNamePrefix = value;
    }

    @Override
    public void setJobGroup(String value) {
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config("jobGroup: " + value);
        }
        this.jobGroup = value;
    }

    @Override
    public boolean isPackageIDSet() {
        return this.packageid != null;
    }

    @Override
    public boolean isJobNamePrefixSet() {
        if (this.jobNamePrefix != null) {
            return this.jobNamePrefix.matches("\\w{1,30}");
        }
        return false;
    }

    @Override
    public boolean isJobGroupSet() {
        if (this.jobGroup != null) {
            return this.jobGroup.matches("\\w{1,64}");
        }
        return false;
    }

    private Certificate loadCertificate(String str) throws TransferException {
        if (!(this.agentList != null && this.agentList.length() != 0 && !this.certificateless || str != null && str.length() != 0)) {
            return null;
        }
        try {
            byte[] bytes = str.getBytes();
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            return factory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            CertificateLoadException te = new CertificateLoadException("Unable to read certificate data", e);
            te.initCause(e);
            throw te;
        }
    }

    private static String prettyRates(long bytes) {
        float amt;
        int scale = 0;
        String[] measure = new String[]{"Bytes/s", "KBytes/s", "MBytes/s", "GBytes/s", "TBytes/s"};
        for (amt = (float)bytes; amt > 1024.0f; amt /= 1024.0f) {
            ++scale;
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        if (scale == 0) {
            return f.format("%.0f %s", Float.valueOf(amt), measure[scale]).toString();
        }
        return f.format("%.2f %s", Float.valueOf(amt), measure[scale]).toString();
    }

    public static void main(String[] args) {
        boolean intervalStats = false;
        int interval = 1000;
        if (args.length < 1) {
            System.out.println("java -jar webclient.jar com.signiant.interactivetransfer.engine.TransferEngine config_file");
            return;
        }
        if (args.length >= 2 && (intervalStats = args[1].equalsIgnoreCase("-int")) && args.length >= 3) {
            try {
                interval = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException discard) {
                // empty catch block
            }
        }
        TransferEngine engine = new TransferEngine();
        try {
            engine.loadSettings(new File(args[0]));
            engine.addTransferListener(new ConsoleEventListener());
            engine.startTransfer();
        }
        catch (Exception e) {
            System.err.println("Exception caught while performing transfer:  " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        long intervalStart = System.currentTimeMillis();
        long nbs = 0L;
        long nba = 0L;
        long wps = 0L;
        long wpa = 0L;
        long wprecv = 0L;
        long wprest = 0L;
        long wprejc = 0L;
        boolean first = true;
        while (!engine.isCompleted()) {
            if (intervalStats) {
                if (engine.getConnectionStatus() != TransferListener.ConnectionStatus.CONNECTED) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException discard) {}
                    continue;
                }
                if (first) {
                    System.out.println("Bits/s Throughput,Interval Start,Interval End,Network Bytes Sent,Network Bytes Acknowledged,Bandwidth Throttle (bits/sec),WAN Accelerator Ceiling (bits/sec),WAN Accelerator Floor (bits/sec),WAN Accelerator Packets Sent,WAN Accelerator Packets Acknowledged,WAN Accelerator Packets Received,WAN Accelerator Packets Resent,WAN Accelerator Packets Rejected");
                    first = false;
                }
                long intervalEnd = System.currentTimeMillis();
                nbs = engine.getBytesTransferred() - nbs;
                nba = engine.getBytesTransferred() - nba;
                System.out.println(engine.getTransferRate() * 8L + "," + intervalStart + "," + intervalEnd + "," + nbs + "," + nba + "," + engine.getBandwidthThrottle() * 8L + "," + engine.getTargetRate() * 8L + "," + engine.getMinimumRate() * 8L + "," + wps + "," + wpa + "," + wprecv + "," + wprest + "," + wprejc);
                nbs = engine.getBytesTransferred();
                nba = engine.getBytesTransferred();
                intervalStart = System.currentTimeMillis();
                try {
                    Thread.sleep(interval);
                }
                catch (Exception discard) {}
                continue;
            }
            System.out.print("\rRate = " + TransferEngine.prettyRates(engine.getTransferRate()) + " " + engine.getFilesTransferred() + "/" + engine.getTotalFilesToTransfer() + "           ");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception discard) {}
        }
        System.out.println("Completion status:        " + (Object)((Object)engine.waitForTransfer()));
        System.out.println("");
        System.out.println("Files Transferred:        " + engine.getFilesTransferred());
        System.out.println("Files Skipped:            " + engine.getFilesSkipped());
        System.out.println("Bytes Transferred:        " + engine.getBytesTransferred());
        System.out.println("Bytes Skipped:            " + engine.getBytesSkipped());
        System.out.println("Directories Transferred:  " + engine.getDirectoriesTransferred());
        System.out.println("Directories Skipped:      " + engine.getDirectoriesSkipped());
        System.out.println("Elapsed Time:             " + engine.getElapsedTime());
        System.out.println("Transfer Rate:            " + engine.getTransferRate());
        switch (engine.getCompletionStatus()) {
            case SUCCESSFUL: {
                System.exit(0);
                break;
            }
            case WARNING: {
                System.exit(1);
                break;
            }
            case FAILURE: {
                System.exit(-1);
            }
        }
        System.exit(0);
    }

    protected static boolean isNetworkError(Exception e) {
        boolean is = e instanceof DataStream.StreamException || e instanceof NoHeartbeatException || e instanceof ConnectionResetException || e instanceof PacketResentCountExceededException || e instanceof StreamConnectionTimeoutException || e instanceof UdpSessionTerminatedException || e instanceof IOException;
        return is;
    }

    @Override
    public TransferInstance getTransferInstance() {
        return this.transferInstance;
    }

    protected int getTotalErrors() {
        return this.warningList.size();
    }

    protected int getPermanentErrors() {
        return this.errorList.size();
    }

    @Override
    public Queue<Exception> getErrorList() {
        return this.errorList;
    }

    @Override
    public Queue<Exception> getWarningList() {
        return this.warningList;
    }

    @Override
    public boolean getInitialConnectionWasSuccessful() {
        return this.initialConnectionWasSuccessful;
    }

    public String getHostname() {
        return this.hostname;
    }

    private static class ConsoleEventListener
    implements TransferListener {
        public void addDetailMessage(String m) {
        }

        public void connectionStatusChange(TransferListener.ConnectionStatus status) {
            this.addDetailMessage(status.toString());
        }

        public void exception(Exception e) {
            this.addDetailMessage("Exception: " + e);
        }

        public void fileHeader(FileTransfer ft) {
            this.addDetailMessage("Starting: " + ft.getFileString());
        }

        public void filePosition(FileTransfer ft, long pos) {
            this.addDetailMessage("Skipped ahead " + pos + " of file " + ft.getFileString());
        }

        public void fileProgress(FileTransfer ft, long bytesSent) {
            this.addDetailMessage("Received " + bytesSent + " of file " + ft.getFileString());
        }

        public void postFile(FileTransfer ft) {
            this.addDetailMessage("Finished: " + ft.getFileString());
        }

        public void postTransfer(TransferListener.CompletionStatus status) {
        }

        public void preFile(FileTransfer ft) {
        }

        public void preTransfer() {
            this.addDetailMessage("Transfer ready to start");
        }

        public void skipFile(FileTransfer ft) {
            this.addDetailMessage("Skipped: " + ft.getFileString());
        }

        public void statusUpdate(StatusEvent status) {
            this.addDetailMessage(status.getStatus());
        }
    }

    private class Connector
    extends Thread {
        private TransferInstance instance;
        private String connectionAttemptResult;
        private Throwable connectionAttemptException;
        private boolean successful;
        private TransportProtocol protocol;

        public Connector(TransferInstance instance) {
            super("Connector: " + instance);
            this.instance = instance;
            if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                TransferEngine.this.logger.fine("Created connector to: " + instance);
            }
        }

        public String getConnectionAttemptResult() {
            return this.connectionAttemptResult;
        }

        public Throwable getConnectionAttemptException() {
            return this.connectionAttemptException;
        }

        public TransportProtocol getTransportProtocolActor() {
            return this.protocol;
        }

        public TransferInstance getTransferInstance() {
            return this.instance;
        }

        public void close() {
            if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                TransferEngine.this.logger.fine("Closing connector to: " + this.instance + ": " + this.instance.getAgentPort());
            }
            try {
                this.protocol.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public void run() {
            this.protocol = null;
            this.successful = false;
            try {
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Connecting to: " + this.instance);
                }
                TransferEngine.this.addInfo("Trying " + this.instance + "...");
                URL url = this.instance.getUrl();
                if (url != null) {
                    if (url.getProtocol().equals("mxwan") || url.getProtocol().equals("mxtcp") || url.getProtocol().equals("plain") || url.getProtocol().equals("http")) {
                        if (TransferEngine.this.logger.isLoggable(Level.FINEST)) {
                            TransferEngine.this.logger.finest("Creating new ControlStream object for: " + this.instance);
                        }
                        this.protocol = new ControlStream(TransferEngine.this, this.instance);
                    } else if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
                        this.protocol = new HTTPStream(TransferEngine.this, this.instance);
                    } else if (url.getProtocol().equals("ftp")) {
                        this.protocol = new FTPStream(TransferEngine.this, this.instance);
                    }
                }
                if (this.protocol == null) {
                    throw new InvalidConfigurationValueException("Protocol not supported at this time", "com.signiant.interactivetransfer.engine.url_list", new String[]{"mxwan://", "mxtcp://", "http://", "https://", "ftp://"});
                }
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Connected to: " + this.instance);
                }
            }
            catch (Throwable noConnection) {
                String message;
                this.connectionAttemptException = noConnection;
                this.connectionAttemptResult = noConnection instanceof OutOfMemoryError ? "Insufficient memory available to perform transfer" : (noConnection instanceof NoClassDefFoundError ? "Cannot locate resource: " + noConnection.getLocalizedMessage() : ((message = noConnection.getMessage()) == null ? "Unable to connect to " + this.instance.getRelayAddress().getHostName() + ":" + this.instance.getRelayPort() + ": " + noConnection.toString() : "Unable to connect to " + this.instance.getRelayAddress().getHostName() + ":" + this.instance.getRelayPort() + ": " + noConnection.getMessage()));
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine(this.connectionAttemptResult);
                }
                if (TransferEngine.this.logger.isLoggable(Level.FINEST)) {
                    StringBuffer b = new StringBuffer();
                    for (StackTraceElement ste : noConnection.getStackTrace()) {
                        b.append(ste + "\n");
                    }
                    TransferEngine.this.logger.finest("Connection backtrace: " + b.toString());
                }
                return;
            }
            try {
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Checking for response from: " + this.instance);
                }
                this.protocol.attemptConnection();
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine("Verified response from: " + this.instance);
                }
                TransferEngine.this.transportProtocolConnectionReady(this.protocol, this.instance);
            }
            catch (Throwable notConfigured) {
                this.connectionAttemptException = notConfigured;
                if (TransferEngine.this.logger.isLoggable(Level.FINER)) {
                    TransferEngine.this.logger.finer("Caught connection exception: " + notConfigured);
                }
                if (notConfigured instanceof OutOfMemoryError) {
                    this.connectionAttemptResult = "Insufficient memory available to perform transfer";
                } else if (notConfigured instanceof SocketTimeoutException || notConfigured instanceof ClosedChannelException) {
                    this.connectionAttemptResult = "Timeout connecting to " + this.instance;
                } else if (notConfigured instanceof IOException) {
                    String detailMessage = notConfigured.getLocalizedMessage();
                    while (notConfigured.getCause() != null && !detailMessage.equals(notConfigured.getCause().getLocalizedMessage())) {
                        TransferEngine.this.logger.fine("Error path: " + detailMessage);
                        detailMessage = notConfigured.getLocalizedMessage();
                        notConfigured = notConfigured.getCause();
                    }
                    this.connectionAttemptResult = "Error connecting to " + this.instance + ": " + detailMessage;
                } else {
                    this.connectionAttemptException = notConfigured instanceof MediaExchangeServerDisabledException ? notConfigured : new ServerUnreachableException("Server not configured to accept transfers", notConfigured, this.instance.getRelayAddress().getHostName());
                    this.connectionAttemptResult = "Unable to connect to " + this.instance.getRelayAddress().getHostName() + ": " + this.connectionAttemptException.getMessage() + " ";
                    if (!this.instance.getAgentAddress().equals(this.instance.getRelayAddress())) {
                        this.connectionAttemptException = new RelayedServerUnreachableException("Server not configured to accept transfers", notConfigured, this.instance.getRelayAddress().getHostName());
                    }
                }
                if (TransferEngine.this.logger.isLoggable(Level.FINE)) {
                    TransferEngine.this.logger.fine(this.connectionAttemptResult);
                }
                try {
                    this.protocol.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.successful = true;
        }
    }

    private class FileProgressEvent {
        private FileTransfer ft;
        private long amount;

        FileProgressEvent() {
        }

        public FileTransfer getFileTransfer() {
            return this.ft;
        }

        public void setFileTransfer(FileTransfer ft) {
            this.ft = ft;
        }

        public long getAmount() {
            return this.amount;
        }

        public void setAmount(long amount) {
            this.amount = amount;
        }
    }
}

