/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

class SizeCountingInputStream
extends InputStream {
    private InputStream delegate;
    private AtomicLong byteCount;

    SizeCountingInputStream(InputStream is) {
        this.delegate = is;
        this.byteCount = new AtomicLong(0L);
    }

    public int read() throws IOException {
        int data = this.delegate.read();
        this.byteCount.incrementAndGet();
        return data;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.delegate.read(b, off, len);
        this.byteCount.addAndGet(count);
        return count;
    }

    public int read(byte[] b) throws IOException {
        int count = this.delegate.read(b);
        this.byteCount.addAndGet(count);
        return count;
    }

    public long getByteCount() {
        return this.byteCount.get();
    }

    public long getByteCountInterval() {
        return this.byteCount.getAndSet(0L);
    }
}

