/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import com.signiant.jsf.services.protocoltunnel.versions.ProtocolConnectionBaseImpl;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.Port;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class HttpTunnel
extends Port {
    private ProtocolConnection client;

    public HttpTunnel(InetSocketAddress address, String logInstance) throws IOException {
        super(logInstance);
        this.address = address;
        this.type = Port.Type.HTTP;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Connecting to: " + address);
        }
        this.client = new ProtocolConnectionBaseImpl("http");
        this.client.setPeerHost(address.getHostName());
        this.client.setPeerPort(address.getPort());
        this.client.setClient(true);
        this.client.setupClient();
    }

    public int readImpl(ByteBuffer buffer) throws IOException, InterruptedException {
        if (this.client.getState() == ProtocolConnection.State.CLOSED) {
            throw new IOException("Stream closed");
        }
        int size = buffer.remaining();
        byte[] tempBuffer = new byte[size];
        int bytesRead = this.client.decodeProtocolStream(tempBuffer);
        if (bytesRead >= 0) {
            buffer.put(tempBuffer, 0, bytesRead);
            buffer.limit(buffer.position());
        } else {
            this.client.terminate();
        }
        return bytesRead;
    }

    public int writeImpl(ByteBuffer buffer, AcknowledgeFeedback feedback) throws IOException {
        if (this.client.getState() == ProtocolConnection.State.CLOSED) {
            throw new IOException("Stream closed");
        }
        int totalSent = 0;
        while (buffer.remaining() > 0) {
            int size = Math.min(buffer.remaining(), 65536);
            byte[] tempBuffer = new byte[size];
            buffer.get(tempBuffer);
            this.client.encodeProtocolStream(tempBuffer, tempBuffer.length);
            totalSent += tempBuffer.length;
        }
        if (feedback != null) {
            feedback.acknowledged(feedback.getSendNumber(), totalSent);
        }
        return totalSent;
    }

    public void closeImpl() throws IOException {
        this.client.terminate();
    }

    public void wakeupImpl() {
        this.client.terminate();
    }

    public InetAddress getLocalInetAddressImpl() {
        return this.client.getLocalInetAddress();
    }
}

