/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferInstance;
import com.signiant.interactivetransfer.engine.TransferMode;
import com.signiant.interactivetransfer.engine.TransportProtocol;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class HTTPStream
implements TransportProtocol,
HostnameVerifier {
    private TransferEngine engine;
    private TransferInstance instance;
    private HttpURLConnection http;
    private HashMap<String, FileTransfer> headersProcessed;
    private LinkedBlockingQueue<FileTransfer> pendingFiles;
    private Thread[] dataStreams;
    private boolean running;
    protected Logger logger;

    public HTTPStream(TransferEngine engine, TransferInstance instance) throws Exception {
        this.engine = engine;
        this.instance = instance;
        this.logger = Logger.getLogger(this.getClass().getPackage().getName() + engine.getLogInstance() + "." + this.getClass().getSimpleName());
        this.pendingFiles = new LinkedBlockingQueue();
        this.headersProcessed = new HashMap();
        if (engine.getMode() == TransferMode.SEND) {
            throw new Exception("Sending of files not supported using HTTP");
        }
    }

    public String toString() {
        return this.instance.getUrl().getProtocol() + "://" + this.instance.getUrl().getHost();
    }

    public boolean verify(String hostname, SSLSession session) {
        return true;
    }

    public void attemptConnection() throws Exception {
        block3: {
            HttpURLConnection.setFollowRedirects(false);
            this.http = (HttpURLConnection)this.instance.getUrl().openConnection();
            if (this.http instanceof HttpsURLConnection) {
                ((HttpsURLConnection)this.http).setHostnameVerifier(this);
            }
            this.http.setConnectTimeout(10000);
            try {
                this.http.connect();
            }
            catch (Throwable npe) {
                if (!(npe.getCause() instanceof NullPointerException) || this.engine.getJava16HttpsAllow()) break block3;
                throw new IOException("Unable to download requested data due to known Java 1.6 HTTPS authentication issue\n(refer to http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6514454 for details)");
            }
        }
        this.http = null;
    }

    public void close() throws IOException, TransferException {
        if (this.http != null) {
            this.http.getInputStream().close();
        }
    }

    public void shutdown() {
        this.running = false;
        for (int i = 0; i < this.dataStreams.length; ++i) {
            if (!this.dataStreams[i].isAlive()) continue;
            try {
                if (Thread.currentThread() == this.dataStreams[i]) continue;
                this.dataStreams[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void transfer() throws IOException {
        int i;
        this.engine.preStreams();
        this.running = true;
        int filenumber = 1;
        for (String filename : this.engine.getFiles()) {
            try {
                FileTransfer ft = new FileTransfer(this.engine, filenumber++, filename, 0, 0L, 0L, false, filename, false);
                this.pendingFiles.put(ft);
            }
            catch (InterruptedException discard) {
                return;
            }
        }
        final String destinationDir = this.engine.getDestination();
        File destdir = new File(destinationDir);
        if (!(destdir.exists() || destdir.mkdirs() || destdir.exists())) {
            throw new IOException("Cannot create directory: " + destinationDir);
        }
        this.engine.preTransfer();
        final URL base = this.instance.getUrl();
        final String urlBasePath = base.getFile();
        int numberOfStreams = Math.max(this.engine.getNumberOfStreams(), Math.min(4, this.pendingFiles.size()));
        this.dataStreams = new Thread[numberOfStreams];
        for (i = 0; i < numberOfStreams; ++i) {
            this.dataStreams[i] = new Thread(){

                public void run() {
                    FileTransfer ft;
                    while (HTTPStream.this.running && (ft = (FileTransfer)HTTPStream.this.pendingFiles.poll()) != null) {
                        URL file;
                        File workfile;
                        File checkpoint;
                        long filesize;
                        long checkpointPosition;
                        String checkpointFilename;
                        String workFilename;
                        String fullfilename;
                        String remotefilename;
                        String filename;
                        block55: {
                            String filepath = "";
                            if (ft.getFile().getParent() != null) {
                                filepath = ft.getFile().getParent().replaceFirst("^/", "") + "/";
                            }
                            filename = ft.getFile().getName();
                            remotefilename = urlBasePath.replaceFirst("^/", "") + filepath + filename;
                            try {
                                String temp = "";
                                for (String part : remotefilename.split("/")) {
                                    temp = temp + "/" + URLEncoder.encode(part, "UTF-8");
                                }
                                remotefilename = temp;
                            }
                            catch (UnsupportedEncodingException e) {
                                ft.setError(e);
                                HTTPStream.this.engine.addWarning(e);
                                continue;
                            }
                            fullfilename = destinationDir + "/" + filename;
                            workFilename = destinationDir + "/#work_file#" + filename;
                            checkpointFilename = destinationDir + "/#chkpt_file#" + filename;
                            checkpointPosition = 0L;
                            filesize = 0L;
                            checkpoint = new File(checkpointFilename);
                            workfile = new File(workFilename);
                            if (checkpoint.exists() && workfile.exists()) {
                                if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    HTTPStream.this.logger.finest(this.toString() + ": Checkpoint and workfile exist: " + checkpointFilename + " " + workFilename);
                                }
                                try {
                                    BufferedReader in = new BufferedReader(new FileReader(checkpointFilename));
                                    checkpointPosition = Long.parseLong(in.readLine());
                                    filesize = Long.parseLong(in.readLine());
                                }
                                catch (Exception badcheckpoint) {
                                    if (HTTPStream.this.logger.isLoggable(Level.WARNING)) {
                                        HTTPStream.this.logger.warning(this.toString() + ": Checkpoint corrupt: " + badcheckpoint);
                                    }
                                    checkpoint.delete();
                                    workfile.delete();
                                    checkpointPosition = 0L;
                                    filesize = 0L;
                                }
                            }
                            try {
                                file = new URL(base, remotefilename);
                                if (!HTTPStream.this.logger.isLoggable(Level.FINEST)) break block55;
                                HTTPStream.this.logger.finest("Connecting to: " + file + " ft=" + ft);
                            }
                            catch (MalformedURLException e) {
                                ft.setError(e);
                                HTTPStream.this.engine.addWarning(e);
                                continue;
                            }
                        }
                        try {
                            PrintWriter checkpointWriter;
                            HttpURLConnection http;
                            block56: {
                                http = (HttpURLConnection)file.openConnection();
                                http.setRequestProperty("Range", "bytes=" + checkpointPosition + "-");
                                http.setConnectTimeout(10000);
                                try {
                                    http.connect();
                                }
                                catch (Throwable npe) {
                                    if (!(npe.getCause() instanceof NullPointerException)) break block56;
                                    if (!HTTPStream.this.engine.getJava16HttpsAllow()) {
                                        ft.failedAttempt(new TransferException("Java Bug 6514454"));
                                        HTTPStream.this.pendingFiles.put(ft);
                                        continue;
                                    }
                                    ft.setError(new TransferException("Unable to download requested data due to known Java 1.6 HTTPS authentication issue"));
                                    continue;
                                }
                            }
                            if (http.getResponseCode() < 200 || http.getResponseCode() >= 300) {
                                if (HTTPStream.this.logger.isLoggable(Level.FINE)) {
                                    HTTPStream.this.logger.fine("HTTP error response (" + http.getResponseCode() + "): " + ft);
                                }
                                TransferWarning why = new TransferWarning("Cannot receive file: " + filename + " HTTP error response: " + http.getResponseMessage());
                                ft.setError(why);
                                HTTPStream.this.engine.addWarning(why);
                                continue;
                            }
                            Map<String, List<String>> headers = http.getHeaderFields();
                            if (headers.containsKey("Last-Modified")) {
                                ft.setLastModifiedAt(http.getLastModified());
                            } else {
                                ft.setLastModifiedAt(http.getDate());
                            }
                            ft.setSize((long)http.getContentLength() + checkpointPosition);
                            FileTransfer verify = (FileTransfer)HTTPStream.this.headersProcessed.get(remotefilename);
                            if (verify == null) {
                                HTTPStream.this.headersProcessed.put(remotefilename, ft);
                                HTTPStream.this.engine.fileHeader(ft);
                            } else if (ft.getLastModifiedAt() != verify.getLastModifiedAt() || ft.getSize() != verify.getSize()) {
                                ft.setError(new TransferException("File on server changed during transfer"));
                                HTTPStream.this.engine.skipFile(ft);
                                continue;
                            }
                            File newname = new File(fullfilename);
                            if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                HTTPStream.this.logger.finest("Receiving content into " + fullfilename + " ft=" + ft);
                            }
                            if (newname.exists()) {
                                if (newname.isDirectory()) {
                                    if (HTTPStream.this.logger.isLoggable(Level.FINE)) {
                                        HTTPStream.this.logger.fine("Skipped (directory): " + ft);
                                    }
                                    ft.skippedFileExists();
                                    HTTPStream.this.engine.addWarning(new TransferWarning("Cannot receive file: " + filename + " is a directory"));
                                    HTTPStream.this.engine.skipFile(ft);
                                    continue;
                                }
                                if (newname.length() == ft.getSize() && newname.lastModified() == ft.getLastModifiedAt()) {
                                    if (HTTPStream.this.logger.isLoggable(Level.FINE)) {
                                        HTTPStream.this.logger.fine("Skipped (file sizes and modified times match): " + ft);
                                    }
                                    ft.skippedFileExists();
                                    HTTPStream.this.engine.skipFile(ft);
                                    continue;
                                }
                                if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    HTTPStream.this.logger.finest("File skip size check failed: " + newname.length() + " <> " + ft.getSize() + " date: " + newname.lastModified() + " <> " + ft.getLastModifiedAt());
                                }
                            }
                            if (filesize != ft.getSize() || checkpointPosition != workfile.length()) {
                                if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    HTTPStream.this.logger.finest(this.toString() + ": Checkpoint does not match workfile: cp " + filesize + " <> rem " + ft.getSize() + " or cp " + checkpointPosition + " <> loc " + workfile.length());
                                }
                                checkpointPosition = 0L;
                                checkpoint.delete();
                                workfile.delete();
                                file = new URL(base, remotefilename);
                                http = (HttpURLConnection)file.openConnection();
                                http.setConnectTimeout(10000);
                                http.connect();
                            } else {
                                HTTPStream.this.engine.filePosition(ft, checkpointPosition);
                            }
                            if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                HTTPStream.this.logger.finest(this.toString() + ": Seek to " + checkpointPosition + " of " + ft);
                            }
                            byte[] buffer = new byte[0x104000];
                            InputStream is = http.getInputStream();
                            BufferedOutputStream workfileStream = new BufferedOutputStream(new FileOutputStream(workFilename, checkpointPosition > 0L));
                            int totalRead = 0;
                            int bytesRead = 0;
                            int index = 0;
                            while (HTTPStream.this.running && (bytesRead = is.read(buffer, index, 16384)) > 0) {
                                HTTPStream.this.engine.fileProgress(ft, bytesRead);
                                if ((index += bytesRead) > 0x100000) {
                                    checkpointWriter = new PrintWriter(checkpointFilename);
                                    ((OutputStream)workfileStream).write(buffer, 0, index);
                                    ((OutputStream)workfileStream).flush();
                                    checkpointWriter.println((long)(totalRead += index) + checkpointPosition);
                                    checkpointWriter.println(ft.getSize());
                                    checkpointWriter.close();
                                    index = 0;
                                }
                                HTTPStream.this.engine.throttle(bytesRead);
                            }
                            if (!HTTPStream.this.running) {
                                ((OutputStream)workfileStream).close();
                                return;
                            }
                            if (index > 0) {
                                ((OutputStream)workfileStream).write(buffer, 0, index);
                                ((OutputStream)workfileStream).flush();
                                totalRead += index;
                            }
                            ((OutputStream)workfileStream).close();
                            if ((long)totalRead + checkpointPosition != ft.getSize()) {
                                checkpointWriter = new PrintWriter(checkpointFilename);
                                checkpointWriter.println((long)totalRead + checkpointPosition);
                                checkpointWriter.println(ft.getSize());
                                checkpointWriter.close();
                                throw new TransferWarning("Connection lost");
                            }
                            if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                HTTPStream.this.logger.finest(this.toString() + ": Completed " + ft);
                            }
                            checkpoint.delete();
                            newname = new File(fullfilename);
                            if (newname.exists()) {
                                if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    HTTPStream.this.logger.finest(this.toString() + ": Deleting existing file " + newname.getAbsolutePath());
                                }
                                newname.delete();
                            }
                            if (!workfile.renameTo(newname)) {
                                int n;
                                FileOutputStream fos;
                                FileInputStream fis;
                                if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    HTTPStream.this.logger.finest(this.toString() + ": Could not rename " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                }
                                try {
                                    fis = new FileInputStream(workfile);
                                    fos = new FileOutputStream(newname);
                                }
                                catch (IOException ie) {
                                    if (HTTPStream.this.logger.isLoggable(Level.WARNING)) {
                                        HTTPStream.this.logger.warning(this.toString() + ": Could not copy " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                    }
                                    HTTPStream.this.engine.addWarning(new TransferWarning("Could not rename '" + workfile.getAbsolutePath() + "' to '" + newname.getAbsolutePath() + "': " + ie.getMessage()));
                                    ft.setTransferred();
                                    HTTPStream.this.engine.postFile(ft);
                                    continue;
                                }
                                if (HTTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    HTTPStream.this.logger.finest(this.toString() + ": Copying " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                }
                                byte[] inbuf = new byte[8192];
                                while ((n = fis.read(inbuf)) != -1) {
                                    fos.write(inbuf, 0, n);
                                }
                                fis.close();
                                fos.close();
                                if (!workfile.delete()) {
                                    if (HTTPStream.this.logger.isLoggable(Level.WARNING)) {
                                        HTTPStream.this.logger.warning(this.toString() + ": Could not delete " + workfile.getAbsolutePath());
                                    }
                                    HTTPStream.this.engine.addWarning(new TransferWarning("Could not remove workfile '" + workfile.getAbsolutePath() + "'"));
                                }
                            }
                            if (HTTPStream.this.logger.isLoggable(Level.FINER)) {
                                HTTPStream.this.logger.finer(this.toString() + ": Setting last modified time of " + newname.getAbsolutePath() + " to " + new Date(ft.getLastModifiedAt()) + "(" + ft.getLastModifiedAt() + ")");
                            }
                            newname.setLastModified(ft.getLastModifiedAt());
                            ft.setTransferred();
                            HTTPStream.this.engine.postFile(ft);
                        }
                        catch (Exception e) {
                            try {
                                ft.failedAttempt(e);
                                HTTPStream.this.engine.addWarning(e);
                                HTTPStream.this.pendingFiles.add(ft);
                            }
                            catch (Exception failed) {
                                HTTPStream.this.engine.addWarning(failed);
                            }
                        }
                    }
                }
            };
            this.dataStreams[i].start();
        }
        for (i = 0; i < this.dataStreams.length; ++i) {
            if (!this.dataStreams[i].isAlive()) continue;
            try {
                this.dataStreams[i].join();
                continue;
            }
            catch (InterruptedException discard) {
                // empty catch block
            }
        }
    }
}

