/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.exceptions.CannotCreateDirectoryWarning;
import com.signiant.interactivetransfer.engine.exceptions.CannotOpenFileWarning;
import com.signiant.interactivetransfer.engine.exceptions.FileHasBeenMovedWarning;
import com.signiant.interactivetransfer.engine.exceptions.FileRetryLimitException;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileTransfer
extends EventObject {
    private static final long serialVersionUID = 0L;
    private TransferEngine engine;
    private String relativeName;
    private String parentDirectory;
    private Exception errorReason;
    private DirectoryHandlingMode directoryHandlingMode;
    private boolean isIncludedForEncryption = false;
    protected File file;
    protected OutputStream fileOutputStream;
    protected int sequence;
    protected Logger logger;
    protected int mode;
    protected long size;
    protected long checkpointPosition;
    protected long lastModifiedAt;
    protected boolean checkpointDisabled;
    protected boolean dummyTransfer;
    protected long dummyPosition;
    protected State state;
    protected int attemptNumber;
    FileChannel fileChannel;

    String getParentDirectory() {
        return this.parentDirectory;
    }

    public boolean isIncludedForEncryption() {
        return this.isIncludedForEncryption;
    }

    public String getPathHandledName() {
        switch (this.directoryHandlingMode) {
            case FLAT: {
                return this.file.getName();
            }
            case FULL: {
                String fullPath = this.file.getPath();
                if (System.getProperty("os.name").startsWith("Win") && fullPath.length() > 1 && fullPath.charAt(1) == ':') {
                    fullPath = fullPath.replaceFirst(":", "");
                }
                return fullPath;
            }
            case PATH: {
                return this.relativeName;
            }
        }
        return this.relativeName;
    }

    private FileTransfer(TransferEngine engine, int sequence) {
        super(engine == null ? new Object() : engine);
        this.engine = engine;
        this.sequence = sequence;
        this.attemptNumber = 1;
        this.state = State.PENDING;
        DirectoryHandlingMode directoryHandlingMode = this.directoryHandlingMode = engine == null ? DirectoryHandlingMode.FULL : engine.getDirectoryHandlingMode();
        if (engine != null) {
            this.logger = Logger.getLogger(this.getClass().getPackage().getName() + engine.getLogInstance() + "." + this.getClass().getSimpleName());
        }
    }

    FileTransfer(TransferEngine engine, int sequence, File file, String parentDirectory, String relativeName) {
        this(engine, sequence);
        this.file = file;
        this.mode = 33279;
        File nullDir = new File("/dev/null/");
        String nullDirectory = nullDir.getAbsolutePath();
        if (parentDirectory.startsWith(nullDirectory)) {
            this.size = Long.parseLong(relativeName);
            this.lastModifiedAt = System.currentTimeMillis() / 1000L;
            this.dummyTransfer = true;
            this.dummyPosition = 0L;
        } else {
            this.size = file.length();
            this.lastModifiedAt = file.lastModified() / 1000L;
            this.dummyTransfer = false;
        }
        this.parentDirectory = parentDirectory;
        this.relativeName = relativeName;
    }

    FileTransfer(TransferEngine engine, int sequence, String name, int mode, long size, long modified, boolean checkpointed, String parentDirectory, boolean isIncludedForEncryption) throws IOException {
        this(engine, sequence);
        this.mode = mode;
        this.size = size;
        this.lastModifiedAt = modified;
        this.checkpointDisabled = checkpointed;
        this.directoryHandlingMode = engine.getDirectoryHandlingMode();
        this.parentDirectory = parentDirectory;
        this.isIncludedForEncryption = isIncludedForEncryption;
        switch (this.directoryHandlingMode) {
            case FLAT: {
                this.file = new File(engine.getDestination(), new File(name).getName());
                break;
            }
            case FULL: {
                if (System.getProperty("os.name").startsWith("Win")) {
                    if (parentDirectory.length() > 1 && parentDirectory.charAt(1) == ':') {
                        parentDirectory = parentDirectory.replaceFirst(":", "");
                    }
                    if (name.length() > 1 && name.charAt(1) == ':') {
                        name = name.replaceFirst(":", "");
                    }
                }
                if (parentDirectory.length() > 0) {
                    name = name.replaceFirst(Pattern.quote(parentDirectory), "");
                }
                this.file = new File(engine.getDestination(), parentDirectory + "/" + name);
                break;
            }
            case PATH: {
                name = parentDirectory.length() > 0 ? name.replaceFirst(Pattern.quote(parentDirectory), "") : new File(name).getName();
                this.file = new File(engine.getDestination(), name);
            }
        }
        if (checkpointed) {
            String workFilename = this.getWorkFilename();
            String checkpointFilename = this.getCheckpointFilename();
            File checkpointFile = new File(checkpointFilename);
            File workfile = new File(workFilename);
            long checkpointPosition = 0L;
            if (checkpointFile.exists() && workfile.exists()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.toString() + ": Checkpoint and workfile exist: " + checkpointFilename + " " + workFilename);
                }
                BufferedReader in = new BufferedReader(new FileReader(checkpointFilename));
                try {
                    checkpointPosition = workfile.length();
                    long filesize = Long.parseLong(in.readLine());
                    long filetime = Long.parseLong(in.readLine());
                    if (filesize != this.getSize() || filetime != this.getLastModifiedAt()) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine(this.toString() + ": Checkpoint does not match workfile: " + filesize + " <> " + this.getSize() + " or timestamps differ: " + filetime + " <> " + this.getLastModifiedAt());
                        }
                        checkpointPosition = 0L;
                        checkpointFile.delete();
                        workfile.delete();
                    }
                }
                catch (NumberFormatException discard) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.warning(this.toString() + ": Checkpoint corrupt: " + discard);
                    }
                    checkpointFile.delete();
                    workfile.delete();
                }
            }
            this.setCheckpointPosition(checkpointPosition);
        }
    }

    public String toString() {
        return "FileTransfer [sequence=" + this.getSequence() + " name=\"" + this.getFileString() + "\"" + " size=" + this.getSize() + " getLastModifiedAt=" + this.getLastModifiedAt() + " state=" + (Object)((Object)this.getState()) + " attempt=" + this.getAttemptNumber() + "]";
    }

    public int getSequence() {
        return this.sequence;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileString() {
        return this.file == null ? "" : this.file.getName();
    }

    String getWorkFilename() {
        return this.getFile().getParentFile().getAbsolutePath() + "/#work_file#" + this.getFileString();
    }

    String getCheckpointFilename() {
        return this.getFile().getParentFile().getAbsolutePath() + "/#chkpt_file#" + this.getFileString();
    }

    public int getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public long getCurrentPosition() {
        if (this.fileChannel != null) {
            try {
                return this.fileChannel.position();
            }
            catch (IOException iOException) {
            }
        } else if (this.dummyTransfer) {
            return this.dummyPosition;
        }
        return 0L;
    }

    public long getCheckpointPosition() {
        return this.checkpointPosition;
    }

    void setCheckpointPosition(long checkpointPosition) {
        this.checkpointPosition = checkpointPosition;
    }

    void setSize(long size) {
        this.size = size;
    }

    public Exception getErrorReason() {
        return this.errorReason;
    }

    public long getLastModifiedAt() {
        return this.lastModifiedAt;
    }

    void setLastModifiedAt(long time) {
        this.lastModifiedAt = time;
    }

    boolean isCheckpointDisabled() {
        return this.checkpointDisabled;
    }

    public State getState() {
        return this.state;
    }

    public boolean isFinished() {
        return this.state != State.PENDING;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    void skippedFileExists() {
        this.state = State.SKIPPED_EXISTS;
    }

    void skippedDenied() {
        this.state = State.SKIPPED_DENIED;
    }

    void failedAttempt(Exception why) throws TransferException {
        if (++this.attemptNumber > this.engine.getRetries()) {
            this.setError(why);
            throw new FileRetryLimitException("Unable to transfer '" + this.getFileString() + "'.  " + "Exceeded maximum number of retries.", this.getFileString());
        }
    }

    void setTransferred() {
        this.state = State.TRANSFERRED;
    }

    void setError(Exception why) {
        this.state = State.ERROR;
        this.errorReason = why;
    }

    void sendActivate() throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.toString() + ": Activate ");
        }
        this.engine.preFile(this);
        if (!this.dummyTransfer) {
            try {
                this.fileChannel = new FileInputStream(this.getFile()).getChannel();
                if (this.getCheckpointPosition() > 0L) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer(this.toString() + ": Seek to " + this.getCheckpointPosition());
                    }
                    this.engine.filePosition(this, this.getCheckpointPosition());
                    this.fileChannel.position(this.getCheckpointPosition());
                }
            }
            catch (Exception e) {
                Exception reason;
                if (!this.getFile().exists()) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": File does not exist");
                    }
                    reason = new FileHasBeenMovedWarning("Can no longer find file: " + this.getFileString(), this);
                    this.setError(e);
                } else {
                    try {
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Caught " + e);
                        }
                        this.failedAttempt(e);
                        reason = new CannotOpenFileWarning("Unable to open source file '" + this.getFileString() + "': " + e.getMessage(), this, e);
                    }
                    catch (TransferException retryExhausted) {
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Caught " + retryExhausted);
                        }
                        reason = retryExhausted;
                    }
                }
                throw reason;
            }
        }
    }

    int sendData(ByteBuffer buffer) throws Exception {
        int amountRead;
        if (this.dummyTransfer) {
            long amountLeft = this.size - this.dummyPosition;
            int currPosition = buffer.position();
            amountRead = buffer.limit() - buffer.position();
            if (amountLeft < (long)amountRead) {
                amountRead = (int)amountLeft;
            }
            buffer.position(currPosition + amountRead);
            this.dummyPosition += (long)amountRead;
        } else {
            amountRead = this.fileChannel.read(buffer);
        }
        return amountRead;
    }

    void sendComplete() throws IOException {
        if (!this.dummyTransfer) {
            this.fileChannel.close();
        }
    }

    void sendCommit() throws IOException {
        this.setTransferred();
        this.engine.postFile(this);
    }

    void sendAbort(Exception why) throws Exception {
        this.failedAttempt(why);
        this.engine.postFile(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveActivate(Object mkdirsLock) throws TransferWarning, IOException {
        this.engine.preFile(this);
        String destinationDir = this.getFile().getParentFile().getAbsolutePath();
        File nullDir = new File("/dev/null/");
        String nullDirectory = nullDir.getAbsolutePath();
        if (!destinationDir.startsWith(nullDirectory)) {
            File destdir = new File(destinationDir);
            Object object = mkdirsLock;
            synchronized (object) {
                if (!(destdir.exists() || destdir.mkdirs() || destdir.exists())) {
                    throw new CannotCreateDirectoryWarning("Cannot create directory: " + destinationDir, destinationDir);
                }
            }
            this.fileChannel = new FileOutputStream(this.getWorkFilename(), this.getCheckpointPosition() > 0L).getChannel();
            if (this.getCheckpointPosition() > 0L) {
                this.engine.filePosition(this, this.getCheckpointPosition());
                this.fileChannel.position(this.getCheckpointPosition());
            } else {
                PrintWriter checkpointWriter = new PrintWriter(this.getCheckpointFilename());
                checkpointWriter.println(this.getSize());
                checkpointWriter.println(this.getLastModifiedAt());
                checkpointWriter.close();
            }
        } else {
            this.dummyTransfer = true;
            this.dummyPosition = 0L;
        }
    }

    int adjustEncrytedCheckpointPosition(int bufferSize) throws IOException {
        long currentPosition = this.getCheckpointPosition();
        long numEncryptBlocks = currentPosition / (long)bufferSize;
        long newSeekPosition = numEncryptBlocks * (long)bufferSize;
        long offsetIn1stBuffer = currentPosition - newSeekPosition;
        this.fileChannel.position(newSeekPosition);
        return (int)offsetIn1stBuffer;
    }

    void receiveData(ByteBuffer data) throws IOException {
        int amt = data.remaining();
        if (this.dummyTransfer) {
            this.dummyPosition += (long)amt;
        } else {
            this.fileChannel.write(data);
        }
        this.engine.fileProgress(this, amt);
    }

    void receiveCommit() throws IOException {
        if (!this.dummyTransfer) {
            File workfile;
            this.fileChannel.force(true);
            this.fileChannel.close();
            new File(this.getCheckpointFilename()).delete();
            if (this.file.exists()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.toString() + ": Deleting existing file " + this.file.getAbsolutePath());
                }
                this.file.delete();
            }
            if (!(workfile = new File(this.getWorkFilename())).renameTo(this.file)) {
                int n;
                FileOutputStream fos;
                FileInputStream fis;
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Could not rename " + workfile.getAbsolutePath() + " to " + this.file.getAbsolutePath());
                }
                try {
                    fis = new FileInputStream(workfile);
                    fos = new FileOutputStream(this.file);
                }
                catch (IOException ie) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.warning(this.toString() + ": Could not copy " + workfile.getAbsolutePath() + " to " + this.file.getAbsolutePath());
                    }
                    this.engine.addWarning(new TransferWarning("Could not rename '" + workfile.getAbsolutePath() + "' to '" + this.file.getAbsolutePath() + "': " + ie.getMessage()));
                    this.setTransferred();
                    this.engine.postFile(this);
                    return;
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.toString() + ": Copying " + workfile.getAbsolutePath() + " to " + this.file.getAbsolutePath());
                }
                byte[] inbuf = new byte[8192];
                while ((n = fis.read(inbuf)) != -1) {
                    fos.write(inbuf, 0, n);
                }
                fis.close();
                fos.close();
                if (!workfile.delete()) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.warning(this.toString() + ": Could not delete " + workfile.getAbsolutePath());
                    }
                    this.engine.addWarning(new TransferWarning("Could not remove workfile '" + workfile.getAbsolutePath() + "'"));
                }
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Setting last modified time of " + this.file.getAbsolutePath() + " to " + new Date(this.getLastModifiedAt()));
            }
            this.file.setLastModified(this.getLastModifiedAt() * 1000L);
        }
        this.setTransferred();
        this.engine.postFile(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectoryHandlingMode {
        PATH,
        FLAT,
        FULL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PENDING,
        SKIPPED_EXISTS,
        SKIPPED_DENIED,
        TRANSFERRED,
        ERROR;

    }

    static class Finished
    extends FileTransfer {
        private static final long serialVersionUID = 0L;

        Finished() {
            super(null, -1);
        }
    }
}

