/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.EDTFtpWrapper;
import com.signiant.interactivetransfer.engine.FTPException;
import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.SizeCountingInputStream;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferInstance;
import com.signiant.interactivetransfer.engine.TransferMode;
import com.signiant.interactivetransfer.engine.TransportProtocol;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FTPStream
implements TransportProtocol {
    private TransferEngine engine;
    private TransferInstance instance;
    private LinkedBlockingQueue<FileTransfer> pendingFiles;
    private Thread[] dataStreams;
    private boolean running;
    private boolean mswin;
    private EDTFtpWrapper ftp;
    private boolean usePassive;
    private boolean restartable;
    private String username;
    private String password;
    protected Logger logger;
    int seq = 0;

    public FTPStream(TransferEngine engine, TransferInstance instance) {
        this.engine = engine;
        this.instance = instance;
        this.logger = Logger.getLogger(this.getClass().getPackage().getName() + engine.getLogInstance() + "." + this.getClass().getSimpleName());
        try {
            this.ftp = new EDTFtpWrapper(this.logger);
        }
        catch (Exception e) {
            engine.addError(e);
        }
        this.pendingFiles = new LinkedBlockingQueue();
        this.restartable = false;
        this.mswin = false;
    }

    public void attemptConnection() throws Exception {
        if (this.ftp == null) {
            return;
        }
        String auth = this.instance.getUrl().getUserInfo();
        this.username = "anonymous";
        this.password = "";
        if (auth != null && auth.length() > 0) {
            String[] tokens = auth.split(":");
            this.username = tokens[0];
            this.username = this.username.equalsIgnoreCase("%user%") && this.engine.getUser() != null ? this.engine.getUser() : URLDecoder.decode(this.username, "UTF-8");
            if (tokens.length > 1) {
                this.password = tokens[1];
                this.password = this.password.equalsIgnoreCase("%password%") && this.engine.getPassword() != null ? new String(this.engine.getPassword()) : URLDecoder.decode(this.password, "UTF-8");
            }
        }
        this.ftp.setRemoteHost(this.instance.getUrl().getHost());
        if (this.instance.getUrl().getPort() == -1) {
            this.ftp.setRemotePort(this.instance.getUrl().getDefaultPort());
        } else {
            this.ftp.setRemotePort(this.instance.getUrl().getPort());
        }
        this.ftp.setTimeout(10000);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(this.toString() + ": Attemping connection");
        }
        this.ftp.connect();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(this.toString() + ": Login as: " + this.username);
        }
        this.ftp.login(this.username, this.password);
        String systemType = this.ftp.system();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(this.toString() + ": Remote system type is " + systemType);
        }
        if (systemType.startsWith("Win")) {
            this.mswin = true;
        }
        this.usePassive = false;
        try {
            this.ftp.quote("PASV", new String[]{"227", "200"});
            this.usePassive = true;
        }
        catch (FTPException ftperr) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.toString() + ": PASV gave code " + ftperr.getCode() + " " + ftperr.getLocalizedMessage());
            }
            this.engine.addInfo("Not using passive FTP mode: " + ftperr.getLocalizedMessage());
        }
        if (this.usePassive) {
            this.engine.addInfo("Entering passive FTP mode");
        }
        for (String feature : this.ftp.features()) {
            if (!feature.trim().equalsIgnoreCase("REST STREAM")) continue;
            this.restartable = true;
        }
        if (!this.restartable) {
            this.engine.addInfo("FTP server does not support restarts");
        } else if (this.username.equalsIgnoreCase("anonymous") && this.engine.getMode() == TransferMode.SEND) {
            this.restartable = false;
            this.engine.addInfo("Anonymous FTP user does not support restarts for send");
        }
        this.ftp.quitImmediately();
        this.ftp = null;
    }

    public String toString() {
        return this.instance.getUrl().getProtocol() + "://" + this.instance.getUrl().getHost();
    }

    public void close() throws IOException, TransferException {
        if (this.ftp != null) {
            try {
                this.ftp.quitImmediately();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
    }

    public void transfer() throws IOException {
        if (this.engine.getMode() == TransferMode.SEND) {
            this.sendFiles();
        } else {
            this.receiveFiles();
        }
        this.engine.markTransferFinishedTime();
    }

    protected void sendFiles() throws IOException {
        int i;
        this.engine.preStreams();
        this.running = true;
        for (String filename : this.engine.getFiles()) {
            File f = new File(filename);
            if (!f.exists()) {
                this.engine.addWarning(new TransferWarning("Could not locate file: " + filename));
                continue;
            }
            this.addFile(f, null);
        }
        this.engine.preTransfer();
        final URL base = this.instance.getUrl();
        int numberOfStreams = Math.max(this.engine.getNumberOfStreams(), Math.min(4, this.pendingFiles.size()));
        this.dataStreams = new Thread[numberOfStreams];
        for (i = 0; i < numberOfStreams; ++i) {
            this.dataStreams[i] = new Thread("FTP Data Stream " + (i + 1)){

                public void run() {
                    FileTransfer ft;
                    EDTFtpWrapper ftp;
                    if (FTPStream.this.logger.isLoggable(Level.FINER)) {
                        FTPStream.this.logger.finer(this.toString() + " started");
                    }
                    try {
                        String basedir;
                        ftp = new EDTFtpWrapper(FTPStream.this.logger);
                        ftp.setRemoteHost(FTPStream.this.instance.getUrl().getHost());
                        if (FTPStream.this.instance.getUrl().getPort() == -1) {
                            ftp.setRemotePort(FTPStream.this.instance.getUrl().getDefaultPort());
                        } else {
                            ftp.setRemotePort(FTPStream.this.instance.getUrl().getPort());
                        }
                        if (FTPStream.this.mswin) {
                            ftp.setControlEncoding("Cp1252");
                        }
                        ftp.setTimeout(10000);
                        ftp.connect();
                        ftp.login(FTPStream.this.username, FTPStream.this.password);
                        if (!FTPStream.this.usePassive) {
                            ftp.setActive();
                        }
                        if ((basedir = base.getFile().replaceFirst("^/", "")).length() > 0) {
                            ftp.chdir(URLDecoder.decode(basedir, "UTF-8"));
                        }
                    }
                    catch (Exception e) {
                        FTPStream.this.engine.addError(e);
                        return;
                    }
                    while (FTPStream.this.running && (ft = (FileTransfer)FTPStream.this.pendingFiles.poll()) != null) {
                        String filename = ft.getFile().getName();
                        String localfilename = ft.getFile().getAbsolutePath();
                        String remotefilename = filename;
                        final String remoteworkfile = (FTPStream.this.restartable ? "#work_file#" : "") + filename;
                        try {
                            try {
                                String[] filelist = ftp.dir(remotefilename);
                                if (filelist.length > 0 && !filelist[0].equals(remotefilename)) {
                                    FTPStream.this.engine.addWarning(new TransferWarning("Cannot send file, it exists as a directory on the remote system: " + remotefilename));
                                    continue;
                                }
                            }
                            catch (FTPException discard) {
                                ftp.setLastException(null);
                            }
                            long startPosition = 0L;
                            if (FTPStream.this.restartable) {
                                try {
                                    startPosition = ftp.size(remoteworkfile);
                                    FTPStream.this.engine.filePosition(ft, startPosition);
                                }
                                catch (FTPException discard) {
                                    ftp.setLastException(null);
                                }
                            }
                            final BufferedInputStream in = new BufferedInputStream(new FileInputStream(localfilename));
                            in.skip(startPosition);
                            ftp.setTransferBufferSize(32768);
                            final PipedOutputStream pout = new PipedOutputStream();
                            final PipedInputStream pin = new PipedInputStream(pout);
                            final SizeCountingInputStream scin = new SizeCountingInputStream(pin);
                            final boolean append = startPosition > 0L;
                            Thread putter = new Thread(Thread.currentThread().getName() + " Sender"){

                                public void run() {
                                    try {
                                        ftp.put(scin, remoteworkfile, append);
                                    }
                                    catch (Exception e) {
                                        ftp.setLastException(e);
                                    }
                                    try {
                                        pin.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            putter.start();
                            final FileTransfer ftrans = ft;
                            Thread getter = new Thread(Thread.currentThread().getName() + " Getter"){

                                public void run() {
                                    try {
                                        int bytesRead = 0;
                                        byte[] buffer = new byte[32768];
                                        while (FTPStream.this.running && (bytesRead = in.read(buffer)) > 0) {
                                            pout.write(buffer, 0, bytesRead);
                                            FTPStream.this.engine.fileProgress(ftrans, scin.getByteCountInterval());
                                            FTPStream.this.engine.throttle(bytesRead);
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    try {
                                        pout.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            getter.start();
                            putter.join();
                            try {
                                pout.close();
                            }
                            catch (Exception discard) {
                                // empty catch block
                            }
                            if (getter.isAlive()) {
                                getter.interrupt();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException discard) {
                                    // empty catch block
                                }
                                if (getter.isAlive()) {
                                    getter.stop();
                                }
                            }
                            FTPStream.this.engine.fileProgress(ft, scin.getByteCountInterval());
                            in.close();
                            if (!FTPStream.this.running) {
                                ftp.quitImmediately();
                                return;
                            }
                            if (ftp.getLastException() != null) {
                                throw ftp.getLastException();
                            }
                            if (FTPStream.this.restartable) {
                                if (ft.getSize() != ftp.size(remoteworkfile)) {
                                    FTPStream.this.engine.addWarning(new TransferWarning("FTP server failed to resume file properly, must restart: " + filename + " (" + ft.getSize() + " != " + ftp.size(remoteworkfile)));
                                    ftp.delete(remoteworkfile);
                                    FTPStream.this.pendingFiles.put(ft);
                                    continue;
                                }
                                try {
                                    ftp.rename(remoteworkfile, remotefilename);
                                }
                                catch (Exception e) {
                                    FTPStream.this.engine.addWarning(new TransferWarning("Failed to rename work file " + remoteworkfile + " to " + remotefilename));
                                    ft.setError(e);
                                    continue;
                                }
                            }
                            if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                FTPStream.this.logger.finest(this.toString() + ": Completed " + ft);
                            }
                            FTPStream.this.engine.postFile(ft);
                            ft.setTransferred();
                        }
                        catch (FTPException e) {
                            try {
                                ft.failedAttempt(e);
                                FTPStream.this.engine.addWarning(new TransferException("Processing file " + ft.getFileString() + ": " + e.getLocalizedMessage()));
                                FTPStream.this.pendingFiles.add(ft);
                            }
                            catch (Exception failed) {
                                ft.setError(e);
                                FTPStream.this.engine.addWarning(failed);
                            }
                        }
                        catch (Exception failed) {
                            FTPStream.this.engine.addError(failed);
                            FTPStream.this.running = false;
                        }
                    }
                    if (FTPStream.this.logger.isLoggable(Level.FINER)) {
                        FTPStream.this.logger.finer(this.toString() + " finished");
                    }
                }
            };
            this.dataStreams[i].start();
        }
        for (i = 0; i < this.dataStreams.length; ++i) {
            if (!this.dataStreams[i].isAlive()) continue;
            try {
                this.dataStreams[i].join();
                continue;
            }
            catch (InterruptedException discard) {
                // empty catch block
            }
        }
    }

    private void addFile(File file, String parentDir) {
        if (!this.running) {
            return;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Adding file name: " + file.getName());
        }
        String relativeName = "";
        if (parentDir != null && parentDir.length() > 0) {
            relativeName = parentDir + "/";
        }
        relativeName = relativeName + file.getName();
        if (file.isDirectory()) {
            File[] dir;
            for (File f : dir = file.listFiles()) {
                this.addFile(f, relativeName);
            }
            return;
        }
        FileTransfer ft = new FileTransfer(this.engine, this.seq++, file, parentDir, relativeName);
        try {
            this.pendingFiles.put(ft);
        }
        catch (InterruptedException discard) {
            // empty catch block
        }
        this.engine.fileHeader(ft);
    }

    protected void receiveFiles() throws IOException {
        int i;
        this.engine.preStreams();
        this.running = true;
        int filenumber = 1;
        for (String filename : this.engine.getFiles()) {
            try {
                FileTransfer ft = new FileTransfer(this.engine, filenumber++, filename, 0, 0L, 0L, false, filename, false);
                this.pendingFiles.put(ft);
            }
            catch (InterruptedException discard) {
                return;
            }
        }
        final String destinationDir = this.engine.getDestination();
        File destdir = new File(destinationDir);
        if (!(destdir.exists() || destdir.mkdirs() || destdir.exists())) {
            throw new IOException("Cannot create directory: " + destinationDir);
        }
        this.engine.preTransfer();
        final URL base = this.instance.getUrl();
        String urlBasePath = "/";
        int numberOfStreams = Math.max(this.engine.getNumberOfStreams(), Math.min(4, this.pendingFiles.size()));
        this.dataStreams = new Thread[numberOfStreams];
        for (i = 0; i < numberOfStreams; ++i) {
            this.dataStreams[i] = new Thread("FTP Data Stream " + (i + 1)){

                public void run() {
                    FileTransfer ft;
                    EDTFtpWrapper ftp;
                    if (FTPStream.this.logger.isLoggable(Level.FINER)) {
                        FTPStream.this.logger.finer(this.toString() + " started");
                    }
                    try {
                        String basedir;
                        ftp = new EDTFtpWrapper(FTPStream.this.logger);
                        ftp.setRemoteHost(FTPStream.this.instance.getUrl().getHost());
                        if (FTPStream.this.instance.getUrl().getPort() == -1) {
                            ftp.setRemotePort(FTPStream.this.instance.getUrl().getDefaultPort());
                        } else {
                            ftp.setRemotePort(FTPStream.this.instance.getUrl().getPort());
                        }
                        if (FTPStream.this.mswin) {
                            ftp.setControlEncoding("Cp1252");
                        }
                        ftp.setTimeout(10000);
                        ftp.connect();
                        ftp.login(FTPStream.this.username, FTPStream.this.password);
                        if (!FTPStream.this.usePassive) {
                            ftp.setActive();
                        }
                        if ((basedir = base.getFile()).length() > 0) {
                            ftp.chdir(URLDecoder.decode(basedir, "UTF-8"));
                        }
                    }
                    catch (Exception e) {
                        FTPStream.this.engine.addError(e);
                        return;
                    }
                    while (FTPStream.this.running && (ft = (FileTransfer)FTPStream.this.pendingFiles.poll()) != null) {
                        String filepath = "";
                        if (ft.getFile().getParent() != null) {
                            filepath = ft.getFile().getParent().replaceFirst("^/", "") + "/";
                        }
                        String filename = ft.getFile().getName();
                        final String remotefilename = "/".replaceFirst("^/", "") + filepath + filename;
                        String localpath = destinationDir.replaceFirst("/$", "") + "/" + filepath;
                        String localfilename = localpath + filename;
                        String workFilename = localpath + "#work_file#" + filename;
                        String checkpointFilename = localpath + "#chkpt_file#" + filename;
                        long checkpointPosition = 0L;
                        long filesize = 0L;
                        try {
                            String[] filelist = ftp.dir(remotefilename);
                            if (filelist.length > 0 && !filelist[0].equals(remotefilename)) {
                                int filenumber = 0;
                                for (String file : filelist) {
                                    try {
                                        if (FTPStream.this.logger.isLoggable(Level.FINER)) {
                                            FTPStream.this.logger.finer(this.toString() + ": Adding filename from remote directory listing: " + file);
                                        }
                                        FileTransfer newft = new FileTransfer(FTPStream.this.engine, filenumber++, file, 0, 0L, 0L, false, file, false);
                                        FTPStream.this.engine.fileHeader(newft);
                                        FTPStream.this.pendingFiles.put(newft);
                                    }
                                    catch (InterruptedException discard) {
                                        return;
                                    }
                                }
                                continue;
                            }
                            ftp.setLastException(null);
                            if (!ftp.exists(remotefilename)) {
                                FTPStream.this.engine.addWarning(new TransferWarning("Could not locate file: " + remotefilename));
                                continue;
                            }
                            File makeLocalPath = new File(localpath);
                            if (!(makeLocalPath.exists() || makeLocalPath.mkdirs() || makeLocalPath.exists())) {
                                throw new IOException("Cannot create directory: " + destinationDir);
                            }
                            ft.setLastModifiedAt(ftp.modtime(remotefilename).getTime() / 1000L);
                            ft.setSize(ftp.size(remotefilename));
                            File checkpoint = new File(checkpointFilename);
                            File workfile = new File(workFilename);
                            if (FTPStream.this.restartable) {
                                if (checkpoint.exists() && workfile.exists()) {
                                    if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                        FTPStream.this.logger.finest(this.toString() + ": Checkpoint and workfile exist: " + checkpointFilename + " " + workFilename);
                                    }
                                    try {
                                        BufferedReader in = new BufferedReader(new FileReader(checkpointFilename));
                                        checkpointPosition = Long.parseLong(in.readLine());
                                        filesize = Long.parseLong(in.readLine());
                                    }
                                    catch (Exception badcheckpoint) {
                                        if (FTPStream.this.logger.isLoggable(Level.WARNING)) {
                                            FTPStream.this.logger.warning(this.toString() + ": Checkpoint corrupt: " + badcheckpoint);
                                        }
                                        checkpoint.delete();
                                        workfile.delete();
                                        checkpointPosition = 0L;
                                        filesize = 0L;
                                    }
                                }
                            } else {
                                checkpoint.delete();
                                workfile.delete();
                                checkpointPosition = 0L;
                                filesize = 0L;
                            }
                            FTPStream.this.engine.fileHeader(ft);
                            File newname = new File(localfilename);
                            if (newname.exists()) {
                                if (newname.isDirectory()) {
                                    if (FTPStream.this.logger.isLoggable(Level.FINE)) {
                                        FTPStream.this.logger.fine("Skipped (directory): " + ft);
                                    }
                                    ft.skippedFileExists();
                                    FTPStream.this.engine.addWarning(new TransferWarning("Cannot receive file: " + filename + " is a directory"));
                                    FTPStream.this.engine.skipFile(ft);
                                }
                                if (newname.length() == ft.getSize() && newname.lastModified() / 1000L == ft.getLastModifiedAt()) {
                                    if (FTPStream.this.logger.isLoggable(Level.FINE)) {
                                        FTPStream.this.logger.fine("Skipped (file sizes and modified times match): " + ft);
                                    }
                                    ft.skippedFileExists();
                                    FTPStream.this.engine.skipFile(ft);
                                    continue;
                                }
                            }
                            if (FTPStream.this.restartable) {
                                if (filesize != ft.getSize() || checkpointPosition != workfile.length()) {
                                    if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                        FTPStream.this.logger.finest(this.toString() + ": Checkpoint does not match workfile: " + filesize + " <> " + ft.getSize() + " or " + checkpointPosition + " <> " + workfile.length());
                                    }
                                    checkpointPosition = 0L;
                                    checkpoint.delete();
                                    workfile.delete();
                                } else {
                                    try {
                                        ftp.restart(checkpointPosition);
                                        FTPStream.this.engine.filePosition(ft, checkpointPosition);
                                    }
                                    catch (Exception e) {
                                        if (FTPStream.this.logger.isLoggable(Level.FINE)) {
                                            FTPStream.this.logger.fine(this.toString() + ": Server does not support seek: " + e.getLocalizedMessage());
                                        }
                                        checkpointPosition = 0L;
                                        checkpoint.delete();
                                        workfile.delete();
                                    }
                                }
                                if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    FTPStream.this.logger.finest(this.toString() + ": Seek to " + checkpointPosition + " of " + ft);
                                }
                            }
                            byte[] buffer = new byte[0x104000];
                            PipedInputStream pin = new PipedInputStream();
                            final PipedOutputStream pout = new PipedOutputStream(pin);
                            Thread getter = new Thread(Thread.currentThread().getName() + " Receiver"){

                                public void run() {
                                    try {
                                        ftp.get(pout, remotefilename);
                                    }
                                    catch (Exception e) {
                                        ftp.setLastException(e);
                                    }
                                    try {
                                        pout.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            };
                            getter.start();
                            BufferedOutputStream workfileStream = new BufferedOutputStream(new FileOutputStream(workFilename, checkpointPosition > 0L));
                            int totalRead = 0;
                            int bytesRead = 0;
                            int index = 0;
                            ftp.setTransferBufferSize(16384);
                            while (FTPStream.this.running && (bytesRead = pin.read(buffer, index, 16384)) > 0) {
                                FTPStream.this.engine.fileProgress(ft, bytesRead);
                                if ((index += bytesRead) > 0x100000) {
                                    ((OutputStream)workfileStream).write(buffer, 0, index);
                                    ((OutputStream)workfileStream).flush();
                                    totalRead += index;
                                    if (FTPStream.this.restartable) {
                                        PrintWriter checkpointWriter = new PrintWriter(checkpointFilename);
                                        checkpointWriter.println((long)totalRead + checkpointPosition);
                                        checkpointWriter.println(ft.getSize());
                                        checkpointWriter.close();
                                    }
                                    index = 0;
                                }
                                FTPStream.this.engine.throttle(bytesRead);
                            }
                            if (!FTPStream.this.running) {
                                ftp.quitImmediately();
                                ((OutputStream)workfileStream).close();
                                return;
                            }
                            try {
                                pout.close();
                            }
                            catch (Exception discard) {
                                // empty catch block
                            }
                            getter.join();
                            if (ftp.getLastException() != null) {
                                throw ftp.getLastException();
                            }
                            if (index > 0) {
                                ((OutputStream)workfileStream).write(buffer, 0, index);
                                ((OutputStream)workfileStream).flush();
                                totalRead += index;
                            }
                            ((OutputStream)workfileStream).close();
                            if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                FTPStream.this.logger.finest(this.toString() + ": Completed " + ft);
                            }
                            checkpoint.delete();
                            newname = new File(localfilename);
                            if (newname.exists()) {
                                if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    FTPStream.this.logger.finest(this.toString() + ": Deleting existing file " + newname.getAbsolutePath());
                                }
                                newname.delete();
                            }
                            if (!workfile.renameTo(newname)) {
                                int n;
                                FileOutputStream fos;
                                FileInputStream fis;
                                if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    FTPStream.this.logger.finest(this.toString() + ": Could not rename " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                }
                                try {
                                    fis = new FileInputStream(workfile);
                                    fos = new FileOutputStream(newname);
                                }
                                catch (IOException ie) {
                                    if (FTPStream.this.logger.isLoggable(Level.WARNING)) {
                                        FTPStream.this.logger.warning(this.toString() + ": Could not copy " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                    }
                                    FTPStream.this.engine.addWarning(new TransferWarning("Could not rename '" + workfile.getAbsolutePath() + "' to '" + newname.getAbsolutePath() + "': " + ie.getMessage()));
                                    ft.setTransferred();
                                    FTPStream.this.engine.postFile(ft);
                                    continue;
                                }
                                if (FTPStream.this.logger.isLoggable(Level.FINEST)) {
                                    FTPStream.this.logger.finest(this.toString() + ": Copying " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                }
                                byte[] inbuf = new byte[8192];
                                while ((n = fis.read(inbuf)) != -1) {
                                    fos.write(inbuf, 0, n);
                                }
                                fis.close();
                                fos.close();
                                if (!workfile.delete()) {
                                    if (FTPStream.this.logger.isLoggable(Level.WARNING)) {
                                        FTPStream.this.logger.warning(this.toString() + ": Could not delete " + workfile.getAbsolutePath());
                                    }
                                    FTPStream.this.engine.addWarning(new TransferWarning("Could not remove workfile '" + workfile.getAbsolutePath() + "'"));
                                }
                            }
                            if (FTPStream.this.logger.isLoggable(Level.FINER)) {
                                FTPStream.this.logger.finer(this.toString() + ": Setting last modified time of " + newname.getAbsolutePath() + " to " + new Date(ft.getLastModifiedAt() * 1000L));
                            }
                            newname.setLastModified(ft.getLastModifiedAt() * 1000L);
                            FTPStream.this.engine.postFile(ft);
                            ft.setTransferred();
                        }
                        catch (FTPException e) {
                            try {
                                ft.failedAttempt(e);
                                FTPStream.this.engine.addWarning(new TransferWarning("Processing file " + ft.getFileString() + ": " + e.getLocalizedMessage()));
                                FTPStream.this.pendingFiles.add(ft);
                            }
                            catch (Exception failed) {
                                ft.setError(e);
                                FTPStream.this.engine.addWarning(new TransferWarning(failed.getLocalizedMessage()));
                            }
                        }
                        catch (Exception failed) {
                            FTPStream.this.engine.addError(failed);
                            FTPStream.this.running = false;
                        }
                    }
                    if (FTPStream.this.logger.isLoggable(Level.FINER)) {
                        FTPStream.this.logger.finer(this.toString() + " finished");
                    }
                }
            };
            this.dataStreams[i].start();
        }
        for (i = 0; i < this.dataStreams.length; ++i) {
            if (!this.dataStreams[i].isAlive()) continue;
            try {
                this.dataStreams[i].join();
                continue;
            }
            catch (InterruptedException discard) {
                // empty catch block
            }
        }
    }
}

