/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.ControlStream;
import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.elements.Abort;
import com.signiant.interactivetransfer.engine.elements.AckAbort;
import com.signiant.interactivetransfer.engine.elements.ActivateManifest;
import com.signiant.interactivetransfer.engine.elements.DataElement;
import com.signiant.interactivetransfer.engine.elements.DataTerminator;
import com.signiant.interactivetransfer.engine.elements.ElementType;
import com.signiant.interactivetransfer.engine.elements.FileComplete;
import com.signiant.interactivetransfer.engine.elements.FileDescriptor;
import com.signiant.interactivetransfer.engine.elements.FileResponse;
import com.signiant.interactivetransfer.engine.elements.IndicateEOF;
import com.signiant.interactivetransfer.engine.elements.InvalidDataElement;
import com.signiant.interactivetransfer.engine.elements.KeepAlive;
import com.signiant.interactivetransfer.engine.elements.ManifestInfo;
import com.signiant.interactivetransfer.engine.elements.ManifestResponse;
import com.signiant.interactivetransfer.engine.elements.ManifestTerminator;
import com.signiant.interactivetransfer.engine.elements.Purge;
import com.signiant.interactivetransfer.engine.elements.SetLocation;
import com.signiant.interactivetransfer.engine.elements.StreamActivate;
import com.signiant.interactivetransfer.engine.elements.StreamData;
import com.signiant.interactivetransfer.engine.elements.StreamSend;
import com.signiant.interactivetransfer.engine.exceptions.CannotCreateDirectoryWarning;
import com.signiant.interactivetransfer.engine.exceptions.CannotOpenFileWarning;
import com.signiant.interactivetransfer.engine.exceptions.FileHasBeenMovedWarning;
import com.signiant.interactivetransfer.engine.exceptions.RemoteRequestedAbortException;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import com.signiant.interactivetransfer.engine.udp.exceptions.UdpSessionTerminatedException;
import com.signiant.mobilize.cryptoapi.CryptoService;
import com.signiant.mobilize.cryptoapi.CryptoServiceFactory;
import com.signiant.mobilize.cryptoapi.ProviderType;
import com.signiant.mobilize.cryptoapi.impl.AESCryptoServiceImpl;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.Port;
import com.signiant.mobilize.ddsclient.connection.Stream;
import com.signiant.mobilize.ddsclient.connection.Udp;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStream
extends Stream
implements Runnable {
    private AtomicLong nwacked;
    private TransferEngine engine;
    private ControlStream controller;
    private byte handle;
    private int remotePort;
    private boolean isDataChannel;
    private FileProgressUpdater fpu;
    protected int bufferSize = 15800;
    private static Object mkdirsLock = new Object();
    boolean activated = false;
    ManifestInfo manifestInfo;
    AtomicBoolean acked;

    public DataStream(TransferEngine engine, ControlStream controller, boolean channel, int remotePort) throws Exception {
        this(engine, controller, 0, remotePort);
        this.isDataChannel = channel;
    }

    public DataStream(TransferEngine engine, ControlStream controller, byte handle, int remotePort) throws Exception {
        super(controller.newDataPort(handle, remotePort), engine.getLogInstance());
        this.engine = engine;
        this.controller = controller;
        this.handle = handle;
        this.remotePort = remotePort;
        this.isDataChannel = false;
        this.nwacked = new AtomicLong(0L);
    }

    public String toString() {
        return "Data Stream " + this.handle + " (" + this.remotePort + ")";
    }

    public HashMap<String, Long> getDataStreamStatistics() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        if (this.nwacked.get() > 0L) {
            stats.put("nwacked", new Long(this.nwacked.get()));
        }
        return stats;
    }

    @Override
    public void wakeup() {
        super.wakeup();
    }

    @Override
    public void run() {
        block27: {
            Thread.currentThread().setName(this.toString());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.toString() + ": Data stream started");
            }
            try {
                if (this.controller.getInstance().isUdpTransfer()) {
                    this.udpPortConnect();
                } else {
                    this.portConnect();
                }
                this.controller.streamInitialized(this);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.toString() + ": Stream initialized");
                }
                switch (this.engine.getMode()) {
                    case SEND: {
                        if (this.isDataChannel) {
                            this.sendManifestAndFiles();
                            break;
                        }
                        this.sendFiles();
                        break;
                    }
                    case RECEIVE: {
                        if (this.isDataChannel) {
                            this.receiveManifestAndFiles();
                            break;
                        }
                        this.receiveFiles();
                    }
                }
            }
            catch (UdpSessionTerminatedException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.toString() + ": UDP Session terminated " + e.getReason());
                }
            }
            catch (InterruptedException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(this.toString() + ": Stream interrupted");
                }
            }
            catch (Throwable e) {
                if (this.isFinished()) break block27;
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(this.toString() + ": Caught exception: " + e.toString());
                }
                StreamException se = new StreamException(e.getMessage(), e);
                se.setStackTrace(e.getStackTrace());
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException discard) {
                    // empty catch block
                }
                this.controller.fireException(se);
                if (this.logger.isLoggable(Level.FINER)) {
                    StringBuffer b = new StringBuffer();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        b.append(ste + "\n");
                    }
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Post stream exception: " + b.toString());
                    }
                }
                se.printStackTrace();
            }
        }
        try {
            this.controller.checkTransferFinished();
        }
        catch (Exception discard) {
            // empty catch block
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Stream shut down");
        }
        try {
            this.getPort().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte getHandle() {
        return this.handle;
    }

    private void udpPortConnect() throws Exception {
        String started;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": UDP stream waiting for connection");
        }
        String connected = this.isDataChannel ? "#data_channel_connected" : "#stream_connected";
        String string = started = this.isDataChannel ? "#data_channel_started" : "#stream_started";
        if (this.engine.getEncryption() != Port.SSLMode.UNSIGNED) {
            this.expect(connected + "\n");
            this.getPort().initializeSSL(this.controller.getInstance().getAgentAddress().getHostName(), this.controller.getInstance().getAgentPort(), this.engine.getCert(), this.engine.getEncryption());
            this.expect(started + "\n");
        } else {
            this.expect(connected + "\n");
            this.expect(started + "\n");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": UDP stream connected");
        }
    }

    private void portConnect() throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": " + (Object)((Object)this.getPort().getType()) + " stream connecting");
        }
        this.println("connect " + this.controller.getInstance().getAgentAddress().getHostName() + " itc" + (this.engine.getEncryption() == Port.SSLMode.UNSIGNED ? " off" : ""));
        if (!this.engine.isCertificateless()) {
            this.expect("initiateSSLhandshake\n");
            this.getPort().initializeSSL(this.controller.getInstance().getAgentAddress().getHostName(), this.getPort().getAddress().getPort(), this.engine.getCert(), this.engine.getEncryption());
        }
        this.println("user \"" + this.engine.getUser() + "\" version=" + this.controller.getAgentProtocolVersionNumber());
        this.expect("version=.*\n");
        this.expect("user=.*\n");
        this.expect("domain=.*\n");
        Properties transferProperties = this.engine.getProperties();
        transferProperties.putAll((Map<?, ?>)this.controller.getInstanceProperties(this));
        StringBuffer buf = new StringBuffer();
        for (Object property : transferProperties.keySet()) {
            String value = (String)transferProperties.get(property);
            if (value.indexOf(10) >= 0) {
                String[] list = value.split("\n");
                StringBuffer concat = new StringBuffer();
                for (String v : list) {
                    if (v.length() > 0) {
                        concat.append(v.substring(0, v.length() - 1));
                    }
                    concat.append("\\\\n");
                }
                value = concat.toString();
            }
            String line = property + "=" + value + "\\n";
            buf.append(line);
            while (buf.length() > 1900) {
                this.println("itc_param " + buf.toString().substring(0, 1900));
                buf = new StringBuffer(buf.toString().substring(1900));
            }
        }
        if (buf.length() > 0) {
            this.println("itc_param " + buf);
        }
        this.println("userdata " + (this.engine.isCertificateless() ? this.getUserData(this.engine.getPassword(), this.engine.getUser()) : this.getUserData(this.engine.getPassword())));
        String received = this.read();
        while (!received.equals("userdata-ok\n")) {
            if (!received.startsWith("itc_param")) {
                throw new Stream.UnexpectedResponseException(received, "userdata-ok\n");
            }
            received = this.read();
        }
        this.println("agent_portconnect " + this.remotePort);
        if (!this.engine.isCertificateless()) {
            this.getPort().shutdownSSL();
        }
        received = this.read();
        if (this.engine.getEncryption() == Port.SSLMode.UNSIGNED || this.engine.isCertificateless()) {
            if (!Pattern.matches("portconnect-ok\n", received)) {
                throw new Stream.UnexpectedResponseException(received, "protconnect-ok\n");
            }
        } else {
            if (!Pattern.matches("portconnect-ok\n", received)) {
                if (!Pattern.matches("reinitializeSSL\n", received)) {
                    throw new Stream.UnexpectedResponseException(received, "reinitializeSSL\n");
                }
                this.expect("portconnect-ok\n");
            } else {
                this.expect("reinitializeSSL\n");
            }
            this.getPort().initializeSSL(this.controller.getInstance().getAgentAddress().getHostName(), this.getPort().getAddress().getPort(), this.engine.getCert(), this.engine.getEncryption());
        }
        if (this.isDataChannel) {
            this.expect("#data_channel_started\n");
        } else {
            this.expect("#stream_started\n");
        }
    }

    private void sendFiles() throws Exception {
        ByteBuffer inputBuffer = ByteBuffer.wrap(new byte[this.bufferSize]);
        while (!this.isFinished()) {
            FileChannel file;
            FileTransfer ft;
            try {
                ft = this.controller.getNextFile();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (ft instanceof FileTransfer.Finished) break;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Processing " + ft);
            }
            this.engine.preFile(ft);
            if (this.engine.getBandwidthThrottle() > 0L && this.engine.getBandwidthThrottle() < (long)this.bufferSize) {
                this.bufferSize = (int)this.engine.getBandwidthThrottle();
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Buffer size " + this.bufferSize);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Activate " + ft);
            }
            StreamActivate.write(this, this.handle, ft.getSequence());
            StreamSend send = (StreamSend)DataElement.expect(this, ElementType.STREAM_SEND);
            try {
                file = new FileInputStream(ft.getFile()).getChannel();
            }
            catch (Exception e) {
                Exception reason;
                if (!ft.getFile().exists()) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": File does not exist");
                    }
                    reason = new FileHasBeenMovedWarning("Can no longer find file: " + ft.getFileString(), ft);
                    ft.setError(e);
                } else {
                    try {
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Caught " + e);
                        }
                        ft.failedAttempt(e);
                        reason = new CannotOpenFileWarning("Unable to open source file '" + ft.getFileString() + "': " + e.getMessage(), ft, e);
                    }
                    catch (TransferException retryExhausted) {
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Caught " + retryExhausted);
                        }
                        reason = retryExhausted;
                    }
                }
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(this.toString() + ": " + reason);
                }
                this.engine.addWarning(reason);
                Abort.write(this, this.handle, reason.getMessage());
                DataElement.expect(this, ElementType.ACKABORT);
                if (ft.getState() != FileTransfer.State.ERROR) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Putting back " + ft);
                    }
                    this.controller.putBackFile(ft);
                    continue;
                }
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.toString() + ": Abandoning " + ft);
                }
                this.engine.postFile(ft);
                this.controller.abandonFile(ft);
                this.controller.checkTransferFinished();
                continue;
            }
            long position = send.getPosition();
            if (position > 0L) {
                this.engine.filePosition(ft, position);
                file.position(position);
                SetLocation.write(this, this.handle, position);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Seek to " + position + " of " + ft);
            }
            long sent = 0L;
            this.fpu = new FileProgressUpdater(ft);
            sent = this.sendFilesRaw(inputBuffer, file);
            file.close();
            if (this.engine.isCancelled()) break;
            this.fpu = null;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Completed " + ft);
            }
            DataTerminator.write(this, this.handle, sent);
            try {
                DataElement.expect(this, ElementType.FILE_COMPLETE);
                ft.setTransferred();
            }
            catch (InvalidDataElement ide) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(this.toString() + ": Caught " + ide);
                }
                if (ElementType.ABORT == ide.getWrongElementType()) {
                    ft.failedAttempt(new RemoteRequestedAbortException("Low level network error: " + ide));
                }
                throw ide;
            }
            this.engine.postFile(ft);
            try {
                this.controller.checkTransferFinished();
            }
            catch (Exception discard) {}
        }
        if (!this.engine.isCancelled() && !this.isShutdown()) {
            IndicateEOF.write(this, this.handle);
        }
    }

    private void sendFilesBuffer(ByteBuffer outputBuffer, int encryptedAmt) throws Exception {
        this.engine.throttle(encryptedAmt);
        this.fpu.setPendingAcknowledgementAmount(encryptedAmt);
        StreamData.write(this, this.handle, outputBuffer, this.fpu);
    }

    protected long sendFilesRaw(ByteBuffer inputBuffer, FileChannel file) throws Exception {
        long sent = 0L;
        int amt = file.read(inputBuffer);
        while (amt > 0) {
            this.sendFilesBuffer(inputBuffer, amt);
            sent += (long)amt;
            if (this.engine.isCancelled()) break;
            inputBuffer.clear();
            amt = file.read(inputBuffer);
        }
        return sent;
    }

    void addFileHeader(FileTransfer ft) throws Exception {
        if (!this.activated) {
            ActivateManifest.write(this, this.handle);
            this.activated = true;
            this.manifestInfo = new ManifestInfo(this, this.handle);
        }
        this.manifestInfo.addDescriptor(new FileDescriptor(ft));
    }

    void fileGenerationComplete() throws Exception {
        if (!this.activated) {
            ActivateManifest.write(this, this.handle);
        }
        if (this.manifestInfo != null) {
            this.manifestInfo.flush();
        }
        this.activated = false;
        ManifestTerminator done = new ManifestTerminator(this.handle);
        done.write(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendManifestAndFiles() throws Exception {
        this.acked = new AtomicBoolean(false);
        FileTransfer ft = null;
        Thread dataChannelController = new Thread("Data Channel Controller"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block30: {
                    try {
                        FileResponse fresp = null;
                        while (!DataStream.this.isFinished()) {
                            FileTransfer ft;
                            DataElement de = DataElement.read(DataStream.this);
                            boolean needToCheckIfFinished = false;
                            if (de instanceof FileComplete) {
                                ft = DataStream.this.controller.getFile(((FileComplete)de).getSequence());
                                ft.sendCommit();
                                needToCheckIfFinished = true;
                            } else if (!(de instanceof KeepAlive)) {
                                if (de instanceof ManifestTerminator) {
                                    if (DataStream.this.logger.isLoggable(Level.FINEST)) {
                                        DataStream.this.logger.finest("Manifest complete");
                                    }
                                } else if (de instanceof ManifestResponse) {
                                    ManifestResponse mresp = (ManifestResponse)de;
                                    if (fresp == null) {
                                        fresp = new FileResponse(mresp);
                                    } else {
                                        fresp.append(mresp);
                                    }
                                    while (fresp.getNextResponse()) {
                                        FileTransfer ft2 = DataStream.this.controller.getFile(fresp.getSequence());
                                        switch (fresp.getDispositionType()) {
                                            case ERROR: {
                                                DataStream.this.controller.abandonFile(ft2);
                                                ft2.skippedDenied();
                                                needToCheckIfFinished = true;
                                                break;
                                            }
                                            case SKIPPED_EXISTS: {
                                                DataStream.this.engine.skipFile(ft2);
                                                ft2.skippedFileExists();
                                                needToCheckIfFinished = true;
                                                break;
                                            }
                                            case PENDING: {
                                                ft2.setCheckpointPosition(fresp.getCheckpointOffest());
                                                if (DataStream.this.logger.isLoggable(Level.FINEST)) {
                                                    DataStream.this.logger.finest("Enqueuing: " + ft2);
                                                }
                                                ((DataStream)DataStream.this).controller.pushFiles.put(ft2);
                                            }
                                        }
                                    }
                                } else if (de instanceof Abort) {
                                    if (DataStream.this.logger.isLoggable(Level.SEVERE)) {
                                        DataStream.this.logger.severe("Abort: " + ((Abort)de).getReason());
                                    }
                                    ft = DataStream.this.controller.getFile(((Abort)de).getSequence());
                                    ft.sendAbort(new RemoteRequestedAbortException("Abort: " + ((Abort)de).getReason()));
                                    DataStream.this.controller.putBackFile(ft);
                                    needToCheckIfFinished = true;
                                } else if (de instanceof AckAbort) {
                                    AtomicBoolean atomicBoolean = DataStream.this.acked;
                                    synchronized (atomicBoolean) {
                                        DataStream.this.acked.set(true);
                                        DataStream.this.acked.notify();
                                    }
                                } else if (de != null) {
                                    throw new InvalidDataElement(de.getType());
                                }
                            }
                            if (!needToCheckIfFinished || !DataStream.this.controller.checkTransferFinished()) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (DataStream.this.isFinished()) break block30;
                        if (DataStream.this.engine.getTransferInstance().isUdpTransfer()) {
                            Udp udp = (Udp)DataStream.this.getPort();
                        }
                        DataStream.this.engine.addError(e);
                    }
                }
            }
        };
        dataChannelController.start();
        if (!this.engine.isFileEncryptionEnabled() && this.engine.getBandwidthThrottle() > 0L && this.engine.getBandwidthThrottle() < (long)this.bufferSize) {
            this.bufferSize = (int)this.engine.getBandwidthThrottle();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.toString() + ": Buffer size " + this.bufferSize);
        }
        ByteBuffer inputBuffer = ByteBuffer.wrap(new byte[this.bufferSize]);
        ByteBuffer outputBuffer = null;
        AESCryptoServiceImpl cryptoService = null;
        if (this.engine.isFileEncryptionEnabled()) {
            cryptoService = new AESCryptoServiceImpl();
            cryptoService.initEncryption(this.engine.getFileEncryptionPassword());
            outputBuffer = ByteBuffer.wrap(new byte[this.bufferSize + 1000]);
        }
        while (!this.isFinished()) {
            try {
                ft = this.controller.getNextFile();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (ft == null || ft instanceof FileTransfer.Finished) continue;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Processing " + ft);
            }
            inputBuffer.clear();
            StreamActivate.write(this, (byte)1, ft.getSequence(), true);
            try {
                ft.sendActivate();
            }
            catch (Exception reason) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(this.toString() + ": " + reason);
                }
                if (ft.getState() != FileTransfer.State.ERROR) {
                    AtomicBoolean atomicBoolean = this.acked;
                    synchronized (atomicBoolean) {
                        this.acked.set(false);
                        Abort.write(this, (byte)1, ft.getSequence() + " " + reason.getMessage());
                        if (!this.acked.get()) {
                            this.acked.wait();
                        }
                        this.acked.set(false);
                    }
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Putting back " + ft);
                    }
                    this.controller.putBackFile(ft);
                } else {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Abandoning " + ft);
                    }
                    this.engine.postFile(ft);
                    this.controller.abandonFile(ft);
                    Purge.write(this, (byte)1, ft.getSequence() + " " + reason.getMessage());
                    this.controller.checkTransferFinished();
                }
                this.engine.addWarning(reason);
                continue;
            }
            if (ft.getCheckpointPosition() > 0L) {
                SetLocation.write(this, (byte)1, ft.getCheckpointPosition());
            }
            this.fpu = new FileProgressUpdater(ft);
            long sent = 0L;
            sent = this.engine.isFileEncryptionEnabled() && this.engine.isFileIncludedForEncryption(ft.getFile().getAbsolutePath()) ? this.sendManifestAndFilesEncrypted(inputBuffer, outputBuffer, ft, cryptoService) : this.sendManifestAndFilesRaw(inputBuffer, ft);
            if (this.engine.isCancelled()) break;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Completed " + ft);
            }
            DataTerminator.write(this, (byte)1, sent);
            ft.sendComplete();
        }
    }

    protected long sendManifestAndFilesEncrypted(ByteBuffer inputBuffer, ByteBuffer outputBuffer, FileTransfer ft, CryptoService cryptoService) throws Exception {
        long sent = 0L;
        int amt = 0;
        int encryptedAmt = 0;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.toString() + ": Transferring file with package encryption enabled");
        }
        if (ft.getCheckpointPosition() > 0L) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": This is a resume operation, checkpoint at " + ft.getCheckpointPosition());
            }
            int offsetIn1stBuffer = ft.adjustEncrytedCheckpointPosition(this.bufferSize);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": adjusted initial file offset to encryption blocks boundary by " + offsetIn1stBuffer);
            }
            if ((amt = ft.sendData(inputBuffer)) > 0) {
                inputBuffer.flip();
                encryptedAmt = cryptoService.encryptBuffer(inputBuffer, outputBuffer);
                outputBuffer.flip();
                sent += (long)(encryptedAmt -= offsetIn1stBuffer);
                byte[] outputDataArray = new byte[encryptedAmt];
                System.arraycopy(outputBuffer.array(), offsetIn1stBuffer, outputDataArray, 0, encryptedAmt);
                ByteBuffer tmpOutputBuffer = ByteBuffer.wrap(outputDataArray);
                this.sendManifestAndFileBuffer(tmpOutputBuffer, encryptedAmt);
                inputBuffer.clear();
                outputBuffer.clear();
                amt = ft.sendData(inputBuffer);
            }
        } else {
            amt = ft.sendData(inputBuffer);
        }
        while (amt > 0) {
            inputBuffer.flip();
            encryptedAmt = cryptoService.encryptBuffer(inputBuffer, outputBuffer);
            outputBuffer.flip();
            sent += (long)encryptedAmt;
            this.sendManifestAndFileBuffer(outputBuffer, encryptedAmt);
            if (this.engine.isCancelled()) break;
            inputBuffer.clear();
            outputBuffer.clear();
            amt = ft.sendData(inputBuffer);
        }
        if (!this.engine.isCancelled() && (encryptedAmt = cryptoService.finalizeBuffer(outputBuffer)) > 0) {
            sent += (long)encryptedAmt;
            outputBuffer.flip();
            this.sendManifestAndFileBuffer(outputBuffer, encryptedAmt);
        }
        return sent;
    }

    protected void sendManifestAndFileBuffer(ByteBuffer outputBuffer, int encryptedAmt) throws Exception {
        this.engine.throttle(encryptedAmt);
        this.fpu.setPendingAcknowledgementAmount(encryptedAmt);
        StreamData.write(this, (byte)1, outputBuffer, this.fpu);
    }

    protected long sendManifestAndFilesRaw(ByteBuffer inputBuffer, FileTransfer ft) throws Exception {
        long sent = 0L;
        int amt = ft.sendData(inputBuffer);
        while (amt > 0) {
            sent += (long)amt;
            this.sendManifestAndFileBuffer(inputBuffer, amt);
            if (this.engine.isCancelled()) break;
            inputBuffer.clear();
            amt = ft.sendData(inputBuffer);
        }
        return sent;
    }

    private void receiveManifestAndFiles() throws Exception {
        ManifestResponse mresp = null;
        FileDescriptor fdesc = null;
        ByteBuffer outputBuffer = null;
        ByteBuffer holdingBuffer = null;
        holdingBuffer = ByteBuffer.wrap(new byte[0x100000]);
        holdingBuffer.clear();
        CryptoService cryptoService = null;
        boolean isPackageEncryptionEnabled = this.engine.isFileEncryptionEnabled();
        if (isPackageEncryptionEnabled) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Preparing cipher for decryption of downloaded files");
            }
            cryptoService = CryptoServiceFactory.GetInstance().getCryptoService(ProviderType.JCE);
            cryptoService.initEncryption(this.engine.getFileEncryptionPassword());
            outputBuffer = ByteBuffer.wrap(new byte[this.bufferSize + 1000]);
        }
        FileTransfer currentFileTransfer = null;
        while (!this.isFinished()) {
            try {
                boolean performEncryption;
                DataElement de = DataElement.read(this);
                if (de instanceof StreamData) {
                    StreamData data = (StreamData)de;
                    holdingBuffer.put(data.getData());
                    performEncryption = false;
                    if (isPackageEncryptionEnabled && currentFileTransfer.isIncludedForEncryption()) {
                        performEncryption = true;
                    }
                    if (performEncryption) {
                        if (holdingBuffer.position() < this.bufferSize) continue;
                        this.decryptReceivedBuffer(outputBuffer, holdingBuffer, cryptoService, currentFileTransfer, false);
                        continue;
                    }
                    if (holdingBuffer.position() < 524288) continue;
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Flushing holding buffer, current size: " + holdingBuffer.position());
                    }
                    holdingBuffer.flip();
                    currentFileTransfer.receiveData(holdingBuffer);
                    holdingBuffer.clear();
                    continue;
                }
                if (de instanceof StreamActivate) {
                    StreamActivate sa = (StreamActivate)de;
                    currentFileTransfer = this.controller.getFile(sa.getFile());
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Processing " + currentFileTransfer);
                    }
                    currentFileTransfer.receiveActivate(mkdirsLock);
                    continue;
                }
                if (de instanceof ManifestInfo) {
                    if (fdesc == null) {
                        fdesc = new FileDescriptor((ManifestInfo)de);
                    } else {
                        fdesc.append((ManifestInfo)de);
                    }
                    while (fdesc.getNextDescriptor()) {
                        String filename = fdesc.getName();
                        filename = this.verifyFilePathForWindows(filename);
                        performEncryption = false;
                        if (isPackageEncryptionEnabled) {
                            String absolutePath = this.engine.getDestination() + "/" + filename;
                            performEncryption = this.engine.isFileIncludedForEncryption(absolutePath);
                        }
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": File - " + filename + " to be included for encrytion - " + performEncryption);
                        }
                        FileTransfer ft = this.controller.addFileToTransfer(fdesc.getSequence(), filename, fdesc.getMode(), fdesc.getSize(), fdesc.getMtime(), fdesc.getChkp_candidate() == 1, performEncryption);
                        mresp.addResponse(new FileResponse(ft));
                    }
                    continue;
                }
                if (de instanceof ManifestTerminator) {
                    mresp.flush();
                    ManifestTerminator done = new ManifestTerminator(this.handle);
                    done.write(this);
                    continue;
                }
                if (de instanceof DataTerminator) {
                    FileComplete.write(this, (byte)de.getHandle(), currentFileTransfer.getSequence(), currentFileTransfer.getSize());
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Processing remaining holding buffer: " + holdingBuffer.position());
                    }
                    if (holdingBuffer.position() > 0) {
                        boolean isIncludedForEncryption = currentFileTransfer.isIncludedForEncryption();
                        if (isPackageEncryptionEnabled && isIncludedForEncryption) {
                            this.decryptReceivedBuffer(outputBuffer, holdingBuffer, cryptoService, currentFileTransfer, true);
                            holdingBuffer.clear();
                        } else {
                            holdingBuffer.flip();
                            currentFileTransfer.receiveData(holdingBuffer);
                            holdingBuffer.clear();
                        }
                    }
                    currentFileTransfer.receiveCommit();
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Completed " + currentFileTransfer);
                    }
                    try {
                        this.controller.checkTransferFinished();
                    }
                    catch (Exception discard) {}
                    continue;
                }
                if (de instanceof ActivateManifest) {
                    mresp = new ManifestResponse(this, this.handle);
                    continue;
                }
                if (!(de instanceof KeepAlive) || !this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest(this.toString() + ": Received a data channel keepalive");
            }
            catch (InterruptedException discard) {
            }
            catch (Exception e) {
                if (currentFileTransfer != null && currentFileTransfer.fileChannel != null && currentFileTransfer.fileChannel.isOpen()) {
                    currentFileTransfer.fileChannel.close();
                }
                throw e;
            }
        }
        if (currentFileTransfer != null && currentFileTransfer.fileChannel != null && currentFileTransfer.fileChannel.isOpen()) {
            currentFileTransfer.fileChannel.close();
        }
    }

    private String verifyFilePathForWindows(String filename) {
        String safeFilename = filename;
        if ("windows".equals(this.controller.getVariable("remote_system_type"))) {
            safeFilename = filename.replaceAll("\\\\", "/");
        }
        return safeFilename;
    }

    protected void decryptReceivedBuffer(ByteBuffer outputBuffer, ByteBuffer holdingBuffer, CryptoService cryptoService, FileTransfer currentFileTransfer, Boolean finalizeBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, IOException {
        int length;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.toString() + ": decrypting holding buffer:  " + holdingBuffer.position() + " bytes");
        }
        if (holdingBuffer.position() > 0) {
            holdingBuffer.flip();
        }
        while (holdingBuffer.limit() - holdingBuffer.position() >= this.bufferSize) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": decryption processing buffer from  " + holdingBuffer.position() + " to " + (holdingBuffer.position() + this.bufferSize));
            }
            length = cryptoService.decryptBuffer(holdingBuffer, holdingBuffer.position(), this.bufferSize, outputBuffer);
            holdingBuffer.position(holdingBuffer.position() + this.bufferSize);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": decrypted to size: " + length);
            }
            outputBuffer.flip();
            currentFileTransfer.receiveData(outputBuffer);
            outputBuffer.clear();
        }
        if (finalizeBuffer.booleanValue() && holdingBuffer.limit() > holdingBuffer.position()) {
            int lenToProcess = holdingBuffer.limit() - holdingBuffer.position();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": decrypting last block from  " + holdingBuffer.position() + " to " + holdingBuffer.limit());
            }
            length = cryptoService.decryptBuffer(holdingBuffer, holdingBuffer.position(), lenToProcess, outputBuffer);
            holdingBuffer.position(holdingBuffer.position() + lenToProcess);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": decrypted last block to size: " + length);
            }
            outputBuffer.flip();
            currentFileTransfer.receiveData(outputBuffer);
            outputBuffer.clear();
        }
        holdingBuffer.compact();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.toString() + ":holding buffer left over bytes: " + holdingBuffer.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFiles() throws Exception {
        while (!this.isFinished()) {
            block44: {
                try {
                    BufferedOutputStream file;
                    DataElement de = DataElement.read(this);
                    if (!(de instanceof StreamActivate)) break block44;
                    StreamActivate sa = (StreamActivate)de;
                    FileTransfer ft = this.controller.getFile(sa.getFile());
                    this.engine.preFile(ft);
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Processing " + ft);
                    }
                    String destinationDir = ft.getFile().getParentFile().getAbsolutePath();
                    File destdir = new File(destinationDir);
                    Object object = mkdirsLock;
                    synchronized (object) {
                        if (!(destdir.exists() || destdir.mkdirs() || destdir.exists())) {
                            throw new CannotCreateDirectoryWarning("Cannot create directory: " + destinationDir, destinationDir);
                        }
                    }
                    String filename = destinationDir + "/" + ft.getFileString();
                    String workFilename = ft.getWorkFilename();
                    String checkpointFilename = ft.getCheckpointFilename();
                    File checkpoint = new File(checkpointFilename);
                    File workfile = new File(workFilename);
                    long checkpointPosition = 0L;
                    if (sa.isFastMode()) {
                        file = new BufferedOutputStream(new FileOutputStream(workFilename, false));
                        de = null;
                    } else {
                        if (checkpoint.exists() && workfile.exists()) {
                            if (this.logger.isLoggable(Level.FINEST)) {
                                this.logger.finest(this.toString() + ": Checkpoint and workfile exist: " + checkpointFilename + " " + workFilename);
                            }
                            BufferedReader in = new BufferedReader(new FileReader(checkpointFilename));
                            try {
                                checkpointPosition = Long.parseLong(in.readLine());
                                long filesize = Long.parseLong(in.readLine());
                                if (filesize != ft.getSize() || checkpointPosition != workfile.length()) {
                                    if (this.logger.isLoggable(Level.FINEST)) {
                                        this.logger.finest(this.toString() + ": Checkpoint does not match workfile: " + filesize + " <> " + ft.getSize() + " or " + checkpointPosition + " <> " + workfile.length());
                                    }
                                    checkpointPosition = 0L;
                                    checkpoint.delete();
                                    workfile.delete();
                                }
                            }
                            catch (NumberFormatException discard) {
                                if (this.logger.isLoggable(Level.WARNING)) {
                                    this.logger.warning(this.toString() + ": Checkpoint corrupt: " + discard);
                                }
                                checkpoint.delete();
                                workfile.delete();
                            }
                        }
                        StreamSend.write(this, this.handle, checkpointPosition);
                        de = null;
                        if (checkpointPosition > 0L) {
                            while ((de = DataElement.read(this)) instanceof KeepAlive) {
                            }
                            de = DataElement.read(this);
                            if (de instanceof SetLocation) {
                                if (checkpointPosition != ((SetLocation)de).getLocation()) {
                                    // empty if block
                                }
                                de = null;
                                this.engine.filePosition(ft, checkpointPosition);
                            } else {
                                checkpointPosition = 0L;
                            }
                        }
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Seek to " + checkpointPosition + " of " + ft);
                        }
                        file = new BufferedOutputStream(new FileOutputStream(workFilename, checkpointPosition > 0L));
                    }
                    ByteBuffer holding = ByteBuffer.wrap(new byte[0x108000]);
                    holding.clear();
                    int totalRead = 0;
                    if (de == null) {
                        de = DataElement.read(this);
                    }
                    while (de instanceof StreamData || de instanceof KeepAlive) {
                        if (de instanceof StreamData) {
                            StreamData data = (StreamData)de;
                            int amt = data.getData().remaining();
                            holding.put(data.getData());
                            this.engine.fileProgress(ft, amt);
                            if (holding.position() >= 0x100000) {
                                int length = holding.position();
                                holding.flip();
                                PrintWriter checkpointWriter = new PrintWriter(checkpointFilename);
                                ((OutputStream)file).write(holding.array(), 0, length);
                                ((OutputStream)file).flush();
                                checkpointWriter.println((long)(totalRead += length) + checkpointPosition);
                                checkpointWriter.println(ft.getSize());
                                checkpointWriter.close();
                                holding.clear();
                            }
                        }
                        de = DataElement.read(this);
                    }
                    if (de instanceof DataTerminator) {
                        int length = holding.position();
                        holding.flip();
                        ((OutputStream)file).write(holding.array(), 0, length);
                        ((OutputStream)file).close();
                        totalRead += length;
                        holding.clear();
                        if (!sa.isFastMode()) {
                            FileComplete.write(this, this.handle, ft.getSequence());
                        }
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Completed " + ft);
                        }
                        checkpoint.delete();
                        File newname = new File(filename);
                        if (newname.exists()) {
                            if (this.logger.isLoggable(Level.FINEST)) {
                                this.logger.finest(this.toString() + ": Deleting existing file " + newname.getAbsolutePath());
                            }
                            newname.delete();
                        }
                        if (!workfile.renameTo(newname)) {
                            int n;
                            FileOutputStream fos;
                            FileInputStream fis;
                            if (this.logger.isLoggable(Level.FINEST)) {
                                this.logger.finest(this.toString() + ": Could not rename " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                            }
                            try {
                                fis = new FileInputStream(workfile);
                                fos = new FileOutputStream(newname);
                            }
                            catch (IOException ie) {
                                if (this.logger.isLoggable(Level.WARNING)) {
                                    this.logger.warning(this.toString() + ": Could not copy " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                                }
                                this.engine.addWarning(new TransferWarning("Could not rename '" + workfile.getAbsolutePath() + "' to '" + newname.getAbsolutePath() + "': " + ie.getMessage()));
                                ft.setTransferred();
                                this.engine.postFile(ft);
                                continue;
                            }
                            if (this.logger.isLoggable(Level.FINEST)) {
                                this.logger.finest(this.toString() + ": Copying " + workfile.getAbsolutePath() + " to " + newname.getAbsolutePath());
                            }
                            byte[] inbuf = new byte[8192];
                            while ((n = fis.read(inbuf)) != -1) {
                                fos.write(inbuf, 0, n);
                            }
                            fis.close();
                            fos.close();
                            if (!workfile.delete()) {
                                if (this.logger.isLoggable(Level.WARNING)) {
                                    this.logger.warning(this.toString() + ": Could not delete " + workfile.getAbsolutePath());
                                }
                                this.engine.addWarning(new TransferWarning("Could not remove workfile '" + workfile.getAbsolutePath() + "'"));
                            }
                        }
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest(this.toString() + ": Setting last modified time of " + newname.getAbsolutePath() + " to " + new Date(ft.getLastModifiedAt()));
                        }
                        newname.setLastModified(ft.getLastModifiedAt() * 1000L);
                    }
                    holding = null;
                    ft.setTransferred();
                    this.engine.postFile(ft);
                }
                catch (InterruptedException discard) {
                    // empty catch block
                }
            }
            try {
                this.controller.checkTransferFinished();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void handleMessage(HashMap<String, String> data) throws Exception {
        this.controller.handleMessage(data);
    }

    protected void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private class FileProgressUpdater
    implements AcknowledgeFeedback {
        private HashMap<Integer, Integer> acknowledgedBytes = new HashMap();
        private int sendNumber;
        private FileTransfer ft;
        private Object acknowledgedBytesLock = new Object();

        FileProgressUpdater(FileTransfer ft) {
            this.ft = ft;
        }

        public void acknowledged(int sendNumber, int amountToAcknowledge) {
            Integer currentAckAmount = this.acknowledgedBytes.remove(sendNumber);
            if (currentAckAmount == null) {
                DataStream.this.logger.severe(DataStream.this.toString() + ": " + this + ": Received ack of unregistered send number " + sendNumber);
            } else {
                DataStream.this.engine.fileProgress(this.ft, currentAckAmount.intValue());
                DataStream.this.nwacked.addAndGet(amountToAcknowledge);
            }
        }

        public int getSendNumber() {
            return this.sendNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPendingAcknowledgementAmount(int amountToAcknowledge) {
            if (amountToAcknowledge <= 0) {
                return;
            }
            Object object = this.acknowledgedBytesLock;
            synchronized (object) {
                this.acknowledgedBytes.put(new Integer(++this.sendNumber), new Integer(amountToAcknowledge));
            }
            if (DataStream.this.logger.isLoggable(Level.FINEST)) {
                DataStream.this.logger.finest(DataStream.this.toString() + ": " + this + ": Scheduled ack for send number " + this.sendNumber);
            }
        }
    }

    public static class StreamException
    extends Exception {
        static final long serialVersionUID = 0L;

        public StreamException(String msg, Throwable e) {
            super(msg, e);
        }
    }
}

