/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine;

import com.signiant.interactivetransfer.engine.ComponentQueuedStatusEvent;
import com.signiant.interactivetransfer.engine.DataStream;
import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.StatusEvent;
import com.signiant.interactivetransfer.engine.TransferBandwidthStatusEvent;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferInstance;
import com.signiant.interactivetransfer.engine.TransferListener;
import com.signiant.interactivetransfer.engine.TransferMode;
import com.signiant.interactivetransfer.engine.TransportProtocol;
import com.signiant.interactivetransfer.engine.exceptions.AuthenticationServicesUnavailableException;
import com.signiant.interactivetransfer.engine.exceptions.DirectoryWithSameNameExistsException;
import com.signiant.interactivetransfer.engine.exceptions.FileListTooLargeException;
import com.signiant.interactivetransfer.engine.exceptions.FileNotFoundWarning;
import com.signiant.interactivetransfer.engine.exceptions.InitialConnectMessageFailedException;
import com.signiant.interactivetransfer.engine.exceptions.InvalidAuthenticationException;
import com.signiant.interactivetransfer.engine.exceptions.InvalidDirectoryPathException;
import com.signiant.interactivetransfer.engine.exceptions.InvalidFilePathException;
import com.signiant.interactivetransfer.engine.exceptions.MediaExchangeServerDisabledException;
import com.signiant.interactivetransfer.engine.exceptions.MissingConfigurationException;
import com.signiant.interactivetransfer.engine.exceptions.NoHeartbeatException;
import com.signiant.interactivetransfer.engine.exceptions.PackageCompletedErrorCodeException;
import com.signiant.interactivetransfer.engine.exceptions.PrepackageFailedException;
import com.signiant.interactivetransfer.engine.exceptions.RemoteAgentException;
import com.signiant.interactivetransfer.engine.exceptions.RemoteAgentWarning;
import com.signiant.interactivetransfer.engine.exceptions.RemoteCannotCreateTemporaryFileException;
import com.signiant.interactivetransfer.engine.exceptions.RemoteCannotSetWorkingDirectoryException;
import com.signiant.interactivetransfer.engine.exceptions.RemoteCannotWriteMoreToWorkFileException;
import com.signiant.interactivetransfer.engine.exceptions.ServerEncryptionNotFoundException;
import com.signiant.interactivetransfer.engine.exceptions.StreamConnectionTimeoutException;
import com.signiant.interactivetransfer.engine.exceptions.TransferCancelledWarning;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import com.signiant.interactivetransfer.engine.exceptions.Windows83FilenameWarning;
import com.signiant.interactivetransfer.engine.exceptions.WindowsCannotCreateFilenameWarning;
import com.signiant.interactivetransfer.engine.remote.SimpleElement;
import com.signiant.interactivetransfer.engine.remote.SimpleElementParser;
import com.signiant.interactivetransfer.engine.resourcemanagement.ResourceNotDefinedException;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResource;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResourceFactory;
import com.signiant.interactivetransfer.engine.udp.exceptions.UdpSessionTerminatedException;
import com.signiant.mobilize.ddsclient.connection.Port;
import com.signiant.mobilize.ddsclient.connection.Stream;
import com.signiant.mobilize.ddsclient.connection.udp.UdpSession;
import com.signiant.mobilize.ddsclient.messagebus.DdsBandwidthCommandType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControlStream
extends Stream
implements TransportProtocol,
PropertyChangeListener {
    protected static String CTE_PROFILE_TOKEN = "TRANSFER_PROFILE";
    protected static int AGENT_CMD_SIZE_PROTO_MANIFEST = 131072;
    protected static int AGENT_CMD_SIZE_LEGACY = 32768;
    protected static final String AGENTBANDWIDTH = "agentbandwidth";
    protected static final String CMDSOURCE = "GUI";
    static String[] errorCodes = new String[]{"", "", "", "", "", "", "", "", "", "", "", "PARAMETER_ERROR", "INITIALIZATION_ERROR", "MEMORY_ALLOCATION_ERROR", "OS_ERROR", "PACKAGE_DEFINITION_ERROR", "AUTHENTICATION_ERROR", "PROMPT_ERROR", "MISSING_FILE_ERROR", "FILE_NOT_FOUND_ERROR", "NODE_DEFINITION_ERROR", "CONFIGURATION_FILE_ERROR", "QUIT_REQUESTED", "ABORT_REQUESTED", "INTERNAL_ERROR", "PROCESS_START_ERROR", "PREPACKAGE_ERROR", "POSTPACKAGE_ERROR", "TRANSFER_ERRORS", "ROLLBACK_CLEANUP_ERROR", "PACKAGE_IN_USE", "SESSION_IN_USE", "SESSION_DEAD_ERROR", "PW_CACHE_ERROR", "TRANSFER_ERRORS_OCCURED", "AUTHORIZATION_ERROR", "OVERRIDE_ERROR", "COMMAND_TIMEOUT", "REPOSITORY_ERROR", "FINDFILES_FAILS_ERROR", "COMMUNICATION_ERROR", "MAP_CMD_ERROR", "VERSION_MISMATCH", "CONNECTION_ERROR", "UPGRADE_ERROR", "HOST_UNAVAILABLE_ERROR", "FINALIZE_ERROR", "HEARTBEAT_ERROR"};
    protected Command[] commands = new Command[]{new Message(), new SetVariable(), new UdpSessionPort(), new DataChannelPort(), new NewTcpStream(), new FileHeader(), new SendFile(), new SkipFile(), new SlaveDone(), new CompletedCommand(), new AgentHeartbeat(), new AgentPrepackageFailed(), new AgentStarted(), new XMLCommand(), new CmdRespEnd(), new Response()};
    private TransferEngine engine;
    private TransferInstance instance;
    private int agentProtocolVersionNumber;
    private List<DataStream> streams;
    private HeartbeatGenerator heartbeatGenerator;
    private List<FileTransfer> pendingFiles;
    private HashMap<String, String> variableTable;
    private List<String> directoryHeaders;
    private HashMap<String, String> mappedFilenamesToReceive;
    private int sequence;
    private static int runnumber;
    private boolean finished;
    private Object shutdownLock = new Object();
    private boolean initialized;
    private boolean agentStarted;
    private boolean postPackageSent;
    private boolean dataStreamsReady;
    private boolean fileGenerationComplete;
    private boolean agentDebugging;
    private boolean sentSlaveCancel;
    protected boolean waitingSlaveCancelAck;
    LinkedBlockingQueue<FileTransfer> pushFiles;
    private ConcurrentHashMap<Integer, FileTransfer> files;
    private CountDownLatch initializationFunnel;
    private GenerateFileHeaders headerThread;
    private HashMap<String, String> packageCommands;
    private Object messageSyncLock;
    protected Timer slaveCancelTimer;
    private boolean firstStatsEntry;
    private RemoteCommandHandler remoteHandler;
    private Timer sourceStatsUpdater;
    private boolean sourceStatsUpdaterNameSet = false;
    private boolean sourceStatsUpdateDisabled = false;
    private final String[] aggressiveness = new String[]{"low", "medium", "high"};

    protected FileTransfer addFileToTransfer(int sequence, String name, int mode, long size, long modifiedTime, boolean checkpoint, boolean isIncludedForEncryption) throws Exception {
        String parent = "";
        for (String dir : this.directoryHeaders) {
            if (!name.startsWith(dir = dir.replaceAll("\\\\", "/"))) continue;
            parent = dir;
        }
        FileTransfer ft = new FileTransfer(this.engine, sequence, name, mode, size, modifiedTime, checkpoint, parent, isIncludedForEncryption);
        String filename = ft.getFile().getAbsolutePath();
        String alternate = this.mappedFilenamesToReceive.get(filename);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Filename mapping: parent=" + parent + " fn=" + name + " mapped=" + filename);
        }
        if (alternate != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Skipped (name collision): " + ft + " (original: " + alternate + " current: " + name + ")");
            }
            ft.skippedFileExists();
            this.engine.addWarning(new TransferWarning("Cannot receive file: " + filename + " is in conflict with a file of the same name in this transfer"));
            this.engine.skipFile(ft);
        } else {
            this.mappedFilenamesToReceive.put(filename, name);
        }
        File file = new File(filename);
        this.engine.fileHeader(ft);
        this.files.put(ft.getSequence(), ft);
        if (file.exists()) {
            if (file.isDirectory()) {
                DirectoryWithSameNameExistsException ex = new DirectoryWithSameNameExistsException("Cannot receive file: " + filename + ", directory with the same name exists");
                ft.setError(ex);
                this.engine.addError(ex);
            }
            if (file.length() == ft.getSize() && file.lastModified() / 1000L == ft.getLastModifiedAt()) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Skipped (file sizes and modified times match): " + ft);
                }
                ft.skippedFileExists();
                this.engine.skipFile(ft);
            }
        }
        return ft;
    }

    public ControlStream(TransferEngine engine, TransferInstance instance) throws IOException, TransferException {
        super(instance.newControlPort(), engine.getLogInstance());
        String[] scripts;
        this.engine = engine;
        this.instance = instance;
        this.logInstance = engine.getLogInstance();
        this.remoteHandler = new RemoteCommandHandler();
        this.variableTable = new HashMap();
        this.sequence = 0;
        this.finished = false;
        this.initialized = false;
        this.sentSlaveCancel = false;
        this.headerThread = null;
        this.postPackageSent = false;
        this.setFileGenerationComplete(false);
        this.streams = new LinkedList<DataStream>();
        this.pendingFiles = new LinkedList<FileTransfer>();
        this.directoryHeaders = new LinkedList<String>();
        this.mappedFilenamesToReceive = new HashMap();
        this.pushFiles = new LinkedBlockingQueue();
        this.files = new ConcurrentHashMap();
        this.initializationFunnel = new CountDownLatch(engine.getNumberOfStreams());
        this.heartbeatGenerator = new HeartbeatGenerator();
        this.messageSyncLock = new Object();
        Thread.currentThread().setName("Control stream");
        this.packageCommands = new HashMap();
        String[] prefixes = new String[]{"src_", "tgt_"};
        for (String script : scripts = new String[]{"setup_cmd", "finalize_cmd", "map_cmd", "postfile_cmd", "postfile_cmd_cond", "prefile_cmd", "prefile_cmd_cond", "prepkg_cmd"}) {
            for (String prefix : prefixes) {
                try {
                    char[] buffer;
                    InputStream is;
                    InputStreamReader ir;
                    int size;
                    String resource = prefix + script + ".pl";
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Loading script: " + resource);
                    }
                    if ((size = (ir = new InputStreamReader(is = this.getClass().getClassLoader().getResourceAsStream("com/signiant/interactivetransfer/scripts/" + resource))).read(buffer = new char[0x100000])) <= 0) continue;
                    String command = new String(buffer, 0, size);
                    command = command.replaceAll("\r", "");
                    this.packageCommands.put(prefix + script, command);
                    if (!this.logger.isLoggable(Level.FINEST)) continue;
                    this.logger.finest(resource + ": " + command);
                }
                catch (Exception discard) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getPort().close();
    }

    @Override
    public void attemptConnection() throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Connection to: " + this.instance.getAgentAddress().getHostName());
        }
        try {
            this.println("connect " + this.instance.getAgentAddress().getHostName() + " itc" + (this.engine.getEncryption() == Port.SSLMode.UNSIGNED ? " off" : ""));
        }
        catch (Exception e) {
            throw new InitialConnectMessageFailedException("Initiate connection failed", e);
        }
        if (!this.engine.isCertificateless()) {
            try {
                this.expect("initiateSSLhandshake\n");
            }
            catch (Stream.UnexpectedResponseException ue) {
                throw new ServerEncryptionNotFoundException("Server does not support encryption", ue);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Connection ready: " + this.instance.getAgentAddress().getHostName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void transfer() throws IOException {
        block141: {
            block140: {
                block133: {
                    block139: {
                        block138: {
                            block132: {
                                this.engine.addPropertyChangeListener(this);
                                hostName = null;
                                try {
                                    hostName = InetAddress.getLocalHost().getCanonicalHostName();
                                }
                                catch (Exception e) {
                                    this.logger.severe("Error retrieving hostname");
                                }
                                this.firstStatsEntry = true;
                                if (!this.engine.isCertificateless()) {
                                    try {
                                        this.getPort().initializeSSL(this.instance.getAgentAddress().getHostName(), this.instance.getRelayPort(), this.engine.getCert(), this.engine.getEncryption());
                                    }
                                    catch (Exception e) {
                                        this.setFinished();
                                        this.engine.addError(e);
                                        this.files.clear();
                                        try {
                                            this.getPort().close();
                                        }
                                        catch (Exception discard) {
                                            // empty catch block
                                        }
                                        if (this.logger.isLoggable(Level.FINE) == false) return;
                                        this.logger.fine("Control stream shut down");
                                        return;
                                    }
                                }
                                try {
                                    try {
                                        this.engine.addInfo("Authenticating");
                                        this.println("user \"" + this.engine.getUser() + "\" version=" + 23);
                                        version = this.read();
                                        if (version.indexOf(61) < 0) {
                                            var25_10 = null;
                                            var26_14 = this.shutdownLock;
                                            break block132;
                                        }
                                        try {
                                            this.agentProtocolVersionNumber = Integer.parseInt(version.split("=")[1].trim());
                                        }
                                        catch (NumberFormatException discard) {
                                            // empty catch block
                                        }
                                        if (this.agentProtocolVersionNumber >= 16) {
                                            this.engine.setNumberOfStreams(1);
                                        }
                                        this.expect("user=.*\n");
                                        this.expect("domain=.*\n");
                                        if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("User authentication starting: " + this.instance.getAgentAddress().getHostName());
                                        }
                                        this.engine.setSessionID(null);
                                        transferProperties = this.engine.getProperties();
                                        newProperties = new Properties();
                                        transferProperties.putAll((Map<?, ?>)this.instance.getProperties(this));
                                        buf = new StringBuffer();
                                        for (Object property : transferProperties.keySet()) {
                                            value = (String)transferProperties.get(property);
                                            if (value.indexOf("\\n") >= 0) {
                                                value = value.replaceAll("\\\\n", "\\\\\\\\n");
                                            }
                                            if (value.indexOf(10) >= 0) {
                                                list = value.split("\n");
                                                concat = new StringBuffer();
                                                for (String v : list) {
                                                    if (v.length() > 0) {
                                                        if (v.charAt(v.length() - 1) == '\r') {
                                                            v = v.substring(0, v.length() - 1);
                                                        }
                                                        concat.append(v);
                                                    }
                                                    concat.append("\\\\n");
                                                }
                                                value = concat.toString();
                                            }
                                            line = property + "=" + value + "\\n";
                                            buf.append(line);
                                            while (buf.length() > 1900) {
                                                this.println("itc_param " + buf.toString().substring(0, 1900));
                                                buf = new StringBuffer(buf.toString().substring(1900));
                                            }
                                        }
                                        if (buf.length() > 0) {
                                            this.println("itc_param " + buf);
                                        }
                                        this.println("userdata " + (this.engine.isCertificateless() != false ? this.getUserData(this.engine.getPassword(), this.engine.getUser()) : this.getUserData(this.engine.getPassword())));
                                        buffer = new StringBuffer();
                                        itcEnabled = false;
                                        authenticationException /* !! */  = null;
                                        received = this.read(60000L, true);
                                        while (!received.equals("userdata-ok\n")) {
                                            if (received.startsWith("itc_param com.signiant.interactivetransfer.engine.authfailure.message")) {
                                                authenticationException /* !! */  = new InvalidAuthenticationException(received.trim().substring("itc_param com.signiant.interactivetransfer.engine.authfailure.message".length() + 1));
                                                break;
                                            }
                                            if (!received.startsWith("itc_param")) {
                                                authenticationException /* !! */  = new InvalidAuthenticationException("Invalid username or password");
                                                break;
                                            }
                                            itcEnabled = true;
                                            data = received.substring("itc_param ".length());
                                            if (data.lastIndexOf(10) == data.length() - 1) {
                                                data = data.substring(0, data.lastIndexOf(10));
                                            }
                                            buffer.append(data);
                                            received = this.read();
                                        }
                                        parseableBuffer = buffer.toString().replaceAll("([^\\\\])\\\\n", "$1\n");
                                        parseableBuffer = parseableBuffer.replaceAll("\\\\n", "\\n");
                                        for (String data : parseableBuffer.split("\n")) {
                                            if (data.toLowerCase().startsWith("fault")) {
                                                authenticationException /* !! */  = new AuthenticationServicesUnavailableException("Authentication services unavailable", data);
                                                break;
                                            }
                                            delim = data.indexOf("=");
                                            if (delim < 0) continue;
                                            key = data.substring(0, delim);
                                            value = data.substring(delim + 1);
                                            newProperties.setProperty(key, value);
                                        }
                                        if (authenticationException /* !! */  != null) {
                                            throw authenticationException /* !! */ ;
                                        }
                                        if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("User authenticated: " + this.instance.getAgentAddress().getHostName());
                                        }
                                        if (itcEnabled) {
                                            if (this.engine.getSandbox() == null) {
                                                this.engine.setSandbox("%dds_default_directory%/" + this.engine.getUser());
                                            }
                                            this.engine.setProperties(newProperties);
                                            if (this.logger.isLoggable(Level.FINE)) {
                                                this.logger.fine("ITC authentication mode");
                                            }
                                        } else if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("Local authentication mode");
                                        }
                                        logbase = this.engine.getLogbase() + "-" + ++ControlStream.runnumber;
                                        if (this.logger.isLoggable(Level.INFO)) {
                                            this.logger.info("Remote agent log base: " + logbase);
                                        }
                                        this.println("DDS_LOGBASE=" + logbase);
                                        this.println("DDS_AGENT_PROTOCOL=" + this.agentProtocolVersionNumber);
                                        this.println("DDS_MASTER_HOST=" + hostName);
                                        this.println("DDS_MASTER_USER=\"" + this.engine.getUser() + "\"");
                                        if (this.agentProtocolVersionNumber >= 18) {
                                            this.println("DDS_STATISTICS_PERIOD=15");
                                        }
                                        if (this.agentProtocolVersionNumber >= 16) {
                                            this.println("DDS_USE_DATACHANNEL=YES");
                                            this.println("DDS_STREAM_TERM_MSG_SUPPORT=YES");
                                        }
                                        this.println("DDS_MASTER_SYSTEM_TYPE=" + (System.getProperty("os.name").startsWith("Win") != false ? "windows" : "unix"));
                                        v0 = this.agentDebugging = this.engine.getTrace().toLowerCase().indexOf("-debug") >= 0;
                                        if (!this.agentDebugging) {
                                            this.println("DDS_HEARTBEATS=REQUESTED");
                                        }
                                        agentMode = this.engine.getMode() == TransferMode.SEND ? " -target" : " -source";
                                        numberOfStreams = this.agentProtocolVersionNumber >= 16 ? 2 : this.engine.getNumberOfStreams();
                                        command = "execute dds_file_agnt " + agentMode + (this.engine.getEncryption() == Port.SSLMode.UNSIGNED ? " -sslauth mutual -encryption off" : "") + " -slave -streams " + numberOfStreams + " -cleanlogs " + this.engine.getTrace();
                                        this.println(command);
                                        if (!this.engine.isCertificateless()) {
                                            this.getPort().shutdownSSL();
                                        }
                                        if (this.engine.getEncryption() != Port.SSLMode.UNSIGNED && !this.engine.isCertificateless()) {
                                            this.expect("reinitializeSSL\n");
                                            this.getPort().initializeSSL(this.instance.getAgentAddress().getHostName(), this.instance.getRelayPort(), this.engine.getCert(), this.engine.getEncryption());
                                        }
                                        if (!this.agentDebugging) {
                                            this.expect("#agent_do_heartbeats\n");
                                        }
                                        this.expect("#get_package\n|");
                                        if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("Sending package definition");
                                        }
                                        mode = this.engine.getMode();
                                        switch (3.$SwitchMap$com$signiant$interactivetransfer$engine$TransferMode[mode.ordinal()]) {
                                            case 1: {
                                                this.println("file_transfer_type push");
                                                this.println("package_name itc_transfer");
                                                this.println("check_type timestamp");
                                                this.println("src_node_list " + hostName);
                                                this.println("src_user \"" + System.getProperty("user.name") + "\"");
                                                this.println("src_names_cmd not applicable");
                                                this.println("src_directory \"not applicable\"");
                                                if (this.engine.getBandwidthThrottle() > 0L) {
                                                    this.println("bandwidth_limit " + this.engine.getBandwidthThrottle());
                                                }
                                                if (this.instance.isUdpTransfer()) {
                                                    this.println("udp_transfer yes");
                                                    this.println("throughput_tgt " + this.engine.getTargetRate());
                                                    this.println("bandwidth_floor " + this.engine.getMinimumRate());
                                                    this.println("udp_aggressiveness " + this.aggressiveness[this.engine.getAggressiveness() - 1]);
                                                }
                                                this.println("tgt_node_list " + this.instance.getAgentAddress().getHostName());
                                                this.println("tgt_user \"" + this.engine.getUser() + "\"");
                                                dest = this.engine.getDestination();
                                                if (dest != null && dest.equals("/dev/null")) {
                                                    this.println("tgt_directory " + dest);
                                                } else {
                                                    this.println("tgt_directory /");
                                                }
                                                for (String scriptName : this.packageCommands.keySet()) {
                                                    if (!scriptName.startsWith("tgt_")) continue;
                                                    scriptContents = this.packageCommands.get(scriptName);
                                                    sessionID = this.engine.getSessionID();
                                                    targetDirectory = this.engine.getSandbox();
                                                    if (sessionID == null) {
                                                        sessionID = "";
                                                        targetDirectory = this.engine.getDestination();
                                                    }
                                                    if (targetDirectory == null) throw new MissingConfigurationException("Target directory not specified", "com.signiant.interactivetransfer.engine.destination_dir");
                                                    if (targetDirectory == "") {
                                                        throw new MissingConfigurationException("Target directory not specified", "com.signiant.interactivetransfer.engine.destination_dir");
                                                    }
                                                    if ((targetDirectory = targetDirectory.replaceAll("\\\\", "/")).indexOf("../") >= 0) {
                                                        throw new InvalidDirectoryPathException("Target directory cannot contain relative path references", "../");
                                                    }
                                                    scriptContents = scriptContents.replaceAll("\\%session_id\\%", sessionID.replaceAll("\\$", "\\\\\\$")).replaceAll("\\%target_directory\\%", targetDirectory.replaceAll("\\$", "\\\\\\$"));
                                                    this.sendMsgln(scriptName + " " + scriptContents);
                                                }
                                                break;
                                            }
                                            case 2: {
                                                this.println("file_transfer_type pull");
                                                this.println("package_name itc_transfer");
                                                this.println("check_type timestamp");
                                                if (this.engine.getBandwidthThrottle() > 0L) {
                                                    this.println("bandwidth_limit " + this.engine.getBandwidthThrottle());
                                                }
                                                this.println("src_node_list " + this.instance.getAgentAddress().getHostName());
                                                this.println("src_user \"" + this.engine.getUser() + "\"");
                                                this.sendNamesCommand();
                                                this.println("src_directory /");
                                                if (this.instance.isUdpTransfer()) {
                                                    this.println("udp_transfer yes");
                                                    this.println("throughput_tgt " + this.engine.getTargetRate());
                                                    this.println("bandwidth_floor " + this.engine.getMinimumRate());
                                                    this.println("udp_aggressiveness " + this.aggressiveness[this.engine.getAggressiveness() - 1]);
                                                }
                                                this.println("tgt_node_list " + hostName);
                                                this.println("tgt_user \"" + System.getProperty("user.name") + "\"");
                                                this.println("tgt_directory \"not applicable\"");
                                                for (String scriptName : this.packageCommands.keySet()) {
                                                    if (!scriptName.startsWith("src_")) continue;
                                                    scriptContents = this.packageCommands.get(scriptName);
                                                    sessionID = this.engine.getSessionID();
                                                    sourceDirectory = this.engine.getSandbox();
                                                    if (sessionID == null) {
                                                        sessionID = "";
                                                        sourceDirectory = "";
                                                    }
                                                    if (sourceDirectory == null) {
                                                        throw new MissingConfigurationException("Source directory not specified", "com.signiant.interactivetransfer.engine.sandbox");
                                                    }
                                                    if ((sourceDirectory = sourceDirectory.replaceAll("\\\\", "/")).indexOf("../") >= 0) {
                                                        throw new InvalidDirectoryPathException("Source directory cannot contain relative path references", "../");
                                                    }
                                                    scriptContents = scriptContents.replaceAll("\\%session_id\\%", sessionID.replaceAll("\\$", "\\\\\\$")).replaceAll("\\%source_directory\\%", sourceDirectory.replaceAll("\\$", "\\\\\\$"));
                                                    this.sendMsgln(scriptName + " " + scriptContents);
                                                }
                                                break;
                                            }
                                            default: {
                                                throw new IOException("Invalid transfer mode");
                                            }
                                        }
                                        this.println("follow_symlinks " + this.engine.getFollowSymlinks());
                                        optHeaderV = new Vector<String>();
                                        optHeader = "";
                                        optHeaderV.add("client_type=jte");
                                        optHeaderV.add("jte_user=" + this.engine.getUser());
                                        if (this.engine.isPackageIDSet()) {
                                            optHeaderV.add("packageid=" + this.engine.getPackageID());
                                        }
                                        if (this.engine.isJobNamePrefixSet()) {
                                            optHeaderV.add("jobname=" + this.engine.getJobNamePrefix());
                                        }
                                        if (this.engine.isJobGroupSet()) {
                                            optHeaderV.add("jobgrpname=" + this.engine.getJobGroup());
                                        }
                                        if (this.engine.getMode() == TransferMode.SEND) {
                                            optHeaderV.add("pkgflow=push");
                                        }
                                        if (this.engine.getMode() == TransferMode.RECEIVE) {
                                            optHeaderV.add("pkgflow=pull");
                                        }
                                        if (this.instance.isUdpTransfer()) {
                                            nLevel = this.engine.getAggressiveness();
                                            if (nLevel == 2) {
                                                nLevel = 1;
                                            } else if (nLevel == 1) {
                                                nLevel = 2;
                                            } else if (nLevel == 3) {
                                                nLevel = 0;
                                            }
                                            optHeaderV.add("agglvl=" + nLevel);
                                        }
                                        if (!optHeaderV.isEmpty()) {
                                            optHeader = optHeader.concat((String)optHeaderV.firstElement());
                                            optHeaderV.remove(0);
                                            e = optHeaderV.elements();
                                            while (e.hasMoreElements()) {
                                                optHeader = optHeader.concat(" " + (String)e.nextElement());
                                            }
                                            this.println("varvalue additionalheaderinf \"" + optHeader + "\" global");
                                        }
                                        this.println("End_of_Transaction");
                                        if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("Package download complete");
                                        }
                                        if (!this.agentDebugging && this.heartbeatGenerator != null) {
                                            this.heartbeatGenerator.start();
                                        }
                                        this.engine.preStreams();
                                        this.handleInitialManualJob();
                                        if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("Control stream command processing start");
                                        }
                                        while (!(this.finished || (s = this.read(0L)) == null && this.isShutdown())) {
                                            if (this.logger.isLoggable(Level.FINE)) {
                                                this.logger.fine("Read control stream message: " + s);
                                            }
                                            matched = false;
                                            arr$ = this.commands;
                                            len$ = arr$.length;
                                            for (i$ = 0; i$ < len$; matched |= c.match(s), ++i$) {
                                                c = arr$[i$];
                                            }
                                            if (matched || !this.logger.isLoggable(Level.FINEST)) continue;
                                            this.logger.finest("Did not use command: " + s);
                                        }
                                        if (this.logger.isLoggable(Level.FINE)) {
                                            this.logger.fine("Control stream command processing complete");
                                        }
                                        break block133;
                                    }
                                    catch (Exception e) {
                                        this.setFinished();
                                        moreData = true;
                                        while (moreData && !this.isShutdown()) {
                                            try {
                                                this.read(1000L);
                                            }
                                            catch (UdpSessionTerminatedException discard) {
                                                break;
                                            }
                                            catch (TransferException important) {
                                                this.engine.addError(important);
                                            }
                                            catch (Exception discard) {
                                                moreData = false;
                                            }
                                        }
                                        this.engine.addError(e);
                                        var25_12 = null;
                                        var26_16 = this.shutdownLock;
                                        synchronized (var26_16) {
                                            if (this.sourceStatsUpdater != null) {
                                                this.sourceStatsUpdateDisabled = true;
                                                this.sourceStatsUpdater.cancel();
                                                this.sourceStatsUpdater = null;
                                            }
                                            if (this.heartbeatGenerator != null) {
                                                this.heartbeatGenerator.cancel();
                                                this.heartbeatGenerator = null;
                                            }
                                            ** if (this.headerThread == null) goto lbl333
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            this.headerThread.cancel();
                                        }
lbl333:
                                        // 2 sources

                                        if (this.files != null) {
                                            this.files.clear();
                                        }
                                        try {
                                            this.getPort().close();
                                        }
                                        catch (Exception discard) {
                                            // empty catch block
                                        }
                                        if (this.instance.isUdpTransfer()) {
                                            try {
                                                if (this.logger.isLoggable(Level.FINER)) {
                                                    this.logger.finer("Shutting down Udp Control Session from transfer");
                                                }
                                                this.instance.terminateUDPControlSession();
                                                if (this.logger.isLoggable(Level.FINER)) {
                                                    this.logger.finer("Udp Control Session shut down from transfer");
                                                }
                                            }
                                            catch (Exception discard) {
                                                // empty catch block
                                            }
                                        }
                                        this.engine.removePropertyChangeListener(this);
                                        return;
                                    }
                                }
                                catch (Throwable var24_52) {
                                    block137: {
                                        block136: {
                                            var25_13 = null;
                                            var26_17 = this.shutdownLock;
                                            synchronized (var26_17) {
                                                if (this.sourceStatsUpdater != null) {
                                                    this.sourceStatsUpdateDisabled = true;
                                                    this.sourceStatsUpdater.cancel();
                                                    this.sourceStatsUpdater = null;
                                                }
                                                if (this.heartbeatGenerator != null) {
                                                    this.heartbeatGenerator.cancel();
                                                    this.heartbeatGenerator = null;
                                                }
                                                ** if (this.headerThread == null) goto lbl368
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                this.headerThread.cancel();
                                            }
lbl368:
                                            // 2 sources

                                            if (this.files != null) {
                                                this.files.clear();
                                            }
                                            ** try [egrp 8[TRYBLOCK] [15 : 3905->3915)] { 
lbl371:
                                            // 1 sources

                                            this.getPort().close();
                                            break block136;
lbl373:
                                            // 1 sources

                                            catch (Exception discard) {
                                                // empty catch block
                                            }
                                        }
                                        if (this.instance.isUdpTransfer()) {
                                            ** try [egrp 9[TRYBLOCK] [16 : 3927->3983)] { 
lbl378:
                                            // 1 sources

                                            if (this.logger.isLoggable(Level.FINER)) {
                                                this.logger.finer("Shutting down Udp Control Session from transfer");
                                            }
                                            this.instance.terminateUDPControlSession();
                                            if (this.logger.isLoggable(Level.FINER)) {
                                                this.logger.finer("Udp Control Session shut down from transfer");
                                            }
                                            break block137;
lbl384:
                                            // 1 sources

                                            catch (Exception discard) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    this.engine.removePropertyChangeListener(this);
                                    throw var24_52;
                                }
                            }
                            synchronized (var26_14) {
                                if (this.sourceStatsUpdater != null) {
                                    this.sourceStatsUpdateDisabled = true;
                                    this.sourceStatsUpdater.cancel();
                                    this.sourceStatsUpdater = null;
                                }
                                if (this.heartbeatGenerator != null) {
                                    this.heartbeatGenerator.cancel();
                                    this.heartbeatGenerator = null;
                                }
                                ** if (this.headerThread == null) goto lbl400
                            }
lbl-1000:
                            // 1 sources

                            {
                                this.headerThread.cancel();
                            }
lbl400:
                            // 2 sources

                            if (this.files != null) {
                                this.files.clear();
                            }
                            ** try [egrp 8[TRYBLOCK] [15 : 3905->3915)] { 
lbl403:
                            // 1 sources

                            this.getPort().close();
                            break block138;
lbl405:
                            // 1 sources

                            catch (Exception discard) {
                                // empty catch block
                            }
                        }
                        if (this.instance.isUdpTransfer()) {
                            ** try [egrp 9[TRYBLOCK] [16 : 3927->3983)] { 
lbl410:
                            // 1 sources

                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Shutting down Udp Control Session from transfer");
                            }
                            this.instance.terminateUDPControlSession();
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Udp Control Session shut down from transfer");
                            }
                            break block139;
lbl416:
                            // 1 sources

                            catch (Exception discard) {
                                // empty catch block
                            }
                        }
                    }
                    this.engine.removePropertyChangeListener(this);
                    return;
                }
                var25_11 = null;
                var26_15 = this.shutdownLock;
                synchronized (var26_15) {
                    if (this.sourceStatsUpdater != null) {
                        this.sourceStatsUpdateDisabled = true;
                        this.sourceStatsUpdater.cancel();
                        this.sourceStatsUpdater = null;
                    }
                    if (this.heartbeatGenerator != null) {
                        this.heartbeatGenerator.cancel();
                        this.heartbeatGenerator = null;
                    }
                    ** if (this.headerThread == null) goto lbl434
                }
lbl-1000:
                // 1 sources

                {
                    this.headerThread.cancel();
                }
lbl434:
                // 2 sources

                if (this.files != null) {
                    this.files.clear();
                }
                ** try [egrp 8[TRYBLOCK] [15 : 3905->3915)] { 
lbl437:
                // 1 sources

                this.getPort().close();
                break block140;
lbl439:
                // 1 sources

                catch (Exception discard) {
                    // empty catch block
                }
            }
            if (this.instance.isUdpTransfer()) {
                ** try [egrp 9[TRYBLOCK] [16 : 3927->3983)] { 
lbl444:
                // 1 sources

                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Shutting down Udp Control Session from transfer");
                }
                this.instance.terminateUDPControlSession();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Udp Control Session shut down from transfer");
                }
                break block141;
lbl450:
                // 1 sources

                catch (Exception discard) {
                    // empty catch block
                }
            }
        }
        this.engine.removePropertyChangeListener(this);
    }

    protected void handleInitialManualJob() throws Exception {
        List<BandwidthResource> manualJobRequests = this.engine.getResourceBandwidthMap().getBandwidthResourceByType(DdsBandwidthCommandType.MANUAL_JOB);
        String managerName = this.engine.getHostname();
        String issuerName = this.engine.getHostname();
        String resourcename = CTE_PROFILE_TOKEN;
        String bwThrottle = "0";
        String bwCeiling = String.valueOf(this.engine.getTargetRate());
        String bwFloor = String.valueOf(this.engine.getMinimumRate());
        if (!manualJobRequests.isEmpty()) {
            BandwidthResource manualJob = manualJobRequests.get(0);
            managerName = manualJob.getCommandInitiator();
            issuerName = manualJob.getCommandInitiator();
            resourcename = manualJob.getResourceName();
            bwThrottle = String.valueOf(manualJob.getBandwidthThrottle());
        }
        HashMap<String, String> fakeCommand = new HashMap<String, String>();
        fakeCommand.put("methodName", "reqtemplate");
        fakeCommand.put("cmdsource", resourcename);
        fakeCommand.put("ceiling", bwCeiling);
        fakeCommand.put("throttle", bwThrottle);
        fakeCommand.put("floor", bwFloor);
        fakeCommand.put("managername", managerName);
        fakeCommand.put("commandtype", String.valueOf(DdsBandwidthCommandType.MANUAL_JOB.getCode()));
        fakeCommand.put("issuername", issuerName);
        this.println("command: BROKERCMD " + this.generateBroadcastEvent(CommandType.COMPONENT_INITIAL_START, fakeCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.isShutdown()) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Control Stream shutdown complete, bypass shutdown processing");
                }
                return;
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Begin Control Stream shutdown sequence ");
            }
            try {
                if (this.dataStreamsReady && !this.sentSlaveCancel) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Sending an XMPP cancel message to the slave");
                    }
                    this.sendSlaveCancelCommand();
                    if (this.slaveCancelTimer != null) {
                        Timer timer = this.slaveCancelTimer;
                        synchronized (timer) {
                            this.waitingSlaveCancelAck = true;
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Waiting for the cancel command acknowledgement");
                            }
                            while (this.waitingSlaveCancelAck) {
                                this.slaveCancelTimer.wait();
                            }
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("The cancel command acknowledgement has been acknowledged or the wait has timed out");
                            }
                        }
                    } else if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("The XMPP cancel message was not sent successfully");
                    }
                }
                if (this.slaveCancelTimer != null) {
                    this.slaveCancelTimer.cancel();
                    this.slaveCancelTimer = null;
                }
                this.sentSlaveCancel = false;
            }
            catch (Exception discard) {
                // empty catch block
            }
            this.engine.setCancelled();
            if (this.instance.isUdpTransfer()) {
                block28: {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Shutting down udp control session in shutdown");
                    }
                    try {
                        this.instance.terminateUDPControlSession();
                    }
                    catch (IOException oops) {
                        if (!this.logger.isLoggable(Level.FINE)) break block28;
                        this.logger.fine("Issue while terminating UDP Control Session in shutdown: " + oops);
                    }
                }
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Udp control session terminated in shutdown");
                }
            }
            this.shutdownStream();
        }
        this.setFinished();
        this.shutdownDataStreams();
        this.wakeup();
        try {
            this.println("command: postpackage normal");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Control Stream shutdown complete");
        }
    }

    void setFinished() {
        this.finished = true;
        this.engine.setFinished();
        this.sentSlaveCancel = false;
    }

    protected void setEngine(TransferEngine engine) {
        this.engine = engine;
    }

    private void shutdownDataStreams() {
        block7: {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Shutting down data streams");
            }
            for (DataStream ds : this.streams) {
                ds.shutdownStream();
                ds.finish();
            }
            for (int i = 0; i < this.engine.getNumberOfStreams(); ++i) {
                this.pushFiles.offer(new FileTransfer.Finished());
            }
            if (this.instance.isUdpTransfer()) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Shutting down udp data session");
                }
                try {
                    this.instance.terminateUDPDataSession();
                }
                catch (IOException oops) {
                    if (!this.logger.isLoggable(Level.FINE)) break block7;
                    this.logger.fine("Error terminating UDP Session: " + oops);
                }
            }
        }
    }

    String getVariable(String variable) {
        return this.variableTable.get(variable);
    }

    public int getAgentProtocolVersionNumber() {
        return this.agentProtocolVersionNumber;
    }

    FileTransfer getFile(int sequence) {
        FileTransfer ft = this.files.get(sequence);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Get file: " + ft);
        }
        return ft;
    }

    FileTransfer getNextFile() throws InterruptedException {
        FileTransfer ft = this.pushFiles.take();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Get next file: " + ft);
        }
        return ft;
    }

    void putBackFile(FileTransfer ft) throws InterruptedException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Put back file: " + ft);
        }
        this.pushFiles.put(ft);
    }

    void abandonFile(FileTransfer ft) throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Abandon file: " + ft);
        }
        if (this.agentProtocolVersionNumber < 16) {
            this.println("abandon: " + ft.getSequence());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamInitialized(DataStream stream) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Data stream connected: " + stream);
        }
        if (this.engine.getNumberOfStreams() > 1) {
            boolean connected;
            Object object = this.messageSyncLock;
            synchronized (object) {
                this.initializationFunnel.countDown();
                this.engine.addInfo("Established data stream " + ((long)this.engine.getNumberOfStreams() - this.initializationFunnel.getCount()) + " of " + this.engine.getNumberOfStreams());
            }
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(stream + ": Awaiting other data streams");
                }
                connected = this.initializationFunnel.await(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                connected = false;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("All data streams connected: " + connected);
            }
            if (!connected) {
                if (this.isShutdown()) {
                    return;
                }
                StreamConnectionTimeoutException e = new StreamConnectionTimeoutException("Unable to connect stream " + stream.getHandle() + " (Timed out).\n" + "Transfer aborted.", stream.getHandle());
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Shutting down data streams");
                }
                this.shutdownStream();
                for (DataStream d : this.streams) {
                    d.shutdownStream();
                }
                throw e;
            }
        }
        ControlStream controlStream = this;
        synchronized (controlStream) {
            if (this.dataStreamsReady) {
                return;
            }
            this.dataStreamsReady = true;
        }
        this.prepareForTransfer();
    }

    void fireException(Exception e) {
        this.engine.addError(e);
    }

    Port newDataPort(byte handle, int id) throws Exception {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Getting new data port: " + handle + " id: " + id);
        }
        return this.instance.newDataPort(handle, id);
    }

    Properties getInstanceProperties(Stream stream) {
        return this.instance.getProperties(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTransferFinished() {
        if (!this.isFileGenerationComplete()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Check finished - file generation not complete");
            }
            return false;
        }
        for (FileTransfer f : this.files.values()) {
            if (f.isFinished()) continue;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Check finished - file transfer not complete: " + f);
            }
            return false;
        }
        Object i$ = this;
        synchronized (i$) {
            if (this.postPackageSent) {
                return true;
            }
            this.postPackageSent = true;
        }
        this.engine.markTransferFinishedTime();
        i$ = this.shutdownLock;
        synchronized (i$) {
            block19: {
                if (!this.isShutdown()) {
                    try {
                        HashMap<String, Long> map = this.createStatsData();
                        String cmd = this.createStatsUpdate(map);
                        this.println(cmd);
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Sent forced stat update at end of transfer:  " + cmd);
                        }
                    }
                    catch (Exception e) {
                        if (!this.logger.isLoggable(Level.WARNING)) break block19;
                        this.logger.warning("Failed to send forced stat update: " + e.getMessage());
                    }
                }
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Sending post package");
        }
        if (this.engine.getConnectionStatus() != TransferListener.ConnectionStatus.DISCONNECTED) {
            try {
                this.println("command: postpackage normal");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    protected void sendNamesCommand() throws Exception {
        String[] files;
        if (this.engine.getMode() == TransferMode.SEND) {
            this.println("src_names_cmd not applicable");
            return;
        }
        String[] namesHeader = new String[]{"#!dds_perl", "", "use Cwd;use Encode('encode_utf8','decode_utf8');", "${^WIDE_SYSTEM_CALLS}=1;", "chdir(decode_utf8('<sandbox>'));", "sub pwd(){if ($^O eq \"MSWin32\"){", "require Win32::API;import Win32::API;", "my $cwdW=new Win32::API('kernel32','GetCurrentDirectoryW','NP','N')or die Win32::FormatMessage(Win32::GetLastError());", "my $Wd=\"\\0\"x32768;$cwdW->Call(length $Wd, $Wd);", "my $w2u=new Win32::API('kernel32','WideCharToMultiByte','NNPNPNPP','N')or die Win32::FormatMessage(Win32::GetLastError());", "my $s=\" \"x($w2u->Call(65001,0,$Wd,-1,0,0,0,0)-1);", "$w2u->Call(65001,0,$Wd,-1,$s,length $s,0,0);;return $s;}", "else{return getcwd();}}", "my $cwd=decode_utf8(pwd());"};
        String[] namesTemplate = new String[]{"my $f=decode_utf8('<file>');if(-e \"$cwd/$f\"){if(-d \"$cwd/$f\"){print STDERR encode_utf8(\"DIRHDR: /$f\\n\");system(\"findfiles \\\"$cwd/$f\\\" -nodirs\");}else{print encode_utf8(\"$cwd/$f\\n\");}}elsif ($f =~ \"^/dev/null/*\"){print encode_utf8(\"$f\\n\");}else{print STDERR encode_utf8(\"FILENFOUND: $f\\n\");}"};
        String sandbox = this.engine.getSandbox();
        if (this.engine.getSessionID() == null || sandbox.equals("/")) {
            sandbox = "";
            namesHeader = new String[]{"#!dds_perl", "", "use Encode;${^WIDE_SYSTEM_CALLS}=1;"};
            namesTemplate = new String[]{"my $f=decode_utf8('<file>');if(-e $f){if(-d $f){print STDERR encode_utf8(\"DIRHDR: $f\\n\");system(\"findfiles \\\"$f\\\" -nodirs\");}else{print encode_utf8(\"$f\\n\");}}elsif ($f =~ \"^/dev/null/*\"){print encode_utf8(\"$f\\n\");}else{print STDERR encode_utf8(\"FILENFOUND: $f\\n\");}"};
        }
        sandbox = sandbox.replaceAll("\\\\", "/");
        sandbox = sandbox.replaceAll("'", "\\\\\\\\'");
        StringBuilder sb = new StringBuilder("src_names_cmd ");
        for (String s : namesHeader) {
            sb.append(s.replaceAll("\\<sandbox\\>", sandbox.replaceAll("\\$", "\\\\\\$")));
            sb.append('\n');
        }
        for (String f : files = this.engine.getFiles()) {
            f = f.replaceAll("\\\\", "/");
            if ((f = f.replaceAll("'", "\\\\\\\\'")).indexOf("../") >= 0) {
                throw new InvalidFilePathException("File to receive cannot contain relative path references: " + f, f);
            }
            for (String line : namesTemplate) {
                sb.append(line.replaceAll("\\<file\\>", f.replaceAll("\\$", "\\\\\\$")).replaceAll("\\<sandbox\\>", sandbox.replaceAll("\\$", "\\\\\\$")));
                sb.append('\n');
            }
        }
        int maxSrcNamesLength = this.calcMaxNamesCommandSize();
        if (sb.length() > maxSrcNamesLength) {
            throw new FileListTooLargeException("File list is too large for remote system to process");
        }
        this.sendMsgln(sb.toString());
    }

    protected int calcMaxNamesCommandSize() {
        int maxSrcNamesLength = this.getAgentProtocolVersionNumber() >= 18 ? 1006633 : (this.getAgentProtocolVersionNumber() >= 16 ? AGENT_CMD_SIZE_PROTO_MANIFEST - AGENT_CMD_SIZE_PROTO_MANIFEST / 25 : AGENT_CMD_SIZE_LEGACY - AGENT_CMD_SIZE_LEGACY / 25);
        return maxSrcNamesLength;
    }

    @Override
    public void handleMessage(HashMap<String, String> data) throws Exception {
        StringBuffer msg = new StringBuffer();
        for (String key : data.keySet()) {
            msg.append(" \"" + key + "=" + data.get(key) + "\"");
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Received message: " + msg);
        }
        if (data.containsKey("_mid")) {
            String errorMessage;
            block36: {
                try {
                    long retCode = new Long(data.get("_mid"));
                    if (retCode >= 58000L && retCode <= 58010L) {
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("Received warning from agent: " + retCode);
                        }
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!this.logger.isLoggable(Level.FINEST)) break block36;
                    this.logger.finest("Could not convert String to Long: " + data.get("_mid"));
                }
            }
            if ("9150".equals(data.get("_mid"))) {
                throw new MediaExchangeServerDisabledException("Media Exchange transfers disabled by remote system");
            }
            if ("9021".equals(data.get("_mid"))) {
                throw new MediaExchangeServerDisabledException("Media Exchange transfers disabled through relay " + data.get("_ms"));
            }
            if ("9166".equals(data.get("_mid")) || "9165".equals(data.get("_mid")) || "9099".equals(data.get("_mid"))) {
                throw new InvalidAuthenticationException("Invalid username or password");
            }
            if ("60136".equals(data.get("_mid"))) {
                String errorMessage2 = "Remote system had a problem with " + data.get("dir") + ": " + data.get("err");
                throw new RemoteCannotSetWorkingDirectoryException(errorMessage2, data);
            }
            if ("60021".equals(data.get("_mid"))) {
                String errorMessage3 = "Remote system cannot use directory " + data.get("dir") + ": it is not an absolute path";
                throw new TransferException(errorMessage3);
            }
            if ("30000".equals(data.get("_mid"))) {
                String filename = new File(data.get("name")).getName();
                errorMessage = "File name contains characters which are invalid in a Windows file name: " + filename;
                this.engine.addWarning(new WindowsCannotCreateFilenameWarning(errorMessage, data));
            }
            if ("30059".equals(data.get("_mid"))) {
                String filename = new File(data.get("rfile")).getName();
                errorMessage = "File name matches the NTFS alternate short name criteria and can't be safely transferred: " + filename;
                this.engine.addWarning(new Windows83FilenameWarning(errorMessage, data));
            }
            if ("30113".equals(data.get("_mid"))) {
                String filename = new File(data.get("name")).getName();
                errorMessage = "Cannot continue to write to file: " + filename + ": " + data.get("err");
                throw new RemoteCannotWriteMoreToWorkFileException(errorMessage, data);
            }
            if ("52514".equals(data.get("_mid")) || "60125".equals(data.get("_mid"))) {
                String errorMessage4 = "Remote system cannot create temporary file:  " + data.get("err");
                throw new RemoteCannotCreateTemporaryFileException(errorMessage4, data);
            }
            if ("60150".equals(data.get("_mid"))) {
                String message = data.get("msg");
                if (message.startsWith("EVENT: ")) {
                    message = message.replaceAll("^EVENT: ", "");
                    StatusEvent status = new StatusEvent(this.engine, message);
                    this.engine.addStatusEvent(status);
                }
                if (message.startsWith("DEBUG: ")) {
                    message = message.replaceAll("^DEBUG: ", "");
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(message);
                    }
                }
                if (message.startsWith("WARNING: ")) {
                    message = message.replaceAll("^WARNING: ", "");
                    this.engine.addWarning(new RemoteAgentWarning(message, data));
                }
                if (message.startsWith("FILENFOUND: ")) {
                    message = message.replaceAll("^FILENFOUND: ", "");
                    this.engine.addWarning(new FileNotFoundWarning(data.get("_ms") + " could not locate file: " + message, message));
                }
                if (message.startsWith("ERROR: ")) {
                    message = message.replaceAll("^ERROR: ", "");
                    throw new RemoteAgentException(message, data);
                }
                if (message.startsWith("INFO: ")) {
                    message = message.replaceAll("^INFO: ", "");
                    this.engine.addInfo(message);
                }
                if (message.startsWith("DIRHDR: ")) {
                    message = message.replaceAll("^DIRHDR: ", "");
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Recursing into directory: " + message);
                    }
                    this.directoryHeaders.add(message);
                }
                return;
            }
            if (data.containsKey("err")) {
                String errorMessage5 = "Remote system reported message " + data.get("_mid") + ": " + data.get("err");
                if (data.containsKey("dir")) {
                    errorMessage5 = errorMessage5 + ": " + data.get("dir");
                }
                if (data.containsKey("file")) {
                    errorMessage5 = errorMessage5 + ": " + data.get("file");
                }
                if (data.containsKey("name")) {
                    errorMessage5 = errorMessage5 + ": " + data.get("name");
                }
                throw new RemoteAgentException(errorMessage5, data);
            }
        }
        if (data.containsKey("_sev") && data.get("_sev").equals("0")) {
            String warningMessage = "Remote system reported warning " + data.get("_mid");
            if (data.containsKey("err")) {
                warningMessage = warningMessage + ": " + data.get("err");
            }
            if (data.containsKey("dir")) {
                warningMessage = warningMessage + ": " + data.get("dir");
            }
            if (data.containsKey("file")) {
                warningMessage = warningMessage + ": " + data.get("file");
            }
            if (data.containsKey("name")) {
                warningMessage = warningMessage + ": " + data.get("name");
            }
            if (!this.engine.isCancelled()) {
                this.engine.addWarning(new RemoteAgentWarning(warningMessage, data));
            }
        }
    }

    public TransferInstance getInstance() {
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForTransfer() throws Exception {
        Object object = this;
        synchronized (object) {
            if (!this.agentStarted || !this.dataStreamsReady || this.initialized) {
                return;
            }
            this.initialized = true;
        }
        this.updateAgentStatistics();
        if (this.engine.getMode() == TransferMode.SEND) {
            this.headerThread = new GenerateFileHeaders(this.engine);
            this.headerThread.start();
        }
        object = this.pendingFiles;
        synchronized (object) {
            for (FileTransfer ft : this.pendingFiles) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Processing pending file: " + ft);
                }
                if (ft.getState() == FileTransfer.State.SKIPPED_EXISTS) {
                    this.println("skipfile: " + ft.getSequence());
                    continue;
                }
                this.println("sendfile: " + ft.getSequence());
            }
            this.pendingFiles.clear();
        }
        this.engine.preTransfer();
    }

    void setFileGenerationComplete(boolean fileGenerationComplete) {
        this.fileGenerationComplete = fileGenerationComplete;
    }

    public boolean isFileGenerationComplete() {
        return this.fileGenerationComplete;
    }

    private String createStatsUpdate(HashMap<String, Long> map) {
        StringWriter report = new StringWriter();
        report.write("STATS_UPDATE:");
        for (String key : map.keySet()) {
            if (key == null || map.get(key) == null) continue;
            report.write(" " + key + "=" + map.get(key).toString());
        }
        report.flush();
        String res = report.toString();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Generated a stats update record: " + res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<String, Long> createStatsData() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (this.engine.getMode() == TransferMode.SEND) {
            ArrayList<HashMap<String, Long>> streamStats = new ArrayList<HashMap<String, Long>>();
            ControlStream controlStream = this;
            synchronized (controlStream) {
                block22: {
                    if (this.initialized && !this.isShutdown()) {
                        try {
                            for (DataStream ds : this.streams) {
                                streamStats.add(ds.getDataStreamStatistics());
                            }
                        }
                        catch (Exception exception) {
                            if (!this.logger.isLoggable(Level.WARNING)) break block22;
                            this.logger.warning("updateAgentStats: could not get data stream statistics " + exception.getMessage());
                        }
                    }
                }
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("ControlStream obtained statistics from " + streamStats.size() + " stream(s)");
            }
            if (this.firstStatsEntry) {
                this.firstStatsEntry = false;
                map.put("INITBWTHRTL", new Long(this.engine.getPriorityBandwidth()));
            }
            map.put("CRNTBWTHRTL", new Long(this.engine.getPriorityBandwidth()));
            map.put("tf", new Long(this.engine.getTotalFilesToTransfer()));
            map.put("ft", new Long(this.engine.getFilesTransferred()));
            map.put("fs", new Long(this.engine.getFilesSkipped()));
            map.put("tb", new Long(this.engine.getTotalBytesToTransfer()));
            map.put("eb", new Long(this.engine.getBytesTransferred()));
            map.put("fbdatskp", new Long(this.engine.getBytesSkipped()));
            map.put("td", new Long(this.engine.getTotalDirectoriesToTransfer()));
            map.put("ds", new Long(this.engine.getDirectoriesSkipped()));
            map.put("dt", new Long(this.engine.getDirectoriesTransferred()));
            map.put("nmcmplttm", new Long(this.engine.getTimeOfFileDetermination()));
            map.put("te", new Long(this.engine.getTotalErrors()));
            map.put("pe", new Long(this.engine.getPermanentErrors()));
            for (HashMap hashMap : streamStats) {
                for (String key : hashMap.keySet()) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("Substatistics contain (" + key + "," + hashMap.get(key) + ")");
                    }
                    if (map.containsKey(key)) {
                        map.put(key, (Long)hashMap.get(key) + map.get(key));
                        continue;
                    }
                    map.put(key, (Long)hashMap.get(key));
                }
            }
            if (this.logger.isLoggable(Level.FINER)) {
                for (String string : map.keySet()) {
                    this.logger.finer("Source statistics contain (" + string + "," + map.get(string) + ")");
                }
            }
        } else if (this.engine.getMode() == TransferMode.RECEIVE) {
            long totalBytes = this.engine.getBytesTransferred();
            map.put("TGTFLBYTES", new Long(totalBytes));
            if (this.logger.isLoggable(Level.FINER)) {
                for (String key : map.keySet()) {
                    this.logger.finer("Target statistics contain (" + key + "," + map.get(key) + ")");
                }
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Cannot create statistics update record for transfer mode: " + (Object)((Object)this.engine.getMode()));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAgentStatisticsTimerTask() {
        if (!this.sourceStatsUpdaterNameSet) {
            Thread.currentThread().setName("Stats update timer");
            this.sourceStatsUpdaterNameSet = true;
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.sourceStatsUpdateDisabled) {
                return;
            }
            try {
                HashMap<String, Long> map = this.createStatsData();
                String cmd = this.createStatsUpdate(map);
                this.println(cmd);
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Sent statistics update message: " + cmd);
                }
            }
            catch (Exception e) {
                this.engine.addError(e);
            }
        }
    }

    protected void updateAgentStatistics() {
        block8: {
            if (!this.instance.isUdpTransfer() && !this.instance.isTcpTransfer()) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning("updateAgentStats: transfer protocol is not UDP or TCP!");
                }
                return;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("updateAgentStats: preparing to update agent's statistics");
            }
            if (this.sourceStatsUpdater == null) {
                this.sourceStatsUpdaterNameSet = false;
                this.sourceStatsUpdateDisabled = false;
                this.sourceStatsUpdater = new Timer();
                TimerTask statsUpdater = new TimerTask(){

                    public void run() {
                        ControlStream.this.updateAgentStatisticsTimerTask();
                    }
                };
                try {
                    long period = this.engine.getAgentStatUpdateInterval();
                    if (period <= 0L) {
                        period = 1000L;
                    }
                    this.sourceStatsUpdater.schedule(statsUpdater, 1000L, period);
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("updateAgentStats: scheduled statsUpdater with period - " + period);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.WARNING)) break block8;
                    this.logger.warning("updateAgentStats: while scheduling statsUpdater: " + e);
                }
            }
        }
    }

    protected String buildSetBandwidthCommand(int sequenceNumber, Long throttleValue, Long floorValue, Long ceilingValue) {
        StringBuilder command = new StringBuilder();
        UdpSession dataSession = this.instance.getUdpSession();
        UdpSession controlSession = this.instance.getUdpControlSession();
        command.append("command: ");
        command.append(sequenceNumber);
        command.append("setbwlimits ");
        if (throttleValue != null) {
            command.append(throttleValue);
            if (throttleValue > 0L) {
                long currentFloorValue;
                long currentCeilingValue = this.engine.getTargetRate();
                if (currentCeilingValue > 0L && throttleValue > currentCeilingValue) {
                    ceilingValue = throttleValue;
                    this.engine.setTargetRate(ceilingValue);
                    if (dataSession != null) {
                        dataSession.setMaximumBandwidth(ceilingValue);
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("buildSetBandwidthCommand set ceiling to: " + ceilingValue + " on data channel");
                        }
                    }
                    if (controlSession != null) {
                        controlSession.setMaximumBandwidth(ceilingValue);
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("buildSetBandwidthCommand set ceiling to: " + ceilingValue + " on control channel");
                        }
                    }
                }
                if ((currentFloorValue = this.engine.getMinimumRate()) > 0L && throttleValue < currentFloorValue) {
                    floorValue = throttleValue;
                    this.engine.setMinimumRate(floorValue);
                    if (dataSession != null) {
                        dataSession.setMinimumBandwidth(floorValue);
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("buildSetBandwidthCommand set floor to: " + floorValue + " on data channel");
                        }
                    }
                    if (controlSession != null) {
                        controlSession.setMinimumBandwidth(floorValue);
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("buildSetBandwidthCommand set floor to: " + floorValue + " on control channel");
                        }
                    }
                }
            }
        }
        command.append(":");
        if (floorValue != null) {
            command.append(floorValue);
        }
        command.append(":");
        if (ceilingValue != null) {
            command.append(ceilingValue);
        }
        return command.toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        long newValue = (Long)evt.getNewValue();
        if (this.engine.getConnectionStatus() == TransferListener.ConnectionStatus.CONNECTED) {
            String cmd = null;
            if (propertyName.equals("com.signiant.interactivetransfer.engine.bandwidth_throttle")) {
                cmd = this.buildSetBandwidthCommand(this.sequence, newValue, null, null);
            } else if (propertyName.equals("com.signiant.interactivetransfer.engine.udp.minimum_rate")) {
                cmd = this.buildSetBandwidthCommand(this.sequence, null, newValue, null);
            } else if (propertyName.equals("com.signiant.interactivetransfer.engine.udp.target_rate")) {
                cmd = this.buildSetBandwidthCommand(this.sequence, null, null, newValue);
            }
            if (cmd != null) {
                try {
                    this.println(cmd);
                }
                catch (Exception e) {
                    this.logger.finest("RemoteCommand caught the exception: " + e + " while sending message: " + cmd);
                }
            }
        }
    }

    private void sendSlaveCancelCommand() throws Exception {
        this.sendSlaveCancelCommand("sdk", this.engine.getHostname(), CMDSOURCE, "" + System.nanoTime());
    }

    private void sendSlaveCancelCommand(String originatorJid, String managerName, String cmdSource, String transId) throws Exception {
        String messageFormat = "command: BROKERCMD <XMLCMD><cmd_origin>controller</cmd_origin><originator_jid>%s</originator_jid>%s</XMLCMD>";
        String cancelCommand = "<methodCall><methodName>cancel</methodName><params><param><value><struct><member><name>header</name><value><struct><member><name>managername</name><value>%s</value></member><member><name>cmdsource</name><value>%s</value></member></struct></value></member></struct></value></param><param><value><struct><member><name>cmdproperties</name><value><struct><member><name>cmdpriority</name><value>0</value></member><member><name>cmdtransid</name><value>%s</value></member></struct></value></member></struct></value></param><param><value><struct><member><name>jobid</name><value>SDK</value></member></struct></value></param></params></methodCall>";
        String formattedCancelCommand = String.format(cancelCommand, managerName, cmdSource, transId);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Sending a cancel command to the slave agent - " + formattedCancelCommand);
        }
        this.println(String.format(messageFormat, originatorJid, formattedCancelCommand));
        this.sentSlaveCancel = true;
        this.slaveCancelTimer = new Timer();
        TimerTask cancelCommandAckTimeout = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("Cancel command acknowledgement timed out");
                }
                Timer timer = ControlStream.this.slaveCancelTimer;
                synchronized (timer) {
                    if (ControlStream.this.waitingSlaveCancelAck) {
                        if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                            ControlStream.this.logger.fine("In progess shutdown will be resumed");
                        }
                        ControlStream.this.waitingSlaveCancelAck = false;
                        ControlStream.this.slaveCancelTimer.notifyAll();
                    } else {
                        if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                            ControlStream.this.logger.fine("Forcing shutdown");
                        }
                        ControlStream.this.engine.cancelTransfer();
                    }
                }
            }
        };
        long timeout = 5000L;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Scheduling a cancel command response time out for " + timeout + " milliseconds");
        }
        this.slaveCancelTimer.schedule(cancelCommandAckTimeout, timeout);
    }

    protected String generateBroadcastEvent(CommandType commandType, Map<String, String> command) {
        SimpleElement root = new SimpleElement("ddsbroadcastgenerate");
        SimpleElement stats = new SimpleElement("stats");
        root.addElement(stats);
        String managerName = command.get("managername");
        String resourceName = command.get("cmdsource");
        if (CommandType.SET_BANDWIDTH_COMMAND == commandType || CommandType.COMPONENT_RUN == commandType) {
            try {
                BandwidthResource bwResource = this.engine.getPriorityBandwitdthRecord();
                managerName = bwResource.getCommandInitiator();
                resourceName = bwResource.getCommandType() == DdsBandwidthCommandType.MANUAL_JOB ? CTE_PROFILE_TOKEN : bwResource.getResourceName();
            }
            catch (ResourceNotDefinedException e) {
                // empty catch block
            }
        }
        String commandName = command.get("methodName");
        switch (commandType) {
            case REQUEST_BANDWIDTH: {
                commandName = "reqbandwidth";
                break;
            }
            case REQUEST_UDP_THRESHOLD: {
                commandName = "requdpthreshold";
                break;
            }
            case COMPONENT_INITIAL_START: {
                resourceName = CTE_PROFILE_TOKEN;
                commandName = "reqtemplate";
                break;
            }
            case REQUEST_COMPONENT_RUN: {
                commandName = "reqcomponentrun";
            }
        }
        stats.addElement(new SimpleElement("cmdname", commandName));
        stats.addElement(new SimpleElement("cmdprocess", resourceName));
        stats.addElement(new SimpleElement("cmdsource", managerName));
        SimpleElement commandInfo = new SimpleElement("commandinfo");
        commandInfo.addElement(new SimpleElement("cmdname", commandName));
        root.addElement(commandInfo);
        commandInfo.addElement(new SimpleElement("cmdmanagername", managerName));
        commandInfo.addElement(new SimpleElement("cmdsource", resourceName));
        SimpleElement params = new SimpleElement("cmdparams");
        commandInfo.addElement(params);
        if (command.get("commandtype") != null) {
            params.addElement(new SimpleElement("commandtype", command.get("commandtype")));
        }
        if (command.get("issuername") != null) {
            params.addElement(new SimpleElement("issuername", command.get("issuername")));
        }
        if (CommandType.SET_BANDWIDTH_COMMAND == commandType || CommandType.SET_UDP_THRESHOLD_COMMAND == commandType || CommandType.COMPONENT_RUN == commandType) {
            params.addElement(new SimpleElement("throttle", String.valueOf(this.engine.getBandwidthThrottle())));
            params.addElement(new SimpleElement("floor", String.valueOf(this.engine.getMinimumRate())));
            params.addElement(new SimpleElement("ceiling", String.valueOf(this.engine.getTargetRate())));
        } else {
            if (command.get("throttle") != null) {
                params.addElement(new SimpleElement("throttle", command.get("throttle")));
            } else if (command.get(AGENTBANDWIDTH) != null) {
                params.addElement(new SimpleElement("throttle", command.get(AGENTBANDWIDTH)));
            }
            if (command.get("floor") != null) {
                params.addElement(new SimpleElement("floor", command.get("floor")));
            }
            if (command.get("ceiling") != null) {
                params.addElement(new SimpleElement("ceiling", command.get("ceiling")));
            }
        }
        String res = root.asString();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("RemoteCommand generated broadcast: " + res);
        }
        return res;
    }

    private class InvalidRemoteCommand
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidRemoteCommand(String reason) {
            super(reason);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RemoteCommandHandler {
        private HashMap<String, String> propertyParameterAssociation = new HashMap();
        private HashMap<String, String> propertyMethodAssociation;
        private SimpleElementParser parser;
        private AtomicInteger sequenceNumber;
        private ConcurrentHashMap<Integer, RemoteCommand> incompleteCommands;

        public RemoteCommandHandler() {
            this.propertyParameterAssociation.put("com.signiant.interactivetransfer.engine.bandwidth_throttle", "throttle");
            this.propertyParameterAssociation.put("com.signiant.interactivetransfer.engine.udp.target_rate", "ceiling");
            this.propertyParameterAssociation.put("com.signiant.interactivetransfer.engine.udp.minimum_rate", "floor");
            this.propertyMethodAssociation = new HashMap();
            this.propertyMethodAssociation.put("com.signiant.interactivetransfer.engine.bandwidth_throttle", "setbandwidth");
            this.propertyMethodAssociation.put("com.signiant.interactivetransfer.engine.udp.target_rate", "setudpthreshold");
            this.propertyMethodAssociation.put("com.signiant.interactivetransfer.engine.udp.minimum_rate", "setudpthreshold");
            this.parser = new SimpleElementParser(SimpleElementParser.RPC);
            this.sequenceNumber = new AtomicInteger();
            this.incompleteCommands = new ConcurrentHashMap(10, 0.75f, 2);
        }

        public void add(Integer key, RemoteCommand value) {
            block2: {
                try {
                    this.incompleteCommands.put(key, value);
                }
                catch (Exception e) {
                    if (!ControlStream.this.logger.isLoggable(Level.WARNING)) break block2;
                    ControlStream.this.logger.warning(e.toString());
                }
            }
        }

        public RemoteCommand get(Integer key) {
            try {
                return this.incompleteCommands.remove(key);
            }
            catch (Exception e) {
                if (ControlStream.this.logger.isLoggable(Level.WARNING)) {
                    ControlStream.this.logger.warning(e.toString());
                }
                return null;
            }
        }

        public int getSequenceNumber() {
            return this.sequenceNumber.incrementAndGet();
        }

        public void processCommand(int key) {
            RemoteCommand storedCommand;
            if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                ControlStream.this.logger.finest("RemoteCommandHandler looking for stored command with sequence " + key);
            }
            if ((storedCommand = this.get(new Integer(key))) != null) {
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    storedCommand.getClass().getCanonicalName();
                    ControlStream.this.logger.fine("RemoteCommandHandler found stored command " + storedCommand.getClass().getSimpleName() + " for sequence " + key);
                }
                storedCommand.performLocalCommand();
            } else if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("RemoteCommandHandler could not find command for sequence " + key + ", could be a stats update response");
            }
        }

        public void processCommand(String cmd) {
            HashMap<String, String> map = this.parser.parse(cmd);
            if (map != null && !map.isEmpty()) {
                RemoteCommand command;
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    for (String key : map.keySet()) {
                        ControlStream.this.logger.fine("RemoteCommandHandler's parser found (" + key + ", " + map.get(key) + ")");
                    }
                }
                if ((command = this.processCommand(map, true)) != null) {
                    command.perform();
                }
            } else if (ControlStream.this.logger.isLoggable(Level.WARNING)) {
                ControlStream.this.logger.warning("RemoteCommandHandler's parser did not understand: " + cmd);
            }
        }

        public RemoteCommand processCommand(HashMap<String, String> map, boolean nack) {
            RemoteCommand command;
            block5: {
                command = null;
                try {
                    command = this.getCommandClass(map);
                }
                catch (InvalidRemoteCommand irc) {
                    if (ControlStream.this.logger.isLoggable(Level.WARNING)) {
                        ControlStream.this.logger.warning("RemoteCommandHandler: " + irc.getMessage());
                    }
                    if (!nack) break block5;
                    try {
                        map.put("faultString", irc.getMessage());
                        map.put("faultCode", String.valueOf(-1));
                        InvalidCommand invalidCommand = new InvalidCommand(map);
                        invalidCommand.performLocalCommand();
                    }
                    catch (Exception e) {
                        if (!ControlStream.this.logger.isLoggable(Level.WARNING)) break block5;
                        ControlStream.this.logger.warning("RemoteCommandHandler: " + e.getMessage());
                    }
                }
            }
            return command;
        }

        protected RemoteCommand getCommandClass(HashMap<String, String> map) throws InvalidRemoteCommand {
            String receivedCommand = map.get("methodName");
            if (receivedCommand != null) {
                if ("setudpthreshold".equalsIgnoreCase(receivedCommand)) {
                    return new UDPThresholdCommand(map);
                }
                if ("setbandwidth".equalsIgnoreCase(receivedCommand)) {
                    return new BandwidthThrottleCommand(map);
                }
                if ("cancel".equalsIgnoreCase(receivedCommand)) {
                    return new CancelCommand(map);
                }
                if ("componentwait".equalsIgnoreCase(receivedCommand)) {
                    return new ComponentQueuedCommand(map);
                }
                if ("componentrun".equalsIgnoreCase(receivedCommand)) {
                    return new ComponentRunCommand(map);
                }
                throw new InvalidRemoteCommand("RemoteCommandHandler: command is not supported - " + receivedCommand);
            }
            throw new InvalidRemoteCommand("RemoteCommandHandler: no method name");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ComponentQueuedCommand
    extends RemoteCommand {
        public ComponentQueuedCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            super(map);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("ComponentQueuedCommand created");
            }
        }

        @Override
        protected void notifyUser(String userInfo) {
            ComponentQueuedStatusEvent status = this.createComponentStatusEvent(userInfo);
            ControlStream.this.engine.addComponentQueuedStatusEvent(status);
        }

        protected ComponentQueuedStatusEvent createComponentStatusEvent(String userInfo) {
            Long estWaitTime = null;
            try {
                estWaitTime = this.getLongParameter("queuetimeestimate");
            }
            catch (InvalidRemoteCommand e) {
                // empty catch block
            }
            ComponentQueuedStatusEvent status = new ComponentQueuedStatusEvent(ControlStream.this.engine, userInfo);
            status.setCommandSource(this.getCommandSource());
            status.setEstimatedTimeLeftInQueue(estWaitTime);
            return status;
        }

        @Override
        public void performLocalCommand() {
            ControlStream.this.engine.setConnectionStatus(TransferListener.ConnectionStatus.COMPONENT_QUEUED);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("ComponentQueuedCommand set connection status queued");
            }
            if (this.command.containsKey("IFCMDUSER")) {
                this.notifyUser(this.generateUserNotification());
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("ComponentQueuedCommand notified user");
                }
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("ComponentQueuedCommand executed command");
            }
        }

        @Override
        public void performSlaveCommand() {
            this.performLocalCommand();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CancelCommand
    extends RemoteCommand {
        public CancelCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            super(map);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("CancelCommand created");
            }
        }

        @Override
        protected void notifyUser(String userInfo) {
            ControlStream.this.engine.addWarning(new TransferCancelledWarning(userInfo));
        }

        @Override
        public void performLocalCommand() {
            if (this.command.containsKey("IFCMDRESP")) {
                this.notifySlave("command: BROKERCMD " + this.generateCommandResponse(true));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("CancelCommand command response sent");
                }
            }
            if (this.command.containsKey("IFCMDUSER")) {
                this.notifyUser(this.generateUserNotification());
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("CancelCommand notified user");
                }
            }
            if (this.command.containsKey("IFCMDEXEC")) {
                this.forwardSlaveCancelCommand();
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("CancelCommand executed command");
            }
        }

        protected void forwardSlaveCancelCommand() {
            String originatorJid = (String)this.command.get("originator_jid");
            String managerName = (String)this.command.get("managername");
            String cmdSource = (String)this.command.get("cmdsource");
            String cmdTransid = (String)this.command.get("cmdtransid");
            try {
                ControlStream.this.sendSlaveCancelCommand(originatorJid, managerName, cmdSource, cmdTransid);
            }
            catch (Exception discard) {
                // empty catch block
            }
        }

        protected void cancelEngineTransfer() {
            ControlStream.this.engine.cancelTransfer();
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("CancelCommand requested TransferEngine to cancel transfer");
            }
        }

        @Override
        public void performSlaveCommand() {
            this.performLocalCommand();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ComponentRunCommand
    extends RemoteCommand {
        BandwidthResource bwResource;
        static final String RUNRELEASED = "run_released";

        public ComponentRunCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            super(map);
            this.bwResource = null;
            this.bwResource = this.addBandwidthResource(map);
        }

        protected BandwidthResource addBandwidthResource(HashMap<String, String> map) {
            BandwidthResource bwResource = null;
            String startThrottle = map.get(ControlStream.AGENTBANDWIDTH);
            if (startThrottle == null || startThrottle.equals("-1")) {
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("ComponentRunCommand no initial bandwidth throttle defined");
                }
            } else {
                try {
                    map.put("throttle", startThrottle.length() == 0 ? "0" : startThrottle);
                    bwResource = BandwidthResourceFactory.getInstance().getBandwidthResource(map);
                    if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                        ControlStream.this.logger.fine("ComponentRunCommand created a bandwidth resource with values " + bwResource);
                    }
                    ControlStream.this.engine.addBandwidthResource(bwResource);
                }
                catch (Exception exception) {
                    ControlStream.this.logger.severe("ComponentRunCommand Failed to process bandwidth command received from remote agent");
                }
            }
            return bwResource;
        }

        @Override
        protected String formatCommandName() {
            String msg = this.bwResource == null ? "Component Run received with no initial bandwidth throttle" : String.format("Component Run received with initial bandwidth throttle values %s", this.bwResource.toString());
            return msg;
        }

        @Override
        public void performLocalCommand() {
            if (this.command.containsKey("IFCMDUPDT")) {
                this.handleStatsNotifySlave(ControlStream.this.sequence);
            }
            if (this.command.containsKey("IFCMDEXEC")) {
                this.applyThrottleNotifySlave();
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("ComponentRunCommand executed command");
            }
        }

        protected void applyThrottleNotifySlave() {
            if (this.generateBroadCastForComponentRun()) {
                ControlStream.this.engine.applyBandwidthThrottle();
                this.notifySlave("command: BROKERCMD " + ControlStream.this.generateBroadcastEvent(CommandType.COMPONENT_RUN, this.command));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("ComponentRunCommand requesting bandwidth throttle change");
                }
            }
        }

        protected void handleStatsNotifySlave(int sequenceNumber) {
            if (this.generateBroadCastForComponentRun()) {
                Long throttle = ControlStream.this.engine.getPriorityBandwidth();
                String updt = "STATS_UPDATE: CRNTBWTHRTL=" + throttle;
                if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                    ControlStream.this.logger.finest("RemoteCommand generated an agent stats update: " + updt);
                }
                this.notifySlave(updt);
                String command = ControlStream.this.buildSetBandwidthCommand(sequenceNumber, throttle, null, null);
                this.notifySlave(command);
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand stats update sent - " + throttle);
                }
            }
        }

        protected boolean generateBroadCastForComponentRun() {
            boolean generate = true;
            if (this.command.containsKey(RUNRELEASED)) {
                generate = "true".equalsIgnoreCase((String)this.command.get(RUNRELEASED));
            }
            return generate;
        }

        @Override
        public void performSlaveCommand() {
            int sequence = ControlStream.this.remoteHandler.getSequenceNumber();
            ControlStream.this.remoteHandler.add(new Integer(sequence), this);
            long bandwidth = ControlStream.this.engine.getPriorityBandwidth();
            String command = ControlStream.this.buildSetBandwidthCommand(sequence, bandwidth, null, null);
            this.notifySlave(command);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("ComponentRunCommand stored setbandwidth command and awaits reply with sequence " + sequence);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BandwidthThrottleCommand
    extends RemoteCommand {
        private long throttleValue;
        BandwidthResource bwResource;

        public BandwidthThrottleCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            super(map);
            this.bwResource = null;
            this.throttleValue = this.getLongParameter("throttle");
            this.bwResource = this.addBandwidthResource(map);
        }

        protected BandwidthResource addBandwidthResource(HashMap<String, String> map) {
            BandwidthResource bwResource = null;
            bwResource = BandwidthResourceFactory.getInstance().getBandwidthResource(map);
            try {
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand created a bandwidth resource with values " + bwResource);
                }
                if (bwResource.getBandwidthThrottle() == 0L) {
                    this.handleUnManagedRequest(bwResource);
                } else {
                    ControlStream.this.engine.addBandwidthResource(bwResource);
                }
                this.notifySlave("command: BROKERCMD " + ControlStream.this.generateBroadcastEvent(CommandType.REQUEST_BANDWIDTH, this.command));
            }
            catch (Exception exception) {
                ControlStream.this.logger.severe("BandwidthThrottleCommand Failed to process bandwidth command received from remote agent");
            }
            return bwResource;
        }

        protected void handleUnManagedRequest(BandwidthResource bwResource) {
            if (bwResource == null || bwResource.getBandwidthThrottle() > 0L) {
                return;
            }
            ControlStream.this.logger.fine("BandwidthThrottleCommand handle Bandwidth un-managed request with values " + bwResource);
            boolean bwHasBeenRemoved = ControlStream.this.engine.removeBandwidthResource(bwResource);
            if (ControlStream.this.logger.isLoggable(Level.FINE) && bwHasBeenRemoved) {
                StringBuilder message = new StringBuilder();
                message.append("BandwidthThrottleCommand bandwidth ");
                message.append(bwResource.toString());
                message.append(" has been removed");
                ControlStream.this.logger.fine(message.toString());
            }
        }

        @Override
        protected String formatCommandName() {
            String msg = this.bwResource == null ? "Invalid bandwidth throttle received" : String.format("bandwidth throttle request with values %s", this.bwResource.toString());
            return msg;
        }

        @Override
        public void performLocalCommand() {
            if (this.command.containsKey("IFCMDEXEC") && this.bwResource != null) {
                ControlStream.this.engine.applyBandwidthThrottle();
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand  requesting bandwidth throttle change");
                }
            }
            if (this.command.containsKey("IFCMDRESP")) {
                this.notifySlave("command: BROKERCMD " + this.generateCommandResponse(true));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand command response sent");
                }
            }
            if (this.command.containsKey("IFCMDUPDT")) {
                Long throttle = ControlStream.this.engine.getPriorityBandwidth();
                String updt = "STATS_UPDATE: CRNTBWTHRTL=" + throttle;
                if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                    ControlStream.this.logger.finest("RemoteCommand generated an agent stats update: " + updt);
                }
                this.notifySlave(updt);
                String cmd = ControlStream.this.buildSetBandwidthCommand(ControlStream.this.sequence, throttle, null, null);
                this.notifySlave(cmd);
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand stats update sent");
                }
            }
            if (this.command.containsKey("IFCMDBCST")) {
                this.notifySlave("command: BROKERCMD " + ControlStream.this.generateBroadcastEvent(CommandType.SET_BANDWIDTH_COMMAND, this.command));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand broadcast sent");
                }
            }
            if (this.command.containsKey("IFCMDUSER")) {
                this.notifyUser(this.generateUserNotification());
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("BandwidthThrottleCommand notified user");
                }
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("BandwidthThrottleCommand executed command");
            }
        }

        @Override
        public void notifyUser(String userInfo) {
            ControlStream.this.engine.addInfo(userInfo);
            TransferBandwidthStatusEvent event = new TransferBandwidthStatusEvent(ControlStream.this.engine, userInfo);
            event.setType(TransferBandwidthStatusEvent.THROTTLE_TYPE.THROTTLE);
            event.setThrottleValue(this.throttleValue);
            event.setCommandSource(this.getCommandSource());
            ControlStream.this.engine.addTransferBandwidthStatusEvent(event);
        }

        @Override
        public void performSlaveCommand() {
            int sequence = ControlStream.this.remoteHandler.getSequenceNumber();
            ControlStream.this.remoteHandler.add(new Integer(sequence), this);
            long bandwidth = ControlStream.this.engine.getPriorityBandwidth();
            String command = ControlStream.this.buildSetBandwidthCommand(sequence, bandwidth, null, null);
            this.notifySlave(command);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("BandwidthThrottleCommand stored command and awaits reply with sequence " + sequence + ", bandwidth " + bandwidth);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UDPThresholdCommand
    extends RemoteCommand {
        private boolean floorOK;
        private boolean ceilingOK;
        private long ceilingValue;
        private long floorValue;
        private UdpSession data;
        private UdpSession control;

        public UDPThresholdCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            block8: {
                block7: {
                    super(map);
                    this.data = null;
                    this.control = null;
                    try {
                        this.floorValue = this.getLongParameter("floor");
                        this.floorOK = true;
                    }
                    catch (InvalidRemoteCommand irc) {
                        this.floorOK = false;
                        if (!ControlStream.this.logger.isLoggable(Level.FINEST)) break block7;
                        ControlStream.this.logger.finest("UDPThresholdCommand: " + irc.getMessage());
                    }
                }
                try {
                    this.ceilingValue = this.getLongParameter("ceiling");
                    this.ceilingOK = true;
                }
                catch (InvalidRemoteCommand irc) {
                    this.ceilingOK = false;
                    if (!ControlStream.this.logger.isLoggable(Level.FINEST)) break block8;
                    ControlStream.this.logger.finest("UDPThresholdCommand: " + irc.getMessage());
                }
            }
            if (!this.floorOK && !this.ceilingOK) {
                throw new InvalidRemoteCommand("UDPThresholdCommand: no valid parameters found");
            }
            this.control = ControlStream.this.instance.getUdpControlSession();
            if (this.control == null) {
                throw new InvalidRemoteCommand("UDPThresholdCommand: not a UDP transfer");
            }
            this.data = ControlStream.this.instance.getUdpSession();
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                String f = this.floorOK ? "floor of " + this.floorValue : "floor n/a";
                String c = this.ceilingOK ? "ceiling of " + this.ceilingValue : "ceiling n/a";
                ControlStream.this.logger.fine("UDPThresholdCommand created with " + f + " and " + c);
            }
        }

        @Override
        protected String formatCommandName() {
            String cmd = "set UDP ";
            String f = "floor to: " + this.floorValue + " Bps";
            String c = "ceiling to: " + this.ceilingValue + " Bps";
            if (this.floorOK && this.ceilingOK) {
                return cmd + f + " and " + c;
            }
            if (this.floorOK) {
                return cmd + f;
            }
            if (this.ceilingOK) {
                return cmd + c;
            }
            return null;
        }

        @Override
        public void notifyUser(String userInfo) {
            TransferBandwidthStatusEvent event;
            ControlStream.this.engine.addInfo(userInfo);
            if (this.floorOK) {
                event = new TransferBandwidthStatusEvent(ControlStream.this.engine, userInfo);
                event.setType(TransferBandwidthStatusEvent.THROTTLE_TYPE.FLOOR);
                event.setThrottleValue(this.floorValue);
                event.setCommandSource(this.getCommandSource());
                ControlStream.this.engine.addTransferBandwidthStatusEvent(event);
            }
            if (this.ceilingOK) {
                event = new TransferBandwidthStatusEvent(ControlStream.this.engine, userInfo);
                event.setType(TransferBandwidthStatusEvent.THROTTLE_TYPE.CEILING);
                event.setThrottleValue(this.ceilingValue);
                event.setCommandSource(this.getCommandSource());
                ControlStream.this.engine.addTransferBandwidthStatusEvent(event);
            }
        }

        @Override
        public void performLocalCommand() {
            if (this.command.containsKey("IFCMDEXEC")) {
                if (this.floorOK) {
                    ControlStream.this.engine.setMinimumRate(this.floorValue, false);
                    if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                        ControlStream.this.logger.finest("UDPThresholdCommand set floor to: " + this.floorValue + " for minimum_rate property");
                    }
                    if (this.data != null) {
                        this.data.setMinimumBandwidth(this.floorValue);
                        if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                            ControlStream.this.logger.finest("UDPThresholdCommand set floor to: " + this.floorValue + " on data channel");
                        }
                    }
                    if (this.control != null) {
                        this.control.setMinimumBandwidth(this.floorValue);
                        if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                            ControlStream.this.logger.finest("UDPThresholdCommand set floor to: " + this.floorValue + " on control channel");
                        }
                    }
                }
                if (this.ceilingOK) {
                    ControlStream.this.engine.setTargetRate(this.ceilingValue, false);
                    if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                        ControlStream.this.logger.finest("UDPThresholdCommand set ceiling to: " + this.ceilingValue + " for target_rate property");
                    }
                    if (this.data != null) {
                        this.data.setMaximumBandwidth(this.ceilingValue);
                        if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                            ControlStream.this.logger.finest("UDPThresholdCommand set ceiling to: " + this.ceilingValue + " on data channel");
                        }
                    }
                    if (this.control != null) {
                        this.control.setMaximumBandwidth(this.ceilingValue);
                        if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                            ControlStream.this.logger.finest("UDPThresholdCommand set ceiling to: " + this.ceilingValue + " on control channel");
                        }
                    }
                }
                if (this.floorOK || this.ceilingOK) {
                    this.notifySlave("command: BROKERCMD " + ControlStream.this.generateBroadcastEvent(CommandType.REQUEST_UDP_THRESHOLD, this.command));
                }
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("UDPThresholdCommand updated floor and ceiling parameters");
                }
            }
            if (this.command.containsKey("IFCMDRESP")) {
                this.notifySlave("command: BROKERCMD " + this.generateCommandResponse(true));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("UDPThresholdCommand command response sent");
                }
            }
            if (this.command.containsKey("IFCMDBCST")) {
                this.notifySlave("command: BROKERCMD " + ControlStream.this.generateBroadcastEvent(CommandType.SET_UDP_THRESHOLD_COMMAND, this.command));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("UDPThresholdCommand broadcast sent");
                }
            }
            if (this.command.containsKey("IFCMDUPDT")) {
                String updt = "STATS_UPDATE:";
                if (this.floorOK) {
                    updt = updt + " CRNTUDPFLOOR=" + this.floorValue;
                }
                if (this.ceilingOK) {
                    updt = updt + " CRNTUDPCEIL=" + this.ceilingValue;
                }
                if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                    ControlStream.this.logger.finest("RemoteCommand generated an agent stats update: " + updt);
                }
                this.notifySlave(updt);
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("UDPThresholdCommand stats update sent");
                }
            }
            if (this.command.containsKey("IFCMDUSER")) {
                this.notifyUser(this.generateUserNotification());
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("UDPThresholdCommand notified user");
                }
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("UDPThresholdCommand executed command");
            }
        }

        @Override
        public void performSlaveCommand() {
            int sequence = ControlStream.this.remoteHandler.getSequenceNumber();
            ControlStream.this.remoteHandler.add(new Integer(sequence), this);
            Long localFloorValue = this.floorOK ? Long.valueOf(this.floorValue) : null;
            Long localCeilingValue = this.ceilingOK ? Long.valueOf(this.ceilingValue) : null;
            Long localThrottleValue = null;
            String cmd = ControlStream.this.buildSetBandwidthCommand(sequence, localThrottleValue, localFloorValue, localCeilingValue);
            if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                ControlStream.this.logger.finest("RemoteCommand generated an agent stats update: " + cmd);
            }
            this.notifySlave(cmd);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("UDPThresholdCommand stored command and awaits reply with sequence " + sequence);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvalidCommand
    extends RemoteCommand {
        public InvalidCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            super(map);
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("InvalidCommand created");
            }
        }

        @Override
        public void performLocalCommand() {
            if (this.command.containsKey("IFCMDRESP")) {
                this.notifySlave("command: BROKERCMD " + this.generateCommandResponse(false));
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("InvalidCommand command response sent");
                }
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("InvalidCommand executed command");
            }
        }

        @Override
        public void performSlaveCommand() {
            this.performLocalCommand();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class RemoteCommand {
        protected static final String IFCMDEXEC = "IFCMDEXEC";
        protected static final String IFCMDRESP = "IFCMDRESP";
        protected static final String IFCMDBCST = "IFCMDBCST";
        protected static final String IFCMDUPDT = "IFCMDUPDT";
        protected static final String IFCMDUSER = "IFCMDUSER";
        protected HashMap<String, String> command;

        protected RemoteCommand(HashMap<String, String> map) throws InvalidRemoteCommand {
            String originator_jid = map.get("originator_jid");
            if (originator_jid == null) {
                throw new InvalidRemoteCommand("RemoteCommand failed on creation, originator_jid is null");
            }
            if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                ControlStream.this.logger.finest("RemoteCommand created, originator_jid is: " + originator_jid);
            }
            this.command = new HashMap<String, String>(map);
            this.command.put(IFCMDEXEC, null);
            this.command.put(IFCMDRESP, null);
            this.command.put(IFCMDBCST, null);
            this.command.put(IFCMDUPDT, null);
            this.command.put(IFCMDUSER, null);
        }

        public abstract void performLocalCommand();

        public abstract void performSlaveCommand();

        public void perform() {
            TransferMode mode = ControlStream.this.engine.getMode();
            if (mode == TransferMode.RECEIVE) {
                this.performSlaveCommand();
            } else if (mode == TransferMode.SEND) {
                this.performLocalCommand();
            } else if (ControlStream.this.logger.isLoggable(Level.WARNING)) {
                ControlStream.this.logger.warning(this.getClass().getSimpleName() + " did not recognize a valid transfer mode");
            }
        }

        protected String generateCommandResponse(boolean success) {
            String text;
            String code;
            SimpleElement resultCode = null;
            SimpleElement resultText = null;
            SimpleElement resultComplete = null;
            SimpleElement root = new SimpleElement("methodResponse");
            if (success) {
                code = this.command.get("cmdresultcode") == null ? String.valueOf(0) : this.command.get("cmdresultcode");
                text = this.command.get("cmdresulttext") == null ? "ok" : this.command.get("cmdresulttext");
                resultCode = SimpleElement.addMember("cmdresultcode", code);
                resultText = SimpleElement.addMember("cmdresulttext", text);
                resultComplete = SimpleElement.addMember("cmdcomplete", "yes");
            } else {
                code = this.command.get("faultCode") == null ? String.valueOf(-1) : this.command.get("faultCode");
                text = this.command.get("faultString") == null ? "fault" : this.command.get("faultString");
                SimpleElement[] faultCondition = new SimpleElement[]{SimpleElement.addMember("faultCode", code), SimpleElement.addMember("faultString", text)};
                SimpleElement fault = new SimpleElement("fault");
                fault.addElement(SimpleElement.addMember(faultCondition));
                root.addElement(fault);
            }
            SimpleElement params = new SimpleElement("params");
            root.addElement(params);
            SimpleElement param = new SimpleElement("param");
            params.addElement(param);
            SimpleElement[] headerContents = new SimpleElement[]{SimpleElement.addMember("managername", this.command.get("managername")), SimpleElement.addMember("cmdsource", this.command.get("cmdsource"))};
            SimpleElement[] cmdContents = new SimpleElement[]{SimpleElement.addMember("cmdpriority", this.command.get("cmdpriority")), SimpleElement.addMember("cmdtransid", this.command.get("cmdtransid"))};
            SimpleElement[] contents = new SimpleElement[]{SimpleElement.addMember("header", SimpleElement.addMember(headerContents)), SimpleElement.addMember("cmdproperties", SimpleElement.addMember(cmdContents)), SimpleElement.addMember("jobid", this.command.get("jobid")), SimpleElement.addMember("componentid", this.command.get("componentid")), resultCode, resultText, resultComplete};
            param.addElement(SimpleElement.addMember(contents));
            SimpleElement top = new SimpleElement("XMLCMD");
            top.addElement(new SimpleElement("originator_jid", this.command.get("originator_jid")));
            top.addElement(root);
            String res = top.asString();
            if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                ControlStream.this.logger.finest("RemoteCommand generated response: " + res);
            }
            return res;
        }

        protected String generateUserNotification() {
            String userInfo;
            String managername = this.command.get("managername");
            String string = userInfo = managername == null ? "Executing '" + this.formatCommandName() + "' command issued by unknown source" : "Executing '" + this.formatCommandName() + "' command issued by " + "'" + managername + "'";
            if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                ControlStream.this.logger.finest("RemoteCommand generated user notification: " + userInfo);
            }
            return userInfo;
        }

        protected void notifySlave(String message) {
            block2: {
                try {
                    ControlStream.this.println(message);
                }
                catch (Exception e) {
                    if (!ControlStream.this.logger.isLoggable(Level.WARNING)) break block2;
                    ControlStream.this.logger.finest("RemoteCommand caught the exception: " + e + " while sending message: " + message);
                }
            }
        }

        protected void notifyUser(String userInfo) {
            ControlStream.this.engine.addInfo("remotecommand " + userInfo);
        }

        protected String formatCommandName() {
            return this.command.get("methodName");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void enableAction(String enable) {
            RemoteCommand remoteCommand = this;
            synchronized (remoteCommand) {
                this.command.put(enable, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void disableAction(String disable) {
            RemoteCommand remoteCommand = this;
            synchronized (remoteCommand) {
                this.command.remove(disable);
            }
        }

        protected long getLongParameter(String key) throws InvalidRemoteCommand {
            if (key == null) {
                throw new InvalidRemoteCommand("RemoteCommand: map key is null");
            }
            String param = this.command.get(key);
            if (param == null) {
                throw new InvalidRemoteCommand("RemoteCommand: cannot find value for - " + key);
            }
            try {
                Long val = new Long(param);
                return val;
            }
            catch (NumberFormatException nfe) {
                throw new InvalidRemoteCommand("RemoteCommand: could not obtain long value of - " + param);
            }
        }

        protected String getCommandSource() {
            String commandSource = this.command.get("managername");
            if (commandSource != null) {
                return commandSource;
            }
            return "";
        }

        protected Map<String, String> getCommand() {
            return this.command;
        }
    }

    private class XMLCommand
    extends Command {
        public XMLCommand() {
            super("command: BROKERCMD (<XMLCMD>.*)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            block3: {
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("XMLCommand message received, forwarding to RemoteCommandHandler");
                }
                try {
                    ControlStream.this.remoteHandler.processCommand(args[0]);
                }
                catch (Exception e) {
                    if (!ControlStream.this.logger.isLoggable(Level.WARNING)) break block3;
                    ControlStream.this.logger.warning("XMLCommand exception: " + e);
                }
            }
        }
    }

    private class CmdRespEnd
    extends Command {
        protected CmdRespEnd() {
            super("\\eR#(cmdresp_end)=(\\d+)#\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            block3: {
                if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                    ControlStream.this.logger.fine("CmdRespEnd message received with sequence " + args[1] + ", forwarding to RemoteCommandHandler");
                }
                try {
                    int key = Integer.parseInt(args[1]);
                    ControlStream.this.remoteHandler.processCommand(key);
                }
                catch (Exception e) {
                    if (!ControlStream.this.logger.isLoggable(Level.WARNING)) break block3;
                    ControlStream.this.logger.warning("CmdRespEnd exception: " + e);
                }
            }
        }
    }

    private class HeartbeatGenerator
    extends Thread {
        private AtomicLong lastRecvHeartbeatTime = new AtomicLong(0L);
        private AtomicLong lastSentHeartbeatTime = new AtomicLong(0L);
        private boolean running;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("Heartbeat Generator");
            this.lastRecvHeartbeatTime.set(System.currentTimeMillis());
            this.lastSentHeartbeatTime.set(System.currentTimeMillis());
            this.running = true;
            while (true) {
                Object object = ControlStream.this.shutdownLock;
                synchronized (object) {
                    if (!this.running) {
                        break;
                    }
                    try {
                        if (System.currentTimeMillis() - this.lastSentHeartbeatTime.get() > 60000L) {
                            if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                                ControlStream.this.logger.finer("Sending heartbeat");
                            }
                            ControlStream.this.println("command: heartbeat");
                            this.lastSentHeartbeatTime.set(System.currentTimeMillis());
                        }
                        if (System.currentTimeMillis() - this.lastRecvHeartbeatTime.get() > 300000L) {
                            if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                                ControlStream.this.logger.finer("Last heartbeat occurred at " + new Date(this.lastRecvHeartbeatTime.get()));
                            }
                            ControlStream.this.engine.addError(new NoHeartbeatException());
                        }
                    }
                    catch (Exception discard) {
                        this.running = false;
                    }
                }
                try {
                    if (!this.running) continue;
                    HeartbeatGenerator.sleep(10000L);
                }
                catch (Exception exception) {}
            }
        }

        public void pulse() {
            if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                ControlStream.this.logger.finer("Heard a heartbeat from remote agent");
            }
            this.lastRecvHeartbeatTime.set(System.currentTimeMillis());
        }

        public void cancel() {
            this.running = false;
        }
    }

    private class GenerateFileHeaders
    extends Thread {
        private TransferEngine engine;
        private boolean cancelled = false;

        public GenerateFileHeaders(TransferEngine engine) {
            this.engine = engine;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run() {
            String[] sFiles;
            Thread.currentThread().setName("Send file headers");
            if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                ControlStream.this.logger.finer("File name header generation starting");
            }
            for (String s : sFiles = this.engine.getFiles()) {
                if (this.engine.getConnectionStatus() == TransferListener.ConnectionStatus.DISCONNECTED || this.cancelled) break;
                File f = new File(s);
                if (!s.startsWith("/dev/null/")) {
                    if (!f.exists()) {
                        this.engine.addWarning(new FileNotFoundWarning("Could not locate file: " + s, s));
                        continue;
                    }
                    this.addFile(f, null, false);
                    continue;
                }
                this.addFile(f, null, true);
            }
            ControlStream.this.setFileGenerationComplete(true);
            if (ControlStream.this.agentProtocolVersionNumber >= 16) {
                DataStream dataChannel = (DataStream)ControlStream.this.streams.get(0);
                try {
                    dataChannel.fileGenerationComplete();
                }
                catch (Exception e) {
                    this.engine.addError(e);
                }
            }
            ControlStream.this.checkTransferFinished();
            if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                ControlStream.this.logger.finer("File name header generation ended");
            }
        }

        private void addFile(File file, String parentDir, boolean dummyFile) {
            if (this.engine.isCancelled() || this.cancelled) {
                return;
            }
            if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                ControlStream.this.logger.finer("Adding file name: " + file.getName());
            }
            String relativeName = "";
            if (parentDir != null && parentDir.length() > 0) {
                relativeName = parentDir + "/";
            }
            relativeName = relativeName + file.getName();
            if (dummyFile) {
                try {
                    long size = Long.parseLong(relativeName);
                }
                catch (NumberFormatException discard) {
                    this.engine.addWarning(new FileNotFoundWarning("Invalid format file name for dummy transfer: " + relativeName, file.getName()));
                    return;
                }
            } else if (!file.exists()) {
                this.engine.addWarning(new FileNotFoundWarning("Unable to determine the existence of file: " + relativeName, file.getName()));
                return;
            }
            if (file.isDirectory()) {
                File[] dir;
                for (File f : dir = file.listFiles()) {
                    this.addFile(f, relativeName, false);
                }
                return;
            }
            String fullySpecifiedParentDirectory = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - relativeName.length());
            int seq = ControlStream.this.sequence++;
            FileTransfer ft = new FileTransfer(ControlStream.this.engine, seq, file, fullySpecifiedParentDirectory, relativeName);
            ControlStream.this.files.put(seq, ft);
            this.engine.fileHeader(ft);
            if (ControlStream.this.agentProtocolVersionNumber >= 16) {
                DataStream dataChannel = (DataStream)ControlStream.this.streams.get(0);
                try {
                    dataChannel.addFileHeader(ft);
                }
                catch (Exception e) {
                    this.engine.addError(e);
                }
            } else {
                StringBuilder sb = new StringBuilder("file_header:");
                sb.append(" ve=5");
                sb.append(" fn=\"" + relativeName + "\"");
                sb.append(" fm=33279");
                sb.append(" fs=" + ft.getSize());
                sb.append(" mt=" + ft.getLastModifiedAt());
                sb.append(" at=0");
                sb.append(" sq=" + seq);
                try {
                    ControlStream.this.println(sb.toString());
                }
                catch (Exception e) {
                    this.engine.addError(e);
                }
            }
        }
    }

    private class AgentPrepackageFailed
    extends Command {
        public AgentPrepackageFailed() {
            super("#agent_prepackage_fails\n");
        }

        public void perform(String cmd, String[] args) {
            ControlStream.this.setFileGenerationComplete(true);
            try {
                ControlStream.this.println("command: postpackage error");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ControlStream.this.engine.addError(new PrepackageFailedException("Remote system rejected transfer"));
        }
    }

    private class AgentHeartbeat
    extends Command {
        public AgentHeartbeat() {
            super("#agent_heartbeat\n");
        }

        public void perform(String cmd, String[] args) {
            if (ControlStream.this.heartbeatGenerator != null) {
                ControlStream.this.heartbeatGenerator.pulse();
            }
        }
    }

    private class CompletedCommand
    extends Command {
        public CompletedCommand() {
            super("command: complete (\\d+)\n");
        }

        public void perform(String cmd, String[] args) {
            int returnCode = 0;
            try {
                returnCode = Integer.parseInt(args[0]);
            }
            catch (Exception discard) {
                // empty catch block
            }
            ControlStream.this.setFinished();
            ControlStream.this.shutdownDataStreams();
            if (returnCode != 0) {
                String error = "code " + returnCode;
                if (returnCode >= 10 && returnCode < errorCodes.length) {
                    error = errorCodes[returnCode];
                }
                ControlStream.this.engine.addError(new PackageCompletedErrorCodeException("Remote system exited with " + error, returnCode));
            }
        }
    }

    private class SlaveDone
    extends Command {
        public SlaveDone() {
            super("slave_done: (\\d+)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("Remote agent file generation complete");
            }
            ControlStream.this.setFileGenerationComplete(true);
            if (ControlStream.this.agentProtocolVersionNumber < 16) {
                if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                    ControlStream.this.logger.finest("Shutting down data streams");
                }
                for (DataStream ds : ControlStream.this.streams) {
                    ds.finish();
                }
            } else {
                ControlStream.this.checkTransferFinished();
            }
        }
    }

    private class SkipFile
    extends Command {
        public SkipFile() {
            super("skipfile: (\\d+)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            FileTransfer ft = (FileTransfer)ControlStream.this.files.get(Integer.parseInt(args[0]));
            if (ft != null) {
                ControlStream.this.engine.skipFile(ft);
                ft.skippedFileExists();
                ControlStream.this.checkTransferFinished();
            }
        }
    }

    private class SendFile
    extends Command {
        public SendFile() {
            super("sendfile: (\\d+)\n");
        }

        public void perform(String cmd, String[] args) {
            FileTransfer f = (FileTransfer)ControlStream.this.files.get(Integer.parseInt(args[0]));
            try {
                if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                    ControlStream.this.logger.finest("Enqueuing: " + f);
                }
                ControlStream.this.pushFiles.put(f);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    private class FileHeader
    extends Command {
        HashMap<String, String> fields;

        public FileHeader() {
            super("file_header: (.+)\n");
            this.fields = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(String cmd, String[] args) throws Exception {
            this.parse(args[0]);
            FileTransfer ft = ControlStream.this.addFileToTransfer(this.getFieldInteger("sq"), this.getFieldString("fn"), (short)this.getFieldInteger("fm"), this.getFieldLong("fs"), this.getFieldLong("mt"), this.getFieldString("cp").equalsIgnoreCase("no"), false);
            FileHeader fileHeader = this;
            synchronized (fileHeader) {
                if (ControlStream.this.initialized) {
                    if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                        ControlStream.this.logger.fine("Processing file: " + ft);
                    }
                    if (ft.getState() == FileTransfer.State.SKIPPED_EXISTS) {
                        ControlStream.this.println("skipfile: " + ft.getSequence());
                    } else {
                        ControlStream.this.println("sendfile: " + ft.getSequence());
                    }
                } else {
                    List list = ControlStream.this.pendingFiles;
                    synchronized (list) {
                        ControlStream.this.pendingFiles.add(ft);
                    }
                }
            }
        }

        private void parse(String cmd) {
            block8: {
                StringReader r = new StringReader(cmd);
                int nextChar = 0;
                try {
                    while (nextChar != -1) {
                        char[] buf = new char[2];
                        r.read(buf);
                        String field = new String(buf);
                        StringBuffer value = new StringBuffer();
                        r.read();
                        nextChar = r.read();
                        if (nextChar == 34) {
                            int nextNext;
                            while (nextChar != -1 && ((nextChar = r.read()) != 34 || nextChar == -1 || (nextNext = r.read()) != 32 && nextNext != -1)) {
                                value.append((char)nextChar);
                            }
                        } else {
                            while (nextChar != -1 && nextChar != 32) {
                                value.append((char)nextChar);
                                nextChar = r.read();
                            }
                        }
                        if (field.equals("fn") && "windows".equals(ControlStream.this.getVariable("remote_system_type"))) {
                            String filename = value.toString().replaceAll("\\\\", "/");
                            this.fields.put(field, filename);
                            continue;
                        }
                        this.fields.put(field, value.toString());
                    }
                }
                catch (IOException discard) {
                    discard.printStackTrace();
                    if (!ControlStream.this.logger.isLoggable(Level.WARNING)) break block8;
                    ControlStream.this.logger.warning("Could not parse file header: '" + cmd + "' " + cmd);
                }
            }
        }

        private String getFieldString(String fieldname) {
            String value = this.fields.get(fieldname);
            if (value == null) {
                value = "";
            }
            return value;
        }

        private int getFieldInteger(String fieldname) {
            String value = this.getFieldString(fieldname);
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }

        private long getFieldLong(String fieldname) {
            String value = this.getFieldString(fieldname);
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
    }

    private class SetVariable
    extends Command {
        public SetVariable() {
            super("\\eV(\\S+)=\"(\\S+)\"\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            if (args.length == 2) {
                if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                    ControlStream.this.logger.finer("Set variable: " + args[0] + "=" + args[1]);
                }
                ControlStream.this.variableTable.put(args[0], args[1]);
            }
        }
    }

    private class Message
    extends Command {
        public Message() {
            super("ms=(\\S+)\\s+(.*)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            Pattern varpattern = Pattern.compile(".*\\eV(\\S+)=(\\S+)");
            for (int i = 0; i < args.length; ++i) {
                Matcher matcher;
                if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                    ControlStream.this.logger.finest("Message info: " + args[i]);
                }
                if (!(matcher = varpattern.matcher(args[i])).matches()) continue;
                if (ControlStream.this.logger.isLoggable(Level.FINER)) {
                    ControlStream.this.logger.finer("Set variable: " + matcher.group(1) + "=" + matcher.group(2));
                }
                ControlStream.this.variableTable.put(matcher.group(1), matcher.group(2));
            }
        }
    }

    private class AgentStarted
    extends Command {
        public AgentStarted() {
            super("#agent_started\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            ControlStream.this.agentStarted = true;
            ControlStream.this.prepareForTransfer();
        }
    }

    private class Response
    extends Command {
        public Response() {
            super("response: (.+)\n");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(String cmd, String[] args) throws Exception {
            if (args[0].equalsIgnoreCase("ddsbrokercancel_ack")) {
                boolean directCancel = false;
                if (ControlStream.this.slaveCancelTimer != null) {
                    Timer timer = ControlStream.this.slaveCancelTimer;
                    synchronized (timer) {
                        if (ControlStream.this.waitingSlaveCancelAck) {
                            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                                ControlStream.this.logger.fine("Cancel command acknowledged, resuming in progress shutdown");
                            }
                            ControlStream.this.waitingSlaveCancelAck = false;
                            ControlStream.this.slaveCancelTimer.notifyAll();
                        } else {
                            directCancel = true;
                        }
                        ControlStream.this.slaveCancelTimer.cancel();
                        ControlStream.this.slaveCancelTimer = null;
                    }
                } else {
                    directCancel = true;
                }
                if (directCancel) {
                    if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                        ControlStream.this.logger.fine("Cancel command acknowledged, cancelling transfer");
                    }
                    ControlStream.this.engine.cancelTransfer();
                }
            }
        }
    }

    private class UdpSessionPort
    extends Command {
        public UdpSessionPort() {
            super("udp_session_port: (\\d+)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            int port;
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid port entry on UDP session initialize [" + args[0] + "]");
            }
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("Initializing UDP session on port: " + port);
            }
            try {
                ControlStream.this.instance.newUdpDataSession(port, 20000000);
            }
            catch (Exception e) {
                if (ControlStream.this.logger.isLoggable(Level.SEVERE)) {
                    ControlStream.this.logger.severe("Failed to initialize UDP session on port: " + port + " " + e);
                }
                throw e;
            }
        }
    }

    private class DataChannelPort
    extends Command {
        public DataChannelPort() {
            super("data_channel_port: (\\d+)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            int port = Integer.parseInt(args[0]);
            DataStream stream = new DataStream(ControlStream.this.engine, ControlStream.this, true, port);
            ControlStream.this.streams.add(stream);
            new Thread(stream).start();
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("Created new data stream: " + stream);
            }
        }
    }

    private class NewTcpStream
    extends Command {
        public NewTcpStream() {
            super("stream_data_port (\\d+): (\\d+)\n");
        }

        public void perform(String cmd, String[] args) throws Exception {
            byte handle = Byte.parseByte(args[0]);
            int port = Integer.parseInt(args[1]);
            DataStream stream = new DataStream(ControlStream.this.engine, ControlStream.this, handle, port);
            ControlStream.this.streams.add(stream);
            new Thread(stream).start();
            if (ControlStream.this.logger.isLoggable(Level.FINE)) {
                ControlStream.this.logger.fine("Created new data stream: " + stream);
            }
        }
    }

    protected abstract class Command {
        private Pattern pattern;

        public boolean match(String cmd) throws Exception {
            Matcher matcher = this.pattern.matcher(cmd);
            if (!matcher.matches()) {
                return false;
            }
            int n = matcher.groupCount();
            String[] args = new String[n];
            for (int i = 0; i < n; ++i) {
                args[i] = matcher.group(i + 1);
            }
            if (ControlStream.this.logger.isLoggable(Level.FINEST)) {
                ControlStream.this.logger.finest("Processing: " + cmd);
            }
            this.perform(cmd, args);
            return true;
        }

        public abstract void perform(String var1, String[] var2) throws Exception;

        protected Command(String regex) {
            this.pattern = Pattern.compile(regex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CommandType {
        REQUEST_BANDWIDTH,
        SET_UDP_THRESHOLD_COMMAND,
        SET_BANDWIDTH_COMMAND,
        REQUEST_UDP_THRESHOLD,
        COMPONENT_INITIAL_START,
        REQUEST_COMPONENT_RUN,
        COMPONENT_RUN;

    }
}

