/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer;

import com.signiant.interactivetransfer.Application;
import com.signiant.interactivetransfer.JSWrapper;
import com.signiant.interactivetransfer.StatusPanel;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferListener;
import com.signiant.interactivetransfer.engine.exceptions.ConfigurationException;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TransferApplet
extends JApplet {
    static final long serialVersionUID = 0L;
    private StatusPanel status = null;
    private TransferEngine engine = null;
    private String cancelLabel;
    private String onCancelCommand;
    private String onCloseCommand;
    private String onCompleteCommand;
    private String onConnectionCommand;
    private String onFileCommand;
    private String onInfoCommand;
    private String onLessCommand;
    private String onMoreCommand;
    private String onPauseCommand;
    private String onResumeCommand;
    private String bgColor;
    private String fgColor;

    public TransferApplet() {
        UIManager.LookAndFeelInfo[] info;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this);
        for (UIManager.LookAndFeelInfo i : info = UIManager.getInstalledLookAndFeels()) {
            if (!i.getName().equals("GTK+")) continue;
            try {
                UIManager.setLookAndFeel(i.getClassName());
            }
            catch (Exception discard) {
                // empty catch block
            }
        }
    }

    public void init() {
        String config;
        super.init();
        this.engine = new TransferEngine();
        Properties props = new Properties();
        this.setParameterIfPresent(props, "mode");
        this.setParameterIfPresent(props, "transport");
        this.setParameterIfPresent(props, "agent_list");
        this.setParameterIfPresent(props, "url_list");
        this.setParameterIfPresent(props, "user");
        this.setParameterIfPresent(props, "password");
        this.setParameterIfPresent(props, "files");
        this.setParameterIfPresent(props, "destination_dir");
        this.setParameterIfPresent(props, "service_data");
        this.setParameterIfPresent(props, "session_id");
        this.setParameterIfPresent(props, "ca_certificate");
        this.setParameterIfPresent(props, "retries");
        this.setParameterIfPresent(props, "restarts");
        this.setParameterIfPresent(props, "bandwidth_throttle");
        this.setParameterIfPresent(props, "encrypt");
        this.setParameterIfPresent(props, "streams");
        this.setParameterIfPresent(props, "logging");
        this.setParameterIfPresent(props, "trace");
        this.setParameterIfPresent(props, "udp.target_rate");
        this.setParameterIfPresent(props, "udp.minimum_rate");
        this.setParameterIfPresent(props, "udp.aggressiveness");
        if (props.size() > 0) {
            try {
                this.engine.setProperties(props);
            }
            catch (ConfigurationException discard) {
                // empty catch block
            }
        }
        if ((config = this.getParameter(".config")) != null && !config.equals(null)) {
            try {
                this.engine.setObfuscatedProperties(config, this);
            }
            catch (ConfigurationException discard) {
                // empty catch block
            }
        }
        this.setCancelLabel(this.getParameter("cancelLabel"));
        this.onCancel(this.getParameter("onCancel"));
        this.onClose(this.getParameter("onClose"));
        this.onComplete(this.getParameter("onComplete"));
        this.onConnection(this.getParameter("onConnection"));
        this.onInfo(this.getParameter("onInfo"));
        this.onFile(this.getParameter("onFile"));
        this.onLess(this.getParameter("onLess"));
        this.onMore(this.getParameter("onMore"));
        this.onPause(this.getParameter("onPause"));
        this.onResume(this.getParameter("onResume"));
        this.setBgColor(this.getParameter("bgColor"));
        this.setFgColor(this.getParameter("fgColor"));
        this.status = new StatusPanel(this, this.engine);
        Thread t = new Thread("Applet Main UI"){

            public void run() {
                TransferApplet.this.displaySettings();
            }
        };
        t.start();
    }

    public void destroy() {
        if (this.status != null) {
            this.status.cancel();
            this.status = null;
        }
        if (this.engine != null) {
            this.engine.cancelTransfer();
            this.engine.release();
            this.engine = null;
        }
        super.destroy();
    }

    public void displaySettings() {
        TransferListener.CompletionStatus status;
        boolean incomplete = !this.engine.isValidTransfer();
        boolean first = true;
        do {
            Application app = null;
            if (!first && incomplete) {
                if (app == null) {
                    app = new Application(this, this.engine);
                } else {
                    app.doDialog();
                }
                if (app.isClosed()) {
                    try {
                        this.destroy();
                    }
                    catch (Throwable discard) {
                        // empty catch block
                    }
                    return;
                }
            }
            while (this.engine != null && !this.engine.isValidTransfer()) {
                if (app == null) {
                    app = new Application(this, this.engine);
                } else {
                    app.doDialog();
                }
                if (!app.isClosed()) continue;
                try {
                    this.destroy();
                }
                catch (Throwable discard) {
                    // empty catch block
                }
                return;
            }
            try {
                if (this.engine != null) {
                    this.engine.startTransfer();
                }
            }
            catch (Exception discard) {
                discard.printStackTrace();
            }
            first = false;
            if (this.engine == null) {
                return;
            }
            status = this.engine.waitForTransfer();
        } while (incomplete && status == TransferListener.CompletionStatus.FAILURE);
    }

    private void setParameterIfPresent(Properties props, String name) {
        String baseProperty = this.engine.getClass().getPackage().getName() + ".";
        String value = this.getParameter(name);
        if (value == null || value.equals("null")) {
            return;
        }
        props.put(baseProperty + name, value);
    }

    public void setCancelLabel(String label) {
        this.cancelLabel = label;
    }

    public String getCancelLabel() {
        return this.cancelLabel;
    }

    public void onCancel(String command) {
        this.onCancelCommand = command;
    }

    public void onClose(String command) {
        this.onCloseCommand = command;
    }

    public void onComplete(String command) {
        this.onCompleteCommand = command;
    }

    public void onConnection(String command) {
        this.onConnectionCommand = command;
    }

    public void onInfo(String command) {
        this.onInfoCommand = command;
    }

    public void onFile(String command) {
        this.onFileCommand = command;
    }

    public void onLess(String command) {
        this.onLessCommand = command;
    }

    public void onMore(String command) {
        this.onMoreCommand = command;
    }

    public void onPause(String command) {
        this.onPauseCommand = command;
    }

    public void onResume(String command) {
        this.onResumeCommand = command;
    }

    public void setBgColor(String color) {
        this.bgColor = color;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setFgColor(String color) {
        this.fgColor = color;
    }

    public String getFgColor() {
        return this.fgColor;
    }

    synchronized void doCommand(String command) {
        if (command == null || command.length() == 0) {
            return;
        }
        try {
            JSWrapper.eval(JSWrapper.getWindow(this), command);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void doCancelCommand() {
        this.doCommand(this.onCancelCommand);
    }

    void doCloseCommand() {
        this.doCommand(this.onCloseCommand);
    }

    void doCompleteCommand(String status) {
        if (this.onCompleteCommand != null) {
            String escapedString = this.escapeString(status);
            this.doCommand(this.onCompleteCommand.replaceAll("%status%", escapedString));
        }
    }

    void doConnectionCommand(String status, String sessionId) {
        if (this.onConnectionCommand != null) {
            String escapedString = this.escapeString(status);
            String escapedSession = "";
            if (sessionId != null) {
                escapedSession = this.escapeString(sessionId);
            }
            this.doCommand(this.onConnectionCommand.replaceAll("%status%", escapedString).replaceAll("%sessionId%", escapedSession));
        }
    }

    void doFileCommand(String filename, long size, String state) {
        if (this.onFileCommand != null) {
            String escapedFilename = this.escapeString(filename);
            this.doCommand(this.onFileCommand.replaceAll("%name%", escapedFilename).replaceAll("%size%", "" + size).replaceAll("%state%", state));
        }
    }

    void doInfoCommand(String msg) {
        if (this.onInfoCommand != null) {
            String escapedString = this.escapeString(msg);
            this.doCommand(this.onInfoCommand.replaceAll("%msg%", escapedString));
        }
    }

    private String escapeString(String original) {
        return original.replaceAll("\\$", "\\\\\\$").replaceAll("'", "\\\\\\\\'").replaceAll("\"", "\\\\\\\"").replaceAll("\n", "");
    }

    void doLessCommand() {
        this.doCommand(this.onLessCommand);
    }

    void doMoreCommand() {
        this.doCommand(this.onMoreCommand);
    }

    void doPauseCommand() {
        this.doCommand(this.onPauseCommand);
    }

    void doResumeCommand() {
        this.doCommand(this.onResumeCommand);
    }
}

