/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer;

import com.signiant.interactivetransfer.Application;
import com.signiant.interactivetransfer.JSWrapper;
import com.signiant.interactivetransfer.TransferApplet;
import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.StatusEvent;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferListener;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.exceptions.TransferWarning;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class StatusPanel
implements TransferListener {
    private static final long serialVersionUID = 0L;
    private Container content;
    private TransferEngine engine;
    private TransferApplet applet;
    private JDialog dialog;
    private Thread exceptionHandlerThread;
    private LinkedBlockingQueue<Throwable> exceptionHandlerQueue;
    private Timer uiUpdaterThread;
    private SpringLayout layout;
    private JProgressBar progress;
    private JLabel lNumFiles;
    private JLabel lProcessedFiles;
    private JLabel lToTransfer;
    private JLabel lTransferred;
    private JLabel lTransferRate;
    private JLabel lRateLimit;
    private JLabel lElapsedTime;
    private JLabel lCompletionTime;
    private JLabel lSourceIcon;
    private JLabel lTargetIcon;
    private JLabel[] lConnectionProgress;
    private Icon[] connectingIcons;
    private Icon[] waitIcons;
    private Icon successIcon;
    private Icon warningIcon;
    private Icon failureIcon;
    private Icon fileTransferIcon;
    private Icon serverWithFileIcon;
    private Icon serverWoutFileIcon;
    private Icon idleIcon;
    private static int progressSteps = 15;
    private boolean updateStatsUI;
    private int processIconHold = 2;
    private int iconNorthOffset = 8;
    private int sourceIconInset = 20;
    private int targetIconOffset = 50;
    private int processIconSize;
    private int sourceTargetIconSize;
    private int processNorthOffset;
    private int processIconInset;
    private int increment;
    private JButton bPauseResume = new JButton("Pause");
    private JButton bCancel = new JButton("Cancel");
    private JButton bDetails = new JButton("More >>>");
    private JLabel currentStatus;
    private boolean detailsVisible;
    private JTextArea detailContent;
    private JScrollPane scrollDetails;
    private JPanel fileProgress;
    private JScrollPane fileProgressScroll;
    private SpringLayout fileProgressLayout;
    private TreeMap<Integer, FileProgressMeter> fileProgressMeters;
    private AtomicBoolean fileProgressMetersChanged;
    private JSplitPane morePane;
    private boolean inBrowser;
    private Dimension detailsHiddenSize;
    private Dimension detailsShownSize;
    private Application app;
    private boolean finished;
    JLabel packetsSent;
    JLabel packetsReceived;
    JLabel packetsResent;
    JLabel packetsRejectedDuplicated;
    JLabel packetsRejectedLeft;
    JLabel packetsRejectedRight;
    JLabel sendWindowFilledCount;

    protected StatusPanel(TransferEngine engine, Container content) {
        this.content = content;
        this.engine = engine;
        this.finished = false;
        this.detailsVisible = false;
        this.fileProgressMeters = new TreeMap();
        this.fileProgressMetersChanged = new AtomicBoolean(false);
        engine.addTransferListener(this);
        this.exceptionHandlerQueue = new LinkedBlockingQueue();
    }

    public StatusPanel(JDialog dlg, TransferEngine engine) {
        this(engine, dlg.getContentPane());
        this.dialog = dlg;
        this.applet = null;
        this.dialog.setModal(true);
        this.dialog.setTitle("Transfer Progress");
        this.buildInterface();
    }

    public StatusPanel(TransferApplet aplt, TransferEngine engine) {
        this(engine, aplt.getContentPane());
        Object document;
        Object browser;
        this.dialog = null;
        this.applet = aplt;
        LookAndFeel lf = UIManager.getLookAndFeel();
        UIDefaults d = lf.getDefaults();
        Color bg = (Color)d.get("Label.background");
        Color fg = (Color)d.get("Label.foreground");
        this.inBrowser = JSWrapper.inBrowser(this.applet);
        String color = this.applet.getBgColor();
        if (color != null && color.length() > 0) {
            try {
                bg = Color.decode(color);
            }
            catch (NumberFormatException discard) {
                System.err.println("Invalid bgColor specification - " + color);
            }
        } else if (this.inBrowser) {
            browser = JSWrapper.getWindow(this.applet);
            document = JSWrapper.getMember(browser, "document");
            JSWrapper.setMember(document, "bgColor", "#" + Integer.toHexString(bg.getRGB()).substring(2));
        }
        this.applet.setBackground(bg);
        this.bPauseResume.setBackground(bg);
        this.bCancel.setBackground(bg);
        this.bDetails.setBackground(bg);
        this.content.setBackground(bg);
        color = this.applet.getFgColor();
        this.applet.showStatus("Set fg to " + color);
        if (color != null && color.length() > 0) {
            try {
                fg = Color.decode(color);
            }
            catch (NumberFormatException discard) {
                System.err.println("Invalid fgColor specification - " + color);
            }
        } else if (this.inBrowser) {
            browser = JSWrapper.getWindow(this.applet);
            document = JSWrapper.getMember(browser, "document");
            JSWrapper.setMember(document, "fgColor", "#" + Integer.toHexString(fg.getRGB()).substring(2));
        }
        this.applet.setForeground(fg);
        this.content.setForeground(fg);
        this.applet.showStatus("Set fg to " + color);
        this.buildInterface();
    }

    private Icon loadIconImage(String iconName) {
        String base = "com/signiant/interactivetransfer/resources/";
        base = base + iconName + ".png";
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(base);
            byte[] buffer = new byte[32768];
            is.read(buffer);
            return new ImageIcon(buffer);
        }
        catch (Exception e) {
            System.err.println("Resource load error: " + base);
            e.printStackTrace();
            return null;
        }
    }

    public void statusUpdate(final StatusEvent status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusPanel.this.addDetailMessage(status.getStatus());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionStatusChange(TransferListener.ConnectionStatus status) {
        if (this.applet != null) {
            this.applet.doConnectionCommand(status.toString(), this.engine.getSessionID());
        }
        if (status == TransferListener.ConnectionStatus.CONNECTING) {
            this.bPauseResume.setText("Pause");
            this.bPauseResume.setEnabled(false);
            TreeMap<Integer, FileProgressMeter> treeMap = this.fileProgressMeters;
            synchronized (treeMap) {
                this.fileProgressMeters.clear();
                this.fileProgressMetersChanged.set(true);
            }
        }
    }

    public void preTransfer() {
        this.bPauseResume.setText("Pause");
        this.bPauseResume.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fileHeader(FileTransfer ft) {
        TreeMap<Integer, FileProgressMeter> treeMap = this.fileProgressMeters;
        synchronized (treeMap) {
            this.fileProgressMeters.put(new Integer(ft.getSequence()), new FileProgressMeter(ft));
            this.fileProgressMetersChanged.set(true);
        }
    }

    public void preFile(final FileTransfer ft) {
        if (this.applet != null) {
            this.applet.doFileCommand(ft.getFileString(), ft.getSize(), ft.getState().toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusPanel.this.addDetailMessage("Starting: " + ft.getFileString());
            }
        });
    }

    public void filePosition(final FileTransfer ft, long position) {
        final long pos = position;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusPanel.this.addDetailMessage("Skipped ahead " + StatusPanel.this.prettyBytes(pos) + " of file " + ft.getFileString());
                FileProgressMeter meter = (FileProgressMeter)StatusPanel.this.fileProgressMeters.get(ft.getSequence());
                meter.setCurrentPosition(meter.getCurrentPosition() + pos);
                double ratio = 0.0;
                if (ft.getSize() > 0L) {
                    ratio = (double)meter.getCurrentPosition() / (double)ft.getSize();
                }
                int progressIndicator = (int)(ratio * 10000.0);
                meter.getProgress().getModel().setValue(progressIndicator);
                meter.getInfoline().setText(ft.getFileString() + " " + StatusPanel.this.prettyBytes(meter.getCurrentPosition()) + "/" + StatusPanel.this.prettyBytes(ft.getSize()));
            }
        });
    }

    public void fileProgress(final FileTransfer ft, final long amt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileProgressMeter meter = (FileProgressMeter)StatusPanel.this.fileProgressMeters.get(ft.getSequence());
                if (meter == null) {
                    return;
                }
                meter.setCurrentPosition(meter.getCurrentPosition() + amt);
                double ratio = 0.0;
                if (ft.getSize() > 0L) {
                    ratio = (double)meter.getCurrentPosition() / (double)ft.getSize();
                }
                int progressIndicator = (int)(ratio * 10000.0);
                meter.getProgress().getModel().setValue(progressIndicator);
                meter.getInfoline().setText(ft.getFileString() + " " + StatusPanel.this.prettyBytes(meter.getCurrentPosition()) + "/" + StatusPanel.this.prettyBytes(ft.getSize()));
            }
        });
    }

    public void skipFile(final FileTransfer ft) {
        if (this.applet != null) {
            this.applet.doFileCommand(ft.getFileString(), ft.getSize(), ft.getState().toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusPanel.this.addDetailMessage("Skipped: " + ft.getFileString());
                FileProgressMeter meter = (FileProgressMeter)StatusPanel.this.fileProgressMeters.get(ft.getSequence());
                meter.getInfoline().setText(ft.getFileString() + " already transferred");
                meter.getProgress().setValue(10000);
            }
        });
    }

    public void postFile(final FileTransfer ft) {
        if (this.applet != null) {
            this.applet.doFileCommand(ft.getFileString(), ft.getSize(), ft.getState().toString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusPanel.this.addDetailMessage("Finished: " + ft.getFileString());
                FileProgressMeter meter = (FileProgressMeter)StatusPanel.this.fileProgressMeters.get(ft.getSequence());
                meter.getProgress().setValue(10000);
                String completion = "";
                switch (ft.getState()) {
                    case PENDING: {
                        completion = "pending";
                        break;
                    }
                    case SKIPPED_EXISTS: {
                        completion = "already transferred";
                        break;
                    }
                    case SKIPPED_DENIED: {
                        completion = "denied by remote system";
                        break;
                    }
                    case TRANSFERRED: {
                        completion = "successfully transferred";
                        break;
                    }
                    case ERROR: {
                        completion = "error transferring file";
                    }
                }
                meter.getInfoline().setText(ft.getFileString() + " " + completion);
            }
        });
    }

    public void postTransfer(TransferListener.CompletionStatus status) {
        boolean resumeEnabled;
        String completion = "";
        switch (status) {
            case CANCELLED: {
                if (this.finished) {
                    completion = "stopped";
                    resumeEnabled = false;
                    break;
                }
                completion = "paused";
                resumeEnabled = true;
                break;
            }
            case SUCCESSFUL: {
                completion = "completed successfully";
                resumeEnabled = false;
                break;
            }
            case WARNING: {
                completion = "completed with warnings";
                resumeEnabled = false;
                break;
            }
            case FAILURE: {
                completion = "failed";
                resumeEnabled = false;
                break;
            }
            default: {
                resumeEnabled = false;
            }
        }
        if (this.applet != null) {
            this.applet.doCompleteCommand(status.toString());
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException discard) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (resumeEnabled) {
                    StatusPanel.this.bPauseResume.setText("Resume");
                    StatusPanel.this.bPauseResume.setEnabled(true);
                } else {
                    StatusPanel.this.bPauseResume.setEnabled(false);
                }
                StatusPanel.this.bCancel.setEnabled(false);
            }
        });
        this.addDetailMessage("Transfer " + completion);
    }

    private void exceptionHandler() {
        Window popupMessage = null;
        while (!this.finished) {
            try {
                String reason;
                Exception se;
                Throwable e;
                try {
                    e = this.exceptionHandlerQueue.take();
                }
                catch (Exception discard) {
                    break;
                }
                if (this.finished) {
                    return;
                }
                if (e instanceof TransferWarning) {
                    se = (TransferWarning)e;
                    reason = ((TransferWarning)se).getReason();
                    if (reason == null) {
                        reason = "An internal error occurred (at " + e.getStackTrace()[0] + ")";
                    }
                    this.addDetailMessage("Warning: " + reason);
                    continue;
                }
                if (e instanceof TransferException) {
                    se = (TransferException)e;
                    reason = ((TransferException)se).getReason();
                    String extended = "";
                    if (reason == null) {
                        reason = "An internal error occurred";
                        extended = "(at " + e.getStackTrace()[0] + ")";
                    }
                    this.addDetailMessage("Transfer failure: " + reason + " " + extended);
                    if (popupMessage != null && popupMessage.isShowing()) continue;
                    JOptionPane pane = new JOptionPane(reason, 0);
                    popupMessage = pane.createDialog(this.applet == null ? this.dialog : this.applet, "Transfer failure");
                    ((Dialog)popupMessage).setModal(false);
                    ((Dialog)popupMessage).setVisible(true);
                    continue;
                }
                if (e instanceof IOException) {
                    String genericMessage = "Error communicating with remote system";
                    this.addDetailMessage("Network error: " + genericMessage);
                    if (e.getMessage() != null) {
                        this.addDetailMessage(e.getMessage());
                    } else {
                        this.addDetailMessage(e.toString());
                    }
                    if (popupMessage != null && popupMessage.isShowing()) continue;
                    JOptionPane pane = new JOptionPane(genericMessage, 0);
                    popupMessage = pane.createDialog(this.applet == null ? this.dialog : this.applet, "Network Error");
                    ((Dialog)popupMessage).setModal(false);
                    ((Dialog)popupMessage).setVisible(true);
                    continue;
                }
                String where = "";
                if (e.getStackTrace().length > 0) {
                    where = "(at " + e.getStackTrace()[0] + ")";
                }
                this.addDetailMessage("An internal error occurred: " + e + " " + where);
                if (popupMessage != null && popupMessage.isShowing()) continue;
                reason = e.getMessage();
                if (reason == null) {
                    reason = "An internal error occurred:\n" + e + " " + where;
                }
                JOptionPane pane = new JOptionPane(reason, 0);
                popupMessage = pane.createDialog(this.applet == null ? this.dialog : this.applet, "Internal Error");
                ((Dialog)popupMessage).setModal(false);
                ((Dialog)popupMessage).setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void exception(Exception e) {
        this.exceptionHandlerQueue.offer(e);
    }

    public boolean doSettingsDialog() {
        this.app = new Application(this.applet, this.engine);
        boolean closed = this.app.isClosed();
        this.app = null;
        return closed;
    }

    private void buildInterface() {
        Dimension d;
        String label;
        String base;
        int i;
        int max = 12;
        this.connectingIcons = new Icon[max];
        for (i = 1; i <= max; ++i) {
            base = "conn";
            if (i < 10) {
                base = base + "0";
            }
            base = base + i;
            this.connectingIcons[i - 1] = this.loadIconImage(base);
        }
        this.waitIcons = new Icon[max];
        for (i = 1; i <= max; ++i) {
            base = "wait";
            if (i < 10) {
                base = base + "0";
            }
            base = base + i;
            this.waitIcons[i - 1] = this.loadIconImage(base);
        }
        this.successIcon = this.loadIconImage("success");
        this.warningIcon = this.loadIconImage("warning");
        this.failureIcon = this.loadIconImage("failure");
        this.fileTransferIcon = this.loadIconImage("file-transfer");
        this.serverWithFileIcon = this.loadIconImage("server-with-file");
        this.serverWoutFileIcon = this.loadIconImage("server-without-file");
        this.processIconSize = this.fileTransferIcon.getIconWidth();
        this.sourceTargetIconSize = this.serverWithFileIcon.getIconWidth();
        this.processNorthOffset = (this.sourceTargetIconSize - this.processIconSize) / 2;
        this.processIconInset = this.sourceTargetIconSize / 4;
        this.increment = (this.targetIconOffset - this.sourceIconInset + this.sourceTargetIconSize + this.sourceTargetIconSize / 4) / (progressSteps - 1);
        this.layout = new SpringLayout();
        this.content.setLayout(this.layout);
        this.progress = new JProgressBar();
        this.progress.getModel().setMaximum(10000);
        this.content.add(this.progress);
        this.layout.getConstraints(this.content).setWidth(Spring.constant(500));
        this.layout.putConstraint("North", (Component)this.progress, 20, "North", (Component)this.content);
        this.layout.putConstraint("East", (Component)this.progress, -20, "East", (Component)this.content);
        this.layout.putConstraint("West", (Component)this.progress, 20, "West", (Component)this.content);
        JLabel dNumFiles = new JLabel("Number of Files:");
        this.content.add(dNumFiles);
        this.layout.putConstraint("North", (Component)dNumFiles, 10, "South", (Component)this.progress);
        this.layout.putConstraint("West", (Component)dNumFiles, 20, "West", (Component)this.content);
        JLabel dProcessedFiles = new JLabel("Files Processed:");
        this.content.add(dProcessedFiles);
        this.layout.putConstraint("North", (Component)dProcessedFiles, 3, "South", (Component)dNumFiles);
        this.layout.putConstraint("West", (Component)dProcessedFiles, 20, "West", (Component)this.content);
        this.lToTransfer = new JLabel("N/A");
        this.content.add(this.lToTransfer);
        this.layout.putConstraint("North", (Component)this.lToTransfer, 10, "South", (Component)this.progress);
        this.layout.putConstraint("East", (Component)this.lToTransfer, 0, "East", (Component)this.progress);
        this.lTransferred = new JLabel("N/A");
        this.content.add(this.lTransferred);
        this.layout.putConstraint("North", (Component)this.lTransferred, 3, "South", (Component)this.lToTransfer);
        this.layout.putConstraint("East", (Component)this.lTransferred, 0, "East", (Component)this.progress);
        this.lTransferRate = new JLabel("N/A");
        this.content.add(this.lTransferRate);
        this.layout.putConstraint("North", (Component)this.lTransferRate, 3, "South", (Component)this.lTransferred);
        this.layout.putConstraint("East", (Component)this.lTransferRate, 0, "East", (Component)this.progress);
        this.lRateLimit = new JLabel("N/A");
        this.content.add(this.lRateLimit);
        this.layout.putConstraint("North", (Component)this.lRateLimit, 3, "South", (Component)this.lTransferRate);
        this.layout.putConstraint("East", (Component)this.lRateLimit, 0, "East", (Component)this.progress);
        this.lElapsedTime = new JLabel("N/A");
        this.content.add(this.lElapsedTime);
        this.layout.putConstraint("North", (Component)this.lElapsedTime, 3, "South", (Component)this.lRateLimit);
        this.layout.putConstraint("East", (Component)this.lElapsedTime, 0, "East", (Component)this.progress);
        this.lCompletionTime = new JLabel("N/A");
        this.content.add(this.lCompletionTime);
        this.layout.putConstraint("North", (Component)this.lCompletionTime, 3, "South", (Component)this.lElapsedTime);
        this.layout.putConstraint("East", (Component)this.lCompletionTime, 0, "East", (Component)this.progress);
        if (this.applet == null) {
            JLabel status = new JLabel("Current Status:");
            this.layout.putConstraint("North", (Component)status, 10, "South", (Component)this.lElapsedTime);
            this.layout.putConstraint("West", (Component)status, 20, "West", (Component)this.content);
            this.content.add(status);
            this.currentStatus = new JLabel("Idle");
            this.currentStatus.setForeground(Color.BLUE);
            this.content.add(this.currentStatus);
            this.layout.putConstraint("North", (Component)this.currentStatus, 2, "South", (Component)status);
            this.layout.putConstraint("West", (Component)this.currentStatus, 20, "West", (Component)this.content);
        }
        this.bCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.cancel();
            }
        });
        if (this.applet != null && (label = this.applet.getCancelLabel()) != null && label.length() > 0) {
            this.bCancel.setText(label);
        }
        this.content.add(this.bCancel);
        this.layout.putConstraint("North", (Component)this.bCancel, 12, "South", (Component)this.lCompletionTime);
        this.layout.putConstraint("East", (Component)this.bCancel, -20, "East", (Component)this.content);
        this.bPauseResume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.pauseResume();
            }
        });
        this.content.add(this.bPauseResume);
        this.bPauseResume.setEnabled(false);
        this.layout.putConstraint("North", (Component)this.bPauseResume, 0, "North", (Component)this.bCancel);
        this.layout.putConstraint("East", (Component)this.bPauseResume, -20, "West", (Component)this.bCancel);
        this.bDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.toggleDetails();
            }
        });
        this.content.add(this.bDetails);
        this.layout.putConstraint("North", (Component)this.bDetails, 0, "North", (Component)this.bPauseResume);
        this.layout.putConstraint("East", (Component)this.bDetails, -20, "West", (Component)this.bPauseResume);
        this.detailContent = new JTextArea();
        this.detailContent.setRows(10);
        this.detailContent.setAutoscrolls(true);
        this.detailContent.setEditable(false);
        this.scrollDetails = new JScrollPane(this.detailContent);
        this.scrollDetails.setVerticalScrollBarPolicy(22);
        this.fileProgress = new JPanel();
        this.fileProgressLayout = new SpringLayout();
        this.fileProgress.setLayout(this.fileProgressLayout);
        this.fileProgressScroll = new JScrollPane(this.fileProgress);
        this.fileProgressScroll.setVerticalScrollBarPolicy(22);
        this.fileProgressScroll.getVerticalScrollBar().setUnitIncrement(10);
        this.fileProgressScroll.setMinimumSize(new Dimension(200, 60));
        this.scrollDetails.setMinimumSize(new Dimension(200, 40));
        this.morePane = new JSplitPane(0, true, this.fileProgressScroll, this.scrollDetails);
        this.content.add(this.morePane);
        this.layout.putConstraint("North", (Component)this.morePane, 10, "South", (Component)this.bDetails);
        this.layout.putConstraint("East", (Component)this.morePane, -10, "East", (Component)this.content);
        this.layout.putConstraint("West", (Component)this.morePane, 10, "West", (Component)this.content);
        this.layout.putConstraint("South", (Component)this.content, 10, "South", (Component)this.morePane);
        this.lSourceIcon = new JLabel("", this.serverWithFileIcon, 2);
        this.content.add(this.lSourceIcon);
        this.layout.putConstraint("North", (Component)this.lSourceIcon, this.iconNorthOffset, "South", (Component)dProcessedFiles);
        this.layout.putConstraint("West", (Component)this.lSourceIcon, this.sourceIconInset, "West", (Component)this.content);
        int i2 = 0;
        this.lConnectionProgress = new JLabel[progressSteps];
        for (i2 = 0; i2 < progressSteps; ++i2) {
            this.lConnectionProgress[i2] = new JLabel("");
            this.content.add(this.lConnectionProgress[i2]);
            this.layout.putConstraint("North", (Component)this.lConnectionProgress[i2], this.processNorthOffset, "North", (Component)this.lSourceIcon);
            this.layout.putConstraint("West", (Component)this.lConnectionProgress[i2], this.increment * (i2 < progressSteps - this.processIconHold ? i2 : progressSteps - this.processIconHold) + this.processIconInset, "West", (Component)this.lSourceIcon);
        }
        this.lTargetIcon = new JLabel("", this.serverWoutFileIcon, 2);
        this.content.add(this.lTargetIcon);
        this.layout.putConstraint("North", (Component)this.lTargetIcon, 0, "North", (Component)this.lSourceIcon);
        this.layout.putConstraint("West", (Component)this.lTargetIcon, this.targetIconOffset, "East", (Component)this.lSourceIcon);
        this.lNumFiles = new JLabel();
        this.content.add(this.lNumFiles);
        this.layout.putConstraint("North", (Component)this.lNumFiles, 0, "North", (Component)dNumFiles);
        this.layout.putConstraint("East", (Component)this.lNumFiles, 0, "East", (Component)this.lTargetIcon);
        this.lProcessedFiles = new JLabel();
        this.content.add(this.lProcessedFiles);
        this.layout.putConstraint("North", (Component)this.lProcessedFiles, 0, "North", (Component)dProcessedFiles);
        this.layout.putConstraint("East", (Component)this.lProcessedFiles, 0, "East", (Component)this.lTargetIcon);
        JLabel dToTransfer = new JLabel("Bytes to Transfer:");
        this.content.add(dToTransfer);
        this.layout.putConstraint("North", (Component)dToTransfer, 0, "North", (Component)this.lToTransfer);
        this.layout.putConstraint("East", (Component)dToTransfer, -8, "East", (Component)this.bPauseResume);
        JLabel dTransferred = new JLabel("Bytes Transferred:");
        this.content.add(dTransferred);
        this.layout.putConstraint("North", (Component)dTransferred, 0, "North", (Component)this.lTransferred);
        this.layout.putConstraint("East", (Component)dTransferred, -8, "East", (Component)this.bPauseResume);
        JLabel dTransferRate = new JLabel("Transfer Rate:");
        this.content.add(dTransferRate);
        this.layout.putConstraint("North", (Component)dTransferRate, 0, "North", (Component)this.lTransferRate);
        this.layout.putConstraint("East", (Component)dTransferRate, -8, "East", (Component)this.bPauseResume);
        JLabel dRateLimit = new JLabel("Transfer Rate Limit:");
        this.content.add(dRateLimit);
        this.layout.putConstraint("North", (Component)dRateLimit, 0, "North", (Component)this.lRateLimit);
        this.layout.putConstraint("East", (Component)dRateLimit, -8, "East", (Component)this.bPauseResume);
        JLabel dElapsedTime = new JLabel("Elapsed Time:");
        this.content.add(dElapsedTime);
        this.layout.putConstraint("North", (Component)dElapsedTime, 0, "North", (Component)this.lElapsedTime);
        this.layout.putConstraint("East", (Component)dElapsedTime, -8, "East", (Component)this.bPauseResume);
        JLabel dCompletionTime = new JLabel("Finished in:");
        this.content.add(dCompletionTime);
        this.layout.putConstraint("North", (Component)dCompletionTime, 0, "North", (Component)this.lCompletionTime);
        this.layout.putConstraint("East", (Component)dCompletionTime, -8, "East", (Component)this.bPauseResume);
        if (this.dialog != null) {
            this.dialog.pack();
            this.detailsShownSize = this.dialog.getSize();
        }
        if (this.applet != null) {
            this.applet.validate();
            d = this.applet.getPreferredSize();
            this.applet.resize(d);
            this.detailsShownSize = this.applet.getSize();
        }
        this.morePane.setVisible(false);
        this.layout.putConstraint("South", (Component)this.content, 10, "South", (Component)this.bDetails);
        if (this.dialog != null) {
            this.dialog.pack();
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = env.getDefaultScreenDevice();
            GraphicsConfiguration cfg = gs.getDefaultConfiguration();
            Rectangle rect = cfg.getBounds();
            this.dialog.setLocation((rect.width - this.dialog.getWidth()) / 2, (rect.height - this.dialog.getHeight()) / 2);
        }
        if (this.applet != null) {
            this.applet.validate();
            d = this.applet.getPreferredSize();
            this.applet.resize(d);
            this.detailsHiddenSize = this.applet.getSize();
            if (this.inBrowser) {
                this.detailsShownSize = new Dimension();
                this.detailsShownSize.setSize(this.applet.getSize().getWidth(), this.applet.getSize().getHeight() + 160.0);
            }
            for (Component c : this.content.getComponents()) {
                c.setForeground(this.content.getForeground());
            }
        }
        this.exceptionHandlerThread = new Thread("Exception Handler"){

            public void run() {
                StatusPanel.this.exceptionHandler();
            }
        };
        this.exceptionHandlerThread.setDaemon(true);
        this.exceptionHandlerThread.start();
        this.uiUpdaterThread = new Timer(40, new UIUpdater());
        this.uiUpdaterThread.setCoalesce(true);
        this.uiUpdaterThread.start();
    }

    private synchronized void toggleDetails() {
        this.detailsVisible = !this.detailsVisible;
        this.morePane.setVisible(this.detailsVisible);
        Dimension newSize = this.getCurrentSize();
        if (this.detailsVisible) {
            this.layout.putConstraint("South", (Component)this.content, 10, "South", (Component)this.morePane);
            this.bDetails.setText("<<< Less");
            this.detailsHiddenSize = new Dimension(newSize);
            double y_diff = this.detailsShownSize.getHeight() - newSize.getHeight();
            newSize.setSize(newSize.getWidth(), newSize.getHeight() + y_diff);
        } else {
            this.layout.putConstraint("South", (Component)this.content, 10, "South", (Component)this.bDetails);
            this.bDetails.setText("More >>>");
            this.detailsShownSize = new Dimension(newSize);
            double y_diff = newSize.getHeight() - this.detailsHiddenSize.getHeight();
            newSize.setSize(newSize.getWidth(), newSize.getHeight() - y_diff);
        }
        if (!this.inBrowser) {
            if (this.applet != null) {
                this.applet.resize(newSize);
            } else {
                this.dialog.setSize(newSize);
            }
        }
        if (this.applet != null) {
            if (this.detailsVisible) {
                this.applet.doMoreCommand();
            } else {
                this.applet.doLessCommand();
            }
        }
    }

    private Dimension getCurrentSize() {
        if (this.applet != null) {
            return this.applet.getSize();
        }
        return this.dialog.getSize();
    }

    private void addDetailMessage(String msg) {
        if (this.applet != null) {
            this.applet.doInfoCommand(msg);
        } else {
            this.currentStatus.setText(msg);
        }
        this.detailContent.append(new Date() + ": " + msg + "\n");
    }

    public synchronized void cancel() {
        this.bCancel.setEnabled(false);
        this.bPauseResume.setEnabled(false);
        if (!this.finished) {
            this.finished = true;
            this.engine.cancelTransfer();
        }
        if (this.app != null) {
            this.app.close();
        }
        if (this.applet != null) {
            this.applet.doCancelCommand();
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void pauseResume() {
        if (this.bPauseResume.getText().equals("Pause")) {
            if (this.applet != null) {
                this.applet.doPauseCommand();
            }
            this.bPauseResume.setEnabled(false);
            this.engine.cancelTransfer();
        } else {
            if (this.applet != null) {
                this.applet.doResumeCommand();
            }
            this.bPauseResume.setEnabled(false);
            this.bCancel.setEnabled(true);
            try {
                this.engine.restartTransfer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String prettyBytes(long bytes) {
        float amt;
        int scale = 0;
        String[] measure = new String[]{"Bytes", "KBytes", "MBytes", "GBytes", "TBytes"};
        for (amt = (float)bytes; amt > 1024.0f; amt /= 1024.0f) {
            ++scale;
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        if (scale == 0) {
            return f.format("%.0f %s", Float.valueOf(amt), measure[scale]).toString();
        }
        return f.format("%.2f %s", Float.valueOf(amt), measure[scale]).toString();
    }

    private static String prettyRates(long bytes) {
        float amt;
        int scale = 0;
        String[] measure = new String[]{"Bytes/s", "KBytes/s", "MBytes/s", "GBytes/s", "TBytes/s"};
        for (amt = (float)bytes; amt > 1024.0f; amt /= 1024.0f) {
            ++scale;
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        if (scale == 0) {
            return f.format("%.0f %s", Float.valueOf(amt), measure[scale]).toString();
        }
        return f.format("%.2f %s", Float.valueOf(amt), measure[scale]).toString();
    }

    private static String prettyTime(long timeInSeconds) {
        long seconds = timeInSeconds % 60L;
        long minutes = timeInSeconds % 3600L / 60L;
        long hours = timeInSeconds % 86400L / 3600L;
        long days = timeInSeconds / 86400L;
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        if (days > 0L) {
            return f.format("%dd %02d:%02d:%02d", days, hours, minutes, seconds).toString();
        }
        if (hours > 0L) {
            return f.format("%02d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return f.format("%02d:%02d", minutes, seconds).toString();
    }

    static /* synthetic */ Icon access$800(StatusPanel x0) {
        return x0.idleIcon;
    }

    private class UIUpdater
    implements ActionListener {
        int connectingPosition = 0;
        Icon connectionIcon = StatusPanel.access$800(StatusPanel.this);
        TransferListener.ConnectionStatus lastStatus = null;
        int updateStatsInterval = 10;
        int updateStatsCounter = 0;
        private int currentProgress = 0;
        private int lastPos;
        private Icon currentIcon;

        UIUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            this.lastPos = this.currentProgress++;
            TransferListener.ConnectionStatus currentStatus = StatusPanel.this.engine.getConnectionStatus();
            block3 : switch (currentStatus) {
                case CONNECTING: {
                    this.currentProgress = progressSteps / 2 + 1;
                    ++this.connectingPosition;
                    if (this.connectingPosition >= StatusPanel.this.connectingIcons.length) {
                        this.connectingPosition = 0;
                    }
                    this.connectionIcon = StatusPanel.this.connectingIcons[this.connectingPosition];
                    break;
                }
                case AWAITING_DATA_STREAMS: {
                    this.currentProgress = progressSteps / 2 + 1;
                    ++this.connectingPosition;
                    if (this.connectingPosition >= StatusPanel.this.connectingIcons.length) {
                        this.connectingPosition = 0;
                    }
                    this.connectionIcon = StatusPanel.this.waitIcons[this.connectingPosition];
                    break;
                }
                case CONNECTED: {
                    this.connectionIcon = StatusPanel.this.fileTransferIcon;
                    if (this.lastStatus != TransferListener.ConnectionStatus.CONNECTING) break;
                    this.currentProgress = 0;
                    break;
                }
                case DISCONNECTED: {
                    this.currentProgress = progressSteps / 2 + 1;
                    if (StatusPanel.this.engine.getFilesTransferred() > 0L) {
                        StatusPanel.this.lSourceIcon.setIcon(StatusPanel.this.serverWoutFileIcon);
                        StatusPanel.this.lTargetIcon.setIcon(StatusPanel.this.serverWithFileIcon);
                    } else {
                        StatusPanel.this.lSourceIcon.setIcon(StatusPanel.this.serverWithFileIcon);
                        StatusPanel.this.lTargetIcon.setIcon(StatusPanel.this.serverWoutFileIcon);
                    }
                    switch (StatusPanel.this.engine.getCompletionStatus()) {
                        case CANCELLED: {
                            this.connectionIcon = null;
                            break block3;
                        }
                        case SUCCESSFUL: {
                            this.connectionIcon = StatusPanel.this.successIcon;
                            break block3;
                        }
                        case WARNING: {
                            this.connectionIcon = StatusPanel.this.warningIcon;
                            break block3;
                        }
                        case FAILURE: {
                            this.connectionIcon = StatusPanel.this.failureIcon;
                            break block3;
                        }
                    }
                    this.connectionIcon = null;
                    break;
                }
            }
            this.lastStatus = currentStatus;
            this.currentIcon = this.connectionIcon;
            if (this.currentProgress >= progressSteps) {
                this.currentProgress = 0;
            }
            StatusPanel.this.updateStatsUI = this.updateStatsCounter == 0;
            ++this.updateStatsCounter;
            if (this.updateStatsCounter >= this.updateStatsInterval) {
                this.updateStatsCounter = 0;
            }
            try {
                StatusPanel.this.lConnectionProgress[this.lastPos].setIcon(null);
                StatusPanel.this.lConnectionProgress[this.currentProgress].setIcon(this.currentIcon);
            }
            catch (Exception e) {
                // empty catch block
            }
            long bytesSkipped = StatusPanel.this.engine.getBytesSkipped();
            long bytesTransferred = StatusPanel.this.engine.getBytesTransferred();
            long filesSkipped = StatusPanel.this.engine.getFilesSkipped();
            long filesTransferred = StatusPanel.this.engine.getFilesTransferred();
            long totalFiles = StatusPanel.this.engine.getTotalFilesToTransfer();
            long totalBytes = StatusPanel.this.engine.getTotalBytesToTransfer();
            double ratio = 0.0;
            if (totalBytes != 0L) {
                ratio = (double)(bytesTransferred + bytesSkipped) / (double)totalBytes;
            }
            int progressIndicator = (int)(ratio * 10000.0);
            long elapsedTime = StatusPanel.this.engine.getElapsedTime();
            StatusPanel.this.progress.getModel().setValue(progressIndicator);
            StatusPanel.this.lNumFiles.setText(Long.toString(totalFiles));
            StatusPanel.this.lProcessedFiles.setText(Long.toString(filesTransferred + filesSkipped));
            StatusPanel.this.lToTransfer.setText(StatusPanel.this.prettyBytes(totalBytes));
            StatusPanel.this.lTransferred.setText(StatusPanel.this.prettyBytes(bytesTransferred + bytesSkipped));
            if (totalBytes == 0L) {
                StatusPanel.this.lCompletionTime.setText("N/A");
                StatusPanel.this.lTransferRate.setText("N/A");
                StatusPanel.this.lElapsedTime.setText(StatusPanel.prettyTime(elapsedTime / 1000L));
                return;
            }
            if (totalBytes <= bytesSkipped + bytesTransferred || currentStatus == TransferListener.ConnectionStatus.DISCONNECTED) {
                StatusPanel.this.lTransferRate.setText(StatusPanel.prettyRates(StatusPanel.this.engine.getTransferRate()));
                StatusPanel.this.lCompletionTime.setText(StatusPanel.prettyTime(0L));
                return;
            }
            if (StatusPanel.this.fileProgressMetersChanged.getAndSet(false)) {
                FileProgressMeter prior = null;
                TreeMap treeMap = StatusPanel.this.fileProgressMeters;
                synchronized (treeMap) {
                    int max = 30;
                    StatusPanel.this.fileProgress.removeAll();
                    StatusPanel.this.fileProgress.validate();
                    for (Map.Entry f : StatusPanel.this.fileProgressMeters.entrySet()) {
                        if (--max == 0) break;
                        FileProgressMeter meter = (FileProgressMeter)f.getValue();
                        StatusPanel.this.fileProgress.add(meter.getInfoline());
                        StatusPanel.this.fileProgress.add(meter.getProgress());
                        if (prior == null) {
                            StatusPanel.this.fileProgressLayout.putConstraint("North", (Component)meter.getProgress(), 15, "North", (Component)StatusPanel.this.fileProgress);
                        } else {
                            StatusPanel.this.fileProgressLayout.putConstraint("North", (Component)meter.getProgress(), 5, "South", (Component)prior.getInfoline());
                        }
                        StatusPanel.this.fileProgressLayout.putConstraint("East", (Component)meter.getProgress(), -25, "East", (Component)StatusPanel.this.fileProgress);
                        StatusPanel.this.fileProgressLayout.putConstraint("West", (Component)meter.getProgress(), 25, "West", (Component)StatusPanel.this.fileProgress);
                        StatusPanel.this.fileProgressLayout.putConstraint("North", (Component)meter.getInfoline(), 1, "South", (Component)meter.getProgress());
                        StatusPanel.this.fileProgressLayout.putConstraint("East", (Component)meter.getInfoline(), -25, "East", (Component)StatusPanel.this.fileProgress);
                        StatusPanel.this.fileProgressLayout.putConstraint("West", (Component)meter.getInfoline(), 25, "West", (Component)StatusPanel.this.fileProgress);
                        prior = meter;
                    }
                }
                if (prior != null) {
                    StatusPanel.this.fileProgressLayout.putConstraint("South", (Component)StatusPanel.this.fileProgress, 5, "South", (Component)prior.getInfoline());
                }
                StatusPanel.this.fileProgress.validate();
            }
            if (!StatusPanel.this.updateStatsUI) {
                return;
            }
            long limit = StatusPanel.this.engine.getBandwidthThrottle();
            if (limit > 0L) {
                StatusPanel.this.lRateLimit.setText(StatusPanel.prettyRates(limit));
            } else {
                StatusPanel.this.lRateLimit.setText("Unlimited");
            }
            StatusPanel.this.lElapsedTime.setText(StatusPanel.prettyTime(elapsedTime / 1000L));
            long transferRate = 0L;
            if (elapsedTime > 0L) {
                transferRate = StatusPanel.this.engine.getTransferRate();
                StatusPanel.this.lTransferRate.setText(StatusPanel.prettyRates(transferRate));
                if (transferRate > 0L) {
                    long completionTime = (totalBytes - bytesTransferred - bytesSkipped) / transferRate;
                    StatusPanel.this.lCompletionTime.setText(StatusPanel.prettyTime(completionTime));
                } else {
                    StatusPanel.this.lCompletionTime.setText(StatusPanel.prettyTime(0L));
                }
            } else {
                StatusPanel.this.lTransferRate.setText("N/A");
                StatusPanel.this.lCompletionTime.setText("N/A");
            }
        }
    }

    private class FileProgressMeter {
        private JProgressBar progress;
        private JLabel infoline;
        private FileTransfer ft;
        private long currentPosition;

        public FileProgressMeter(FileTransfer ft) {
            this.ft = ft;
            this.progress = new JProgressBar();
            this.infoline = new JLabel(ft.getFileString() + " " + StatusPanel.this.prettyBytes(ft.getSize()));
            this.progress.getModel().setMaximum(10000);
        }

        public FileTransfer getFt() {
            return this.ft;
        }

        public JLabel getInfoline() {
            return this.infoline;
        }

        public JProgressBar getProgress() {
            return this.progress;
        }

        public long getCurrentPosition() {
            return this.currentPosition;
        }

        public void setCurrentPosition(long currentPosition) {
            this.currentPosition = currentPosition;
        }
    }
}

