/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer;

import com.signiant.interactivetransfer.StatusPanel;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferMode;
import com.signiant.interactivetransfer.engine.Transport;
import com.signiant.interactivetransfer.engine.exceptions.ConfigurationException;
import com.signiant.mobilize.ddsclient.connection.Port;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static final String[] logMenu = new String[]{"None", "Info", "Fine", "Finer", "Finest"};
    private boolean standalone;
    private Component root;
    private JFrame app;
    private JDialog dlg;
    private JToolBar toolbar;
    private JTabbedPane tabs;
    private JRadioButton send;
    private JRadioButton receive;
    private ProtectedTextField agent;
    private DroppableTextArea urlList;
    private ProtectedTextField user;
    private JPasswordField password;
    private DroppableTextArea files;
    private JButton browseFiles;
    private ProtectedTextField destination;
    private JButton browseDestination;
    private ProtectedTextArea certificate;
    private ProtectedNumberField retries;
    private ProtectedNumberField restarts;
    private JComboBox encrypt;
    private JSlider aggressiveness;
    private JComboBox transport;
    private JComboBox streams;
    private Throttle targetRate;
    private Throttle minRate;
    private Throttle bandwidthThrottle;
    private JComboBox logging;
    private ProtectedTextField traceFlags;
    private ProtectedTextField jobGroup;
    private ProtectedTextField jobName;
    private JButton transfer;
    private Object closedEvent;
    private boolean closed;
    private TransferEngine engine;
    private Map<JComponent, String> propertyMap;
    private Map<JComponent, String> transferPropertyMap;
    private Map<JComponent, String> certificatePropertyMap;
    private Map<JComponent, String> optionsPropertyMap;
    private Map<JComponent, String> loggingPropertyMap;
    private Map<JComponent, String> headerPropertyMap;

    public Application() {
        this.standalone = true;
        this.engine = new TransferEngine();
        this.transferPropertyMap = new HashMap<JComponent, String>();
        this.certificatePropertyMap = new HashMap<JComponent, String>();
        this.optionsPropertyMap = new HashMap<JComponent, String>();
        this.loggingPropertyMap = new HashMap<JComponent, String>();
        this.headerPropertyMap = new HashMap<JComponent, String>();
        this.propertyMap = new HashMap<JComponent, String>();
        this.closedEvent = new Object();
        this.closed = false;
        if (SwingUtilities.isEventDispatchThread()) {
            this.createApplicationWindow();
            this.resetFields();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Application.this.createApplicationWindow();
                        Application.this.resetFields();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Application(Container awtUIContainer, TransferEngine engine) {
        this.standalone = false;
        this.engine = engine;
        this.transferPropertyMap = new HashMap<JComponent, String>();
        this.certificatePropertyMap = new HashMap<JComponent, String>();
        this.optionsPropertyMap = new HashMap<JComponent, String>();
        this.propertyMap = new HashMap<JComponent, String>();
        this.loggingPropertyMap = new HashMap<JComponent, String>();
        this.headerPropertyMap = new HashMap<JComponent, String>();
        this.closedEvent = new Object();
        this.closed = false;
        final Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, awtUIContainer);
        if (SwingUtilities.isEventDispatchThread()) {
            this.createDialogWindow(frame);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Application.this.createDialogWindow(frame);
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String[] getFilesArea() {
        String value = this.files.getProtectedValue();
        BufferedReader rdr = new BufferedReader(new StringReader(value));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = rdr.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    lines.add(line);
                }
                line = rdr.readLine();
            }
        }
        catch (IOException ie) {
            // empty catch block
        }
        return lines.toArray(new String[0]);
    }

    private void setFilesArea(String[] values) {
        StringBuilder str = new StringBuilder();
        for (String f : values) {
            if (str.length() > 0) {
                str.append("\n");
            }
            str.append(f);
        }
        this.files.setText(str.toString());
        this.files.disableProtected();
    }

    private void resetFields() {
        TransferMode mode = this.engine.getMode();
        switch (mode) {
            case SEND: {
                this.send.setSelected(true);
                this.browseFiles.setEnabled(true);
                this.browseDestination.setEnabled(false);
                break;
            }
            case RECEIVE: {
                this.receive.setSelected(true);
                this.browseFiles.setEnabled(false);
                this.browseDestination.setEnabled(true);
            }
        }
        Transport engineTransport = this.engine.getTransport();
        switch (engineTransport) {
            case TCP: {
                this.transport.setSelectedIndex(2);
                break;
            }
            case UDP: {
                this.transport.setSelectedIndex(0);
                break;
            }
            case UDP_THEN_TCP: {
                this.transport.setSelectedIndex(1);
            }
        }
        this.encrypt.setSelectedItem((Object)this.engine.getEncryption());
        this.agent.setText(this.engine.getAgentList());
        this.urlList.setText(this.engine.getUrlList());
        this.user.setText(this.engine.getUser());
        if (this.engine.getPassword() != null) {
            this.password.setText(String.copyValueOf(this.engine.getPassword()));
        }
        this.setFilesArea(this.engine.getFiles());
        this.destination.setText(this.engine.getDestination());
        this.certificate.setText(this.engine.getCertificate());
        this.retries.setText(Integer.toString(this.engine.getRetries()));
        this.restarts.setText(Integer.toString(this.engine.getRestarts()));
        this.targetRate.setValue(this.engine.getTargetRate());
        this.minRate.setValue(this.engine.getMinimumRate());
        this.bandwidthThrottle.setValue(this.engine.getBandwidthThrottle());
        this.aggressiveness.setValue(this.engine.getAggressiveness());
        this.streams.setSelectedIndex(Math.min(this.engine.getNumberOfStreams() - 1, 3));
        this.setLogging(this.engine.getLogging());
        this.traceFlags.setText(this.engine.getTrace());
        this.jobGroup.setText(this.engine.getJobGroup());
        this.jobName.setText(this.engine.getJobNamePrefix());
        this.applyShownProperties(this.engine.getShownProperties());
        this.applyEditableProperties(this.engine.getEditableProperties());
    }

    private void createToolBar(Container panel) {
        this.toolbar = new JToolBar("Agent Settings");
        this.toolbar.setFloatable(false);
        JButton bNew = new JButton("Reset");
        bNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Application.this.engine.newSettings();
                Application.this.resetFields();
            }
        });
        this.toolbar.add(bNew);
        JButton bSave = new JButton("Save ...");
        bSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Save transfer settings");
                if (fc.showSaveDialog(Application.this.root) != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                try {
                    Application.this.engine.saveSettings(file);
                }
                catch (IOException ie) {
                    JOptionPane.showMessageDialog(Application.this.app, "Cannot save settings to [ " + file.getName() + " ]\n\n" + ie.getMessage(), "Save Transfer Settings", 0);
                }
            }
        });
        this.toolbar.add(bSave);
        JButton bLoad = new JButton("Open ...");
        bLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Open transfer settings");
                if (fc.showOpenDialog(Application.this.root) != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                try {
                    Application.this.engine.loadSettings(file);
                    Application.this.resetFields();
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(Application.this.app, "Cannot open settings from [ " + file.getName() + " ]\n\n" + ie.getMessage(), "Open Transfer Settings", 0);
                }
            }
        });
        this.toolbar.add(bLoad);
        panel.add(this.toolbar);
        SpringLayout sl = (SpringLayout)panel.getLayout();
        sl.putConstraint("East", (Component)this.toolbar, 0, "East", (Component)panel);
    }

    private void createTransferPage(Container panel) {
        SpringLayout sl = (SpringLayout)panel.getLayout();
        this.send = new JRadioButton("Send");
        this.send.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                if (Application.this.send.isSelected()) {
                    Application.this.engine.setMode(TransferMode.SEND);
                    Application.this.browseFiles.setEnabled(Application.this.standalone || Application.this.isPropertyListed(Application.this.engine.getEditableProperties(), "com.signiant.interactivetransfer.engine.FILES"));
                    Application.this.browseDestination.setEnabled(false);
                }
            }
        });
        panel.add(this.send);
        this.transferPropertyMap.put(this.send, "com.signiant.interactivetransfer.engine.MODE");
        this.receive = new JRadioButton("Receive");
        this.receive.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                if (Application.this.receive.isSelected()) {
                    Application.this.engine.setMode(TransferMode.RECEIVE);
                    Application.this.browseFiles.setEnabled(false);
                    Application.this.browseDestination.setEnabled(Application.this.standalone || Application.this.isPropertyListed(Application.this.engine.getEditableProperties(), "com.signiant.interactivetransfer.engine.DESTINATION_DIR"));
                }
            }
        });
        panel.add(this.receive);
        this.transferPropertyMap.put(this.receive, "com.signiant.interactivetransfer.engine.MODE");
        ButtonGroup bgTransfer = new ButtonGroup();
        bgTransfer.add(this.send);
        bgTransfer.add(this.receive);
        JLabel lAgent = new JLabel("Remote Agent");
        this.transferPropertyMap.put(lAgent, "com.signiant.interactivetransfer.engine.AGENT_LIST");
        panel.add(lAgent);
        this.agent = new ProtectedTextField();
        this.agent.setColumns(40);
        this.agent.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setAgentList(Application.this.agent.getProtectedValue());
            }
        });
        lAgent.setLabelFor(this.agent);
        this.transferPropertyMap.put(this.agent, "com.signiant.interactivetransfer.engine.AGENT_LIST");
        panel.add(this.agent);
        JLabel lUrlList = new JLabel("Fallback URLs");
        this.transferPropertyMap.put(lAgent, "com.signiant.interactivetransfer.engine.URL_LIST");
        panel.add(lUrlList);
        this.urlList = new DroppableTextArea();
        this.urlList.setColumns(40);
        this.urlList.setRows(4);
        this.urlList.setAutoscrolls(true);
        this.urlList.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Application.this.engine.setUrlList(Application.this.urlList.getProtectedValue());
            }
        });
        JScrollPane scrollUrlList = new JScrollPane(this.urlList);
        lUrlList.setLabelFor(this.urlList);
        this.transferPropertyMap.put(this.urlList, "com.signiant.interactivetransfer.engine.URL_LIST");
        panel.add(scrollUrlList);
        JLabel lUser = new JLabel("User");
        this.transferPropertyMap.put(lUser, "com.signiant.interactivetransfer.engine.USER");
        panel.add(lUser);
        this.user = new ProtectedTextField();
        this.user.setColumns(25);
        this.user.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setUser(Application.this.user.getProtectedValue());
            }
        });
        lUser.setLabelFor(this.user);
        this.transferPropertyMap.put(this.user, "com.signiant.interactivetransfer.engine.USER");
        panel.add(this.user);
        JLabel lPassword = new JLabel("Password");
        this.transferPropertyMap.put(lPassword, "com.signiant.interactivetransfer.engine.PASSWORD");
        panel.add(lPassword);
        this.password = new JPasswordField();
        this.password.setColumns(15);
        this.password.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setPassword(Application.this.password.getPassword());
            }
        });
        lPassword.setLabelFor(this.password);
        this.transferPropertyMap.put(this.password, "com.signiant.interactivetransfer.engine.PASSWORD");
        panel.add(this.password);
        JLabel lFiles = new JLabel("File(s) to Transfer");
        this.transferPropertyMap.put(lFiles, "com.signiant.interactivetransfer.engine.FILES");
        panel.add(lFiles);
        this.files = new DroppableTextArea();
        this.files.setColumns(40);
        this.files.setRows(4);
        this.files.setAutoscrolls(true);
        this.files.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Application.this.engine.setFiles(Application.this.getFilesArea());
            }
        });
        JScrollPane scrollFiles = new JScrollPane(this.files);
        lFiles.setLabelFor(this.files);
        this.transferPropertyMap.put(this.files, "com.signiant.interactivetransfer.engine.FILES");
        panel.add(scrollFiles);
        this.browseFiles = new JButton("Browse ...");
        this.browseFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                boolean notset = true;
                while (notset) {
                    String[] fldValue = Application.this.engine.getFiles();
                    ArrayList<File> al = new ArrayList<File>();
                    for (String string : fldValue) {
                        File f = new File(string);
                        if (!f.exists()) continue;
                        al.add(f);
                    }
                    File[] fld = al.toArray(new File[0]);
                    JFileChooser fc = new JFileChooser();
                    fc.setDialogTitle("Transfer files");
                    fc.setMultiSelectionEnabled(true);
                    fc.setFileSelectionMode(2);
                    if (fld.length > 0) {
                        fc.setCurrentDirectory(fld[0].getParentFile());
                        fc.setSelectedFiles(fld);
                    }
                    if (fc.showOpenDialog(Application.this.root) != 0) {
                        return;
                    }
                    fld = fc.getSelectedFiles();
                    LinkedList<Object> value = new LinkedList<Object>();
                    for (File file : fld) {
                        value.add(file.getAbsolutePath());
                    }
                    if (!Application.this.files.isProtected()) {
                        for (String string : Application.this.engine.getFiles()) {
                            value.add(string);
                        }
                    }
                    try {
                        Application.this.engine.setFiles(value.toArray(new String[0]));
                    }
                    catch (IllegalArgumentException iae) {
                        JOptionPane pane = new JOptionPane(iae.getMessage(), 0);
                        JDialog popupMessage = pane.createDialog(Application.this.dlg, "Too many files selected");
                        popupMessage.setModal(true);
                        popupMessage.setVisible(true);
                        notset = true;
                        continue;
                    }
                    Application.this.setFilesArea(value.toArray(new String[0]));
                    notset = false;
                }
            }
        });
        this.transferPropertyMap.put(this.browseFiles, "com.signiant.interactivetransfer.engine.FILES");
        panel.add(this.browseFiles);
        JLabel lDestination = new JLabel("Destination Directory");
        this.transferPropertyMap.put(lDestination, "com.signiant.interactivetransfer.engine.DESTINATION_DIR");
        panel.add(lDestination);
        this.destination = new ProtectedTextField();
        this.destination.setColumns(40);
        this.destination.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setDestination(Application.this.destination.getProtectedValue());
            }
        });
        this.transferPropertyMap.put(this.destination, "com.signiant.interactivetransfer.engine.DESTINATION_DIR");
        panel.add(this.destination);
        lDestination.setLabelFor(this.destination);
        this.browseDestination = new JButton("Browse ...");
        this.browseDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Destination Directory");
                fc.setFileSelectionMode(1);
                String value = Application.this.engine.getDestination();
                File fld = null;
                if (value != null) {
                    fld = new File(value);
                }
                if (fld != null && fld.exists()) {
                    fc.setCurrentDirectory(fld.getParentFile());
                    fc.setSelectedFile(fld);
                }
                if (fc.showOpenDialog(Application.this.root) != 0) {
                    return;
                }
                fld = fc.getSelectedFile();
                value = fld.getAbsolutePath();
                Application.this.engine.setDestination(value);
                Application.this.destination.setText(value);
                Application.this.destination.disableProtected();
            }
        });
        this.transferPropertyMap.put(this.browseDestination, "com.signiant.interactivetransfer.engine.DESTINATION_DIR");
        panel.add(this.browseDestination);
        sl.putConstraint("West", (Component)lDestination, 8, "West", (Component)panel);
        sl.putConstraint("West", (Component)this.destination, 3, "East", (Component)lDestination);
        sl.putConstraint("West", (Component)this.browseDestination, 3, "East", (Component)this.destination);
        sl.putConstraint("East", (Component)panel, 8, "East", (Component)this.browseDestination);
        sl.putConstraint("North", (Component)this.send, 8, "North", (Component)panel);
        sl.putConstraint("West", (Component)this.send, 0, "West", (Component)this.destination);
        sl.putConstraint("North", (Component)this.receive, 0, "North", (Component)this.send);
        sl.putConstraint("West", (Component)this.receive, 8, "East", (Component)this.send);
        sl.putConstraint("East", (Component)lAgent, 0, "East", (Component)lDestination);
        sl.putConstraint("North", (Component)lAgent, 8, "South", (Component)this.send);
        sl.putConstraint("East", (Component)this.agent, 0, "East", (Component)this.destination);
        sl.putConstraint("West", (Component)this.agent, 0, "West", (Component)this.destination);
        sl.putConstraint("North", (Component)this.agent, -2, "North", (Component)lAgent);
        sl.putConstraint("East", (Component)lUrlList, 0, "East", (Component)lDestination);
        sl.putConstraint("North", (Component)lUrlList, 8, "South", (Component)this.agent);
        sl.putConstraint("East", (Component)scrollUrlList, 0, "East", (Component)this.destination);
        sl.putConstraint("West", (Component)scrollUrlList, 0, "West", (Component)this.destination);
        sl.putConstraint("North", (Component)scrollUrlList, -2, "North", (Component)lUrlList);
        sl.putConstraint("East", (Component)lUser, 0, "East", (Component)lDestination);
        sl.putConstraint("North", (Component)lUser, 8, "South", (Component)scrollUrlList);
        sl.putConstraint("East", (Component)this.user, 0, "East", (Component)this.destination);
        sl.putConstraint("West", (Component)this.user, 0, "West", (Component)this.destination);
        sl.putConstraint("North", (Component)this.user, -2, "North", (Component)lUser);
        sl.putConstraint("East", (Component)lPassword, 0, "East", (Component)lDestination);
        sl.putConstraint("North", (Component)lPassword, 8, "South", (Component)this.user);
        sl.putConstraint("East", (Component)this.password, 0, "East", (Component)this.destination);
        sl.putConstraint("West", (Component)this.password, 0, "West", (Component)this.destination);
        sl.putConstraint("North", (Component)this.password, -2, "North", (Component)lPassword);
        sl.putConstraint("East", (Component)lFiles, 0, "East", (Component)lDestination);
        sl.putConstraint("North", (Component)lFiles, 8, "South", (Component)this.password);
        sl.putConstraint("East", (Component)scrollFiles, 0, "East", (Component)this.destination);
        sl.putConstraint("West", (Component)scrollFiles, 0, "West", (Component)this.destination);
        sl.putConstraint("North", (Component)scrollFiles, -2, "North", (Component)lFiles);
        sl.putConstraint("West", (Component)this.browseFiles, 0, "West", (Component)this.browseDestination);
        sl.putConstraint("North", (Component)this.browseFiles, -2, "North", (Component)lFiles);
        sl.putConstraint("North", (Component)lDestination, 8, "South", (Component)scrollFiles);
        sl.putConstraint("North", (Component)this.destination, -2, "North", (Component)lDestination);
        sl.putConstraint("North", (Component)this.browseDestination, -2, "North", (Component)lDestination);
        sl.putConstraint("South", (Component)panel, 12, "South", (Component)this.destination);
        sl.layoutContainer(panel);
        sl.getConstraints(this.agent).setHeight(Spring.constant(this.agent.getHeight()));
        sl.getConstraints(this.user).setHeight(Spring.constant(this.user.getHeight()));
        sl.getConstraints(this.password).setHeight(Spring.constant(this.password.getHeight()));
        sl.getConstraints(this.destination).setHeight(Spring.constant(this.destination.getHeight()));
        this.propertyMap.putAll(this.transferPropertyMap);
    }

    private void createCertificatePage(Container panel) {
        JLabel lCertificate = new JLabel("C.A. Certificate");
        this.certificatePropertyMap.put(lCertificate, "com.signiant.interactivetransfer.engine.CA_CERTIFICATE");
        panel.add(lCertificate);
        JButton browseCertificate = new JButton("Browse ...");
        browseCertificate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Open root certificate");
                if (fc.showOpenDialog(Application.this.root) != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                try {
                    StringBuilder sb = new StringBuilder();
                    CharBuffer buf = CharBuffer.allocate(1024);
                    FileReader rdr = new FileReader(file);
                    while (rdr.read(buf) > 0) {
                        buf.flip();
                        while (buf.hasRemaining()) {
                            sb.append(buf.get());
                        }
                        buf.clear();
                    }
                    String value = sb.toString();
                    Application.this.engine.setCertificate(value);
                    Application.this.certificate.setText(value);
                    Application.this.certificate.disableProtected();
                }
                catch (IOException ie) {
                    JOptionPane.showMessageDialog(Application.this.app, "Cannot read CA certificate from [" + file.getName() + "]\n\n" + ie.getMessage(), "Open CA Certificate", 0);
                }
            }
        });
        this.certificatePropertyMap.put(browseCertificate, "com.signiant.interactivetransfer.engine.CA_CERTIFICATE");
        panel.add(browseCertificate);
        this.certificate = new ProtectedTextArea();
        this.certificate.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setCertificate(Application.this.certificate.getProtectedValue());
            }
        });
        JScrollPane scrollCertificate = new JScrollPane(this.certificate);
        lCertificate.setLabelFor(scrollCertificate);
        this.certificatePropertyMap.put(this.certificate, "com.signiant.interactivetransfer.engine.CA_CERTIFICATE");
        panel.add(scrollCertificate);
        SpringLayout sl = (SpringLayout)panel.getLayout();
        sl.putConstraint("North", (Component)lCertificate, 8, "North", (Component)panel);
        sl.putConstraint("North", (Component)browseCertificate, 0, "North", (Component)lCertificate);
        sl.putConstraint("West", (Component)lCertificate, 8, "West", (Component)panel);
        sl.putConstraint("East", (Component)browseCertificate, -8, "East", (Component)panel);
        sl.putConstraint("East", (Component)scrollCertificate, 0, "East", (Component)browseCertificate);
        sl.putConstraint("West", (Component)scrollCertificate, 0, "West", (Component)lCertificate);
        sl.putConstraint("South", (Component)scrollCertificate, -8, "South", (Component)panel);
        sl.putConstraint("North", (Component)scrollCertificate, 8, "South", (Component)browseCertificate);
        this.propertyMap.putAll(this.certificatePropertyMap);
    }

    private void createOptionsPage(Container panel) {
        SpringLayout sl = (SpringLayout)panel.getLayout();
        Spring halfWay = Spring.scale(Spring.sum(sl.getConstraint("East", panel), Spring.minus(sl.getConstraint("West", panel))), 0.5f);
        JLabel lRetries = new JLabel("Number of Retries");
        this.optionsPropertyMap.put(lRetries, "com.signiant.interactivetransfer.engine.RETRIES");
        panel.add(lRetries);
        this.retries = new ProtectedNumberField();
        this.retries.setColumns(5);
        this.retries.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setRetries(Integer.parseInt(Application.this.retries.getProtectedValue()));
            }
        });
        lRetries.setLabelFor(this.retries);
        this.optionsPropertyMap.put(this.retries, "com.signiant.interactivetransfer.engine.RETRIES");
        panel.add(this.retries);
        JLabel lRestarts = new JLabel("Number of Restarts");
        this.optionsPropertyMap.put(lRestarts, "com.signiant.interactivetransfer.engine.RESTARTS");
        panel.add(lRestarts);
        this.restarts = new ProtectedNumberField();
        this.restarts.setColumns(5);
        this.restarts.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setRestarts(Integer.parseInt(Application.this.restarts.getProtectedValue()));
            }
        });
        lRestarts.setLabelFor(this.restarts);
        this.optionsPropertyMap.put(this.restarts, "com.signiant.interactivetransfer.engine.RESTARTS");
        panel.add(this.restarts);
        JLabel lEncryption = new JLabel("Data Transmission Protection");
        panel.add(lEncryption);
        this.optionsPropertyMap.put(lEncryption, "com.signiant.interactivetransfer.engine.ENCRYPT");
        this.encrypt = new JComboBox<Port.SSLMode>(new Port.SSLMode[]{Port.SSLMode.STRONG, Port.SSLMode.NONE, Port.SSLMode.UNSIGNED});
        this.encrypt.setMaximumRowCount(3);
        this.encrypt.setRenderer(new RightJustifiedCellRenderer());
        this.encrypt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.engine.setEncryption((Port.SSLMode)((Object)Application.this.encrypt.getSelectedItem()));
            }
        });
        panel.add(this.encrypt);
        this.optionsPropertyMap.put(this.encrypt, "com.signiant.interactivetransfer.engine.ENCRYPT");
        JLabel lBandwidthThrottle = new JLabel("Bandwidth Limit");
        panel.add(lBandwidthThrottle);
        this.optionsPropertyMap.put(lBandwidthThrottle, "com.signiant.interactivetransfer.engine.BANDWIDTH_THROTTLE");
        JLabel lTargetRate = new JLabel("Target Transfer Rate");
        this.optionsPropertyMap.put(lTargetRate, "com.signiant.interactivetransfer.engine.udp.TARGET_RATE");
        panel.add(lTargetRate);
        JLabel lMinRate = new JLabel("Minimum Transfer Rate");
        panel.add(lMinRate);
        this.optionsPropertyMap.put(lMinRate, "com.signiant.interactivetransfer.engine.udp.MINIMUM_RATE");
        JLabel lAggressiveness = new JLabel("Aggressiveness");
        this.optionsPropertyMap.put(lAggressiveness, "com.signiant.interactivetransfer.engine.udp.aggressiveness");
        panel.add(lAggressiveness);
        this.targetRate = new Throttle(panel);
        this.targetRate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (Application.this.minRate.getValue() > Application.this.targetRate.getValue()) {
                            Application.this.minRate.setValue(Application.this.targetRate.getValue());
                        }
                        Application.this.engine.setTargetRate(Application.this.targetRate.getValue());
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        });
        this.optionsPropertyMap.put(this.targetRate, "com.signiant.interactivetransfer.engine.udp.TARGET_RATE");
        this.minRate = new Throttle(panel);
        this.minRate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                Runnable r = new Runnable(){

                    public void run() {
                        if (Application.this.minRate.getValue() > Application.this.targetRate.getValue()) {
                            Application.this.targetRate.setValue(Application.this.minRate.getValue());
                        }
                        Application.this.engine.setMinimumRate(Application.this.minRate.getValue());
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        });
        this.optionsPropertyMap.put(this.minRate, "com.signiant.interactivetransfer.engine.udp.MINIMUM_RATE");
        this.bandwidthThrottle = new Throttle(panel);
        this.bandwidthThrottle.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                Application.this.engine.setBandwidthThrottle(Application.this.bandwidthThrottle.getValue());
            }
        });
        this.optionsPropertyMap.put(this.bandwidthThrottle, "com.signiant.interactivetransfer.engine.BANDWIDTH_THROTTLE");
        this.aggressiveness = new JSlider(0, 1, 3, this.engine.getAggressiveness());
        lAggressiveness.setLabelFor(this.aggressiveness);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(new Integer(1), new JLabel("Low"));
        labels.put(new Integer(2), new JLabel("Medium"));
        labels.put(new Integer(3), new JLabel("High"));
        this.aggressiveness.setSnapToTicks(true);
        this.aggressiveness.setLabelTable(labels);
        this.aggressiveness.setPaintLabels(true);
        this.aggressiveness.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    Application.this.engine.setAggressiveness(Application.this.aggressiveness.getValue());
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
        this.optionsPropertyMap.put(this.aggressiveness, "com.signiant.interactivetransfer.engine.udp.aggressiveness");
        panel.add(this.aggressiveness);
        JLabel lTransport = new JLabel("Transport");
        panel.add(lTransport);
        this.optionsPropertyMap.put(lTransport, "com.signiant.interactivetransfer.engine.TRANSPORT");
        this.transport = new JComboBox<String>(new String[]{"WAN Accelerator", "WAN Accelerator then Parallel Streams", "Parallel Streams"});
        this.transport.setMaximumRowCount(3);
        this.transport.setRenderer(new RightJustifiedCellRenderer());
        this.transport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Application.this.transport.getSelectedIndex() == 0) {
                    Application.this.engine.setTransport(Transport.UDP);
                    Application.this.aggressiveness.setEnabled(true);
                    Application.this.targetRate.setEnabled(true);
                    Application.this.minRate.setEnabled(true);
                }
                if (Application.this.transport.getSelectedIndex() == 1) {
                    Application.this.engine.setTransport(Transport.UDP_THEN_TCP);
                    Application.this.aggressiveness.setEnabled(true);
                    Application.this.targetRate.setEnabled(true);
                    Application.this.minRate.setEnabled(true);
                }
                if (Application.this.transport.getSelectedIndex() == 2) {
                    Application.this.engine.setTransport(Transport.TCP);
                    Application.this.aggressiveness.setEnabled(false);
                    Application.this.targetRate.setEnabled(false);
                    Application.this.minRate.setEnabled(false);
                }
            }
        });
        panel.add(this.transport);
        this.optionsPropertyMap.put(this.transport, "com.signiant.interactivetransfer.engine.TRANSPORT");
        JLabel lStreams = new JLabel("Number of Streams");
        this.optionsPropertyMap.put(lStreams, "com.signiant.interactivetransfer.engine.STREAMS");
        panel.add(lStreams);
        this.streams = new JComboBox<String>(new String[]{"1", "2", "3", "4"});
        this.streams.setMaximumRowCount(4);
        this.streams.setRenderer(new RightJustifiedCellRenderer());
        this.streams.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Application.this.engine.setNumberOfStreams(Application.this.streams.getSelectedIndex() + 1);
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
        this.optionsPropertyMap.put(this.streams, "com.signiant.interactivetransfer.engine.STREAMS");
        panel.add(this.streams);
        JLabel middle = new JLabel();
        panel.add(middle);
        sl.putConstraint("West", (Component)middle, halfWay, "West", (Component)panel);
        sl.putConstraint("North", (Component)lRetries, 8, "North", (Component)panel);
        sl.putConstraint("East", (Component)lRetries, -8, "West", (Component)this.retries);
        sl.putConstraint("North", (Component)this.retries, -2, "North", (Component)lRetries);
        sl.putConstraint("East", (Component)this.retries, -8, "West", (Component)middle);
        sl.putConstraint("North", (Component)lRestarts, 8, "South", (Component)lRetries);
        sl.putConstraint("East", (Component)lRestarts, -8, "West", (Component)this.restarts);
        sl.putConstraint("North", (Component)this.restarts, -2, "North", (Component)lRestarts);
        sl.putConstraint("East", (Component)this.restarts, 0, "East", (Component)this.retries);
        sl.putConstraint("West", (Component)this.restarts, 0, "West", (Component)this.retries);
        sl.putConstraint("North", (Component)lStreams, 8, "South", (Component)lRestarts);
        sl.putConstraint("East", (Component)lStreams, -8, "West", (Component)this.streams);
        sl.putConstraint("North", (Component)this.streams, -2, "North", (Component)lStreams);
        sl.putConstraint("East", (Component)this.streams, 0, "East", (Component)this.retries);
        sl.putConstraint("West", (Component)this.streams, 0, "West", (Component)this.retries);
        sl.putConstraint("North", (Component)this.transport, 10, "South", (Component)lStreams);
        sl.putConstraint("West", (Component)this.transport, 0, "West", (Component)this.retries);
        sl.putConstraint("East", (Component)lTransport, -10, "West", (Component)this.transport);
        sl.putConstraint("North", (Component)lTransport, 0, "North", (Component)this.transport);
        sl.putConstraint("North", (Component)lBandwidthThrottle, 6, "South", (Component)this.transport);
        sl.putConstraint("East", (Component)lBandwidthThrottle, -8, "West", (Component)this.bandwidthThrottle.getPercent());
        sl.putConstraint("East", (Component)this.bandwidthThrottle.getUnits(), -8, "East", (Component)panel);
        sl.putConstraint("North", (Component)this.bandwidthThrottle.getPercent(), -2, "North", (Component)lBandwidthThrottle);
        sl.putConstraint("North", (Component)lTargetRate, 8, "South", (Component)lBandwidthThrottle);
        sl.putConstraint("East", (Component)lTargetRate, -8, "West", (Component)this.targetRate.getPercent());
        sl.putConstraint("East", (Component)this.targetRate.getUnits(), -8, "East", (Component)panel);
        sl.putConstraint("North", (Component)this.targetRate.getPercent(), -2, "North", (Component)lTargetRate);
        sl.putConstraint("North", (Component)lMinRate, 8, "South", (Component)lTargetRate);
        sl.putConstraint("East", (Component)lMinRate, -8, "West", (Component)this.minRate.getPercent());
        sl.putConstraint("East", (Component)this.minRate.getUnits(), -8, "East", (Component)panel);
        sl.putConstraint("North", (Component)this.minRate.getPercent(), -2, "North", (Component)lMinRate);
        sl.putConstraint("North", (Component)lAggressiveness, 16, "South", (Component)lMinRate);
        sl.putConstraint("West", (Component)lAggressiveness, 0, "West", (Component)lStreams);
        sl.putConstraint("West", (Component)this.aggressiveness, 8, "East", (Component)lAggressiveness);
        sl.putConstraint("North", (Component)this.aggressiveness, -8, "North", (Component)lAggressiveness);
        sl.putConstraint("North", (Component)lEncryption, 0, "North", (Component)this.retries);
        sl.putConstraint("East", (Component)lEncryption, -8, "East", (Component)panel);
        sl.putConstraint("North", (Component)this.encrypt, 0, "South", (Component)this.retries);
        sl.putConstraint("East", (Component)this.encrypt, -8, "East", (Component)panel);
        sl.putConstraint("West", (Component)this.encrypt, 8, "East", (Component)middle);
        this.propertyMap.putAll(this.optionsPropertyMap);
    }

    private void createLoggingPage(Container panel) {
        JLabel lLogging = new JLabel("Logging");
        this.loggingPropertyMap.put(lLogging, "com.signiant.interactivetransfer.engine.logging");
        panel.add(lLogging);
        this.logging = new JComboBox<String>(logMenu);
        this.logging.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Application.this.engine.setLogLevel(logMenu[Application.this.logging.getSelectedIndex()]);
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        });
        lLogging.setLabelFor(this.logging);
        panel.add(this.logging);
        JLabel lTraceFlags = new JLabel("Agent Trace Flags");
        this.loggingPropertyMap.put(lTraceFlags, "com.signiant.interactivetransfer.engine.logging");
        panel.add(lTraceFlags);
        this.traceFlags = new ProtectedTextField();
        this.traceFlags.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setTrace(Application.this.traceFlags.getText());
            }
        });
        lTraceFlags.setLabelFor(this.traceFlags);
        this.transferPropertyMap.put(this.traceFlags, "com.signiant.interactivetransfer.engine.trace");
        panel.add(this.traceFlags);
        SpringLayout sl = (SpringLayout)panel.getLayout();
        sl.putConstraint("North", (Component)lLogging, 20, "North", (Component)panel);
        sl.putConstraint("North", (Component)this.logging, 0, "North", (Component)lLogging);
        sl.putConstraint("North", (Component)lTraceFlags, 16, "South", (Component)this.logging);
        sl.putConstraint("North", (Component)this.traceFlags, 0, "North", (Component)lTraceFlags);
        sl.putConstraint("West", (Component)lTraceFlags, 8, "West", (Component)panel);
        sl.putConstraint("East", (Component)this.traceFlags, -8, "East", (Component)panel);
        sl.putConstraint("West", (Component)this.traceFlags, 8, "East", (Component)lTraceFlags);
        sl.putConstraint("East", (Component)lLogging, 0, "East", (Component)lTraceFlags);
        sl.putConstraint("West", (Component)this.logging, 8, "East", (Component)lLogging);
        sl.layoutContainer(panel);
        this.propertyMap.putAll(this.loggingPropertyMap);
    }

    private void createOptionalHeaderPage(Container panel) {
        JLabel label_jobgroup = new JLabel("Job group");
        this.headerPropertyMap.put(label_jobgroup, "com.signiant.interactivetransfer.engine.jobgroup");
        panel.add(label_jobgroup);
        this.jobGroup = new ProtectedTextField();
        this.jobGroup.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setJobGroup(Application.this.jobGroup.getText());
            }
        });
        label_jobgroup.setLabelFor(this.jobGroup);
        this.transferPropertyMap.put(this.jobGroup, "com.signiant.interactivetransfer.engine.jobgroup");
        panel.add(this.jobGroup);
        JLabel label_jobname = new JLabel("Job name");
        this.headerPropertyMap.put(label_jobname, "com.signiant.interactivetransfer.engine.jobnameprefix");
        panel.add(label_jobname);
        this.jobName = new ProtectedTextField();
        this.jobName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Application.this.engine.setJobNamePrefix(Application.this.jobName.getText());
            }
        });
        label_jobname.setLabelFor(this.jobName);
        this.transferPropertyMap.put(this.jobName, "com.signiant.interactivetransfer.engine.jobnameprefix");
        panel.add(this.jobName);
        SpringLayout sl = (SpringLayout)panel.getLayout();
        sl.putConstraint("North", (Component)label_jobgroup, 16, "South", (Component)panel);
        sl.putConstraint("North", (Component)this.jobGroup, 0, "North", (Component)label_jobgroup);
        sl.putConstraint("North", (Component)label_jobname, 16, "South", (Component)this.jobGroup);
        sl.putConstraint("North", (Component)this.jobName, 0, "North", (Component)label_jobname);
        sl.putConstraint("East", (Component)label_jobgroup, 0, "East", (Component)panel);
        sl.putConstraint("East", (Component)this.jobGroup, -8, "East", (Component)panel);
        sl.putConstraint("West", (Component)this.jobGroup, 8, "East", (Component)label_jobgroup);
        sl.putConstraint("East", (Component)label_jobname, 0, "East", (Component)label_jobgroup);
        sl.putConstraint("East", (Component)this.jobName, -8, "East", (Component)panel);
        sl.putConstraint("West", (Component)this.jobName, 8, "East", (Component)label_jobname);
        sl.layoutContainer(panel);
        this.propertyMap.putAll(this.headerPropertyMap);
    }

    private void createTabs(Container panel) {
        boolean addTab;
        SpringLayout sl = (SpringLayout)panel.getLayout();
        this.tabs = new JTabbedPane();
        panel.add(this.tabs);
        sl.putConstraint("West", (Component)this.tabs, 10, "West", (Component)panel);
        if (this.toolbar != null) {
            sl.putConstraint("North", (Component)this.tabs, 10, "South", (Component)this.toolbar);
        } else {
            sl.putConstraint("North", (Component)this.tabs, 10, "North", (Component)panel);
        }
        sl.putConstraint("East", (Component)panel, 10, "East", (Component)this.tabs);
        JPanel page = new JPanel();
        SpringLayout layout = new SpringLayout();
        page.setLayout(layout);
        this.createTransferPage(page);
        boolean bl = addTab = this.propertyScan(this.engine.getShownProperties(), this.transferPropertyMap) || this.propertyScan(this.engine.getEditableProperties(), this.transferPropertyMap);
        if (addTab) {
            this.tabs.addTab("Transfer", page);
        }
        page = new JPanel();
        layout = new SpringLayout();
        page.setLayout(layout);
        this.createCertificatePage(page);
        boolean bl2 = addTab = this.propertyScan(this.engine.getShownProperties(), this.certificatePropertyMap) || this.propertyScan(this.engine.getEditableProperties(), this.certificatePropertyMap);
        if (addTab) {
            this.tabs.addTab("Certificate", page);
        }
        page = new JPanel();
        layout = new SpringLayout();
        page.setLayout(layout);
        this.createOptionsPage(page);
        boolean bl3 = addTab = this.propertyScan(this.engine.getShownProperties(), this.optionsPropertyMap) || this.propertyScan(this.engine.getEditableProperties(), this.optionsPropertyMap);
        if (addTab) {
            this.tabs.addTab("Options", page);
        }
        page = new JPanel();
        layout = new SpringLayout();
        page.setLayout(layout);
        this.createLoggingPage(page);
        boolean bl4 = addTab = this.propertyScan(this.engine.getShownProperties(), this.loggingPropertyMap) || this.propertyScan(this.engine.getEditableProperties(), this.loggingPropertyMap);
        if (addTab) {
            this.tabs.addTab("Logging", page);
        }
        page = new JPanel();
        layout = new SpringLayout();
        page.setLayout(layout);
        this.createOptionalHeaderPage(page);
        boolean bl5 = addTab = this.propertyScan(this.engine.getShownProperties(), this.headerPropertyMap) || this.propertyScan(this.engine.getEditableProperties(), this.headerPropertyMap);
        if (addTab) {
            this.tabs.addTab("Optional Header", page);
        }
    }

    private void createDialogWindow(Frame frame) {
        try {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gs = env.getDefaultScreenDevice();
            GraphicsConfiguration cfg = gs.getDefaultConfiguration();
            Rectangle rect = cfg.getBounds();
            Point pt = new Point((int)rect.getCenterX(), (int)rect.getCenterY());
            this.dlg = new JDialog(frame, "Transfer Settings");
            this.root = this.dlg;
            Container base = this.dlg.getContentPane();
            SpringLayout layout = new SpringLayout();
            base.setLayout(layout);
            this.createTabs(base);
            this.transfer = new JButton("Transfer ...");
            this.transfer.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (Application.this.dlg != null) {
                        Application.this.dlg.setVisible(false);
                    }
                    if (Application.this.app != null) {
                        Application.this.app.setVisible(false);
                    }
                    Application.this.setClosed(false);
                }
            });
            base.add(this.transfer);
            JButton close = new JButton("Close");
            close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (Application.this.dlg != null) {
                        Application.this.dlg.setVisible(false);
                    }
                    if (Application.this.app != null) {
                        Application.this.app.setVisible(false);
                    }
                    Application.this.setClosed(true);
                }
            });
            base.add(close);
            layout.putConstraint("North", (Component)close, 10, "South", (Component)this.tabs);
            layout.putConstraint("East", (Component)close, 0, "East", (Component)this.tabs);
            layout.putConstraint("North", (Component)this.transfer, 0, "North", (Component)close);
            layout.putConstraint("East", (Component)this.transfer, -20, "West", (Component)close);
            layout.putConstraint("South", (Component)base, 10, "South", (Component)close);
            this.dlg.pack();
            pt.x -= this.dlg.getWidth() / 2;
            pt.y -= this.dlg.getHeight() / 2;
            this.dlg.setLocation(pt.x, pt.y);
            this.resetFields();
            this.dlg.setVisible(true);
        }
        catch (Exception oops) {
            oops.printStackTrace();
        }
    }

    private void createApplicationWindow() {
        UIManager.LookAndFeelInfo[] info;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = env.getDefaultScreenDevice();
        GraphicsConfiguration cfg = gs.getDefaultConfiguration();
        Rectangle rect = cfg.getBounds();
        Point pt = new Point((int)rect.getCenterX(), (int)rect.getCenterY());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (UIManager.LookAndFeelInfo i : info = UIManager.getInstalledLookAndFeels()) {
            if (!i.getName().equals("GTK+")) continue;
            try {
                UIManager.setLookAndFeel(i.getClassName());
            }
            catch (Exception discard) {
                // empty catch block
            }
        }
        this.app = new JFrame("Signiant Mobilize Java Agent", cfg);
        this.app.setDefaultCloseOperation(3);
        this.root = this.app;
        Container base = this.app.getContentPane();
        SpringLayout layout = new SpringLayout();
        base.setLayout(layout);
        this.createToolBar(base);
        this.createTabs(base);
        this.transfer = new JButton("Transfer ...");
        this.transfer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JDialog dlg = new JDialog(Application.this.app);
                StatusPanel status = new StatusPanel(dlg, Application.this.engine);
                try {
                    Application.this.engine.startTransfer();
                }
                catch (Exception e) {
                    status.exception(e);
                }
                dlg.setVisible(true);
            }
        });
        base.add(this.transfer);
        JButton close = new JButton("Close");
        base.add(close);
        layout.putConstraint("North", (Component)close, 10, "South", (Component)this.tabs);
        layout.putConstraint("East", (Component)close, 0, "East", (Component)this.tabs);
        layout.putConstraint("North", (Component)this.transfer, 0, "North", (Component)close);
        layout.putConstraint("East", (Component)this.transfer, -20, "West", (Component)close);
        layout.putConstraint("South", (Component)base, 10, "South", (Component)close);
        this.app.pack();
        pt.x -= this.app.getWidth() / 2;
        pt.y -= this.app.getHeight() / 2;
        this.app.setLocation(pt.x, pt.y);
        this.app.setVisible(true);
    }

    private boolean isPropertyListed(String[] properties, String value) {
        if (properties == null) {
            return false;
        }
        for (String s : properties) {
            if (!s.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private void applyShownProperties(String[] properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        for (Map.Entry<JComponent, String> e : this.propertyMap.entrySet()) {
            if (!(e.getKey() instanceof ProtectedValue) || this.isPropertyListed(properties, e.getValue())) continue;
            ((ProtectedValue)((Object)e.getKey())).setProtected();
        }
    }

    private void applyEditableProperties(String[] properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        for (Map.Entry<JComponent, String> e : this.propertyMap.entrySet()) {
            JComponent component = e.getKey();
            if (!component.isEnabled()) continue;
            component.setEnabled(this.isPropertyListed(properties, e.getValue()));
            if (!(component instanceof JTextArea)) continue;
            ((JTextArea)component).setEditable(this.isPropertyListed(properties, e.getValue()));
        }
    }

    private boolean propertyScan(String[] properties, Map<JComponent, String> map) {
        if (properties == null || properties.length == 0) {
            return true;
        }
        boolean listed = false;
        for (Map.Entry<JComponent, String> e : map.entrySet()) {
            listed = listed || this.isPropertyListed(properties, e.getValue());
        }
        return listed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        try {
            Object object = this.closedEvent;
            synchronized (object) {
                this.closedEvent.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClosed(boolean closedState) {
        Object object = this.closedEvent;
        synchronized (object) {
            this.closed = closedState;
            this.closedEvent.notifyAll();
        }
    }

    public void close() {
        this.dlg.setVisible(false);
        this.setClosed(true);
    }

    public static void main(String[] args) {
        new Application();
    }

    private void setLogging(String value) {
        for (int i = 0; i < logMenu.length; ++i) {
            if (!logMenu[i].equalsIgnoreCase(value)) continue;
            this.logging.setSelectedIndex(i);
            return;
        }
        this.logging.setSelectedIndex(0);
    }

    public void doDialog() {
        this.dlg.setVisible(true);
    }

    private static class RightJustifiedCellRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = 0L;

        public RightJustifiedCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(value.toString());
            return this;
        }
    }

    private class DroppableTextArea
    extends ProtectedTextArea
    implements DropTargetListener {
        private static final long serialVersionUID = 0L;
        private DropTarget dropTarget;

        private DroppableTextArea() {
            this.dropTarget = new DropTarget(this, this);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            Transferable tr = dtde.getTransferable();
            if (!tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.rejectDrag();
                return;
            }
            List l = null;
            StringBuilder sb = new StringBuilder();
            try {
                l = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (Exception e) {
                dtde.rejectDrag();
                return;
            }
            for (Object o : l) {
                File f = (File)o;
                if (!f.isDirectory() && !f.isFile()) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(f.getAbsolutePath());
            }
            if (sb.length() == 0) {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void drop(DropTargetDropEvent de) {
            try {
                Transferable tr = de.getTransferable();
                if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    de.acceptDrop(1);
                    LinkedList<String> files = new LinkedList<String>();
                    List l = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                    for (Object o : l) {
                        File f = (File)o;
                        if (!f.isDirectory() && !f.isFile()) continue;
                        files.add(f.getAbsolutePath());
                    }
                    StringBuilder sb = new StringBuilder();
                    for (String s : files) {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(s);
                    }
                    if (sb.length() > 0) {
                        this.secured = false;
                        this.setText(sb.toString());
                        Application.this.engine.setFiles(files.toArray(new String[0]));
                    }
                }
                de.getDropTargetContext().dropComplete(true);
            }
            catch (IOException ioe) {
                de.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                de.rejectDrop();
            }
        }

        public boolean isProtected() {
            return this.secured;
        }
    }

    private class ProtectedTextArea
    extends JTextArea
    implements ProtectedValue,
    FocusListener {
        private static final long serialVersionUID = 0L;
        protected String value = "";
        protected boolean secured = false;

        public ProtectedTextArea() {
            this.addFocusListener(this);
        }

        public String getProtectedValue() {
            if (this.secured) {
                return this.value;
            }
            return this.getText();
        }

        public void setProtected() {
            this.value = this.getText();
            this.secured = true;
            this.setText("******");
        }

        public void disableProtected() {
            this.secured = false;
        }

        public void focusGained(FocusEvent e) {
            if (this.secured) {
                this.setText("");
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.secured && this.getText().length() == 0) {
                this.setText("******");
            } else {
                this.secured = false;
            }
        }
    }

    private static class ProtectedNumberField
    extends ProtectedTextField {
        static final long serialVersionUID = 0L;
        private boolean inFocus = false;

        public ProtectedNumberField() {
            this.setHorizontalAlignment(4);
        }

        protected String getProtectedString() {
            return "*";
        }

        public void focusGained(FocusEvent e) {
            this.inFocus = true;
            super.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            this.inFocus = false;
            super.focusLost(e);
        }

        protected Document createDefaultModel() {
            return new NumberDocument();
        }

        private class NumberDocument
        extends PlainDocument {
            static final long serialVersionUID = 0L;

            private NumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (ProtectedNumberField.this.secured && !ProtectedNumberField.this.inFocus) {
                    super.insertString(offs, str, a);
                    return;
                }
                boolean beep = false;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    if (Character.isDigit(c)) {
                        sb.append(c);
                        continue;
                    }
                    beep = true;
                }
                if (beep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                super.insertString(offs, sb.toString(), a);
            }
        }
    }

    private static class ProtectedTextField
    extends JTextField
    implements ProtectedValue,
    FocusListener {
        static final long serialVersionUID = 0L;
        protected String value = "";
        protected boolean secured = false;

        protected String getProtectedString() {
            return "******";
        }

        public ProtectedTextField() {
            this.addFocusListener(this);
        }

        public String getProtectedValue() {
            if (this.secured) {
                return this.value;
            }
            return this.getText();
        }

        public void setProtected() {
            this.value = this.getText();
            this.secured = true;
            this.setText(this.getProtectedString());
        }

        public void disableProtected() {
            this.secured = false;
        }

        public void focusGained(FocusEvent e) {
            if (this.secured) {
                this.setText("");
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.secured && this.getText().length() == 0) {
                this.setText(this.getProtectedString());
            } else {
                this.secured = false;
            }
        }
    }

    private static interface ProtectedValue {
        public String getProtectedValue();

        public void setProtected();

        public void disableProtected();
    }

    private static class Throttle
    extends JComponent {
        static final long serialVersionUID = 0L;
        private boolean updating;
        private JComboBox percent;
        private JLabel of;
        private JComboBox ofSpeed;
        private JLabel or;
        private ProtectedNumberField textField;
        private JComboBox units;
        private long value;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private boolean required = false;
        private boolean enabled = true;
        private static int[] divisors = new int[]{1, 1024, 0x100000};
        private static String[] percents = new String[]{"None", "5%", "10%", "15%", "20%", "25%", "30%", "35%", "40%", "45%", "50%", "55%", "60%", "65%", "70%", "75%", "80%", "85%", "90%", "95%", "100%", "Fixed"};
        private static String[] speedLabels = new String[]{"<unknown>", "56 Kbps", "64 Kbps (DS0)", "128 Kbps", "256 Kbps", "512 Kbps", "768 Kbps", "1 Mbps", "1.54 Mbps (T1/DS1)", "2 Mbps", "3.08 Mbps (Dual T1)", "4 Mbps", "6 Mbps", "8 Mbps", "10 Mbps", "44.7 Mbps (T3/DS3)", "51.8 Mbps (OC1)", "100 Mbps", "155 Mbps (OC3)", "1 Gbps"};
        private static long[] speeds = new long[]{0L, 7168L, 8192L, 16384L, 32768L, 65536L, 98304L, 131072L, 201850L, 262144L, 403701L, 524288L, 786432L, 0x100000L, 0x140000L, 0x596666L, 0x679999L, 0xC80000L, 20316160L, 0x8000000L};

        public Throttle(Container c) {
            this(c, 0L);
            this.enabled = true;
            this.required = false;
        }

        public Throttle(Container c, long value) {
            SpringLayout sl = (SpringLayout)c.getLayout();
            Spring halfWay = Spring.scale(Spring.sum(sl.getConstraint("East", c), Spring.minus(sl.getConstraint("West", c))), 0.5f);
            this.updating = false;
            this.percent = new JComboBox<String>(percents);
            this.percent.setMaximumRowCount(6);
            this.percent.setRenderer(new RightJustifiedCellRenderer());
            this.percent.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Throttle.this.percentChanged();
                }
            });
            c.add(this.percent);
            this.ofSpeed = new JComboBox<String>(speedLabels);
            this.ofSpeed.setMaximumRowCount(6);
            this.ofSpeed.setRenderer(new RightJustifiedCellRenderer());
            this.ofSpeed.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Throttle.this.percentChanged();
                }
            });
            c.add(this.ofSpeed);
            this.textField = new ProtectedNumberField();
            this.textField.setColumns(9);
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                private void changed() {
                    if (Throttle.this.textField.getText().length() > 0 && !Throttle.this.updating) {
                        Throttle.this.updateFromUI();
                    }
                }

                public void changedUpdate(DocumentEvent de) {
                    this.changed();
                }

                public void insertUpdate(DocumentEvent de) {
                    this.changed();
                }

                public void removeUpdate(DocumentEvent de) {
                    this.changed();
                }
            });
            c.add(this.textField);
            this.units = new JComboBox<String>(new String[]{"bytes/sec (Bps)", "Kbytes/sec (KBps)", "Mbytes/sec (MBps)"});
            this.units.setMaximumRowCount(6);
            this.units.setRenderer(new RightJustifiedCellRenderer());
            this.units.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Throttle.this.update();
                }
            });
            c.add(this.units);
            JLabel middle = new JLabel();
            c.add(middle);
            sl.putConstraint("West", (Component)middle, halfWay, "West", (Component)c);
            this.of = new JLabel("of");
            c.add(this.of);
            this.or = new JLabel("or");
            c.add(this.or);
            sl.putConstraint("North", (Component)this.of, 2, "North", (Component)this.percent);
            sl.putConstraint("North", (Component)this.ofSpeed, 0, "North", (Component)this.percent);
            sl.putConstraint("North", (Component)this.or, 2, "North", (Component)this.percent);
            sl.putConstraint("North", (Component)this.textField, 0, "North", (Component)this.percent);
            sl.putConstraint("North", (Component)this.units, 0, "North", (Component)this.percent);
            sl.putConstraint("East", (Component)this.textField, -4, "West", (Component)this.units);
            sl.putConstraint("East", (Component)this.or, -4, "West", (Component)this.textField);
            sl.putConstraint("East", (Component)this.ofSpeed, -4, "West", (Component)this.or);
            sl.putConstraint("East", (Component)this.of, -4, "West", (Component)this.ofSpeed);
            sl.putConstraint("East", (Component)this.percent, -4, "West", (Component)this.of);
            this.setValue(value);
            this.handleState();
        }

        public void addChangeListener(ChangeListener l) {
            this.listeners.add(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listeners.remove(l);
        }

        private void fireChangedEvent() {
            for (ChangeListener l : this.listeners) {
                l.stateChanged(new ChangeEvent(this));
            }
        }

        public void setRequired(boolean value) {
            this.required = value;
            if (value) {
                if (this.percent.getItemCount() == percents.length - 1) {
                    return;
                }
                this.percent.removeItemAt(0);
                return;
            }
            if (this.percent.getItemCount() == percents.length) {
                return;
            }
            this.percent.insertItemAt("None", 0);
        }

        public JComboBox getPercent() {
            return this.percent;
        }

        public JLabel getOf() {
            return this.of;
        }

        public JComboBox getOfSpeed() {
            return this.ofSpeed;
        }

        public JLabel getOr() {
            return this.or;
        }

        public ProtectedNumberField getTextField() {
            return this.textField;
        }

        public JComboBox getUnits() {
            return this.units;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.setValueInternal(value);
            if (value > 0L) {
                this.percent.setSelectedIndex(this.percent.getItemCount() - 1);
            } else {
                this.percent.setSelectedIndex(0);
            }
        }

        private void setValueInternal(long value) {
            this.value = value;
            this.update();
            this.fireChangedEvent();
        }

        private void updateFromUI() {
            try {
                this.value = Long.parseLong(this.textField.getText()) * (long)divisors[this.units.getSelectedIndex()];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.fireChangedEvent();
            if (!this.updating) {
                this.updating = true;
                if (this.value > 0L) {
                    this.percent.setSelectedIndex(this.percent.getItemCount() - 1);
                } else {
                    this.percent.setSelectedIndex(0);
                }
                this.updating = false;
            }
        }

        private void update() {
            if (!this.updating) {
                this.updating = true;
                this.textField.setText(this.value > 0L ? Long.toString(this.value / (long)divisors[this.units.getSelectedIndex()]) : "0");
                this.updating = false;
            }
        }

        private void percentChanged() {
            int selected = this.percent.getSelectedIndex();
            if ((this.required || selected > 0) && selected < this.percent.getItemCount() - 1) {
                if (this.ofSpeed.getSelectedIndex() == 0) {
                    this.ofSpeed.setSelectedIndex(this.ofSpeed.getItemCount() - 1);
                }
                int p = 5 * (selected + (this.required ? 1 : 0));
                this.setValueInternal(speeds[this.ofSpeed.getSelectedIndex()] * (long)p / 100L);
            } else if (selected == 0) {
                this.setValueInternal(0L);
            }
            this.handleState();
        }

        private void handleState() {
            if (!this.enabled) {
                this.percent.setEnabled(false);
                this.of.setEnabled(false);
                this.ofSpeed.setEnabled(false);
                this.or.setEnabled(false);
                this.textField.setEnabled(false);
                this.units.setEnabled(false);
                return;
            }
            int p = this.percent.getSelectedIndex();
            if (p == 0 && !this.required) {
                this.percent.setEnabled(true);
                this.of.setEnabled(false);
                this.ofSpeed.setEnabled(false);
                this.or.setEnabled(false);
                this.textField.setEnabled(false);
                this.units.setEnabled(false);
                return;
            }
            if (p == this.percent.getItemCount() - 1) {
                this.percent.setEnabled(true);
                this.ofSpeed.setSelectedIndex(0);
                this.of.setEnabled(false);
                this.ofSpeed.setEnabled(false);
                this.or.setEnabled(false);
                this.textField.setEnabled(true);
                this.units.setEnabled(true);
                return;
            }
            this.percent.setEnabled(true);
            this.of.setEnabled(true);
            this.ofSpeed.setEnabled(true);
            this.or.setEnabled(true);
            this.textField.setEnabled(true);
            this.units.setEnabled(true);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.handleState();
        }

        public void setVisible(boolean visible) {
            this.percent.setVisible(visible);
            this.of.setVisible(visible);
            this.ofSpeed.setVisible(visible);
            this.or.setVisible(visible);
            this.textField.setVisible(visible);
            this.units.setVisible(visible);
            this.handleState();
        }
    }
}

