/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.decryptionapi;

import com.signiant.decryptionapi.ProgressUpdate;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PassPhrase {
    public static void encrypt(String filename, String passPhrase) throws Exception {
        PassPhrase.encrypt(filename, filename + ".enc", passPhrase, null);
    }

    public static void encrypt(String filename, String passPhrase, ProgressUpdate callback) throws Exception {
        PassPhrase.encrypt(filename, filename + ".enc", passPhrase, callback);
        File orig = new File(filename);
        File dest = new File(filename + ".enc");
        orig.delete();
        dest.renameTo(orig);
    }

    public static void encrypt(String filename, String encryptedFilename, String passPhrase, ProgressUpdate callback) throws Exception {
        String cipherAlgorithm = "AES/CTR/NoPadding";
        String keySpecification = "AES";
        byte[] ivBytes = "1234567812345678".getBytes();
        for (int i = 0; i < 10; ++i) {
            passPhrase = passPhrase + passPhrase;
        }
        int start = 7;
        String newPassPhrase = passPhrase.substring(start, start + 16);
        SecretKeySpec secretKey = new SecretKeySpec(newPassPhrase.getBytes(), keySpecification);
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(1, (Key)secretKey, new IvParameterSpec(ivBytes));
        File inputFile = new File(filename);
        File outputFile = new File(encryptedFilename);
        if (!inputFile.canWrite()) {
            throw new IOException("Cannot write to file:" + inputFile);
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(inputFile));
        FileOutputStream output = new FileOutputStream(outputFile);
        long totalSize = inputFile.length();
        long currentSize = 0L;
        CipherOutputStream encryptedStream = new CipherOutputStream(output, cipher);
        byte[] buffer = new byte[65536];
        int length = 0;
        while ((length = ((InputStream)input).read(buffer)) >= 0) {
            ((OutputStream)encryptedStream).write(buffer, 0, length);
            if (callback == null) continue;
            long percent = (currentSize += (long)length) * 100L / totalSize;
            callback.cryptProgress(currentSize, totalSize, (int)percent);
        }
        ((OutputStream)encryptedStream).close();
    }

    public static void decrypt(String filename, String passPhrase) throws Exception {
        PassPhrase.decrypt(filename, passPhrase, null);
    }

    public static void decrypt(String filename, String passPhrase, ProgressUpdate callback) throws Exception {
        PassPhrase.decrypt(filename, filename + ".dec", passPhrase, callback);
        File orig = new File(filename);
        File dest = new File(filename + ".dec");
        orig.delete();
        dest.renameTo(orig);
    }

    public static void decrypt(String filename, String newFilename, String passPhrase, ProgressUpdate callback) throws Exception {
        String cipherAlgorithm = "AES/CTR/NoPadding";
        String keySpecification = "AES";
        byte[] ivBytes = "1234567812345678".getBytes();
        for (int i = 0; i < 10; ++i) {
            passPhrase = passPhrase + passPhrase;
        }
        int start = 7;
        String newPassPhrase = passPhrase.substring(start, start + 16);
        SecretKeySpec secretKey = new SecretKeySpec(newPassPhrase.getBytes(), keySpecification);
        final Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(ivBytes));
        File inputFile = new File(filename);
        File outputFile = new File(newFilename);
        final FileChannel input = new FileInputStream(inputFile).getChannel();
        FileChannel output = new FileOutputStream(outputFile).getChannel();
        if (!inputFile.canWrite()) {
            throw new IOException("Cannot write to file:" + inputFile);
        }
        final LinkedBlockingQueue<ByteBuffer> freeQueue = new LinkedBlockingQueue<ByteBuffer>();
        final LinkedBlockingQueue processingQueue = new LinkedBlockingQueue();
        final LinkedBlockingQueue decryptedQueue = new LinkedBlockingQueue();
        final LinkedBlockingQueue exceptionQueue = new LinkedBlockingQueue();
        int bufferSize = 0x100000;
        Thread reader = new Thread("Decryption Read-ahead"){

            public void run() {
                boolean running = true;
                boolean oom = false;
                int count = 0;
                try {
                    while (running && !this.isInterrupted()) {
                        ByteBuffer buffer = (ByteBuffer)freeQueue.poll(10L, TimeUnit.MILLISECONDS);
                        if (buffer == null) {
                            long memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
                            if (!oom && count < 100 && memory > 0x2000000L) {
                                try {
                                    buffer = ByteBuffer.allocateDirect(0x100000);
                                    ++count;
                                }
                                catch (OutOfMemoryError e) {
                                    oom = true;
                                    buffer = (ByteBuffer)freeQueue.take();
                                }
                            } else {
                                buffer = (ByteBuffer)freeQueue.take();
                            }
                        }
                        int length = input.read(buffer);
                        buffer.flip();
                        processingQueue.offer(buffer);
                        if (length >= 0) continue;
                        running = false;
                    }
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        return;
                    }
                    if (e instanceof Exception) {
                        exceptionQueue.offer((Exception)e);
                    }
                    exceptionQueue.offer(new Exception(e));
                }
            }
        };
        reader.start();
        Thread decryptor = new Thread("Decryptor"){

            public void run() {
                boolean running = true;
                ByteBuffer transfer = ByteBuffer.allocateDirect(0x100000);
                try {
                    while (running && !this.isInterrupted()) {
                        ByteBuffer buffer = (ByteBuffer)processingQueue.take();
                        if (buffer.remaining() == 0) {
                            decryptedQueue.offer(buffer);
                            running = false;
                            break;
                        }
                        cipher.update(buffer, transfer);
                        transfer.flip();
                        decryptedQueue.offer(transfer);
                        buffer.clear();
                        transfer = buffer;
                    }
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        return;
                    }
                    if (e instanceof Exception) {
                        exceptionQueue.offer((Exception)e);
                    }
                    exceptionQueue.offer(new Exception(e));
                }
                transfer = null;
            }
        };
        decryptor.start();
        long currentSize = 0L;
        long totalSize = inputFile.length();
        long lastTime = System.currentTimeMillis();
        boolean running = true;
        while (running) {
            ByteBuffer buffer = (ByteBuffer)decryptedQueue.poll(1L, TimeUnit.SECONDS);
            if (buffer == null) {
                if (exceptionQueue.size() <= 0) continue;
                break;
            }
            if (buffer.remaining() == 0) {
                running = false;
                break;
            }
            currentSize += (long)buffer.remaining();
            output.write(buffer);
            buffer.clear();
            freeQueue.offer(buffer);
            if (callback == null || System.currentTimeMillis() - lastTime <= 500L) continue;
            lastTime = System.currentTimeMillis();
            long percent = currentSize * 100L / totalSize;
            callback.cryptProgress(currentSize, totalSize, (int)percent);
        }
        byte[] terminator = cipher.doFinal();
        output.write(ByteBuffer.wrap(terminator));
        callback.cryptProgress(totalSize, totalSize, 100);
        output.close();
        if (exceptionQueue.size() > 0) {
            throw (Exception)exceptionQueue.take();
        }
    }
}

