/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.decryptionapi;

import com.signiant.decryptionapi.PassPhrase;
import com.signiant.decryptionapi.ProgressUpdate;

public class DecryptionConsoleApplication {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: DecryptionApplication filename passphrase");
            System.err.println("");
            System.err.println("where: filename is the name of the file to decrypt, and");
            System.err.println("       passphrase is the pass phrase to use.");
            System.exit(1);
        }
        try {
            final long startTime = System.currentTimeMillis();
            PassPhrase.decrypt(args[0], args[1], new ProgressUpdate(){

                public void cryptProgress(long bytesConverted, long totalToConvert, int percentCompleted) {
                    long rate = bytesConverted * 1000L / (System.currentTimeMillis() - startTime);
                    System.out.print(percentCompleted + "% complete   " + rate + "  \r");
                }
            });
            System.out.println("100% complete");
        }
        catch (Throwable t) {
            System.err.println("Could not decrypt file: " + t.getLocalizedMessage());
            System.exit(-1);
        }
    }
}

