/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.decryptionapi;

import com.signiant.decryptionapi.PassPhrase;
import com.signiant.decryptionapi.ProgressUpdate;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DecryptionApplication {
    private Component root;
    private JFrame app;
    private JDialog dlg;
    private JTextField password;
    private JTextField fileToDecrypt;
    private JButton browseForFileToDecrypt;
    private JButton performDecryption;
    private JProgressBar progress;

    public void createDecryptionPanel(Container panel, SpringLayout sl) {
        JLabel lPassword = new JLabel("Pass Phrase");
        panel.add(lPassword);
        this.password = new JTextField(40);
        lPassword.setLabelFor(this.password);
        panel.add(this.password);
        JLabel lDestination = new JLabel("File to decrypt");
        panel.add(lDestination);
        this.fileToDecrypt = new JTextField();
        this.fileToDecrypt.setColumns(40);
        panel.add(this.fileToDecrypt);
        lDestination.setLabelFor(this.fileToDecrypt);
        this.browseForFileToDecrypt = new JButton("Browse ...");
        this.browseForFileToDecrypt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("Destination Directory");
                fc.setFileSelectionMode(0);
                String value = "";
                File fld = null;
                if (value != null) {
                    fld = new File(value);
                }
                if (fld != null && fld.exists()) {
                    fc.setCurrentDirectory(fld.getParentFile());
                    fc.setSelectedFile(fld);
                }
                if (fc.showOpenDialog(DecryptionApplication.this.root) != 0) {
                    return;
                }
                fld = fc.getSelectedFile();
                value = fld.getAbsolutePath();
                DecryptionApplication.this.fileToDecrypt.setText(value);
            }
        });
        panel.add(this.browseForFileToDecrypt);
        this.performDecryption = new JButton("Decrypt");
        this.performDecryption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DecryptionApplication.this.decryptFile(DecryptionApplication.this.fileToDecrypt.getText(), DecryptionApplication.this.password.getText(), DecryptionApplication.this.progress);
            }
        });
        panel.add(this.performDecryption);
        this.progress = new JProgressBar();
        panel.add(this.progress);
        sl.putConstraint("West", (Component)lDestination, 8, "West", (Component)panel);
        sl.putConstraint("North", (Component)lDestination, 8, "North", (Component)panel);
        sl.putConstraint("West", (Component)this.fileToDecrypt, 8, "East", (Component)lDestination);
        sl.putConstraint("West", (Component)this.browseForFileToDecrypt, 8, "East", (Component)this.fileToDecrypt);
        sl.putConstraint("East", (Component)panel, 8, "East", (Component)this.browseForFileToDecrypt);
        sl.putConstraint("North", (Component)lPassword, 12, "South", (Component)this.fileToDecrypt);
        sl.putConstraint("West", (Component)lPassword, 8, "West", (Component)panel);
        sl.putConstraint("North", (Component)this.password, 8, "South", (Component)this.fileToDecrypt);
        sl.putConstraint("West", (Component)this.password, 0, "West", (Component)this.fileToDecrypt);
        sl.putConstraint("North", (Component)this.performDecryption, 0, "North", (Component)this.password);
        sl.putConstraint("East", (Component)this.performDecryption, 0, "East", (Component)this.browseForFileToDecrypt);
        sl.putConstraint("West", (Component)this.performDecryption, 0, "West", (Component)this.browseForFileToDecrypt);
        sl.putConstraint("North", (Component)this.progress, 8, "South", (Component)this.password);
        sl.putConstraint("West", (Component)this.progress, 8, "West", (Component)panel);
        sl.putConstraint("East", (Component)this.progress, -8, "East", (Component)panel);
        sl.putConstraint("South", (Component)panel, 8, "South", (Component)this.progress);
        this.progress.setValue(0);
        this.progress.setString("--");
        sl.layoutContainer(panel);
    }

    private void decryptFile(String filename, String passPhrase, final JProgressBar progressBar) {
        try {
            PassPhrase.decrypt(filename, passPhrase, new ProgressUpdate(){

                public void cryptProgress(long bytesConverted, long totalToConvert, int percentCompleted) {
                    progressBar.setValue(percentCompleted);
                    progressBar.setString(percentCompleted + "%");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createApplicationWindow() {
        UIManager.LookAndFeelInfo[] info;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = env.getDefaultScreenDevice();
        GraphicsConfiguration cfg = gs.getDefaultConfiguration();
        Rectangle rect = cfg.getBounds();
        Point pt = new Point((int)rect.getCenterX(), (int)rect.getCenterY());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        for (UIManager.LookAndFeelInfo i : info = UIManager.getInstalledLookAndFeels()) {
            if (!i.getName().equals("GTK+")) continue;
            try {
                UIManager.setLookAndFeel(i.getClassName());
            }
            catch (Exception discard) {
                // empty catch block
            }
        }
        this.app = new JFrame("Signiant Pass Phrase Decryptor", cfg);
        this.app.setDefaultCloseOperation(3);
        this.root = this.app;
        Container base = this.app.getContentPane();
        SpringLayout layout = new SpringLayout();
        base.setLayout(layout);
        this.createDecryptionPanel(base, layout);
        this.app.pack();
        pt.x -= this.app.getWidth() / 2;
        pt.y -= this.app.getHeight() / 2;
        this.app.setLocation(pt.x, pt.y);
        this.app.setVisible(true);
    }

    public void close() {
        this.dlg.setVisible(false);
    }

    public static void main(String[] args) {
        final DecryptionApplication application = new DecryptionApplication();
        if (SwingUtilities.isEventDispatchThread()) {
            application.createApplicationWindow();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        application.createApplicationWindow();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doDialog() {
        this.dlg.setVisible(true);
    }
}

