/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.decryptionapi;

import com.signiant.decryptionapi.PassPhrase;
import com.signiant.decryptionapi.ProgressUpdate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DecryptionApplet
extends JApplet {
    private static final long serialVersionUID = -3005436336820783407L;
    private JLabel fileToDecryptLabel;
    private JTextField fileToDecrypt;
    private JButton browse;
    private JLabel passwordLabel;
    private JTextField password;
    private JButton decrypt;
    private JProgressBar progress;

    public void init() {
        UIManager.LookAndFeelInfo[] info;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        for (UIManager.LookAndFeelInfo i : info = UIManager.getInstalledLookAndFeels()) {
            if (!i.getName().equals("GTK+")) continue;
            try {
                UIManager.setLookAndFeel(i.getClassName());
            }
            catch (Exception discard) {
                // empty catch block
            }
        }
        SpringLayout sl = new SpringLayout();
        this.setLayout(sl);
        this.fileToDecryptLabel = new JLabel("File to decrypt");
        this.add(this.fileToDecryptLabel);
        this.fileToDecrypt = new JTextField(60);
        this.add(this.fileToDecrypt);
        this.fileToDecryptLabel.setLabelFor(this.fileToDecrypt);
        this.browse = new JButton("Browse ...");
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle("File To Decrypt");
                fc.setFileSelectionMode(0);
                String value = "";
                File fld = null;
                if (value != null) {
                    fld = new File(value);
                }
                if (fld != null && fld.exists()) {
                    fc.setCurrentDirectory(fld.getParentFile());
                    fc.setSelectedFile(fld);
                }
                if (fc.showOpenDialog(DecryptionApplet.this) != 0) {
                    return;
                }
                fld = fc.getSelectedFile();
                value = fld.getAbsolutePath();
                DecryptionApplet.this.fileToDecrypt.setText(value);
                DecryptionApplet.this.decrypt.setEnabled(true);
            }
        });
        this.add(this.browse);
        this.passwordLabel = new JLabel("Pass Phrase");
        this.add(this.passwordLabel);
        this.password = new JTextField(60);
        this.passwordLabel.setLabelFor(this.password);
        this.add(this.password);
        this.decrypt = new JButton("Decrypt");
        this.decrypt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DecryptionApplet.this.decrypt.setEnabled(false);
                DecryptionApplet.this.decrypt();
            }
        });
        this.add(this.decrypt);
        this.progress = new JProgressBar();
        this.add(this.progress);
        sl.putConstraint("West", (Component)this.fileToDecryptLabel, 8, "West", (Component)this);
        sl.putConstraint("North", (Component)this.fileToDecryptLabel, 8, "North", (Component)this);
        sl.putConstraint("West", (Component)this.fileToDecrypt, 8, "East", (Component)this.fileToDecryptLabel);
        sl.putConstraint("West", (Component)this.browse, 8, "East", (Component)this.fileToDecrypt);
        sl.putConstraint("East", (Component)this, 8, "East", (Component)this.browse);
        sl.putConstraint("North", (Component)this.passwordLabel, 12, "South", (Component)this.fileToDecrypt);
        sl.putConstraint("West", (Component)this.passwordLabel, 8, "West", (Component)this);
        sl.putConstraint("North", (Component)this.password, 8, "South", (Component)this.fileToDecrypt);
        sl.putConstraint("West", (Component)this.password, 0, "West", (Component)this.fileToDecrypt);
        sl.putConstraint("North", (Component)this.decrypt, 0, "North", (Component)this.password);
        sl.putConstraint("East", (Component)this.decrypt, 0, "East", (Component)this.browse);
        sl.putConstraint("West", (Component)this.decrypt, 0, "West", (Component)this.browse);
        sl.putConstraint("North", (Component)this.progress, 8, "South", (Component)this.password);
        sl.putConstraint("West", (Component)this.progress, 8, "West", (Component)this);
        sl.putConstraint("East", (Component)this.progress, -8, "East", (Component)this);
        sl.putConstraint("South", (Component)this, 8, "South", (Component)this.progress);
        sl.layoutContainer(this);
        this.progress.setValue(0);
        this.progress.setString("--");
        this.fileToDecrypt.requestFocus();
    }

    private void decrypt() {
        Thread decryptor = new Thread(){

            public void run() {
                try {
                    PassPhrase.decrypt(DecryptionApplet.this.fileToDecrypt.getText(), DecryptionApplet.this.password.getText(), new ProgressUpdate(){

                        public void cryptProgress(long bytesConverted, long totalToConvert, final int percentCompleted) {
                            Runnable updator = new Runnable(){

                                public void run() {
                                    DecryptionApplet.this.progress.setValue(percentCompleted);
                                    DecryptionApplet.this.progress.setString(percentCompleted + "%");
                                }
                            };
                            SwingUtilities.invokeLater(updator);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        decryptor.start();
    }
}

