/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestTransfer
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestTransfer.java,v 1.13 2007/04/21 04:14:12 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestTransfer;

    protected String getLogName() {
        return "TestTransfer.log";
    }

    public void testTransferBinary() throws Exception {
        this.log.info("testTransferBinary()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, filename);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (IOException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        this.assertIdentical(String.valueOf(this.localDataDir) + this.localBinaryFile, String.valueOf(this.localDataDir) + filename);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testTransferUnique() throws Exception {
        this.log.info("testTransferUnique()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, null);
        this.log.info("Put file to '" + filename + "'");
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (IOException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        this.assertIdentical(String.valueOf(this.localDataDir) + this.localBinaryFile, String.valueOf(this.localDataDir) + filename);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testNoLocalFilename() throws Exception {
        this.log.info("testNoLocalFilename()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, filename);
        this.log.info("Put file to '" + filename + "'");
        this.ftp.get(this.localDataDir, filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (IOException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        this.assertIdentical(String.valueOf(this.localDataDir) + this.localBinaryFile, String.valueOf(this.localDataDir) + filename);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testTransferText() throws Exception {
        this.log.info("testTransferText()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.ASCII);
        String filename = this.generateRandomFilename();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localTextFile, filename);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (IOException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        this.assertIdentical(String.valueOf(this.localDataDir) + this.localTextFile, String.valueOf(this.localDataDir) + filename);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testTransferUnixText() throws Exception {
        this.log.info("testTransferUnixText()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.ASCII);
        String filename = this.generateRandomFilename();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localUnixTextFile, filename);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.assertIdentical(String.valueOf(this.localDataDir) + this.localTextFile, String.valueOf(this.localDataDir) + filename);
        this.ftp.delete(filename);
        try {
            this.ftp.modtime(filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (IOException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testGetBytes() throws Exception {
        this.log.info("testGetBytes()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename1 = this.generateRandomFilename();
        this.ftp.get(String.valueOf(this.localDataDir) + filename1, this.remoteBinaryFile);
        File file1 = new File(String.valueOf(this.localDataDir) + filename1);
        long len = file1.length();
        byte[] result = this.ftp.get(this.remoteBinaryFile);
        Assert.assertTrue(((long)result.length == len ? 1 : 0) != 0);
        String filename2 = this.generateRandomFilename();
        this.ftp.put(result, filename2);
        this.ftp.get(String.valueOf(this.localDataDir) + filename2, filename2);
        this.ftp.delete(filename2);
        File file2 = new File(String.valueOf(this.localDataDir) + filename2);
        this.assertIdentical(file1, file2);
        file1.delete();
        file2.delete();
        this.ftp.quit();
    }

    public void testTransferStream() throws Exception {
        this.log.info("testTransferStream()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.ftp.get(out, this.remoteBinaryFile);
        byte[] result1 = out.toByteArray();
        String filename = this.generateRandomFilename();
        this.ftp.put(new ByteArrayInputStream(result1), filename);
        byte[] result2 = this.ftp.get(filename);
        this.ftp.delete(filename);
        this.assertIdentical(result1, result2);
        this.ftp.quit();
    }

    public void testPutAppend() throws Exception {
        this.log.info("testPutAppend()");
        this.connect();
        this.ftp.setProgressMonitor(new TestProgressMonitor(), 250000L);
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, filename);
        int count = 1;
        this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, filename, true);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.ftp.delete(filename);
        File file1 = new File(String.valueOf(this.localDataDir) + this.localBinaryFile);
        File file2 = new File(String.valueOf(this.localDataDir) + filename);
        Assert.assertTrue((file1.length() * (long)(++count) == file2.length() ? 1 : 0) != 0);
        this.log.info(String.valueOf(this.localBinaryFile) + " length=" + file1.length() + ", " + filename + " length=" + file2.length());
        file2.delete();
        this.ftp.quit();
    }

    public void testTransferEmpty() throws Exception {
        this.log.info("testTransferEmpty()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.get(String.valueOf(this.localDataDir) + this.remoteEmptyFile, this.remoteEmptyFile);
        File empty = new File(String.valueOf(this.localDataDir) + this.remoteEmptyFile);
        Assert.assertTrue((boolean)empty.exists());
        Assert.assertTrue((empty.length() == 0L ? 1 : 0) != 0);
        empty.delete();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localEmptyFile, this.localEmptyFile);
        String filename = this.generateRandomFilename();
        this.ftp.get(String.valueOf(this.localDataDir) + filename, this.localEmptyFile);
        empty = new File(String.valueOf(this.localDataDir) + filename);
        Assert.assertTrue((boolean)empty.exists());
        Assert.assertTrue((empty.length() == 0L ? 1 : 0) != 0);
        empty.delete();
        this.ftp.delete(this.localEmptyFile);
        this.ftp.quit();
    }

    public void testTransferNonExistent() throws Exception {
        this.log.info("testTransferNonExistent()");
        this.connect();
        this.ftp.chdir(this.testdir);
        String filename = this.generateRandomFilename();
        this.log.info("Getting non-existent file: " + filename);
        try {
            this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (IOException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        catch (FTPException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        File file = new File(String.valueOf(this.localDataDir) + filename);
        Assert.assertFalse((boolean)file.exists());
        filename = this.generateRandomFilename();
        try {
            this.ftp.put(String.valueOf(this.localDataDir) + filename, filename);
            Assert.fail((String)(String.valueOf(filename) + " should not be found"));
        }
        catch (FileNotFoundException ex) {
            this.log.info("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestTransfer != null ? class$com$enterprisedt$net$ftp$test$TestTransfer : (class$com$enterprisedt$net$ftp$test$TestTransfer = TestTransfer.class$("com.enterprisedt.net.ftp.test.TestTransfer")));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestTransfer.suite());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public class TestProgressMonitor
    implements FTPProgressMonitor {
        public void bytesTransferred(long count) {
            TestTransfer.this.log.info(String.valueOf(count) + " bytes transferred");
        }

        public TestProgressMonitor() {
            TestTransfer.this = TestTransfer.this;
        }
    }
}

