/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListings
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestListings.java,v 1.12 2007-08-09 00:10:52 hans Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestListings;

    protected String getLogName() {
        return "TestListings.log";
    }

    public void testDir() throws Exception {
        block2: {
            this.log.debug("testDir() - ENTRY");
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir();
            this.print(list);
            list = this.ftp.dir(".");
            this.print(list);
            this.log.debug("Testing for empty dir: " + this.remoteEmptyDir);
            list = this.ftp.dir(this.remoteEmptyDir);
            this.print(list);
            this.log.debug("End testing for empty dir");
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block2;
                Assert.fail((String)("dir(" + randomName + ") should throw 450/550 for non-existent dir"));
            }
        }
        this.ftp.quit();
        this.log.debug("testDir() - EXIT");
    }

    public void testDirFull() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir(".", true);
            this.print(list);
            this.log.debug("******* dirDetails *******");
            FTPFile[] files = this.ftp.dirDetails(".");
            this.print(files);
            this.log.debug("******* end dirDetails *******");
            this.log.debug("Testing for empty dir: " + this.remoteEmptyDir);
            list = this.ftp.dir(this.remoteEmptyDir, true);
            this.print(list);
            this.log.debug("End testing for empty dir");
            String randomName = this.generateRandomFilename();
            this.log.debug("Testing for non-existent dir: " + randomName);
            try {
                list = this.ftp.dir(randomName, true);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 450 || ex.getReplyCode() == 2) break block2;
                Assert.fail((String)("dir(" + randomName + ") should throw 450/550/2 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestListings != null ? class$com$enterprisedt$net$ftp$test$TestListings : (class$com$enterprisedt$net$ftp$test$TestListings = TestListings.class$("com.enterprisedt.net.ftp.test.TestListings")));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestListings.suite());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

