/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.text.SimpleDateFormat;
import java.util.Date;

public class FTPFile {
    protected static final String cvsId = "@(#)$Id: FTPFile.java,v 1.17 2007-10-12 05:21:29 bruceb Exp $";
    public static final int UNKNOWN = -1;
    public static final int WINDOWS = 0;
    public static final int UNIX = 1;
    public static final int VMS = 2;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    private int type;
    protected boolean isLink = false;
    protected int linkCount = 1;
    protected String permissions;
    protected boolean isDir = false;
    protected long size;
    protected String name;
    protected String linkedname;
    protected String owner;
    protected String group;
    protected Date lastModified;
    protected Date created;
    protected String raw;
    protected String path;
    private FTPFile[] children;

    public FTPFile(int type, String raw, String name, long size, boolean isDir, Date lastModified) {
        this(raw);
        this.type = type;
        this.name = name;
        this.size = size;
        this.isDir = isDir;
        this.lastModified = lastModified;
    }

    public FTPFile(String raw, String name, long size, boolean isDir, Date lastModified) {
        this(raw);
        this.type = -1;
        this.name = name;
        this.size = size;
        this.isDir = isDir;
        this.lastModified = lastModified;
    }

    public FTPFile(String raw) {
        this.raw = raw;
    }

    public FTPFile[] listFiles() {
        return this.children;
    }

    void setChildren(FTPFile[] children) {
        this.children = children;
    }

    public int getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public Date created() {
        return this.created;
    }

    public void setCreated(Date date) {
        this.created = date;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRaw() {
        return this.raw;
    }

    public long size() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public int getLinkCount() {
        return this.linkCount;
    }

    public String getLinkedname() {
        return this.linkedname;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setDir(boolean isDir) {
        this.isDir = isDir;
    }

    public void setLink(boolean isLink) {
        this.isLink = isLink;
    }

    public void setLinkedName(String linkedname) {
        this.linkedname = linkedname;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setLinkCount(int linkCount) {
        this.linkCount = linkCount;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.raw);
        buf.append("Name=").append(this.name).append(",").append("Size=").append(this.size).append(",").append("Permissions=").append(this.permissions).append(",").append("Owner=").append(this.owner).append(",").append("Group=").append(this.group).append(",").append("Is link=").append(this.isLink).append(",").append("Link count=").append(this.linkCount).append(".").append("Is dir=").append(this.isDir).append(",").append("Linked name=").append(this.linkedname).append(",").append("Last modified=").append(this.lastModified != null ? formatter.format(this.lastModified) : "null");
        if (this.created != null) {
            buf.append(",").append("Created=").append(formatter.format(this.created));
        }
        return buf.toString();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

