/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XMLUtil {
    public static String convertCharacterToXML(char character) {
        if (character == '<') {
            return "&lt;";
        }
        if (character == '>') {
            return "&gt;";
        }
        if (character == '&') {
            return "&amp;";
        }
        if (character == '\'') {
            return "&apos;";
        }
        if (character >= '\u0080') {
            char conversion = character;
            return "&#" + conversion + ';';
        }
        if (character == '\"') {
            return "&quot;";
        }
        return String.valueOf(character);
    }

    public static String convertStringToXML(String string) {
        StringBuilder builder = new StringBuilder();
        int length = string.length();
        for (int index = 0; index < length; ++index) {
            char character = string.charAt(index);
            String convertedCharacter = XMLUtil.convertCharacterToXML(character);
            builder.append(convertedCharacter);
        }
        return builder.toString();
    }

    public static void generateXML(Map<String, ? extends Object> map, PrintStream printStream) {
        XMLUtil.generateXML(map, printStream, "");
    }

    public static void generateXMLElement(Object element, PrintStream printStream, String prefix) {
        if (element instanceof Map) {
            XMLUtil.generateXML((Map)element, printStream, prefix);
            return;
        }
        if (element instanceof List) {
            XMLUtil.generateXML((List)element, printStream, prefix);
            return;
        }
        String output = XMLUtil.convertStringToXML(element.toString());
        printStream.println(prefix + "<string>" + output + "</string>");
    }

    public static void generateXML(Map<String, ? extends Object> map, PrintStream printStream, String prefix) {
        printStream.println(prefix + "<dict>");
        ArrayList<String> sortedKeys = new ArrayList<String>(map.keySet());
        Collections.sort(sortedKeys);
        for (Object e : sortedKeys) {
            Object value = map.get(e);
            printStream.println(prefix + "\t<key>" + XMLUtil.convertStringToXML(e.toString()) + "</key>");
            XMLUtil.generateXMLElement(value, printStream, prefix + "\t");
        }
        printStream.println(prefix + "</dict>");
    }

    public static void generateXML(List<? extends Object> list, PrintStream printStream, String prefix) {
        printStream.println(prefix + "<array>");
        for (Object object : list) {
            XMLUtil.generateXMLElement(object, printStream, prefix + "\t");
        }
        printStream.println(prefix + "</array>");
    }

    public static XMLTag generateLogTagAndAddToParent(Logger.Level level, String message, XMLTag parent) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent argument cannot be null.");
        }
        XMLTag logTag = XMLUtil.logTag(-1, level, message, 0, null);
        parent.addChildTag(logTag);
        return logTag;
    }

    public static XMLTag generateLogTag(int indentLevel, Logger.Level level, String message) {
        return XMLUtil.logTag(indentLevel, level, message, 0, null);
    }

    public static XMLTag logTag(int indentLevel, Logger.Level level, String message, int errorCode, String stackTrace) {
        XMLTag tag = new XMLTag("log", indentLevel);
        if (level != null) {
            tag.addAttribute("level", level.toString().toLowerCase());
        }
        if (message != null) {
            tag.addChildTag("message").setText(message);
        }
        if (errorCode != 0) {
            tag.addChildTag("error_code").setText(String.valueOf(errorCode));
        }
        if (stackTrace != null) {
            tag.addChildTag("exception").setText(stackTrace);
        }
        return tag;
    }

    public static class XMLTag {
        private static final String TABS = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
        private String name;
        private int indentLevel;
        private Map<String, String> attributes = new LinkedHashMap<String, String>();
        private List children = new ArrayList();

        public XMLTag(String name) {
            this(name, 0);
        }

        public XMLTag(String name, int indentLevel) {
            this.name = name;
            this.indentLevel = indentLevel;
        }

        public XMLTag setIndentLevel(int indentLevel) {
            this.indentLevel = indentLevel;
            for (Object child : this.children) {
                if (!(child instanceof XMLTag)) continue;
                ((XMLTag)child).setIndentLevel(indentLevel + 1);
            }
            return this;
        }

        public XMLTag addAttribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public XMLTag addChildTag(String name) {
            XMLTag child = new XMLTag(name, this.indentLevel + 1);
            this.children.add(child);
            return child;
        }

        public XMLTag addChildTag(XMLTag child) {
            this.children.add(child);
            child.setIndentLevel(this.indentLevel + 1);
            return child;
        }

        public void setText(String text) {
            this.children.add(XMLUtil.convertStringToXML(text));
        }

        public void setCDATA(String cdata) {
            this.children.add("<![CDATA[" + cdata + "]]>");
        }

        public void addList(List list) {
            this.children.add(list);
        }

        public void addMap(Map map) {
            this.children.add(map);
        }

        public String marshall() {
            StringBuilder buf = new StringBuilder();
            String tab = TABS.substring(0, this.indentLevel);
            buf.append(tab).append("<").append(this.name);
            for (String key : this.attributes.keySet()) {
                buf.append(" ").append(key).append("=\"").append(this.attributes.get(key)).append("\"");
            }
            if (this.children.isEmpty()) {
                buf.append("/>\n");
            } else {
                buf.append(">\n");
                for (String child : this.children) {
                    ByteArrayOutputStream baos;
                    if (child instanceof XMLTag) {
                        buf.append(((XMLTag)((Object)child)).marshall());
                        continue;
                    }
                    if (child instanceof String) {
                        buf.append(tab).append("\t").append(child.toString()).append("\n");
                        continue;
                    }
                    if (child instanceof Map) {
                        baos = new ByteArrayOutputStream();
                        XMLUtil.generateXML((Map)((Object)child), new PrintStream(baos), TABS.substring(0, this.indentLevel + 1));
                        buf.append(new String(baos.toByteArray()));
                        continue;
                    }
                    if (child instanceof List) {
                        baos = new ByteArrayOutputStream();
                        XMLUtil.generateXML((List)((Object)child), new PrintStream(baos), TABS.substring(0, this.indentLevel + 1));
                        buf.append(new String(baos.toByteArray()));
                        continue;
                    }
                    Logger.warn("cannot process xml child object " + child + "; skipping");
                }
                buf.append(tab).append("</").append(this.name).append(">\n");
            }
            return buf.toString();
        }
    }
}

