/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.Application;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.transport.TransportConnectionSpec;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportPod;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.UnknownTransportException;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public class TransportUtil {
    private static final String DARWIN_OS = "darwin";
    private static Map<String, Long> uploadingFilesAndBytesSent;
    private static Map<TransportType, List<String>> transportToFailedDiagnosticHosts;
    private static Map transportDiscoveryResults;

    public static void postFileUploadSucceededNotification(ITMSPackage pkg, File oneFile) {
        Long anObj;
        if (oneFile == null || !oneFile.exists()) {
            return;
        }
        if (uploadingFilesAndBytesSent != null && (anObj = uploadingFilesAndBytesSent.remove(oneFile.getName())) == null) {
            anObj = uploadingFilesAndBytesSent.remove(oneFile.getPath());
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        Notification notification = new Notification("FileInPackageUploadSucceeded", oneFile);
        notification.getUserInfo().put("Package", pkg);
        defaultCenter.postNotification(notification);
    }

    public static void postPreparingToUploadFilesNotification(List<File> filesToUpload, ITMSPackage aPackage, boolean isResumedUpload, boolean isRetry) {
        if (filesToUpload == null || filesToUpload.size() == 0) {
            return;
        }
        uploadingFilesAndBytesSent = null;
        Notification notification = new Notification("PreparingToUploadFilesInPackage", filesToUpload);
        Map<String, Object> userInfo = notification.getUserInfo();
        userInfo.put("IsResumedUpload", new Boolean(isResumedUpload));
        userInfo.put("IsRetry", new Boolean(isRetry));
        if (aPackage != null) {
            userInfo.put("Package", aPackage);
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.postNotification(notification);
    }

    public static void postFinishedUploadOfFilesNotification(Map uploadedFileInfo, ITMSPackage aPackage) {
        uploadingFilesAndBytesSent = null;
        Notification notification = new Notification("FinishedUploadOfFilesInPackage", uploadedFileInfo);
        if (aPackage != null) {
            Map<String, Object> userInfo = notification.getUserInfo();
            userInfo.put("Package", aPackage);
        }
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.postNotification(notification);
    }

    public static void postTotalBytesWrittenToServerNotification(long bytesWritten) {
        Notification notification = new Notification("TotalBytesWrittenToServer", new Long(bytesWritten));
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.postNotification(notification);
    }

    public static void postFileHasBeenPartiallyUploadedNotification(String fileName, long bytesWritten, long fileSize) {
        Long storedBytesWritten;
        if (fileName == null || fileName.trim().length() == 0) {
            return;
        }
        if (uploadingFilesAndBytesSent == null) {
            uploadingFilesAndBytesSent = new HashMap<String, Long>();
        }
        if ((storedBytesWritten = uploadingFilesAndBytesSent.get(fileName)) != null && storedBytesWritten == bytesWritten) {
            return;
        }
        uploadingFilesAndBytesSent.put(fileName, bytesWritten);
        Notification notification = new Notification("FileHasBeenPartiallyUploaded", fileName);
        Map<String, Object> userInfo = notification.getUserInfo();
        userInfo.put("BytesWritten", new Long(bytesWritten));
        userInfo.put("FileSize", new Long(fileSize));
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.postNotification(notification);
    }

    public static void postFileChunkHasBeenUploadedNotification(String fileName, long chunkSize, long fileSize, TransportType transportType) {
        if (fileName == null || fileName.trim().length() == 0 || chunkSize == 0L || fileSize == 0L) {
            return;
        }
        if (uploadingFilesAndBytesSent == null) {
            uploadingFilesAndBytesSent = new HashMap<String, Long>();
        }
        Long previouslyUploadedBytes = uploadingFilesAndBytesSent.get(fileName);
        if (transportType.isSigniant() && previouslyUploadedBytes != null && chunkSize == fileSize && fileSize == previouslyUploadedBytes) {
            previouslyUploadedBytes = new Long(0L);
            uploadingFilesAndBytesSent.put(fileName, previouslyUploadedBytes);
        }
        Long bytesUploadedSoFar = null;
        if (previouslyUploadedBytes == null) {
            bytesUploadedSoFar = new Long(chunkSize);
        } else {
            long sum = previouslyUploadedBytes + chunkSize;
            bytesUploadedSoFar = new Long(sum);
        }
        TransportUtil.postFileHasBeenPartiallyUploadedNotification(fileName, bytesUploadedSoFar, fileSize);
    }

    public static String remoteFilePath(String folderPath, String newPackageName, TransportType transportType) {
        if (folderPath == null || folderPath.length() == 0) {
            return null;
        }
        if (newPackageName == null || newPackageName.trim().length() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(folderPath);
        if (!folderPath.endsWith("/") && !folderPath.endsWith("\\")) {
            result.append('/');
        }
        if (newPackageName.startsWith("/")) {
            newPackageName = newPackageName.substring(1, newPackageName.length());
        }
        result.append(newPackageName);
        if (transportType.isDAV() && result.charAt(result.length() - 1) != '/') {
            result.append('/');
            Logger.extreme("A trailing slash was added to the remote path: " + result);
        }
        return result.toString();
    }

    public static String remoteFilePath(String transportArea, String username, String folderPath, String newPackageName) {
        if (folderPath == null || folderPath.trim().length() == 0) {
            return null;
        }
        if (newPackageName == null || newPackageName.trim().length() == 0) {
            return null;
        }
        if (username == null || username.trim().length() == 0) {
            return null;
        }
        String path = transportArea == null || transportArea.length() == 0 ? "" : (transportArea.endsWith("/") || transportArea.endsWith("\\") ? transportArea.trim() + username.trim() : transportArea.trim() + "/" + username.trim());
        if (!folderPath.startsWith("/") && !folderPath.startsWith("\\")) {
            path = path + "/";
        }
        path = folderPath.endsWith("/") || folderPath.endsWith("\\") ? path + folderPath.trim() + newPackageName.trim() : path + folderPath.trim() + "/" + newPackageName.trim();
        return path;
    }

    private static TransportConnectionSpec lookupTransportHostsAndPort(TransportType transportName) {
        Object[] hosts;
        if (transportName == null) {
            transportName = TransportType.DAV;
        }
        if (transportDiscoveryResults != null && (hosts = (Object[])transportDiscoveryResults.get("TransportHosts." + transportName.toString())) != null) {
            HashSet<String> hostSet = new HashSet<String>();
            HashSet<Integer> portSet = new HashSet<Integer>();
            for (Object host : hosts) {
                String s = (String)host;
                String[] split = s.split(":");
                if (split.length > 0) {
                    hostSet.add(split[0]);
                }
                if (split.length <= 1) continue;
                portSet.add(Integer.parseInt(split[1]));
            }
            return new TransportConnectionSpec(hostSet.toArray(new String[hostSet.size()]), ArrayUtils.toPrimitive((Integer[])portSet.toArray(new Integer[portSet.size()]), (int)-1), new int[0]);
        }
        String prefix = "transport." + (Object)((Object)transportName) + ".";
        String hosts2 = System.getProperty(prefix + "hosts");
        String tcpPorts = System.getProperty(prefix + "tcpPorts");
        String udpPorts = System.getProperty(prefix + "udpPorts");
        TransportConnectionSpec result = new TransportConnectionSpec(hosts2, tcpPorts, udpPorts);
        return result;
    }

    public static List<String> failedDiagnosticHostsForTransport(TransportType name) {
        List<String> result = transportToFailedDiagnosticHosts.get((Object)name);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static boolean performUnauthenticatedDiagnostic(TransportType transportName, boolean allMustSucceed) {
        Logger.info("Performing transport diagnostic test ...");
        TransportConnectionSpec spec = TransportUtil.lookupTransportHostsAndPort(transportName);
        List<String> gatherHosts = Arrays.asList(spec.getHosts());
        int[] tcpPorts = spec.getTcpPorts();
        int[] udpPorts = spec.getUdpPorts();
        String diagnosticHostOverride = System.getProperty("diagnosticHost");
        String diagnosticPortOverride = System.getProperty("diagnosticPort");
        if (diagnosticHostOverride != null && diagnosticHostOverride.length() > 0) {
            gatherHosts = Arrays.asList(diagnosticHostOverride);
        }
        if (diagnosticPortOverride != null && diagnosticPortOverride.length() > 0) {
            try {
                tcpPorts = new int[]{new Integer(diagnosticPortOverride)};
                udpPorts = new int[]{};
            }
            catch (Throwable t) {
                Logger.error("Could not convert the diagnosticPort value (" + diagnosticPortOverride + ") to an int.", t);
                return false;
            }
        }
        boolean success = true;
        if (!gatherHosts.isEmpty()) {
            Logger.debug("Testing available hosts...");
            ArrayList<String> failedHosts = new ArrayList<String>();
            for (String host : gatherHosts) {
                for (int port : tcpPorts) {
                    if (!TransportUtil.testHostAndPort(host, port, true)) {
                        if (allMustSucceed) {
                            success = false;
                        }
                        failedHosts.add(host);
                        continue;
                    }
                    if (!allMustSucceed) break;
                }
                for (int port : udpPorts) {
                    if (!TransportUtil.testHostAndPort(host, port, false)) {
                        if (allMustSucceed) {
                            success = false;
                        }
                        failedHosts.add(host);
                        continue;
                    }
                    if (!allMustSucceed) break;
                }
                if (!success || allMustSucceed) continue;
                break;
            }
            if (gatherHosts.size() == failedHosts.size()) {
                success = false;
            }
            transportToFailedDiagnosticHosts.put(transportName, failedHosts);
        } else {
            success = false;
            Logger.error("Unable to obtain diagnostic mode configuration from local or remote sources.");
        }
        Logger.info("Done performing transport diagnostic test.");
        return success;
    }

    public static boolean performDiagnostic(TransportPod pod) {
        Logger.info("Performing transport diagnostic test ...");
        List<String> gatherHosts = pod.getServerNames();
        Number tcpPort = pod.getPort();
        String diagnosticHostOverride = System.getProperty("diagnosticHost");
        String diagnosticPortOverride = System.getProperty("diagnosticPort");
        if (diagnosticHostOverride != null && diagnosticHostOverride.length() > 0) {
            gatherHosts = Arrays.asList(diagnosticHostOverride);
        }
        if (diagnosticPortOverride != null && diagnosticPortOverride.length() > 0) {
            try {
                tcpPort = new Integer(diagnosticPortOverride);
            }
            catch (Throwable t) {
                Logger.error("Could not convert the diagnosticPort value (" + diagnosticPortOverride + ") to an int.", t);
                return false;
            }
        }
        boolean returnValue = true;
        if (!gatherHosts.isEmpty()) {
            Logger.debug("Testing available hosts...");
            if (tcpPort != null) {
                gatherHosts = new ArrayList<String>(gatherHosts);
                List<String> failedHosts = transportToFailedDiagnosticHosts.get((Object)pod.getType());
                if (failedHosts == null) {
                    failedHosts = new ArrayList<String>();
                    transportToFailedDiagnosticHosts.put(pod.getType(), failedHosts);
                }
                Random random = new Random();
                while (!gatherHosts.isEmpty()) {
                    int hostIndex = random.nextInt(gatherHosts.size());
                    String host = gatherHosts.remove(hostIndex);
                    if (!TransportUtil.testHostAndPort(host, tcpPort.intValue(), true)) {
                        if (!failedHosts.contains(host)) {
                            failedHosts.add(host);
                        }
                        returnValue = false;
                        continue;
                    }
                    if (failedHosts.contains(host)) {
                        failedHosts.remove(host);
                    }
                    returnValue = true;
                    break;
                }
            }
        } else {
            returnValue = false;
            Logger.error("Unable to obtain diagnostic mode configuration from local or remote sources.");
        }
        Logger.info("Done performing transport diagnostic test.");
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testHostAndPort(String host, int portNum, boolean tcp) {
        Logger.extreme("  testing host/port: " + host + "/" + portNum + (tcp ? " (tcp)" : " (udp)"));
        if (host == null || host.length() == 0) {
            return false;
        }
        String checkedHost = host;
        if (host.startsWith("http")) {
            try {
                URL transportDestinationURL = new URL(host);
                HttpURLConnection connection = (HttpURLConnection)transportDestinationURL.openConnection();
                connection.connect();
                connection.disconnect();
                return true;
            }
            catch (MalformedURLException mue) {
                Logger.error("An error occurred while connecting to the transport host " + host, mue);
                checkedHost = null;
            }
            catch (Throwable t) {
                Logger.error("An error occurred while connecting to the transport host " + host + ": " + t.getMessage());
                checkedHost = null;
            }
        }
        if (checkedHost == null) {
            return false;
        }
        boolean didSucceed = false;
        Socket socketConnection = null;
        DatagramSocket datagramSocket = null;
        boolean isDiagnosticMode = System.getProperty("m").equals("diagnostic");
        try {
            InetAddress localHost;
            if (tcp) {
                socketConnection = new Socket(checkedHost, portNum);
                socketConnection.setSoTimeout(15000);
                Logger.debug("  Connection succeeded to host " + checkedHost + " on TCP port " + portNum);
                localHost = socketConnection.getLocalAddress();
                didSucceed = true;
            } else {
                datagramSocket = new DatagramSocket();
                datagramSocket.setSoTimeout(15000);
                datagramSocket.connect(InetAddress.getByName(checkedHost), portNum);
                DatagramPacket packet = new DatagramPacket(new byte[1024], 0, 1);
                datagramSocket.send(packet);
                datagramSocket.receive(packet);
                Logger.debug("  Connection succeeded to host " + checkedHost + " on UDP port " + portNum);
                localHost = datagramSocket.getLocalAddress();
                didSucceed = true;
            }
            try {
                InetAddress.getLocalHost();
            }
            catch (UnknownHostException ex) {
                HashMap<String, Object> localhostMap = new HashMap<String, Object>(2);
                localhostMap.put("cachedLocalHost", localHost);
                localhostMap.put("cacheTime", new Long(System.currentTimeMillis()));
                try {
                    TransportUtil.setStaticFieldsOnClassWithLock(localhostMap, InetAddress.class, "cacheLock");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (SocketTimeoutException e) {
            Logger.error("Connection timed out before being able to reach host: " + checkedHost, isDiagnosticMode);
        }
        catch (UnknownHostException e) {
            Logger.error("Unknown host: " + checkedHost, isDiagnosticMode);
        }
        catch (IOException e) {
            Logger.error("An I/O error occurred while connecting to the transport host/port " + checkedHost + "/" + portNum, e, isDiagnosticMode);
        }
        catch (Throwable t) {
            Logger.error("An error occurred while connecting to the transport host/port " + checkedHost + "/" + portNum + ": " + t, t, isDiagnosticMode);
        }
        finally {
            try {
                if (socketConnection != null) {
                    socketConnection.close();
                }
                if (datagramSocket != null) {
                    datagramSocket.close();
                }
            }
            catch (IOException ioe) {
                Logger.error("Could not close the connection.", ioe);
            }
        }
        return didSucceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setStaticFieldsOnClassWithLock(Map<String, Object> newValues, Class targetClazz, String lockName) throws Exception {
        Object lock;
        try {
            Field lockField = targetClazz.getDeclaredField(lockName);
            lockField.setAccessible(true);
            lock = lockField.get(null);
        }
        catch (NoSuchFieldException ex) {
            lock = targetClazz;
        }
        Class clazz = lock;
        synchronized (clazz) {
            for (Map.Entry<String, Object> entry : newValues.entrySet()) {
                Field field = targetClazz.getDeclaredField(entry.getKey());
                if (field == null) continue;
                field.setAccessible(true);
                field.set(null, entry.getValue());
            }
        }
    }

    public static List<String> serverNamesFromAuthenticateReturnValue(Map authenticateReturnValue, TransportType transportType) {
        ArrayList<String> result = null;
        if (authenticateReturnValue == null) {
            return null;
        }
        if (transportType.isAspera() || transportType.isSigniant()) {
            Object[] serverNamesArray = (Object[])authenticateReturnValue.get(System.getProperty("transportHostsKey"));
            if (serverNamesArray == null) {
                return null;
            }
            result = new ArrayList<String>();
            for (Object serverName : serverNamesArray) {
                result.add((String)serverName);
            }
            return result;
        }
        String aServerName = (String)authenticateReturnValue.get(System.getProperty("webDavServerNameKey"));
        result = new ArrayList();
        result.add(aServerName);
        return result;
    }

    public static String folderPathFromAuthenticateReturnValue(Map authenticateReturnValue, TransportType transportType) {
        if (authenticateReturnValue == null) {
            return null;
        }
        if (transportType.isDAV()) {
            return (String)authenticateReturnValue.get(System.getProperty("webDavFolderPathKey"));
        }
        return (String)authenticateReturnValue.get(System.getProperty("transportPathKey"));
    }

    public static String newPackageNameFromAuthenticateReturnValue(Map authenticateReturnValue) {
        if (authenticateReturnValue == null) {
            return null;
        }
        return (String)authenticateReturnValue.get(System.getProperty("newPackageNameKey"));
    }

    public static String identityPPKFilePathForEmbeddedFile(String ppkFileContents) {
        try {
            File tmp = File.createTempFile("id_dsa_", "ppk");
            tmp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tmp);
            IOUtils.write((String)ppkFileContents, (OutputStream)out);
            ((OutputStream)out).close();
            return tmp.getPath();
        }
        catch (Exception e) {
            Logger.error("Failed to obtain id_dsa.ppk", e);
            throw new RuntimeException(e);
        }
    }

    public static Integer transportPortFromAuthenticateReturnValue(Map authenticateReturnValue) {
        if (authenticateReturnValue == null) {
            return null;
        }
        String port = (String)authenticateReturnValue.get(System.getProperty("transportPortKey"));
        if (port != null) {
            return new Integer(port);
        }
        return null;
    }

    public static String transportUserFromAuthenticateReturnValue(Map authenticateReturnValue) {
        if (authenticateReturnValue == null) {
            return null;
        }
        return (String)authenticateReturnValue.get(System.getProperty("transportUserKey"));
    }

    public static String transportAreaFromAuthenticateReturnValue(Map authenticateReturnValue) {
        if (authenticateReturnValue == null) {
            return null;
        }
        return (String)authenticateReturnValue.get(System.getProperty("transportAreaKey"));
    }

    public static String transportCertificateFromAuthenticateReturnValue(Map authenticateReturnValue) {
        if (authenticateReturnValue == null) {
            return null;
        }
        return (String)authenticateReturnValue.get(System.getProperty("transportCertificiateKey"));
    }

    public static String transportTokenFromAuthenticateReturnValue(Map authenticateReturnValue) {
        if (authenticateReturnValue == null) {
            return null;
        }
        return (String)authenticateReturnValue.get(System.getProperty("transportTokenKey"));
    }

    public static List<File> orderedFilesToBeUploaded(List<File> filesToUpload, ITMSPackage aPkg) throws Exception {
        if (filesToUpload == null || filesToUpload.size() == 0) {
            return null;
        }
        if (aPkg == null) {
            return filesToUpload;
        }
        HashMap<String, File> infoFiles = new HashMap<String, File>();
        HashMap<String, File> encryptedFiles = new HashMap<String, File>();
        HashMap<String, File> miscFiles = new HashMap<String, File>();
        Logger.extreme("Dividing the files into groups by their extension ...");
        for (File oneFileInPkg : filesToUpload) {
            String oneFileInPkgName = oneFileInPkg.getName();
            if (aPkg.isInfoFileName(oneFileInPkgName)) {
                infoFiles.put(oneFileInPkg.getName(), oneFileInPkg);
                continue;
            }
            if (aPkg.isEncryptedFileName(oneFileInPkgName)) {
                encryptedFiles.put(oneFileInPkg.getName(), oneFileInPkg);
                continue;
            }
            miscFiles.put(oneFileInPkg.getName(), oneFileInPkg);
        }
        Logger.extreme("\n infoFiles:\n" + infoFiles.values());
        Logger.extreme("\n encryptedFiles:\n" + encryptedFiles.values());
        Logger.extreme("\n miscFiles:\n" + miscFiles.values());
        Logger.extreme("Done dividing the files into groups by their extension.");
        ArrayList<File> orderedArray = new ArrayList<File>();
        Iterator infoFilesEnum = null;
        infoFilesEnum = infoFiles.values().iterator();
        while (infoFilesEnum != null && infoFilesEnum.hasNext()) {
            File oneInfoFileInPkg = (File)infoFilesEnum.next();
            String infoFileName = oneInfoFileInPkg.getName();
            String encryptedFileName = aPkg.encryptedFileNameForInfoFileName(infoFileName);
            File oneEncryptedFileInPkg = (File)encryptedFiles.get(encryptedFileName);
            if (oneEncryptedFileInPkg == null) {
                throw new Exception("No info file found for encrypted file: " + encryptedFileName);
            }
            orderedArray.add(oneEncryptedFileInPkg);
            orderedArray.add(oneInfoFileInPkg);
        }
        orderedArray.addAll(miscFiles.values());
        return orderedArray;
    }

    public static String destinationPathFromProperty() {
        String destOption = System.getProperty("destination");
        String destPath = "";
        File destFile = null;
        if (destOption != null && destOption.length() > 0) {
            destFile = new File(destOption);
        }
        try {
            destOption = FileUtil.absolutePathForFile(destFile);
        }
        catch (IOException ioe) {
            Logger.error("Cannot get the full destination path.", ioe);
            destOption = null;
        }
        if (destOption != null && destOption.length() > 0) {
            File aFile = new File(destOption);
            destPath = aFile.getAbsolutePath();
        }
        return destPath;
    }

    public static boolean validateDirectoryPath(String aDirPath, boolean createIfNotExists) {
        if (aDirPath == null || aDirPath.trim().length() == 0) {
            return false;
        }
        File aDir = new File(aDirPath);
        if (!aDir.exists()) {
            if (createIfNotExists) {
                boolean made = aDir.mkdirs();
                if (!made) {
                    Logger.error("The specified directory, " + aDirPath + ", does not exist and could not be created.");
                    return false;
                }
            } else {
                Logger.error("The specified directory, " + aDirPath + ", does not exist.");
                return false;
            }
        }
        if (!aDir.isDirectory()) {
            Logger.error("The specified directory, " + aDirPath + ", is not a directory.");
            return false;
        }
        if (!aDir.canWrite()) {
            Logger.error("The specified directory, " + aDirPath + ", does have not write access.");
            return false;
        }
        if (!aDir.canRead()) {
            Logger.error("The specified directory, " + aDirPath + ", does have not read access.");
            return false;
        }
        return true;
    }

    public static boolean isOSWindows() {
        String osSearchName;
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf(osSearchName = System.getProperty("osSearchNameForWindows").toLowerCase()) > -1;
    }

    public static boolean isOSMac() {
        String osSearchName;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf(osSearchName = System.getProperty("osSearchNameForMac").toLowerCase()) > -1) {
            return true;
        }
        return osName.indexOf(DARWIN_OS) > -1;
    }

    public static boolean isOSLinux() {
        String osSearchName;
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf(osSearchName = System.getProperty("osSearchNameForLinux").toLowerCase()) > -1;
    }

    public static void needToSleep(long sleepDuration, String message) {
        TransportUtil.needToSleep(sleepDuration, message, false);
    }

    public static void needToSleep(long sleepDuration, String message, boolean isQuiet) {
        try {
            if (!isQuiet) {
                Logger.extreme("Sleeping for " + sleepDuration + " ms");
            }
            Thread.sleep(sleepDuration);
            if (!isQuiet) {
                Logger.extreme("Done sleeping");
                if (null != message) {
                    Logger.debug(message);
                }
            }
        }
        catch (Throwable t) {
            Logger.extreme("Sleep operation failed.", t);
        }
    }

    public static void needToWait(Object toWaitOn, long sleepDuration, String message, boolean isQuiet) {
        try {
            if (!isQuiet) {
                Logger.extreme("Waiting for " + sleepDuration + " ms");
            }
            toWaitOn.wait(sleepDuration);
            if (!isQuiet) {
                Logger.extreme("Done waiting");
                Logger.debug(message);
            }
        }
        catch (InterruptedException t) {
            Logger.extreme("Wait operation interrupted.", t);
        }
    }

    public static String prependSpacesToStringToReachLength(String origString, int desiredLength) {
        if (origString != null && origString.length() > desiredLength) {
            throw new IllegalArgumentException("The length of the string '" + origString + "' is over the desiredLength " + desiredLength);
        }
        if (origString != null && origString.length() == desiredLength) {
            return origString;
        }
        if (origString == null && desiredLength == 0) {
            return "";
        }
        int origLength = 0;
        StringBuilder inProgressString = new StringBuilder();
        if (origString != null) {
            origLength = origString.length();
        }
        int numOfSpacesNeeded = desiredLength - origLength;
        for (int i = 0; i < numOfSpacesNeeded; ++i) {
            inProgressString.append(" ");
        }
        if (origString != null) {
            inProgressString.append(origString);
        }
        return inProgressString.toString();
    }

    public static String appendSpacesToStringToReachLength(String origString, int desiredLength) {
        if (origString != null && origString.length() > desiredLength) {
            throw new IllegalArgumentException("The length of the string '" + origString + "' is over the desiredLength " + desiredLength);
        }
        if (origString != null && origString.length() == desiredLength) {
            return origString;
        }
        if (origString == null && desiredLength == 0) {
            return "";
        }
        int origLength = 0;
        StringBuilder inProgressString = null;
        if (origString == null) {
            inProgressString = new StringBuilder();
        } else {
            origLength = origString.length();
            inProgressString = new StringBuilder(origString);
        }
        int numOfSpacesNeeded = desiredLength - origLength;
        for (int i = 0; i < numOfSpacesNeeded; ++i) {
            inProgressString.append(" ");
        }
        return inProgressString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createStubPackageForMetadata(String metadata, String searchId, String destDirPath) throws IOException {
        if (metadata == null || metadata.length() == 0) {
            return false;
        }
        if (searchId == null || searchId.length() == 0) {
            return false;
        }
        if (destDirPath == null || destDirPath.length() == 0) {
            return false;
        }
        String packageDirName = searchId + ".itmsp";
        String stubPackageDirPath = NSPathUtilities.stringByAppendingPathComponent(destDirPath, packageDirName);
        File stubPackageDir = new File(stubPackageDirPath);
        if (stubPackageDir.exists()) {
            Logger.info("The package directory " + stubPackageDirPath + " already exists so no need to create it.");
        } else {
            Logger.info("Creating the stub package directory ...");
            boolean wasDirCreated = stubPackageDir.mkdirs();
            if (!wasDirCreated) {
                Logger.error("An error occurred while creating the stub package directory: " + stubPackageDir.getPath());
                return false;
            }
            Logger.info("Created the stub package directory: " + stubPackageDir.getPath());
        }
        String metadataFilePath = NSPathUtilities.stringByAppendingPathComponent(stubPackageDirPath, "metadata.xml");
        File metadataFile = new File(metadataFilePath);
        if (metadataFile.exists()) {
            Logger.warn("The metadata file " + metadataFilePath + " already exists.  It will be overwritten.");
        }
        Logger.info("Writing out the metadata file ...");
        FileOutputStream fileOutStream = null;
        FilterOutputStream bufferedOutStream = null;
        OutputStreamWriter outStreamWriter = null;
        try {
            fileOutStream = new FileOutputStream(metadataFile);
            bufferedOutStream = new BufferedOutputStream(fileOutStream);
            outStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutStream, "UTF-8");
            outStreamWriter.write(metadata);
        }
        catch (Throwable t) {
            Logger.error("An error occurred while writing out the metadata file.", t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (outStreamWriter != null) {
                outStreamWriter.flush();
                outStreamWriter.close();
            }
            if (bufferedOutStream != null) {
                bufferedOutStream.close();
            }
            if (fileOutStream != null) {
                fileOutStream.close();
            }
        }
        Logger.info("Finished writing out the metadata file.");
        Logger.essential("The package directory is: " + stubPackageDirPath);
        return true;
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuilder out = new StringBuilder();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static Long transferTimeInMilliseconds(Date start, Date end) {
        if (start == null || end == null) {
            return null;
        }
        long milliseconds = end.getTime() - start.getTime();
        return new Long(milliseconds);
    }

    public static Long addLongValues(Long value1, Long value2) {
        if (value1 == null && value2 == null) {
            return null;
        }
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        long sum = value1 + value2;
        return new Long(sum);
    }

    public static long sizeSpecToLong(String spec) {
        if (spec == null) {
            return 0L;
        }
        if ((spec = spec.trim().toLowerCase()).endsWith("k")) {
            return Long.parseLong(spec.substring(0, spec.length() - 1)) * 1024L;
        }
        if (spec.endsWith("kb")) {
            return Long.parseLong(spec.substring(0, spec.length() - 2)) * 1024L;
        }
        if (spec.endsWith("m")) {
            return Long.parseLong(spec.substring(0, spec.length() - 1)) * 1024L * 1024L;
        }
        if (spec.endsWith("mb")) {
            return Long.parseLong(spec.substring(0, spec.length() - 2)) * 1024L * 1024L;
        }
        if (spec.endsWith("g")) {
            return Long.parseLong(spec.substring(0, spec.length() - 1)) * 1024L * 1024L * 1024L;
        }
        if (spec.endsWith("gb")) {
            return Long.parseLong(spec.substring(0, spec.length() - 2)) * 1024L * 1024L * 1024L;
        }
        return Long.parseLong(spec);
    }

    public static String longToSizeSpec(long size) {
        if (size < 1024L) {
            return String.valueOf(size);
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + "K";
        }
        return String.valueOf(size /= 1024L) + "M";
    }

    public static List<TransportType> getTransportTypes(WebService service) {
        String[] transports = TransportUtil.getPreferredTransports(service);
        if (transports == null || transports.length == 0) {
            return null;
        }
        ArrayList<TransportType> result = new ArrayList<TransportType>(transports.length);
        for (String transport : transports) {
            result.add(TransportType.valueOf(transport));
        }
        return result;
    }

    public static String[] getPreferredTransports(final WebService service) {
        ArrayList<String> result;
        block7: {
            String[] split;
            block8: {
                Object[] preferredTransports;
                result = new ArrayList<String>(3);
                if (!TransportUtil.shouldContinueAddingTransportsAfterProperties(result)) break block7;
                if (transportDiscoveryResults == null && Application.doesContainSOAPError(transportDiscoveryResults = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Map>(){

                    @Override
                    public void setNetworkIsReachable(boolean isReachable) {
                    }

                    @Override
                    public Map invoke() {
                        return service.authenticateForTransportDiscovery();
                    }
                }))) {
                    Application.displaySOAPErrorMessages(transportDiscoveryResults);
                    Logger.info("Failed to retrieve current preferred transport order; reverting to default values");
                    transportDiscoveryResults = null;
                }
                if (transportDiscoveryResults == null) break block8;
                for (Object preferredTransport : preferredTransports = (Object[])transportDiscoveryResults.get("PreferredTransports")) {
                    String t = ((String)preferredTransport).trim();
                    try {
                        if (result.contains(t) || !TransportType.valueOf(t).isChainable()) continue;
                        result.add(t);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                break block7;
            }
            String fromDefaults = System.getProperty("transport.preferred");
            if (fromDefaults == null || fromDefaults.length() <= 0) break block7;
            for (String s : split = fromDefaults.split(",")) {
                s = s.trim();
                try {
                    if (result.contains(s) || !TransportType.valueOf(s).isChainable()) continue;
                    result.add(s);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean shouldContinueAddingTransportsAfterProperties(ArrayList<String> result) {
        String[] split;
        String mode = System.getProperty("m");
        if (mode == null || !mode.equals("upload")) {
            String transport = System.getProperty("t");
            if (transport == null || transport.length() == 0) {
                transport = TransportType.DAV.name();
                System.setProperty("t", transport);
            }
            result.add(transport);
            return false;
        }
        String fromProperties = System.getProperty("t");
        if (fromProperties == null || fromProperties.length() == 0) {
            return true;
        }
        for (String s : split = fromProperties.split(",")) {
            s = s.trim();
            try {
                if (s.equals("Auto")) {
                    return true;
                }
                if (!TransportType.valueOf(s).isChainable()) {
                    result.clear();
                    result.add(s);
                    return false;
                }
                result.add(s);
            }
            catch (IllegalArgumentException unknownTransport) {
                Logger.warn("Unknown transport type: " + s);
            }
        }
        return false;
    }

    public static List<TransportType> getTransports() throws UnknownTransportException {
        ArrayList<TransportType> transports;
        block8: {
            String[] split;
            String t;
            block6: {
                block7: {
                    String[] split2;
                    t = System.getProperty("t");
                    transports = new ArrayList<TransportType>();
                    if (t != null && t.length() != 0) break block6;
                    String m = System.getProperty("m");
                    if (m == null || !m.equals("upload") && !m.equals("diagnostic")) break block7;
                    String fromDefaults = System.getProperty("transport.preferred");
                    if (fromDefaults == null || fromDefaults.length() <= 0) break block8;
                    for (String s : split2 = fromDefaults.split(",")) {
                        if (s == null) continue;
                        try {
                            transports.add(TransportType.valueOf(s.trim()));
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownTransportException(s);
                        }
                    }
                    break block8;
                }
                transports.add(TransportType.DAV);
                break block8;
            }
            for (String s : split = t.split(",")) {
                if (s == null) continue;
                try {
                    transports.add(TransportType.valueOf(s.trim()));
                }
                catch (IllegalArgumentException e) {
                    throw new UnknownTransportException(s);
                }
            }
        }
        return transports;
    }

    public static void splitDiagnosticPath(String diagnosticPath, TransportInterface transport) {
        if (diagnosticPath == null || diagnosticPath.trim().isEmpty()) {
            Logger.warn("diagnostic path is empty");
            return;
        }
        String folderPath = diagnosticPath.trim();
        while (folderPath.endsWith("/") && folderPath.length() > 1) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        int slash = folderPath.lastIndexOf(47);
        if (slash == -1) {
            Logger.warn("diagnostic path is missing a path separator");
            return;
        }
        String subdirName = folderPath.substring(slash + 1);
        folderPath = folderPath.substring(0, slash);
        transport.setNewPackageName(subdirName);
        transport.setFolderPath(folderPath);
    }

    static {
        transportToFailedDiagnosticHosts = new HashMap<TransportType, List<String>>();
        transportDiscoveryResults = null;
    }
}

