/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import java.text.NumberFormat;

public class ThroughputUtil {
    public static final long PB_BYTES = 0x4000000000000L;
    public static final long TB_BYTES = 0x10000000000L;
    public static final long GB_BYTES = 0x40000000L;
    public static final long MB_BYTES = 0x100000L;
    public static final long KB_BYTES = 1024L;

    public static String getBytesAsString(long bytes) {
        String unitString;
        long unitDivisor;
        String unitFormat = "%,.2f";
        if (bytes > 0x4000000000000L) {
            unitDivisor = 0x4000000000000L;
            unitString = "PB";
        } else if (bytes > 0x10000000000L) {
            unitDivisor = 0x10000000000L;
            unitString = "TB";
        } else if (bytes > 0x40000000L) {
            unitDivisor = 0x40000000L;
            unitString = "GB";
        } else if (bytes > 0x100000L) {
            unitDivisor = 0x100000L;
            unitString = "MB";
        } else if (bytes > 1024L) {
            unitDivisor = 1024L;
            unitString = "KB";
        } else {
            unitDivisor = 1L;
            unitFormat = "%,.0f";
            unitString = bytes == 1L ? " byte" : " bytes";
        }
        double value = (double)bytes / (double)unitDivisor;
        String numericResult = String.format(unitFormat, value);
        return numericResult + unitString;
    }

    public static String getThroughputPerSecondString(long durationMillis, long bytesTransferred) {
        if (durationMillis <= 0L) {
            return "0 bytes/sec";
        }
        long bytesPerSecond = bytesTransferred * 1000L / durationMillis;
        String perSecond = ThroughputUtil.getBytesAsString(bytesPerSecond);
        return perSecond + "/sec";
    }

    public static String getDurationMillisAsString(long durationMillis) {
        String throughputString = "0 seconds";
        if (durationMillis > 0L) {
            float deltaSecs = (float)durationMillis / 1000.0f;
            double minutes = Math.floor((double)deltaSecs / 60.0);
            double seconds = (double)deltaSecs - minutes * 60.0;
            NumberFormat numberFormatter = NumberFormat.getNumberInstance();
            numberFormatter.setMaximumFractionDigits(2);
            String minutesString = numberFormatter.format(minutes);
            String secondsString = numberFormatter.format(seconds);
            throughputString = minutesString + " minutes, " + secondsString + " seconds";
        }
        return throughputString;
    }
}

