/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.util.TransportUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class SystemUtil {
    public static long getFreePhysicalMemorySize() {
        OperatingSystemMXBean sunmxbean = SystemUtil.getOSMXBean();
        return sunmxbean.getFreePhysicalMemorySize();
    }

    public static long getTotalPhysicalMemorySize() {
        OperatingSystemMXBean sunmxbean = SystemUtil.getOSMXBean();
        return sunmxbean.getTotalPhysicalMemorySize();
    }

    public static long getFreeSwapSpaceSize() {
        OperatingSystemMXBean sunmxbean = SystemUtil.getOSMXBean();
        return sunmxbean.getFreeSwapSpaceSize();
    }

    public static long getTotalSwapSpaceSize() {
        OperatingSystemMXBean sunmxbean = SystemUtil.getOSMXBean();
        return sunmxbean.getTotalSwapSpaceSize();
    }

    private static OperatingSystemMXBean getOSMXBean() {
        java.lang.management.OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        return (OperatingSystemMXBean)mxbean;
    }

    public static String memoryStatsString() {
        try {
            Runtime runtime = Runtime.getRuntime();
            return "Memory: [JVM] " + TransportUtil.longToSizeSpec(runtime.freeMemory()) + " free, " + TransportUtil.longToSizeSpec(runtime.totalMemory()) + " total, " + TransportUtil.longToSizeSpec(runtime.maxMemory()) + " max [System] (Physical) " + TransportUtil.longToSizeSpec(SystemUtil.getFreePhysicalMemorySize()) + " free, " + TransportUtil.longToSizeSpec(SystemUtil.getTotalPhysicalMemorySize()) + " total (Swap) " + TransportUtil.longToSizeSpec(SystemUtil.getFreeSwapSpaceSize()) + " free, " + TransportUtil.longToSizeSpec(SystemUtil.getTotalSwapSpaceSize()) + " total";
        }
        catch (Exception e) {
            return "(undetermined)";
        }
    }
}

