/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;

public class StringEncryptionUtil {
    private static final String DESEDE_ENCRYPTION_SCHEME = "DESede";
    private static final String UNICODE_FORMAT = "UTF8";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;

    private static StringEncryptionUtil desedeEcnryptionInstance(String encryptionKey) throws EncryptionException {
        return new StringEncryptionUtil(DESEDE_ENCRYPTION_SCHEME, encryptionKey);
    }

    public static String desedeDecrypt(String encryptionKey, String encryptedString) throws EncryptionException {
        String decryptedString = null;
        if (encryptionKey == null || encryptionKey.length() == 0) {
            Logger.error("Invalid encryption key.");
            return null;
        }
        try {
            StringEncryptionUtil stringEncryptUtil = StringEncryptionUtil.desedeEcnryptionInstance(encryptionKey);
            decryptedString = stringEncryptUtil.decrypt(encryptedString);
        }
        catch (IllegalArgumentException ie) {
            throw ie;
        }
        catch (Throwable t) {
            decryptedString = null;
        }
        return decryptedString;
    }

    private StringEncryptionUtil(String encryptionScheme, String encryptionKey) throws EncryptionException {
        if (encryptionKey == null) {
            throw new IllegalArgumentException("encryption key was null");
        }
        if (encryptionKey.trim().length() < 24) {
            throw new IllegalArgumentException("encryption key was less than 24 characters");
        }
        try {
            byte[] keyAsBytes = encryptionKey.getBytes(UNICODE_FORMAT);
            if (!encryptionScheme.equals(DESEDE_ENCRYPTION_SCHEME)) {
                throw new IllegalArgumentException("Encryption scheme not supported: " + encryptionScheme);
            }
            this.keySpec = new DESedeKeySpec(keyAsBytes);
            this.keyFactory = SecretKeyFactory.getInstance(encryptionScheme);
            this.cipher = Cipher.getInstance(encryptionScheme);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException(e);
        }
    }

    private String decrypt(String encryptedString) throws EncryptionException {
        if (encryptedString == null || encryptedString.trim().length() <= 0) {
            throw new IllegalArgumentException("encrypted string was null or empty");
        }
        try {
            SecretKey key = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, key);
            byte[] cleartext = Base64.decodeBase64((byte[])encryptedString.getBytes("UTF-8"));
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return new String(ciphertext, UNICODE_FORMAT);
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    public static class EncryptionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EncryptionException(Throwable t) {
            super(t);
        }
    }
}

