/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import com.apple.transporter.util.CopyListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class StreamUtil {
    public static byte[] readBytes(InputStream in, CopyListener listener) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copyStream(baos, in, listener);
        return baos.toByteArray();
    }

    public static void copyStream(OutputStream os, InputStream is) throws IOException {
        StreamUtil.copyStream(os, is, null);
    }

    public static void copyStream(OutputStream os, InputStream is, CopyListener listener) throws IOException {
        int c;
        byte[] buf = new byte[4096];
        while ((c = is.read(buf)) >= 0) {
            os.write(buf, 0, c);
            if (listener == null) continue;
            try {
                listener.numberOfBytesCopied(c);
            }
            catch (Exception e) {
                Logger.error("An error occurred while notifying the listener of copy's progress.", e);
            }
        }
    }

    public static InputStream getResourceAsStream(String resourceName) {
        InputStream resource = StreamUtil.class.getClassLoader().getResourceAsStream(resourceName);
        if (resource != null) {
            return resource;
        }
        String message = "An expected configuration file was not found.  Please reinstall Transporter.";
        Logger.error(message);
        throw new IllegalStateException(message);
    }

    public static String getResourceAsString(String resourceName) throws IOException {
        InputStream in = StreamUtil.getResourceAsStream(resourceName);
        if (in != null) {
            return IOUtils.toString((InputStream)in);
        }
        return null;
    }

    public static void copyResourceToFile(String resourceName, File file) throws IOException {
        FileOutputStream out = FileUtils.openOutputStream((File)file);
        InputStream in = StreamUtil.getResourceAsStream(resourceName);
        if (in != null) {
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static String streamToString(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (String)"UTF-8");
    }

    public static String base64GzipToString(String base64Gzip) throws IOException {
        byte[] decoded = Base64.decodeBase64((byte[])base64Gzip.getBytes("utf-8"));
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(decoded));
        String result = IOUtils.toString((InputStream)gis, (String)"UTF-8");
        IOUtils.closeQuietly((InputStream)gis);
        Logger.extreme("Inflated " + base64Gzip.getBytes("utf-8").length + " bytes to " + result.getBytes("utf-8").length);
        return result;
    }

    public static boolean base64GzipToStream(String base64Gzip, OutputStream out) throws IOException {
        byte[] decoded = Base64.decodeBase64((byte[])base64Gzip.getBytes("utf-8"));
        GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(decoded));
        int count = IOUtils.copy((InputStream)gis, (OutputStream)out);
        IOUtils.closeQuietly((InputStream)gis);
        Logger.extreme("Inflated " + base64Gzip.getBytes("utf-8").length + " bytes to " + count);
        return count != -1;
    }

    public static String bytesToBase64Gzip(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        IOUtils.write((byte[])bytes, (OutputStream)gos);
        IOUtils.closeQuietly((OutputStream)gos);
        byte[] base64 = Base64.encodeBase64((byte[])baos.toByteArray());
        baos = null;
        Logger.extreme("Deflated " + bytes.length + " bytes to " + base64.length);
        return new String(base64);
    }

    public static String stringToBase64Gzip(String data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        IOUtils.write((String)data, (OutputStream)gos, (String)"UTF-8");
        IOUtils.closeQuietly((OutputStream)gos);
        byte[] base64 = Base64.encodeBase64((byte[])baos.toByteArray());
        baos = null;
        Logger.extreme("Deflated " + data.getBytes("utf-8").length + " bytes to " + base64.length);
        return new String(base64);
    }
}

