/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import java.util.HashMap;
import java.util.Map;

public class ProgressMonitor {
    public static long DEFAULT_MAXIMUM_HEARTBEAT_INTERLUDE = 600000L;
    private static final Map<Monitorable, Stats> monitorables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLoop() {
        while (true) {
            try {
                while (true) {
                    long sleepDuration = DEFAULT_MAXIMUM_HEARTBEAT_INTERLUDE;
                    long now = System.currentTimeMillis();
                    Map<Monitorable, Stats> map = monitorables;
                    synchronized (map) {
                        for (Monitorable monitorable : monitorables.keySet()) {
                            Stats stats = monitorables.get(monitorable);
                            if (now - stats.lastHearbeat > stats.interlude) {
                                monitorable.abort();
                                ProgressMonitor.stopMonitoring(monitorable);
                                continue;
                            }
                            sleepDuration = Math.min(sleepDuration, stats.lastHearbeat + stats.interlude - now);
                        }
                    }
                    Thread.sleep(sleepDuration);
                }
            }
            catch (Exception e) {
                Logger.debug("Encountered error while executing ProgressMonitor loop", e);
                continue;
            }
            break;
        }
    }

    public static void monitor(Monitorable monitorable) {
        ProgressMonitor.monitor(monitorable, DEFAULT_MAXIMUM_HEARTBEAT_INTERLUDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void monitor(Monitorable monitorable, long interlude) {
        Map<Monitorable, Stats> map = monitorables;
        synchronized (map) {
            if (monitorables.get(monitorable) != null) {
                throw new IllegalStateException("Already monitoring instance: " + monitorable);
            }
            Stats stats = new Stats(interlude);
            monitorables.put(monitorable, stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopMonitoring(Monitorable monitorable) {
        Map<Monitorable, Stats> map = monitorables;
        synchronized (map) {
            if (monitorables.get(monitorable) != null) {
                monitorables.remove(monitorable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void heartbeat(Monitorable monitorable) {
        Map<Monitorable, Stats> map = monitorables;
        synchronized (map) {
            Stats stats = monitorables.get(monitorable);
            if (stats != null) {
                stats.lastHearbeat = System.currentTimeMillis();
            }
        }
    }

    static {
        String defaultInterlude = System.getProperty("com.apple.transporter.DefaultMaximumHeartbeatInterlude");
        if (defaultInterlude != null) {
            try {
                DEFAULT_MAXIMUM_HEARTBEAT_INTERLUDE = Long.parseLong(defaultInterlude);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        monitorables = new HashMap<Monitorable, Stats>();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (DEFAULT_MAXIMUM_HEARTBEAT_INTERLUDE > 0L) {
                    ProgressMonitor.runLoop();
                }
            }
        };
        Thread thread = new Thread(r);
        thread.setName("transporter.ProgressMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    private static class Stats {
        long interlude;
        long lastHearbeat;

        private Stats(long interlude) {
            this.interlude = interlude;
            this.lastHearbeat = System.currentTimeMillis();
        }
    }

    public static interface Monitorable {
        public void abort();
    }
}

