/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import com.apple.transporter.util.TransportUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;

public class ProcUtil {
    private static final int MAXIMUM_PROCESS_LIST_WAIT_TIME_MS = 10000;

    public static int executeProcess(String ... args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            Process proc = pb.start();
            return proc.waitFor();
        }
        catch (Exception e) {
            Logger.extreme("Unable to launch process");
            return -1;
        }
    }

    public static String executeProcessAndGetStdout(String ... args) {
        String argsAsString = "";
        for (int i = 0; i < args.length; ++i) {
            argsAsString = argsAsString + args[i];
            if (i + 1 >= args.length) continue;
            argsAsString = argsAsString + " ";
        }
        Process proc = null;
        BufferedReader stdout = null;
        String stdoutString = "";
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            proc = pb.start();
            stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = stdout.readLine()) != null) {
                if (stdoutString == null) {
                    stdoutString = line;
                    continue;
                }
                stdoutString = stdoutString + line;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred executing: " + argsAsString);
        }
        finally {
            if (stdout != null) {
                try {
                    stdout.close();
                }
                catch (IOException e) {
                    Logger.extreme("Unable to close stdout");
                }
            }
            if (proc != null) {
                try {
                    proc.waitFor();
                }
                catch (InterruptedException e) {
                    Logger.extreme("Interrupted waiting for process to complete");
                }
            }
        }
        return stdoutString;
    }

    public static int getPid() {
        try {
            return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        catch (Exception e) {
            try {
                ProcessBuilder pb = new ProcessBuilder("echo", "$PPID");
                Process proc = pb.start();
                BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String pid = stdout.readLine();
                stdout.close();
                if (pid != null) {
                    return Integer.parseInt(pid);
                }
            }
            catch (Exception e1) {
                Logger.extreme("Unable to determine process ID. Using zero.");
            }
            return 0;
        }
    }

    public static boolean processExists(final int pid) {
        final boolean errorsAsWarn = !TransportUtil.isOSMac();
        Executable<Boolean> executable = new Executable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean execute() {
                Process proc = null;
                BufferedReader stdout = null;
                try {
                    String line;
                    String[] psArgs = new String[]{"ps", "-e"};
                    if (ProcUtil.isWindows()) {
                        psArgs = new String[]{"tasklist", "/fo", "csv"};
                    }
                    ProcessBuilder pb = new ProcessBuilder(psArgs);
                    proc = pb.start();
                    stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = stdout.readLine()) != null) {
                        if (line.trim().length() <= 0) continue;
                        String[] s = line.trim().split(ProcUtil.isWindows() ? "," : " ");
                        try {
                            String pidString = ProcUtil.isWindows() ? s[1].substring(1, s[1].length() - 1) : s[0];
                            int p = Integer.parseInt(pidString);
                            if (p != pid) continue;
                            Boolean bl = true;
                            return bl;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                catch (Exception e) {
                    if (errorsAsWarn) {
                        Logger.warn("exception determining if process exists", e);
                    } else {
                        Logger.debug("exception determining if process exists", e);
                    }
                }
                finally {
                    if (stdout != null) {
                        try {
                            stdout.close();
                        }
                        catch (IOException e) {
                            Logger.extreme("Unable to close stdout");
                        }
                    }
                    if (proc != null) {
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            Logger.extreme("Interrupted waiting for process to complete");
                        }
                    }
                }
                return false;
            }
        };
        Boolean result = ProcUtil.executeWithTimeout(executable, 10000L);
        return result == null ? false : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithTimeout(final Executable<T> executable, long timeout) {
        Runnable r;
        final Holder holder = new Holder();
        Runnable runnable = r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                holder.held = executable.execute();
                2 var1_1 = this;
                synchronized (var1_1) {
                    this.notify();
                }
            }
        };
        synchronized (runnable) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.start();
            try {
                if (timeout > 0L) {
                    r.wait(timeout);
                } else {
                    r.wait();
                }
            }
            catch (InterruptedException e) {
                Logger.extreme("Interrupted waiting for process to finish executing");
            }
            return holder.held;
        }
    }

    public static boolean isWindows() {
        return ProcUtil.isOS("windows");
    }

    private static boolean isOS(String os) {
        String thisOs = System.getProperty("os.name");
        return thisOs != null && (thisOs = thisOs.trim().toLowerCase()).indexOf(os.trim().toLowerCase()) != -1;
    }

    private static class Holder<T> {
        T held = null;

        private Holder() {
        }
    }

    public static interface Executable<T> {
        public T execute();
    }
}

