/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class NSPathUtilities {
    public static String _fileURLPrefix = File.pathSeparatorChar == ';' ? "file:///" : "file://";

    private NSPathUtilities() {
        throw new IllegalStateException("Can't instantiate an instance of class " + this.getClass().getName());
    }

    public static String _fileSeparatorStandardizedPath(String path) {
        if (path == null) {
            return "";
        }
        return File.separatorChar != '/' ? path.replace(File.separatorChar, '/') : path;
    }

    public static String _normalizedPath(String path) {
        if (path == null) {
            return "";
        }
        return File.separatorChar != '/' ? path.replace('/', File.separatorChar) : path;
    }

    public static String _standardizedPath(String path) {
        int pathLength;
        if (path != null && (pathLength = path.length()) > 0) {
            path = NSPathUtilities._fileSeparatorStandardizedPath(path);
            int index = path.indexOf("//");
            while (index >= 0) {
                if (index == pathLength - 1) {
                    path = path.substring(0, index);
                    break;
                }
                path = path.substring(0, index).concat(path.substring(index + 1));
                index = path.indexOf("//");
            }
            return path;
        }
        return "";
    }

    public static String pathExtension(String path) {
        String standardizedPath;
        int extensionIndex;
        int pathLength;
        if (path != null && (pathLength = path.length()) > 0 && (extensionIndex = (standardizedPath = NSPathUtilities._fileSeparatorStandardizedPath(path)).lastIndexOf(46)) >= 0) {
            int separatorIndex = standardizedPath.lastIndexOf(47);
            int lastIndex = pathLength - 1;
            int substringIndex = pathLength;
            if (separatorIndex == lastIndex) {
                separatorIndex = standardizedPath.lastIndexOf(47, lastIndex - 1);
                substringIndex = lastIndex;
            }
            if ((separatorIndex < 0 || extensionIndex > separatorIndex) && extensionIndex < pathLength - 1) {
                return standardizedPath.substring(extensionIndex + 1, substringIndex);
            }
        }
        return "";
    }

    public static String lastPathComponent(String path) {
        int lastIndex;
        String pathComponent = path;
        if (path == null) {
            return "";
        }
        int pathLength = path.length();
        if (pathLength == 0) {
            return "";
        }
        String standardizedPath = NSPathUtilities._fileSeparatorStandardizedPath(path);
        int separatorIndex = standardizedPath.lastIndexOf(47);
        if (separatorIndex == (lastIndex = pathLength - 1)) {
            separatorIndex = standardizedPath.lastIndexOf(47, lastIndex - 1);
            pathComponent = separatorIndex >= 0 && separatorIndex < lastIndex ? path.substring(separatorIndex + 1, lastIndex) : path.substring(0, lastIndex);
        } else if (separatorIndex >= 0 && separatorIndex < lastIndex) {
            pathComponent = path.substring(separatorIndex + 1);
        }
        if (path.startsWith(pathComponent) && pathComponent.length() == 2 && Character.isLetter(pathComponent.charAt(0)) && pathComponent.endsWith(":") && File.separatorChar == '\\' && File.pathSeparatorChar == ';') {
            pathComponent = "";
        }
        return pathComponent;
    }

    public static String stringByDeletingLastPathComponent(String path) {
        int pathLength;
        if (path != null && (pathLength = path.length()) > 0) {
            String standardizedPath = NSPathUtilities._fileSeparatorStandardizedPath(path);
            int separatorIndex = standardizedPath.lastIndexOf(47);
            int firstSeparatorIndex = 0;
            int lastIndex = pathLength - 1;
            if (Character.isLetter(standardizedPath.charAt(0))) {
                if (standardizedPath.indexOf(":/") == 1 || standardizedPath.indexOf(":\\") == 1) {
                    firstSeparatorIndex = 2;
                    if (separatorIndex == -1) {
                        separatorIndex = standardizedPath.lastIndexOf(92);
                    }
                } else if (standardizedPath.indexOf(":") == 1) {
                    firstSeparatorIndex = 1;
                    separatorIndex = 1;
                }
            }
            if (separatorIndex > -1 && separatorIndex == firstSeparatorIndex) {
                return path.substring(0, firstSeparatorIndex + 1);
            }
            if (separatorIndex == lastIndex) {
                separatorIndex = standardizedPath.lastIndexOf(47, lastIndex - 1);
            }
            if (separatorIndex > -1 && separatorIndex == firstSeparatorIndex) {
                return path.substring(0, firstSeparatorIndex + 1);
            }
            if (separatorIndex > 0) {
                return path.substring(0, separatorIndex);
            }
        }
        return "";
    }

    public static String stringByDeletingPathExtension(String path) {
        int pos;
        String standardizedPath = NSPathUtilities._fileSeparatorStandardizedPath(path);
        int length = standardizedPath.length();
        for (pos = length - 1; pos >= 0 && standardizedPath.charAt(pos) == '/'; --pos) {
        }
        if (pos == -1) {
            if (length == 0) {
                return "";
            }
            return File.separator;
        }
        int lastSlash = pos;
        while (pos >= 0 && standardizedPath.charAt(pos) != '.') {
            --pos;
        }
        String result = pos == -1 ? path.substring(0, lastSlash + 1) : path.substring(0, pos);
        return result;
    }

    public static String stringByAppendingPathComponent(String path, String component) {
        if (path == null) {
            return component != null ? component : "";
        }
        if (component == null) {
            return path != null ? path : "";
        }
        int pathLength = path.length();
        int componentLength = component.length();
        if (pathLength == 0) {
            return component;
        }
        if (componentLength == 0) {
            return path;
        }
        boolean pathEndsWithFileSeparator = path.endsWith(File.separator);
        boolean componentStartsWithFileSeparator = component.startsWith(File.separator);
        if (pathEndsWithFileSeparator && componentStartsWithFileSeparator) {
            StringBuilder buffer = new StringBuilder(pathLength + componentLength - 1);
            buffer.append(path.substring(0, pathLength - 1));
            buffer.append(component);
            return new String(buffer);
        }
        if (pathEndsWithFileSeparator || componentStartsWithFileSeparator) {
            StringBuilder buffer = new StringBuilder(pathLength + componentLength);
            buffer.append(path);
            buffer.append(component);
            return new String(buffer);
        }
        StringBuilder buffer = new StringBuilder(pathLength + componentLength + 1);
        buffer.append(path);
        buffer.append(File.separator);
        buffer.append(component);
        return new String(buffer);
    }

    public static String stringByAppendingPathExtension(String path, String extension) {
        if (path == null) {
            if (extension != null) {
                StringBuilder buffer = new StringBuilder(extension.length() + 1);
                buffer.append('.');
                buffer.append(extension);
                return new String(buffer);
            }
            return "";
        }
        if (extension == null) {
            return path != null ? path : "";
        }
        int pathLength = path.length();
        if (path.endsWith("/") && pathLength > 1) {
            StringBuilder buffer = new StringBuilder(pathLength + extension.length());
            buffer.append(path.substring(0, pathLength - 1));
            buffer.append('.');
            buffer.append(extension);
            return new String(buffer);
        }
        StringBuilder buffer = new StringBuilder(pathLength + extension.length() + 1);
        buffer.append(path);
        buffer.append('.');
        buffer.append(extension);
        return new String(buffer);
    }

    public static String stringByNormalizingExistingPath(String path) {
        File f;
        if (path != null && (f = new File(path)).exists()) {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                Logger.debug("Exception while getting canonical path: " + path, e);
            }
        }
        return "";
    }

    public static boolean pathIsEqualToString(String path1, String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        return new File(path1).equals(new File(path2));
    }

    public static boolean pathIsAbsolute(String path) {
        return path != null ? new File(path).isAbsolute() : false;
    }

    public static boolean fileExistsAtPath(String path) {
        return path != null ? new File(path).exists() : false;
    }

    public static long _lastModifiedForPathURL(URL anURL) {
        long aTimeStamp = 0L;
        if (anURL.getProtocol().equals("file")) {
            File aPath = new File(anURL.getPath());
            aTimeStamp = aPath.lastModified();
        }
        return aTimeStamp;
    }

    public static String stringByNormalizingPath(String path) {
        if (path != null) {
            File f = new File(path);
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                Logger.debug("Exception while getting canonical path: " + path, e);
            }
        }
        return "";
    }

    public static File _FileWithURL(URL url) {
        File aFile = null;
        if (url != null && "file".equals(url.getProtocol())) {
            aFile = new File(url.getPath());
        }
        return aFile;
    }

    public static List<String> _directoryContentsAtPath(String path) {
        if (path == null) {
            return null;
        }
        String[] contents = new File(path).list();
        List<String> results = Arrays.asList(contents);
        return results;
    }

    public static boolean _isDirectory(String path) {
        return path != null ? new File(path).isDirectory() : false;
    }

    public static void _movePath(String src, String dest) {
        if (src == null || dest == null) {
            return;
        }
        File fileDest = new File(dest);
        File fileSrc = new File(src);
        fileSrc.renameTo(fileDest);
    }

    public static boolean _overwriteFileWithFile(File originalFile, File newFile) {
        File parent = originalFile.getParentFile();
        if (parent != null) {
            File backup = null;
            try {
                if (originalFile.exists()) {
                    backup = File.createTempFile("backup", "tmp", parent);
                    backup.delete();
                }
            }
            catch (IOException ioe) {
                Logger.error("Failed to create backup file in directory " + parent);
                return false;
            }
            String originalPath = originalFile.getAbsolutePath();
            if (backup != null && backup != null && !originalFile.renameTo(backup)) {
                System.out.println("Failed to rename " + originalFile + " to " + backup);
                return false;
            }
            if (newFile.renameTo(new File(originalPath))) {
                if (backup != null) {
                    backup.delete();
                }
                return true;
            }
            if (backup != null && !originalFile.renameTo(new File(originalPath))) {
                throw new IllegalStateException("Tried to move " + newFile + " on to " + originalFile + " but failed. Attempts at restoring the original conditions have failed. The original file is at " + backup);
            }
        }
        return false;
    }

    public static boolean _createDirectory(String path) {
        if (path == null) {
            return false;
        }
        return new File(path).mkdirs();
    }

    public static String _currentDirectoryPath() {
        return System.getProperty("user.dir");
    }

    public static boolean _fileAtPathIsWritable(String path) {
        return path != null ? new File(path).canWrite() : false;
    }

    public static void _copyPath(String source, String dest, Object sender) {
        if (source.equals(dest)) {
            return;
        }
        try {
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[in.available()];
            int chunk = in.read(buffer);
            while (chunk >= 0) {
                out.write(buffer, 0, chunk);
                chunk = in.read(buffer);
            }
        }
        catch (IOException e) {
            Logger.debug("Exception while copying path " + source + " to path " + dest, e);
        }
    }
}

