/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.ContainerType;
import com.apple.jingle.leghorn.fileformat.Verifier;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriberNotFoundException;
import com.apple.jingle.leghorn.media.MediaDescriptionResult;
import com.apple.transporter.log.Logger;
import com.apple.transporter.mediatoolkit.MediaToolkitUtils;
import com.apple.transporter.streaming.StreamableDescriptionWrapper;
import com.apple.transporter.streaming.StreamingUtil;
import com.apple.transporter.streaming.api.StreamableContent;
import com.apple.transporter.util.ChecksummedGZIPOutputStream;
import com.apple.transporter.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.SchemaTypeLoader;

public class LeghornUtil {
    private static ThreadLocal<ClassLoader> threadLocal = new ThreadLocal();

    public static void begin() {
        if (threadLocal.get() != null) {
            throw new IllegalStateException("begin() called before end() for prior begin() invocation!");
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        threadLocal.set(oldContextClassLoader);
        Thread.currentThread().setContextClassLoader(SchemaTypeLoader.class.getClassLoader());
    }

    public static void end() {
        ClassLoader oldContextClassLoader = threadLocal.get();
        if (oldContextClassLoader == null) {
            throw new IllegalStateException("end() already called, or begin() never called!");
        }
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        threadLocal.remove();
    }

    public static Map<String, Object> describeAsset(Verifier verifier, String filename, String path, String uti, String role, boolean logDescription) {
        MediaDescriptionResult mdr;
        String toolName = "<unknown>";
        String toolVersion = "<unknown>";
        StreamableContent streamableContent = null;
        try {
            Object descDoc;
            ContainerType containerType = verifier.getContainerTypeFactory().getTypeForUTI(uti);
            if (containerType != null && containerType.getContainerDescriber() != null) {
                try {
                    toolName = containerType.getContainerDescriber().getToolName();
                    toolVersion = containerType.getContainerDescriber().getToolVersion();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            Logger.debug("Using container type tool name and version: " + toolName + ":" + toolVersion);
            Logger.debug("Using path: " + path);
            File toDescribe = new File(path);
            ContainerDescription description = verifier.describe(toDescribe, containerType);
            String descriptionString = description.serializeToString();
            if (logDescription) {
                if (descriptionString == null) {
                    Logger.extreme("Asset description is NULL");
                } else {
                    Logger.extreme("description length:" + descriptionString.length());
                    if (Boolean.getBoolean("AlwaysLogAssetDescription") || descriptionString.length() < Integer.getInteger("MaximumAssetDescriptionSizeToLog", 32768)) {
                        Logger.extreme("Asset description: " + descriptionString);
                    }
                }
            }
            StreamableContent streamableContent2 = streamableContent = (descDoc = description.getDescriptionDocument()) instanceof StreamableDescriptionWrapper ? ((StreamableDescriptionWrapper)descDoc).getStreamableContent() : null;
            if (null == streamableContent) {
                mdr = new MediaDescriptionResult(toolName, toolVersion, new MediaDescriptionResult.Asset(filename, uti, role), descriptionString);
            } else if (streamableContent.getUncompressedContentLength() < streamableContent.getMaximumFileSize()) {
                mdr = new MediaDescriptionResult(toolName, toolVersion, new MediaDescriptionResult.Asset(filename, uti, role), StreamingUtil.getServerFile(streamableContent));
            } else {
                mdr = new MediaDescriptionResult(toolName, toolVersion, new MediaDescriptionResult.Asset(filename, uti, role), "$MEDIA_DESCRIPTION_NOT_SENT$");
                mdr.setMediaDescriptionNotSent(true);
                File fileToDelete = new File(streamableContent.getFilePath());
                if (fileToDelete.exists()) {
                    fileToDelete.delete();
                }
            }
            descriptionString = null;
            Logger.debug("Asset successfully described: " + description);
            description = null;
        }
        catch (DescriberNotFoundException e) {
            Logger.debug("Asset cannot be described: " + e.getMessage());
            mdr = new MediaDescriptionResult(toolName, toolVersion, new MediaDescriptionResult.Asset(filename, uti, role));
            mdr.addException((Exception)((Object)e));
        }
        catch (Exception e) {
            Logger.extreme("Exception describing asset", e);
            mdr = new MediaDescriptionResult(toolName, toolVersion, new MediaDescriptionResult.Asset(filename, uti, role));
            mdr.addException(e);
        }
        catch (Throwable t) {
            Logger.extreme("Error describing asset", t);
            mdr = new MediaDescriptionResult(toolName, toolVersion, new MediaDescriptionResult.Asset(filename, uti, role));
            mdr.addException(new Exception(t));
        }
        return LeghornUtil.mediaDescriptionToChecksummedBlob(mdr, streamableContent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> mediaDescriptionToChecksummedBlob(MediaDescriptionResult assetDescription, StreamableContent streamableContent) {
        try (ChecksummedGZIPOutputStream out = new ChecksummedGZIPOutputStream();){
            if (System.getProperty("debugAssetXML", "false").equals("true")) {
                Throwable throwable2;
                String documentsPath = System.getProperty("user.home") + File.separator + "Documents";
                File documentsDir = new File(documentsPath);
                String assetName = assetDescription.getAsset().getFile().replaceAll("\\/", "_");
                File xmlFile = new File(documentsDir, "media_descr-" + assetName + ".xml");
                try {
                    throwable2 = null;
                    try (FileOutputStream fos = new FileOutputStream(xmlFile);){
                        Logger.extreme("writing media desc to: " + xmlFile.getAbsolutePath());
                        MediaToolkitUtils.toXML((MediaDescriptionResult)assetDescription, (OutputStream)fos);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException fos) {
                    // empty catch block
                }
                try {
                    throwable2 = null;
                    try (FileInputStream fis = new FileInputStream(xmlFile);){
                        int c = 0;
                        while ((c = fis.read()) != -1) {
                            out.write(c);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (IOException iOException) {}
            } else {
                MediaToolkitUtils.toXML((MediaDescriptionResult)assetDescription, (OutputStream)out);
            }
            String zipped = new String(out.getBase64EncodedGZIPBytes());
            byte[] hash = out.getMD5();
            String checksum = StringUtil.byteArrayToHexString(hash);
            HashMap<String, Object> entry = new HashMap<String, Object>(3);
            entry.put("Checksum", checksum);
            entry.put("GzipContent", zipped);
            entry.put("$STREAMABLE_ITEM$", streamableContent);
            HashMap<String, Object> hashMap = entry;
            return hashMap;
        }
        catch (IOException errio) {
            Logger.error("failed to compress asset description", errio);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error("failed to create checksum on asset description", e);
        }
        return null;
    }
}

