/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.LogMessageType;
import com.apple.transporter.log.Logger;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;

public class JSONMessageLogger {
    private JSONMessageLogger() {
    }

    private static String sendMessage(LogMessageType messageType, Map<String, Object> payload) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageType", messageType.type);
        map.put("msg", payload);
        JSONObject json = new JSONObject(map);
        String j = json.toJSONString();
        return "JSON:" + j;
    }

    public static void debug(LogMessageType messageType, Map<String, Object> payload) {
        Logger.debug(JSONMessageLogger.sendMessage(messageType, payload));
    }

    public static void info(LogMessageType messageType, Map<String, Object> payload) {
        Logger.info(JSONMessageLogger.sendMessage(messageType, payload));
    }

    public static void warn(LogMessageType messageType, Map<String, Object> payload) {
        Logger.warn(JSONMessageLogger.sendMessage(messageType, payload));
    }

    public static void error(LogMessageType messageType, Map<String, Object> payload) {
        Logger.error(JSONMessageLogger.sendMessage(messageType, payload));
    }

    public static void essential(LogMessageType messageType, Map<String, Object> payload) {
        Logger.essential(JSONMessageLogger.sendMessage(messageType, payload));
    }

    public static void extreme(LogMessageType messageType, Map<String, Object> payload) {
        Logger.extreme(JSONMessageLogger.sendMessage(messageType, payload));
    }

    public static void fatal(LogMessageType messageType, Map<String, Object> payload) {
        Logger.fatal(JSONMessageLogger.sendMessage(messageType, payload));
    }
}

