/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.DownloadProgressReporter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.ProcUtil;
import com.apple.transporter.util.StreamUtil;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    private static final File localConfigHomeFile = FileUtil.localConfigHome0();
    private static final boolean canUseNIOLocking = FileUtil.testWhetherNIOLockingWorks();
    private static Thread shutdownHookForDeletingConfigHome;
    private static File cachedHomeDirectory;
    private static ConcurrentLinkedQueue<File> fileCleanupList;

    public static void makeFileWorldReadableAndWriteable(File destFile, boolean recursive) throws IOException {
        if (TransportUtil.isOSWindows()) {
            throw new IllegalArgumentException("This method cannot be used on Windows");
        }
        String absolutePath = destFile.getAbsolutePath();
        if (absolutePath.matches("^.*\\s.*$")) {
            throw new IllegalArgumentException("This method does not support files with spaces in their names: " + absolutePath);
        }
        boolean isDirectory = destFile.isDirectory();
        String chmodArgs = isDirectory ? "a+rwx" : "a+rw";
        String[] command = null;
        command = recursive && isDirectory ? new String[]{"/bin/chmod", "-R", chmodArgs, absolutePath} : new String[]{"/bin/chmod", chmodArgs, absolutePath};
        int exitValue = ProcUtil.executeProcess(command);
        if (exitValue != 0) {
            throw new IOException("Failed to change permissions on file: " + absolutePath + ", " + exitValue);
        }
    }

    private static boolean isFileWorldReadableAndWriteable(File destFile) {
        if (TransportUtil.isOSWindows()) {
            throw new IllegalArgumentException("This method cannot be used on Windows");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("The destFile cannot be null");
        }
        if (!destFile.exists()) {
            throw new IllegalArgumentException("The destFile does not exist");
        }
        String absolutePath = destFile.getAbsolutePath();
        if (absolutePath.matches("^.*\\s.*$")) {
            throw new IllegalArgumentException("This method does not support files with spaces in their names: " + absolutePath);
        }
        boolean isDirectory = destFile.isDirectory();
        String[] command = null;
        command = isDirectory ? new String[]{"/bin/ls", "-ld", absolutePath} : new String[]{"/bin/ls", "-l", absolutePath};
        String lsOutput = null;
        lsOutput = ProcUtil.executeProcessAndGetStdout(command);
        if (lsOutput == null || lsOutput.trim().length() == 0) {
            throw new RuntimeException("Failed to determine if file was world reabable and writeable: " + absolutePath);
        }
        String userPerms = lsOutput.substring(1, 4);
        String groupPerms = lsOutput.substring(4, 7);
        String otherPerms = lsOutput.substring(7, 10);
        return userPerms.indexOf("r") != -1 && groupPerms.indexOf("r") != -1 && otherPerms.indexOf("r") != -1 && userPerms.indexOf("w") != -1 && groupPerms.indexOf("w") != -1 && otherPerms.indexOf("w") != -1;
    }

    public static boolean isFileWorldReadableAndWriteable(File destFile, boolean recursive) {
        if (TransportUtil.isOSWindows()) {
            throw new IllegalArgumentException("This method cannot be used on Windows");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("The destFile cannot be null");
        }
        if (!destFile.exists()) {
            throw new IllegalArgumentException("The destFile does not exist");
        }
        boolean isTopFileOK = FileUtil.isFileWorldReadableAndWriteable(destFile);
        if (!isTopFileOK) {
            Logger.extreme("'" + destFile.getPath() + "' is not world readable and writable.");
        }
        if (!recursive) {
            return isTopFileOK;
        }
        if (!destFile.isDirectory()) {
            return isTopFileOK;
        }
        if (destFile.isDirectory() && !isTopFileOK) {
            return isTopFileOK;
        }
        File[] files = destFile.listFiles();
        if (files == null) {
            return isTopFileOK;
        }
        for (int i = 0; i < files.length; ++i) {
            File aFile = files[i];
            if (!FileUtil.isFileWorldReadableAndWriteable(aFile)) {
                Logger.extreme("'" + aFile.getPath() + "' is not world readable and writable.");
                return false;
            }
            if (!aFile.isDirectory() || FileUtil.isFileWorldReadableAndWriteable(aFile, recursive)) continue;
            return false;
        }
        return true;
    }

    public static File localConfigHome() {
        return localConfigHomeFile;
    }

    public static File localConfigHomeOverride() {
        return new File(localConfigHomeFile.getAbsolutePath() + "_override");
    }

    public static File userHomeDirectory() {
        if (cachedHomeDirectory != null) {
            return cachedHomeDirectory;
        }
        String userHome = System.getProperty("user.home");
        cachedHomeDirectory = FileUtil.testPossibleHomeDirectory(userHome);
        if (cachedHomeDirectory != null) {
            return cachedHomeDirectory;
        }
        String envHome = System.getenv("HOME");
        cachedHomeDirectory = FileUtil.testPossibleHomeDirectory(envHome);
        if (cachedHomeDirectory != null) {
            return cachedHomeDirectory;
        }
        String tmpHome = System.getProperty("java.io.tmpdir");
        cachedHomeDirectory = FileUtil.testPossibleHomeDirectory(tmpHome);
        if (cachedHomeDirectory != null) {
            String warnMessage = ", user home directory is not defined";
            if (userHome != null && !userHome.isEmpty()) {
                warnMessage = " in " + userHome + ", the directory is not writeable";
            } else if (envHome != null && !envHome.isEmpty()) {
                warnMessage = " in " + envHome + ", the directory is not writeable";
            }
            FileUtil.logWarning("could not create cache directory" + warnMessage);
            return cachedHomeDirectory;
        }
        if (tmpHome != null && !tmpHome.isEmpty()) {
            FileUtil.logError("could not create cache directory in " + tmpHome + ", the directory is not writeable");
        } else {
            FileUtil.logError("could not create temporary cache directory, temporary directory is not defined");
        }
        return null;
    }

    private static void logError(String message) {
        System.err.println("ERROR: " + message);
    }

    private static void logWarning(String message) {
        try {
            Logger.warn(message);
        }
        catch (RuntimeException ex) {
            System.err.println("WARN: " + message);
        }
    }

    private static File testPossibleHomeDirectory(String possibleHome) {
        File subdir;
        if (possibleHome == null || possibleHome.trim().isEmpty()) {
            return null;
        }
        File homeDir = new File(possibleHome);
        if ((homeDir.mkdir() || homeDir.exists()) && ((subdir = new File(homeDir, ".itmstransporter")).mkdir() || subdir.exists())) {
            if (subdir.isDirectory() && subdir.canWrite()) {
                return homeDir;
            }
            try {
                boolean isCandidate;
                File subfile = File.createTempFile("test", null, subdir);
                File subdirtest = new File(subdir, subfile.getName() + ".dir");
                boolean bl = isCandidate = subdirtest.mkdir() && subfile.exists();
                if (!subdirtest.delete()) {
                    subdirtest.deleteOnExit();
                }
                if (!subfile.delete()) {
                    subfile.deleteOnExit();
                }
                if (isCandidate) {
                    return homeDir;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static File localConfigHome0() {
        File homeDir = FileUtil.userHomeDirectory();
        if (homeDir == null) {
            return null;
        }
        File file = new File(homeDir, ".itmstransporter");
        if (!file.exists() || !file.canWrite()) {
            file.mkdirs();
            if (!file.exists()) {
                Logger.error("Unable to create configuration directory: " + file.getAbsolutePath());
                return null;
            }
        }
        if (!file.canWrite()) {
            Logger.error("Unable to write to configuration directory: " + file.getAbsolutePath());
            return null;
        }
        return file;
    }

    public static synchronized void deleteLocalConfigHomeOnExit() {
        if (shutdownHookForDeletingConfigHome == null) {
            shutdownHookForDeletingConfigHome = new Thread(new Runnable(){

                @Override
                public void run() {
                    Logger.debug("Repairing auto-update configuration.");
                    if (!FileUtil.recursivelyDelete(localConfigHomeFile)) {
                        FileUtil.recursivelyDeleteOnExit(localConfigHomeFile);
                    }
                }
            }, "Auto-Update Repair");
            Runtime.getRuntime().addShutdownHook(shutdownHookForDeletingConfigHome);
        }
    }

    private static void recursivelyDeleteOnExit(File file) {
        file.deleteOnExit();
        for (File child : file.listFiles()) {
            if (child.isDirectory()) {
                FileUtil.recursivelyDeleteOnExit(child);
                continue;
            }
            child.deleteOnExit();
        }
    }

    public static boolean recursivelyDelete(File file) {
        File parent;
        File[] children = file.listFiles();
        if (children != null) {
            file.setWritable(true);
            for (File child : file.listFiles()) {
                if (!(child.isDirectory() ? !FileUtil.recursivelyDelete(child) : !FileUtil.deleteFile(child, true))) continue;
                return false;
            }
        }
        if ((parent = file.getParentFile()) != null) {
            parent.setWritable(true);
        }
        return FileUtil.deleteFile(file, true);
    }

    public static File tempDir() {
        File file;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir != null && (file = new File(tempDir)).exists()) {
            return file;
        }
        throw new IllegalStateException("No system temp dir defined");
    }

    public static boolean canUseNIOLocking() {
        return canUseNIOLocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testWhetherNIOLockingWorks() {
        boolean result = false;
        File home = FileUtil.userHomeDirectory();
        if (home == null) {
            return false;
        }
        File file = new File(home, UUID.randomUUID().toString().toLowerCase());
        FileOutputStream fout = null;
        AbstractInterruptibleChannel fchannel = null;
        FileLock flock = null;
        try {
            file.getParentFile().mkdirs();
            fout = new FileOutputStream(file);
            fchannel = fout.getChannel();
            flock = ((FileChannel)fchannel).tryLock();
            result = true;
        }
        catch (IOException errio) {
        }
        finally {
            try {
                if (flock != null) {
                    flock.release();
                }
                if (fchannel != null) {
                    fchannel.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException errio) {
                result = false;
            }
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
                result = false;
            }
        }
        return result;
    }

    public static String fileContentsForWebService(String filename) {
        String fileContents = null;
        if (filename != null && filename.length() > 0) {
            File aFile = new File(filename);
            if (aFile.exists()) {
                try {
                    fileContents = FileUtils.readFileToString((File)aFile, (String)"UTF-8");
                    fileContents = TransportUtil.stripNonValidXMLCharacters(fileContents);
                }
                catch (Throwable t) {
                    Logger.error("An error occurred while reading the file: " + filename, t);
                }
            } else {
                Logger.info("The file '" + filename + "' does not exist.");
            }
        }
        return fileContents;
    }

    public static byte[] md5(File file) throws IOException, NoSuchAlgorithmException {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] byArray = FileUtil.md5(fis);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    public static byte[] md5(InputStream in) throws IOException, NoSuchAlgorithmException {
        int numRead;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] buf = new byte[51200];
        while ((numRead = in.read(buf)) != -1) {
            md5.update(buf, 0, numRead);
        }
        return md5.digest();
    }

    public static String md5Hex(File file) throws IOException, NoSuchAlgorithmException {
        return StringUtil.byteArrayToHexString(FileUtil.md5(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFileAtURLToDestination(String remoteUrl, File destination, boolean shouldLogProgress) throws FileNotFoundException, IOException {
        if (destination == null) {
            throw new IllegalArgumentException("The argument destination cannot be null.");
        }
        if (remoteUrl == null || remoteUrl.length() == 0) {
            throw new IllegalArgumentException("The argument remoteUrl cannot be null or empty.");
        }
        boolean wasSuccessful = false;
        if (destination.exists() && destination.canWrite() || !destination.exists() && destination.getParentFile().exists() && destination.getParentFile().canWrite()) {
            DownloadProgressReporter listener = null;
            URL url = new URL(remoteUrl);
            URLConnection conn = url.openConnection();
            conn.connect();
            InputStream is = conn.getInputStream();
            String filename = NSPathUtilities.lastPathComponent(url.getPath());
            FileOutputStream os = new FileOutputStream(destination);
            if (shouldLogProgress) {
                listener = new DownloadProgressReporter(filename, conn.getContentLength());
                Logger.info("Starting to download the file '" + filename + "'");
            }
            try {
                StreamUtil.copyStream(os, is, listener);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
            if (shouldLogProgress) {
                Logger.info("Finished downloading the file '" + filename + "'");
            }
            wasSuccessful = true;
        } else {
            Logger.warn("Cannot save local copy of " + destination.getPath() + "; local path is not writable");
        }
        return wasSuccessful;
    }

    public static byte[] fetchFileAtURL(String remoteUrl) throws FileNotFoundException, IOException {
        return FileUtil.fetchFileAtURL(remoteUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] fetchFileAtURL(String remoteUrl, boolean shouldLogProgress) throws FileNotFoundException, IOException {
        if (remoteUrl == null || remoteUrl.length() == 0) {
            throw new IllegalArgumentException("The argument remoteUrl cannot be null or empty.");
        }
        byte[] remoteData = null;
        InputStream content = null;
        try {
            URL url = new URL(remoteUrl);
            URLConnection conn = url.openConnection();
            conn.connect();
            content = conn.getInputStream();
            DownloadProgressReporter listener = null;
            String pathFromURL = url.getPath();
            String filename = NSPathUtilities.lastPathComponent(pathFromURL);
            if (shouldLogProgress) {
                listener = new DownloadProgressReporter(filename, conn.getContentLength());
                Logger.info("Starting to download the file '" + filename + "'");
            }
            remoteData = StreamUtil.readBytes(content, listener);
            if (shouldLogProgress) {
                Logger.info("Finished downloading the file '" + filename + "'");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(content);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)content);
        return remoteData;
    }

    public static void copyFileWithVerify(File source, File dest) throws IOException {
        try {
            FileUtils.copyFile((File)source, (File)dest, (boolean)false);
            String md5Source = FileUtil.md5Hex(source);
            String md5Dest = FileUtil.md5Hex(dest);
            if (!md5Source.equals(md5Dest)) {
                FileUtils.copyFile((File)source, (File)dest, (boolean)false);
                md5Dest = FileUtil.md5Hex(dest);
                if (!md5Source.equals(md5Dest)) {
                    throw new RuntimeException("Checksum validation failed copying file " + source + " to " + dest);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static String absolutePathForFile(File aFile) throws IOException {
        if (aFile == null) {
            return null;
        }
        String returnString = null;
        if (!TransportUtil.isOSWindows() && aFile.getPath().startsWith("~")) {
            String homeDirPath;
            String aPath = aFile.getPath();
            File homeDir = FileUtil.userHomeDirectory();
            String string = homeDirPath = homeDir != null ? homeDir.getAbsolutePath() : null;
            if (homeDirPath == null || homeDirPath.length() == 0) {
                String aMsg = "Could not replace the '~' in the path '" + aPath + "' with the actual home directory path.  Please specify the full path.";
                Logger.error(aMsg);
                throw new IOException(aMsg);
            }
            String betterFilePath = NSPathUtilities.stringByAppendingPathComponent(homeDirPath, aPath.substring(1));
            aFile = new File(betterFilePath);
        }
        if (!aFile.isAbsolute()) {
            String pathToExecutable = null;
            pathToExecutable = TransportUtil.isOSWindows() ? System.getProperty("callerPWD") : System.getProperty("WOUserDirectory");
            returnString = NSPathUtilities.stringByAppendingPathComponent(pathToExecutable, aFile.getPath());
        } else {
            returnString = aFile.getAbsolutePath();
        }
        return returnString;
    }

    public static String absolutePathForPath(String aPath) throws IOException {
        if (aPath == null || aPath.length() == 0) {
            return null;
        }
        return FileUtil.absolutePathForFile(new File(aPath));
    }

    public static String stringFromFile(File f) throws IOException {
        return FileUtils.readFileToString((File)f, (String)"UTF-8");
    }

    public static Long fileSizeSumForFiles(ITMSPackage pkg, List<File> filesArray) {
        if (filesArray == null || filesArray.size() == 0) {
            return 0L;
        }
        long pkgSize = 0L;
        for (File oneFile : filesArray) {
            pkgSize += pkg == null ? oneFile.length() : pkg.getFileSize(oneFile);
        }
        return pkgSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFile(File aFile, boolean isQuiet) {
        if (aFile == null) {
            return false;
        }
        boolean wasSuccessful = false;
        boolean isWindows = TransportUtil.isOSWindows();
        boolean fileExists = aFile.exists();
        if (!fileExists) {
            return true;
        }
        if (!isWindows) {
            wasSuccessful = aFile.delete();
        }
        int attempts = 0;
        while (!wasSuccessful && attempts < 10 && isWindows) {
            try {
                TransportUtil.needToSleep(100L, "Wait between delete attempts on Windows", isQuiet);
                System.gc();
                wasSuccessful = aFile.delete();
            }
            catch (RuntimeException t) {
                Logger.extreme("An error occurred while trying to delete: " + aFile.getPath(), t);
                if (attempts + 1 >= 10 || isQuiet) continue;
                Logger.extreme("Another attempt will be made.");
            }
            finally {
                ++attempts;
            }
        }
        return wasSuccessful;
    }

    public static void addFileToCleanupList(@Nonnull File file) {
        file.deleteOnExit();
        fileCleanupList.add(file);
    }

    public static void cleanupFiles() {
        ArrayList<File> deletedFiles = new ArrayList<File>();
        for (File file : fileCleanupList) {
            if (!file.exists() || file.delete()) {
                deletedFiles.add(file);
                continue;
            }
            Logger.warn("Unable to delete file in the fileCleanupList: " + file.getAbsolutePath());
        }
        fileCleanupList.removeAll(deletedFiles);
    }

    static {
        fileCleanupList = new ConcurrentLinkedQueue();
    }
}

