/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import com.apple.transporter.transport.TransportType;

public class FileChunkUtil {
    private static final int CHUNK_SIZE_DEFAULT = 0xA00000;
    private static Boolean isChunkingEnabled;
    private static Long chunkSize;

    public static boolean isChunkingEnabled(TransportType transportType) {
        if (isChunkingEnabled == null) {
            if (System.getProperty("fileChunking") != null && System.getProperty("fileChunking").toLowerCase().equals("false")) {
                Logger.info("File chunking manually turned off");
                isChunkingEnabled = Boolean.FALSE;
            } else if (transportType.isAspera()) {
                Logger.info("File chunking disable for Aspera Transport");
                isChunkingEnabled = Boolean.FALSE;
            } else {
                isChunkingEnabled = Boolean.TRUE;
            }
        }
        return isChunkingEnabled;
    }

    public static boolean shouldFileBeChunked(long fileSize) {
        return fileSize > FileChunkUtil.chunkSize();
    }

    public static Long chunkSize() {
        if (chunkSize != null) {
            return chunkSize;
        }
        int tempChunkSize = 0;
        try {
            tempChunkSize = System.getProperty("chunkSize") != null ? Integer.parseInt(System.getProperty("chunkSize")) : 0xA00000;
        }
        catch (NumberFormatException nfe) {
            Logger.error("The specified chunk size is invalid, using default");
            tempChunkSize = 0xA00000;
        }
        chunkSize = new Long(tempChunkSize);
        return chunkSize;
    }
}

