/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ConfigurationUtil {
    public static final String defaultURLPrefix = "https://contentdelivery.itunes.apple.com/transporter/";
    private static final String defaultsPropertiesURL = "https://contentdelivery.itunes.apple.com/transporter/Defaults.properties";
    private static final String defaultsPropertiesFileName = "Defaults.properties";
    private static String baseInstallVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPropertyDefaults() {
        ConfigurationUtil.loadResourceProperties();
        InputStream propertiesStream = null;
        try {
            propertiesStream = ConfigurationUtil.getConfigurationFileStream(ConfigurationUtil.refreshDefaultsFromRemote() ? defaultsPropertiesURL : null, defaultsPropertiesFileName);
            if (propertiesStream != null) {
                Properties props = new Properties();
                props.load(propertiesStream);
                for (Object o : props.keySet()) {
                    String key = (String)o;
                    System.setProperty(key, props.getProperty(key));
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (propertiesStream != null) {
                IOUtils.closeQuietly((InputStream)propertiesStream);
            }
        }
    }

    private static void loadResourceProperties() {
        ConfigurationUtil.loadNamedResourceProperties("Properties");
        ConfigurationUtil.loadNamedResourceProperties("build-version.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNamedResourceProperties(String name) {
        InputStream is = StreamUtil.getResourceAsStream(name);
        if (is != null) {
            try {
                Properties props = new Properties();
                props.load(is);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Exception e) {
                Logger.error("Could not load properties", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public static InputStream getConfigurationFileStream(String remoteUrl, String name) {
        File localConfigHome = FileUtil.localConfigHome();
        File localConfigFullPath = null;
        File localConfigOverrideFullPath = null;
        if (localConfigHome != null) {
            localConfigFullPath = new File(localConfigHome.getAbsolutePath(), name);
            localConfigOverrideFullPath = new File(FileUtil.localConfigHomeOverride(), name);
        }
        if (remoteUrl != null) {
            byte[] remoteData = ConfigurationUtil.fetchRemoteConfig(remoteUrl);
            try {
                if (remoteData != null) {
                    if (localConfigFullPath != null && (localConfigFullPath.exists() && localConfigFullPath.canWrite() || localConfigHome.canWrite())) {
                        Logger.debug("Saving configuration to local path: " + localConfigFullPath);
                        FileUtils.writeByteArrayToFile((File)localConfigFullPath, (byte[])remoteData);
                    } else {
                        Logger.warn("Cannot save local copy of remote diagnostic configuration; local path is not writable");
                    }
                }
            }
            catch (IOException e) {
                Logger.error("Exception writing local configuration file: " + name, e);
            }
        }
        if (localConfigFullPath != null && localConfigFullPath.exists()) {
            try {
                return new FileInputStream(localConfigOverrideFullPath);
            }
            catch (FileNotFoundException e) {
                try {
                    return new FileInputStream(localConfigFullPath);
                }
                catch (FileNotFoundException e1) {
                    Logger.extreme("unable to find configuration file", e1);
                }
            }
        }
        return StreamUtil.getResourceAsStream(name);
    }

    private static byte[] fetchRemoteConfig(String remoteUrl) {
        Logger.debug("Attempting refresh of configuration data from " + remoteUrl);
        byte[] remoteData = null;
        try {
            remoteData = FileUtil.fetchFileAtURL(remoteUrl);
            Logger.debug("Configuration refresh successful.");
        }
        catch (FileNotFoundException e) {
            Logger.debug("No remote configuration found.");
        }
        catch (IOException e) {
            Logger.error("Could not retrieve remote configuration details.", e);
        }
        return remoteData;
    }

    public static boolean refreshDefaultsFromRemote() {
        String mode = System.getProperty("m");
        return mode != null && (mode.equalsIgnoreCase("upload") || mode.equalsIgnoreCase("diagnostic") || mode.equalsIgnoreCase("resetSoftwareApplication") || mode.equalsIgnoreCase("sleep") || mode.equalsIgnoreCase("provider"));
    }

    public static ServiceReference getServiceReference(String version, ServiceReference[] serviceReferences) {
        if (serviceReferences == null) {
            throw new NullPointerException("serviceReferences parameter cannot be null");
        }
        ServiceReference serviceReference = null;
        for (ServiceReference ref : serviceReferences) {
            if (version == null && serviceReference == null) {
                serviceReference = ref;
                continue;
            }
            if (version == null && ref.getBundle().getVersion().compareTo(serviceReference.getBundle().getVersion()) > 0) {
                serviceReference = ref;
                continue;
            }
            if (version == null || !version.equals(ref.getBundle().getVersion().toString())) continue;
            serviceReference = ref;
            break;
        }
        return serviceReference;
    }

    public static void deleteDefaultsPropertiesFile() {
        File localConfigHome = FileUtil.localConfigHome();
        File localConfigFullPath = new File(localConfigHome.getAbsolutePath(), defaultsPropertiesFileName);
        if (localConfigFullPath.exists()) {
            try {
                localConfigFullPath.delete();
            }
            catch (SecurityException e) {
                Logger.warn("Unable to delete " + localConfigFullPath.toString() + ".");
            }
        }
    }

    public static void checkConfigHomeFreeSpace() {
        try {
            long free = FileUtil.localConfigHome().getFreeSpace();
            long megabyte = 0x100000L;
            if (free < 1048576000L) {
                Logger.warn("Your configuration home partition has fewer than 100 megabytes free; for best results Apple recommends increasing the amount of free space.");
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static String getBaseInstallVersion() {
        if (baseInstallVersion != null) {
            return baseInstallVersion;
        }
        baseInstallVersion = "Unknown";
        if (!ConfigurationUtil.extractBaseInstallVersionFromProperties()) {
            for (String infoPlistPath : ConfigurationUtil.infoPlistPaths()) {
                File infoPlist = new File(infoPlistPath);
                if (!infoPlist.exists() || !infoPlist.canRead()) continue;
                ConfigurationUtil.extractBaseInstallVersionFromInfoPlist(infoPlistPath);
                break;
            }
        }
        return baseInstallVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractBaseInstallVersionFromProperties() {
        block22: {
            String osgiBundle;
            File osgiBundles = null;
            Iterator<String> iterator = ConfigurationUtil.osgiBundlesPaths().iterator();
            while (!(!iterator.hasNext() || (osgiBundles = new File(osgiBundle = iterator.next())).exists() && osgiBundles.isDirectory())) {
            }
            if (osgiBundles == null) {
                return false;
            }
            File[] resourceFiles = osgiBundles.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith("com.apple.transporter.resources") && name.endsWith(".jar");
                }
            });
            if (resourceFiles == null || resourceFiles.length == 0) {
                return false;
            }
            ZipFile resourceJar = null;
            try {
                resourceJar = new ZipFile(resourceFiles[0]);
                ZipEntry buildVersionEntry = resourceJar.getEntry(ConfigurationUtil.buildVersionFileName());
                if (buildVersionEntry == null) break block22;
                try (InputStream buildVersionStream = resourceJar.getInputStream(buildVersionEntry);){
                    Properties props = new Properties();
                    props.load(buildVersionStream);
                    String version = props.getProperty(ConfigurationUtil.versionKey());
                    if (version != null && version.trim().length() != 0) {
                        baseInstallVersion = version.trim();
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception e) {
                Logger.debug("Unable to extract BaseInstallVersion", e);
            }
            finally {
                if (resourceJar != null) {
                    try {
                        resourceJar.close();
                    }
                    catch (IOException e) {
                        Logger.extreme("Trouble closing jar", e);
                    }
                }
            }
        }
        return false;
    }

    private static void extractBaseInstallVersionFromInfoPlist(String infoPlistPath) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            docBuilderFactory.setAttribute("http://xml.org/sax/features/validation", false);
            docBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            docBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            docBuilderFactory.setValidating(false);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(infoPlistPath));
            XPathFactory factory = XPathFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XPath xpath = factory.newXPath();
            XPathExpression expression = xpath.compile("/plist/dict/key[.='CFBundleShortVersionString']/following-sibling::*[1]");
            baseInstallVersion = expression.evaluate(document);
            if (baseInstallVersion == null || baseInstallVersion.equals("1")) {
                expression = xpath.compile("/plist/dict/key[.='CFBundleVersion']/following-sibling::*[1]");
                baseInstallVersion = expression.evaluate(document);
            }
        }
        catch (Exception e) {
            Logger.debug("Unable to extract BaseInstallVersion", e);
        }
    }

    private static String installationRoot() {
        String path = System.getProperty("user.dir");
        return path;
    }

    private static List<String> infoPlistPaths() {
        return Arrays.asList(ConfigurationUtil.installationRoot() + File.separatorChar + "Info.plist", ConfigurationUtil.installationRoot() + File.separatorChar + "Contents" + File.separatorChar + "Info.plist");
    }

    private static List<String> osgiBundlesPaths() {
        return Arrays.asList(ConfigurationUtil.installationRoot() + File.separatorChar + "share" + File.separatorChar + "OSGi-Bundles", ConfigurationUtil.installationRoot() + File.separatorChar + File.separatorChar + "Contents" + File.separatorChar + "OSGi-Bundles");
    }

    private static String buildVersionFileName() {
        return "Properties";
    }

    private static String versionKey() {
        return "versionNumber";
    }
}

