/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.util;

import com.apple.transporter.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;

public class ChecksummedGZIPOutputStream
extends OutputStream {
    private final MessageDigest md5 = MessageDigest.getInstance("MD5");
    private final GZIPOutputStream gzipStream;
    private final ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
    private int uncompressedCount = 0;

    public ChecksummedGZIPOutputStream() throws NoSuchAlgorithmException, IOException {
        this.gzipStream = new GZIPOutputStream(this.byteStream);
    }

    public byte[] getMD5() {
        return this.md5.digest();
    }

    public byte[] getBase64EncodedGZIPBytes() throws IOException {
        this.flush();
        this.close();
        Logger.extreme("Deflated " + this.uncompressedCount + " bytes to " + this.byteStream.size());
        return Base64.encodeBase64((byte[])this.byteStream.toByteArray());
    }

    @Override
    public void write(int b) throws IOException {
        this.md5.update((byte)(b & 0xFF));
        this.gzipStream.write(b);
        ++this.uncompressedCount;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.md5.update(b, off, len);
        this.gzipStream.write(b, off, len);
        this.uncompressedCount += len;
    }

    @Override
    public void flush() throws IOException {
        this.gzipStream.flush();
        this.byteStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.gzipStream.close();
        this.byteStream.close();
    }
}

