/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport.webdav;

import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.transport.webdav.ChunkedFileSource;
import com.apple.transporter.transport.webdav.HttpException;
import com.apple.transporter.transport.webdav.HttpMkcol;
import com.apple.transporter.transport.webdav.HttpPropfind;
import com.apple.transporter.transport.webdav.Resource;
import com.apple.transporter.transport.webdav.WebDAV;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public class WebdavFile
implements WebDAV {
    private URI requestUri;
    private final WebService service;
    private CloseableHttpClient client;
    private final HttpClientBuilder clientBuilder;
    HttpResponse response;
    private Resource resource;
    private UsernamePasswordCredentials credentials;
    private final Map<String, Resource> childResources = new HashMap<String, Resource>();
    private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(this.getClass());

    public WebdavFile(URI uri, String logFileName, WebService service) {
        this.requestUri = uri;
        this.service = service;
        this.clientBuilder = HttpClientBuilder.create().useSystemProperties().disableCookieManagement();
        Integer readTimeout = Integer.getInteger("com.apple.transporter.httpReadTimeout");
        if (readTimeout != null && readTimeout >= 0) {
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(readTimeout.intValue()).build();
            this.clientBuilder.setDefaultSocketConfig(socketConfig);
        }
        this.clientBuilder.disableAutomaticRetries();
        this.resource = new Resource(uri, 0L, 0L);
        this.initLogging(logFileName);
        this.log.debug((Object)("requestUri:[" + this.requestUri + "] resource:[" + this.resource + "]"));
    }

    public CloseableHttpClient getClient() {
        if (this.client != null) {
            return this.client;
        }
        this.client = this.clientBuilder.build();
        return this.client;
    }

    private HttpResponse executeWithPreemptiveAuthentication(HttpUriRequest method) throws IOException, ClientProtocolException {
        if (this.credentials != null) {
            try {
                Header authenticationHeader = new BasicScheme().authenticate((Credentials)this.credentials, (HttpRequest)method, null);
                method.addHeader(authenticationHeader);
            }
            catch (AuthenticationException e) {
                this.log.debug((Object)"error setting up preemptive authentication", (Throwable)e);
            }
        }
        CloseableHttpResponse response = this.getClient().execute(method);
        return response;
    }

    private void initLogging(String logFileName) {
        if (logFileName == null) {
            return;
        }
        this.log.removeAppender("console");
        Appender fileAppender = this.log.getAppender("file");
        if (fileAppender != null) {
            this.log.removeAppender(fileAppender);
        }
        try {
            PatternLayout layout = new PatternLayout();
            layout.setConversionPattern("%r [%t] %p %c %x - %m%n");
            fileAppender = new FileAppender((Layout)layout, logFileName);
            this.log.addAppender(fileAppender);
            this.log.setAdditivity(false);
        }
        catch (IOException e) {
            Logger.debug("unable to create WebDAV log file appender", e);
        }
    }

    @Override
    public void init() throws IOException, HttpException {
        this.getProperties(HttpPropfind.Depth.Self);
    }

    @Override
    public Resource getAsResource() {
        return this.resource;
    }

    @Override
    public String getPath() {
        return this.requestUri.getPath();
    }

    @Override
    public void setPath(String remoteFolderPath) throws IOException, HttpException, IllegalArgumentException {
        URIBuilder builder = new URIBuilder(this.requestUri);
        builder.setPath(remoteFolderPath);
        try {
            this.requestUri = builder.build();
            this.resource = new Resource(this.requestUri, 0L, 0L);
            this.log.debug((Object)("requestUri:[" + this.requestUri + "] resource:[" + this.resource + "]"));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI path: " + remoteFolderPath, e);
        }
        this.getProperties(HttpPropfind.Depth.Self);
    }

    @Override
    public boolean isSecure() {
        return this.requestUri.getScheme().startsWith("https");
    }

    @Override
    public void setUserInfo(String username, String password) {
        if (this.service != null && this.service.hasSession()) {
            username = this.service.sessionId();
            password = UUID.randomUUID().toString();
        }
        if (username == null || username.trim().isEmpty()) {
            username = UUID.randomUUID().toString();
        }
        if (password == null || password.trim().isEmpty()) {
            password = UUID.randomUUID().toString();
        }
        this.credentials = new UsernamePasswordCredentials(username, password);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(this.requestUri.getHost(), -1), (Credentials)this.credentials);
        this.clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                Logger.debug("error closing connection to DAV: " + e.getMessage());
            }
            this.client = null;
        }
    }

    @Override
    public Iterator<Resource> getResources() throws IOException, HttpException {
        if (this.getPropertiesWithRetry(HttpPropfind.Depth.Children)) {
            return this.childResources.values().iterator();
        }
        return null;
    }

    @Override
    public Resource getResource(String destinationFilename) {
        return this.childResources.get(destinationFilename);
    }

    private boolean getPropertiesWithRetry(final HttpPropfind.Depth depth) {
        boolean response = WebServiceInvoker.invokeWithRetry(new WebServiceInvoker.Invocation<Boolean>(){

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
            }

            @Override
            public Boolean invoke() {
                try {
                    return WebdavFile.this.getProperties(depth);
                }
                catch (Exception e) {
                    throw new RuntimeException("An error occured while attempting to gather list of uploaded files from Apple's webDAV.", e);
                }
            }
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getProperties(HttpPropfind.Depth depth) throws ClientProtocolException, IOException, HttpException {
        this.log.debug((Object)("PROPFIND depth:[" + depth.getValue() + "]"));
        HttpPropfind method = new HttpPropfind(this.requestUri, depth);
        if (this.service != null) {
            this.service.addSessionHeaders((HttpRequestBase)method);
        }
        HttpResponse response = this.executeWithPreemptiveAuthentication((HttpUriRequest)method);
        try {
            int code = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("PROPFIND statusCode:[" + code + "]"));
            if (code != 207) {
                String host;
                if (null != this.requestUri && 405 == code && ((host = this.requestUri.getHost().toLowerCase()).equals("localhost") || host.endsWith(".local"))) {
                    throw new IOException("Your Apache configuration, may be incorrect for WebDAV. " + response.getStatusLine().getReasonPhrase());
                }
                throw new HttpException(response.getStatusLine());
            }
            Map<String, Resource> properties = method.parseResponse(response.getEntity(), this.getAsResource());
            if (properties == null) {
                boolean bl = false;
                return bl;
            }
            this.log.debug((Object)("PROPFIND children:[" + properties + "]"));
            if (depth == HttpPropfind.Depth.Children) {
                this.childResources.clear();
                this.childResources.putAll(properties);
            } else if (!properties.isEmpty()) {
                this.resource = properties.values().iterator().next();
                this.log.debug((Object)("resource:[" + this.resource + "]"));
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createDirectoryOnServer(String remoteFolderPath) throws URISyntaxException, IOException {
        URI directoryUri;
        this.log.debug((Object)("MKCOL remoteFolderPath:[" + remoteFolderPath + "]"));
        URIBuilder builder = new URIBuilder(this.requestUri);
        builder.setPath(remoteFolderPath);
        try {
            directoryUri = builder.build();
        }
        catch (URISyntaxException erruri) {
            return false;
        }
        HttpMkcol method = new HttpMkcol(directoryUri);
        if (this.service != null) {
            this.service.addSessionHeaders(method);
        }
        HttpResponse response = this.executeWithPreemptiveAuthentication((HttpUriRequest)method);
        try {
            int code = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("MKCOL statusCode:[" + code + "]"));
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFileOnServer(String filePath) throws IOException, URISyntaxException {
        this.log.debug((Object)("DELETE filePath:[" + filePath + "]"));
        URIBuilder builder = new URIBuilder(this.requestUri);
        builder.setPath(filePath);
        HttpDelete method = new HttpDelete(builder.build());
        if (this.service != null) {
            this.service.addSessionHeaders((HttpRequestBase)method);
        }
        HttpResponse response = this.executeWithPreemptiveAuthentication((HttpUriRequest)method);
        try {
            int code = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("DELETE statusCode:[" + code + "]"));
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadFileToServer(String filePath, HttpEntity reqEntity) throws URISyntaxException, IOException {
        this.log.debug((Object)("PUT filePath:[" + filePath + "]"));
        URIBuilder builder = new URIBuilder(this.requestUri);
        builder.setPath(filePath);
        HttpPut method = new HttpPut(builder.build());
        method.setEntity(reqEntity);
        if (this.service != null) {
            this.service.addSessionHeaders((HttpRequestBase)method);
        }
        HttpResponse response = this.executeWithPreemptiveAuthentication((HttpUriRequest)method);
        try {
            int code = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("PUT statusCode:[" + code + "]"));
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    @Override
    public boolean uploadFileToServer(String filePath, File oneFileInPkg) throws URISyntaxException, IOException {
        return this.uploadFileToServer(filePath, (HttpEntity)new FileEntity(oneFileInPkg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadFileChunkToServer(String filePath, ChunkedFileSource oneFileInPkg, long start, long end) throws URISyntaxException, IOException {
        HttpResponse response;
        this.log.debug((Object)("PUT filePath:[" + filePath + "] start:[" + start + "] end:[" + end + "]"));
        URIBuilder builder = new URIBuilder(this.requestUri);
        builder.setPath(filePath);
        HttpPut method = new HttpPut(builder.build());
        this.setByteArrayEntity(method, oneFileInPkg, start, end);
        if (this.service != null) {
            this.service.addSessionHeaders((HttpRequestBase)method);
        }
        this.response = response = this.executeWithPreemptiveAuthentication((HttpUriRequest)method);
        try {
            int code = response.getStatusLine().getStatusCode();
            this.log.debug((Object)("PUT statusCode:[" + code + "]"));
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    private void setByteArrayEntity(HttpPut method, ChunkedFileSource oneFileInPkg, long start, long end) throws IOException {
        if (start > end) {
            throw new IndexOutOfBoundsException("The start index cannot be greater than the end index.");
        }
        long fileLength = oneFileInPkg.length();
        if (end >= fileLength) {
            throw new IndexOutOfBoundsException("The end index cannot be greater than or equal to the file's length.");
        }
        long dataLength = end - start + 1L;
        byte[] data = new byte[(int)dataLength];
        oneFileInPkg.readFully(data);
        String rangeString = "bytes " + start + "-" + end + "/" + fileLength;
        method.setHeader("Content-Range", rangeString);
        this.log.debug((Object)("Content-Range:[" + rangeString + "]"));
        ByteArrayEntity entity = new ByteArrayEntity(data);
        method.setEntity((HttpEntity)entity);
    }
}

