/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport.webdav;

import java.net.URI;

public class Resource {
    private final String name;
    private final URI href;
    private final long contentLength;
    private final long lastModified;

    public Resource(URI href, long contentLength, long lastModified) {
        this.href = href;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
        this.name = Resource.basename(href.getPath());
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isCollection() {
        return this.contentLength == 0L;
    }

    public boolean equals(Object other) {
        return other instanceof Resource && ((Resource)other).href.equals(this.href);
    }

    public String toString() {
        return this.href.toString();
    }

    private static String basename(String path) {
        if (path.length() == 0 || path.equals("/")) {
            return "";
        }
        int slash = path.lastIndexOf(47);
        if (slash == -1) {
            return path;
        }
        if (slash == path.length() - 1) {
            int end = slash;
            if ((slash = path.lastIndexOf(47, end - 1)) == -1) {
                return path.substring(0, end);
            }
            return path.substring(slash + 1, end);
        }
        return path.substring(slash + 1);
    }
}

