/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport.webdav;

import com.apple.transporter.transport.webdav.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HttpPropfind
extends HttpEntityEnclosingRequestBase {
    public static final String METHOD_NAME = "PROPFIND";
    private static final String PropfindXml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><d:propfind xmlns:d='DAV:'><d:prop><d:getcontentlength/><d:getlastmodified/></d:prop></d:propfind>";
    private static final SimpleDateFormat rfc1123DateFormat = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss zz", Locale.US);
    private static boolean compiledXPaths;
    private static XPathExpression responsesXPath;
    private static XPathExpression hrefXPath;
    private static XPathExpression getContentLengthXPath;
    private static XPathExpression getLastModifiedXPath;
    private final Depth depth;

    public HttpPropfind(URI uri, Depth depth) {
        this.depth = depth;
        this.setURI(uri);
        this.setHeader("Depth", depth.getValue());
        this.setEntity((HttpEntity)new StringEntity(PropfindXml, ContentType.APPLICATION_XML));
    }

    public String getMethod() {
        return METHOD_NAME;
    }

    protected Map<String, Resource> parseResponse(HttpEntity responseEntity, Resource parent) throws IOException {
        ContentType fromResponse = ContentType.get((HttpEntity)responseEntity);
        if (!ContentType.APPLICATION_XML.getMimeType().equals(fromResponse.getMimeType()) && !ContentType.TEXT_XML.getMimeType().equals(fromResponse.getMimeType())) {
            throw new IOException("response Content-Type is unexpected: " + fromResponse);
        }
        try {
            Document document = this.parseResponseXml(responseEntity.getContent());
            NodeList responses = (NodeList)HttpPropfind.responsesXPath().evaluate(document, XPathConstants.NODESET);
            HashMap<String, Resource> responseMap = new HashMap<String, Resource>(responses.getLength());
            for (int i = 0; i < responses.getLength(); ++i) {
                Node responseNode = responses.item(i);
                Resource oneFile = this.extractResource(responseNode, parent);
                if (oneFile.equals(parent)) {
                    if (this.depth != Depth.Self) continue;
                    responseMap.put(".", oneFile);
                    return responseMap;
                }
                if (this.depth == Depth.Self) continue;
                responseMap.put(oneFile.getName(), oneFile);
            }
            return responseMap;
        }
        catch (IOException errio) {
            throw errio;
        }
        catch (Exception ex) {
            throw new IOException("Unable to parse WebDAV PROPFIND response.", ex);
        }
    }

    private Document parseResponseXml(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://xml.org/sax/features/validation", false);
        factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(stream);
    }

    private Resource extractResource(Node responseNode, Resource parent) throws XPathExpressionException, URISyntaxException, ParseException {
        String href = HttpPropfind.hrefXPath().evaluate(responseNode);
        String getContentLength = HttpPropfind.getContentLengthXPath().evaluate(responseNode);
        String getLastModified = HttpPropfind.getLastModifiedXPath().evaluate(responseNode);
        URI newUri = href.charAt(0) == '/' ? parent.getHref().resolve(href) : new URI(href);
        long contentLength = getContentLength == null || getContentLength.length() == 0 ? 0L : Long.parseLong(getContentLength);
        long lastModified = rfc1123DateFormat.parse(getLastModified).getTime();
        return new Resource(newUri, contentLength, lastModified);
    }

    private static void compileXPaths() throws XPathExpressionException {
        if (compiledXPaths) {
            return;
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        responsesXPath = xpath.compile("/*[local-name()='multistatus' and namespace-uri()='DAV:']/*[local-name()='response' and namespace-uri()='DAV:']");
        hrefXPath = xpath.compile("*[local-name()='href' and namespace-uri()='DAV:']");
        getContentLengthXPath = xpath.compile("*[local-name()='propstat' and namespace-uri()='DAV:']/*[local-name()='prop' and namespace-uri()='DAV:']/*[local-name()='getcontentlength']");
        getLastModifiedXPath = xpath.compile("*[local-name()='propstat' and namespace-uri()='DAV:']/*[local-name()='prop' and namespace-uri()='DAV:']/*[local-name()='getlastmodified']");
        compiledXPaths = true;
    }

    private static XPathExpression responsesXPath() throws XPathExpressionException {
        HttpPropfind.compileXPaths();
        return responsesXPath;
    }

    private static XPathExpression hrefXPath() throws XPathExpressionException {
        HttpPropfind.compileXPaths();
        return hrefXPath;
    }

    private static XPathExpression getContentLengthXPath() throws XPathExpressionException {
        HttpPropfind.compileXPaths();
        return getContentLengthXPath;
    }

    private static XPathExpression getLastModifiedXPath() throws XPathExpressionException {
        HttpPropfind.compileXPaths();
        return getLastModifiedXPath;
    }

    public static enum Depth {
        Self("0"),
        Children("1");

        private final String value;

        private Depth(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

