/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport.webdav;

import org.apache.http.StatusLine;

public class HttpException
extends Exception {
    private static final long serialVersionUID = -3230843108852772680L;

    protected HttpException(StatusLine httpStatus) {
        super(httpStatus.getReasonPhrase() != null ? httpStatus.getReasonPhrase() : httpStatus.getStatusCode() + " " + HttpException.httpErrorCodeAsString(httpStatus.getStatusCode()));
    }

    public static String httpErrorCodeAsString(int errorCode) {
        switch (errorCode) {
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Temporary Redirect";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-Out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return "Unknown";
    }
}

