/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.Application;
import com.apple.transporter.ServerConnectionException;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportReturnValue;
import com.apple.transporter.transport.TransportStalledException;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.webdav.ChunkedFileSource;
import com.apple.transporter.transport.webdav.HttpException;
import com.apple.transporter.transport.webdav.RandomAccessFileSource;
import com.apple.transporter.transport.webdav.Resource;
import com.apple.transporter.transport.webdav.WebDAV;
import com.apple.transporter.transport.webdav.WebdavFile;
import com.apple.transporter.util.FileChunkUtil;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.ProgressMonitor;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class WebDAVTransport
implements TransportInterface,
ProgressMonitor.Monitorable {
    private boolean resumeFlag;
    private String newPackageName;
    private List<String> serverNames;
    private String folderPath;
    private String username;
    private String password;
    private int transportPort;
    private String transportArea;
    private ITMSPackage itmsPackage;
    private String diagnosticPath;
    private Long transferTimeInMilliseconds;
    private boolean isRetry;
    private boolean isStalled = false;
    private String logFileName;
    private static final String davLogFileName = "webdav-transfer.log";

    @Override
    public void setTransportArea(String value) {
        this.transportArea = value;
    }

    @Override
    public String transportArea() {
        return this.transportArea;
    }

    @Override
    public void setTransportPort(int value) {
        this.transportPort = value;
    }

    @Override
    public int transportPort() {
        return this.transportPort;
    }

    @Override
    public void setResumeFlag(boolean value) {
        this.resumeFlag = value;
    }

    @Override
    public boolean resumeFlag() {
        return this.resumeFlag;
    }

    @Override
    public void setNewPackageName(String value) {
        this.newPackageName = value;
    }

    @Override
    public String newPackageName() {
        return this.newPackageName;
    }

    @Override
    public void setServerNames(List<String> value) {
        this.serverNames = value;
    }

    @Override
    public List<String> serverNames() {
        return this.serverNames;
    }

    public String serverName() {
        if (this.serverNames() == null || this.serverNames().size() == 0) {
            return null;
        }
        return this.serverNames.get(0);
    }

    @Override
    public void setFolderPath(String value) {
        this.folderPath = value;
    }

    @Override
    public String folderPath() {
        return this.folderPath;
    }

    @Override
    public void setItmsPackage(ITMSPackage value) {
        this.itmsPackage = value;
    }

    @Override
    public ITMSPackage itmsPackage() {
        return this.itmsPackage;
    }

    @Override
    public void setUsername(String value) {
        this.username = value;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public void setPassword(String value) {
        this.password = value;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public void setCertificate(String value) {
    }

    @Override
    public void setToken(String value) {
    }

    @Override
    public void setDecryptionKey(String key) {
    }

    @Override
    public void setSharedDecryptionSeed(String seed) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String transportLogFileName() {
        if (this.logFileName == null) {
            String tmpDirPropertyValue = System.getProperty("java.io.tmpdir");
            String tmpDir = null;
            try {
                tmpDir = FileUtil.absolutePathForPath(tmpDirPropertyValue);
            }
            catch (IOException ioe) {
                Logger.info("An error occurred trying to get the absolute path for the 'java.io.tmpdir' System property.", ioe);
                this.logFileName = null;
                return this.logFileName;
            }
            if (tmpDir == null || tmpDir.length() == 0) {
                Logger.info("Could not get 'java.io.tmpdir' from the System's properties.  Cannot create the WebDAV log file.");
                this.logFileName = null;
                return this.logFileName;
            }
            Calendar now = Calendar.getInstance();
            if (this.itmsPackage() == null) {
                this.logFileName = null;
                return this.logFileName;
            }
            String parentDirName = NSPathUtilities.stringByDeletingPathExtension(this.itmsPackage().packageName());
            File fullDirFile = new File(tmpDir, parentDirName = parentDirName + "_" + now.get(1) + now.get(2) + now.get(5) + now.get(11) + now.get(12) + now.get(13) + "_WebDAV");
            if (!fullDirFile.exists()) {
                boolean didMakeDir = fullDirFile.mkdirs();
                if (!didMakeDir) {
                    Logger.info("Could not create the directory '" + fullDirFile + "'.  Cannot create the WebDAV log file.");
                    this.logFileName = null;
                    return this.logFileName;
                }
                fullDirFile.deleteOnExit();
            }
            File logFile = new File(fullDirFile, davLogFileName);
            try {
                this.logFileName = logFile.getCanonicalPath();
            }
            catch (IOException ioe) {
                Logger.info("Could not get the full WebDAV log file path.  No WebDAV log file will be created.", ioe);
                this.logFileName = null;
            }
            finally {
                logFile.deleteOnExit();
            }
        }
        return this.logFileName;
    }

    @Override
    public Long transferTimeInMilliseconds() {
        return this.transferTimeInMilliseconds;
    }

    @Override
    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void setIsRetry(boolean value) {
        this.isRetry = value;
    }

    /*
     * Exception decompiling
     */
    @Override
    public TransportReturnValue uploadPackage(WebService service, boolean willRetry) throws ServerConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public TransportReturnValue uploadFile(String fullPath, WebService service) throws ServerConnectionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean prepareWebDAVFolders(WebDAV wdr, String remoteFolderPath) throws URISyntaxException, IOException, HttpException {
        if (wdr == null || remoteFolderPath == null || remoteFolderPath.length() == 0) {
            return false;
        }
        boolean success = true;
        if (this.resumeFlag()) {
            Logger.info("Attempting to resume upload of package ...");
            try {
                wdr.setPath(remoteFolderPath);
                success = true;
            }
            catch (HttpException he) {
                Logger.error("Could NOT set the remote path to the existing package.", he);
                success = false;
            }
        } else {
            Logger.info("Attempting to create the package's folder on Apple's webDAV: " + remoteFolderPath);
            success = wdr.createDirectoryOnServer(remoteFolderPath);
            if (!success && this.isRetry()) {
                try {
                    wdr.setPath(remoteFolderPath);
                    success = true;
                }
                catch (HttpException he) {
                    Logger.error("Could NOT set the remote path to the existing package.", he);
                    success = false;
                }
            }
        }
        if (success) {
            Logger.info("Successfully created/set the package's folder on Apple's webDAV.");
        } else {
            Logger.error("Could not create/set the package's folder on Apple's webDAV.");
        }
        return success;
    }

    private boolean createWebDAVFolderAndChangeDir(WebDAV wdr, String remoteFolderPath) throws URISyntaxException, IOException, HttpException {
        if (wdr == null || remoteFolderPath == null || remoteFolderPath.length() == 0) {
            return false;
        }
        boolean success = true;
        try {
            String path;
            URI uri = new URI(remoteFolderPath);
            remoteFolderPath = path = uri.getPath();
        }
        catch (URISyntaxException erruri) {
            Logger.error("Invalid URI: " + remoteFolderPath, erruri);
        }
        Logger.info("Attempting to create and change to directory on Apple's webDAV: " + remoteFolderPath);
        success = wdr.createDirectoryOnServer(remoteFolderPath);
        if (!success) {
            Logger.debug("Unable to create directory, trying to change directory: " + remoteFolderPath);
        }
        try {
            wdr.setPath(remoteFolderPath);
            success = true;
        }
        catch (HttpException he) {
            Logger.error("Could NOT set the remote path to the specified directory.", he);
            success = false;
        }
        if (success) {
            Logger.info("Successfully created/set the directory on Apple's webDAV.");
        } else {
            Logger.error("Could not create/set the directory on Apple's webDAV.");
        }
        return success;
    }

    private WebDAV createConnectionToWebDAVURL(String fullURL, String logFileName, WebService service) throws URISyntaxException, IOException, HttpException {
        if (!fullURL.endsWith("/")) {
            fullURL = fullURL + "/";
            Logger.extreme("Added a trailing slash to the URL to make it ... " + fullURL);
        }
        Logger.info("Attempting to connect to Apple's webDAV...");
        URI uri = new URI(fullURL);
        WebdavFile wdr = new WebdavFile(uri, logFileName, service);
        wdr.setUserInfo(this.username(), this.password());
        wdr.init();
        Logger.info("Successfully connected to Apple's webDAV.");
        return wdr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putFilesOnWebDAV(WebDAV wdr, List<File> filesToUpload, String remoteFolderPath, Map<String, Map<String, Object>> alreadyUploadedFilesInfo) throws HttpException, IOException, TransportStalledException, URISyntaxException {
        if (wdr == null || filesToUpload == null || filesToUpload.size() == 0 || remoteFolderPath == null || remoteFolderPath.length() == 0) {
            return false;
        }
        TransportUtil.postPreparingToUploadFilesNotification(filesToUpload, this.itmsPackage(), this.resumeFlag(), this.isRetry());
        List<File> orderedFiles = null;
        try {
            orderedFiles = TransportUtil.orderedFilesToBeUploaded(filesToUpload, this.itmsPackage());
        }
        catch (Throwable t) {
            Logger.error("An error occurred while ordering the files to be uploaded.", t);
            return false;
        }
        if (!wdr.getPath().equals(remoteFolderPath)) {
            if (!remoteFolderPath.endsWith("/")) {
                remoteFolderPath = remoteFolderPath + "/";
            }
            wdr.setPath(remoteFolderPath);
        }
        this.isStalled = false;
        boolean didPutFiles = false;
        try {
            ProgressMonitor.monitor(this, Math.max(ProgressMonitor.DEFAULT_MAXIMUM_HEARTBEAT_INTERLUDE, FileChunkUtil.chunkSize() * 60000L / 1024L / 1024L));
            Date start = new Date();
            didPutFiles = this.putSubsetOfFilesOnWebDAV(wdr, orderedFiles, remoteFolderPath, alreadyUploadedFilesInfo);
            Date end = new Date();
            this.transferTimeInMilliseconds = TransportUtil.transferTimeInMilliseconds(start, end);
        }
        finally {
            ProgressMonitor.stopMonitoring(this);
        }
        return didPutFiles;
    }

    @Override
    public void abort() {
        this.isStalled = true;
        Logger.debug("Received stalled transfer notification; aborting");
    }

    private boolean deleteOldFilesOnWebDAV(WebDAV wdr, String remoteFolderPath, Map<String, Map<String, Object>> alreadyUploadedFilesInfo) throws HttpException, IOException, URISyntaxException {
        if (wdr == null || remoteFolderPath == null || remoteFolderPath.equals("") || !remoteFolderPath.equals(wdr.getPath())) {
            return false;
        }
        if (alreadyUploadedFilesInfo == null || alreadyUploadedFilesInfo.size() == 0) {
            return true;
        }
        boolean returnValue = true;
        Logger.info("Comparing the local file list to the remote file list to determine if anything should be deleted on Apple's webDAV ...");
        Collection<String> fileNamesToDelete = this.itmsPackage().filesToBeRemovedFromDestination(alreadyUploadedFilesInfo, TransportType.DAV);
        if (fileNamesToDelete != null) {
            Iterator<Resource> wdrChildResources = wdr.getResources();
            while (!fileNamesToDelete.isEmpty() && wdrChildResources.hasNext()) {
                Resource oneResourceOnWD = wdrChildResources.next();
                String resourceDisplayName = oneResourceOnWD.getName();
                if (!fileNamesToDelete.contains(resourceDisplayName)) continue;
                Logger.debug("The file: " + resourceDisplayName + " was found in the remote package, but either its size/date does not match the corresponding local file or it is no longer a part of your upload package.");
                Logger.debug("   Attempting to remove " + resourceDisplayName + " from Apple's webDAV...");
                boolean success = wdr.deleteFileOnServer(oneResourceOnWD.getHref().getPath());
                if (success) {
                    alreadyUploadedFilesInfo.remove(resourceDisplayName);
                    Logger.debug("   " + resourceDisplayName + " has been successfully removed.");
                    continue;
                }
                Logger.error("   There was an error while attempting to delete " + resourceDisplayName + " on Apple's webDAV.");
                returnValue = false;
            }
        }
        Logger.info("Done comparing the local file list to the remote file list to determine if anything should be deleted on Apple's webDAV.");
        return returnValue;
    }

    private void closeWebDAVConnection(WebDAV wdr) {
        if (wdr == null) {
            return;
        }
        try {
            wdr.close();
        }
        catch (IOException ioe) {
            Logger.error("Could NOT close the connection to Apple's remote server.");
        }
    }

    private boolean doSourceAndDestinationFileLengthsMatch(File sourceFile, Resource remoteResource) {
        if (remoteResource == null || sourceFile == null) {
            return false;
        }
        long lengthOfFileAtSource = this.itmsPackage == null ? sourceFile.length() : this.itmsPackage.getFileSize(sourceFile);
        long lengthOfFileAtDestination = remoteResource.getContentLength();
        Logger.extreme("Comparing local and remote file sizes...");
        Logger.extreme("  local filename:" + sourceFile.getName() + ", local filesize: " + lengthOfFileAtSource);
        Logger.extreme("  remote filename: " + remoteResource + ", remote filesize: " + lengthOfFileAtDestination);
        return lengthOfFileAtSource == lengthOfFileAtDestination;
    }

    private Map<String, Map<String, Object>> gatherAlreadyUploadedFilesInfo(WebDAV wdr) {
        Logger.info("Gathering list of uploaded files from Apple's webDAV...");
        HashMap<String, Map<String, Object>> alreadyUploadedFiles = new HashMap<String, Map<String, Object>>();
        try {
            Iterator<Resource> wdrChildResources = wdr.getResources();
            if (wdrChildResources == null || !wdrChildResources.hasNext()) {
                return alreadyUploadedFiles;
            }
            String parentOfWDRPath = NSPathUtilities.stringByNormalizingPath(NSPathUtilities.stringByDeletingLastPathComponent(wdr.getPath()));
            while (wdrChildResources.hasNext()) {
                Resource oneResourceOnWD = wdrChildResources.next();
                String path = oneResourceOnWD.getHref().getPath();
                String normalizedResourcePath = NSPathUtilities.stringByNormalizingPath(path);
                if (normalizedResourcePath.equals(parentOfWDRPath)) {
                    Logger.extreme("Parent folder found in child list, not adding to already uploaded files: " + parentOfWDRPath);
                    continue;
                }
                if (oneResourceOnWD.getName().equals(this.newPackageName())) {
                    Logger.extreme("Parent folder found in child list, not adding to already uploaded files: " + this.newPackageName());
                    continue;
                }
                String lastComponent = NSPathUtilities.lastPathComponent(path);
                if (lastComponent != null && lastComponent.equals(this.newPackageName())) {
                    Logger.extreme("Parent folder found in child list, not adding to already uploaded files: " + lastComponent);
                    continue;
                }
                long fileSize = oneResourceOnWD.getContentLength();
                String resourceName = oneResourceOnWD.getName();
                Long resourceSize = new Long(fileSize);
                long lastModified = oneResourceOnWD.getLastModified();
                Long resourceLastModified = new Long(lastModified);
                HashMap<String, Long> sizeAndDateDict = new HashMap<String, Long>();
                sizeAndDateDict.put("RemoteFileSize", resourceSize);
                sizeAndDateDict.put("RemoteFileLastModified", resourceLastModified);
                alreadyUploadedFiles.put(resourceName, sizeAndDateDict);
            }
        }
        catch (Throwable t) {
            Application.logExceptionWithUnnecessaryError("An error occured while attempting to gather list of uploaded files from Apple's webDAV.", t);
        }
        Logger.info("Done gathering list of uploaded files from Apple's webDAV...");
        return alreadyUploadedFiles;
    }

    private boolean putSubsetOfFilesOnWebDAV(WebDAV wdr, List<File> filesToUpload, String remoteFolderPath, Map<String, Map<String, Object>> alreadyUploadedFilesInfo) throws IOException, TransportStalledException, URISyntaxException, HttpException {
        if (wdr == null || remoteFolderPath == null || remoteFolderPath.length() == 0) {
            return false;
        }
        if (filesToUpload == null || filesToUpload.size() == 0) {
            return true;
        }
        for (File oneFileInPkg : filesToUpload) {
            boolean success = this.putFileOnServer(wdr, oneFileInPkg, remoteFolderPath, oneFileInPkg.getName(), alreadyUploadedFilesInfo);
            if (success) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putFileOnServer(WebDAV wdr, File file, String remoteFolderPath, String destinationFilename, Map<String, Map<String, Object>> alreadyUploadedFilesInfo) throws HttpException, IOException, TransportStalledException, URISyntaxException {
        long length;
        File oneFileInPkg = file;
        if (!remoteFolderPath.endsWith("/")) {
            remoteFolderPath = remoteFolderPath + '/';
        }
        String filePath = remoteFolderPath + destinationFilename;
        Logger.info("Starting upload of file: " + oneFileInPkg.getPath() + " ...");
        boolean success = true;
        if (!FileChunkUtil.shouldFileBeChunked(this.itmsPackage == null ? oneFileInPkg.length() : this.itmsPackage.getFileSize(oneFileInPkg)) || !FileChunkUtil.isChunkingEnabled(TransportType.DAV)) {
            ProgressMonitor.heartbeat(this);
            success = this.itmsPackage != null ? wdr.uploadFileToServer(filePath, this.itmsPackage.getDavHttpEntityForFile(oneFileInPkg)) : wdr.uploadFileToServer(filePath, oneFileInPkg);
            length = this.itmsPackage == null ? oneFileInPkg.length() : this.itmsPackage.getFileSize(oneFileInPkg);
            TransportUtil.postFileHasBeenPartiallyUploadedNotification(destinationFilename, length, length);
        } else {
            long end;
            length = this.itmsPackage == null ? oneFileInPkg.length() : this.itmsPackage.getFileSize(oneFileInPkg);
            Map<String, Object> fileInfo = null;
            if (alreadyUploadedFilesInfo != null && this.resumeFlag()) {
                fileInfo = alreadyUploadedFilesInfo.get(destinationFilename);
            }
            Long alreadyUploadedSize = null;
            if (fileInfo != null) {
                alreadyUploadedSize = (Long)fileInfo.get("RemoteFileSize");
                Logger.info("     Resuming upload of " + destinationFilename + ", " + (alreadyUploadedSize - 1L) + " bytes have already been uploaded.");
            }
            long chunkSize = FileChunkUtil.chunkSize();
            long start = 0L;
            if (alreadyUploadedSize != null) {
                start = alreadyUploadedSize;
            }
            if ((end = start + chunkSize - 1L) > length) {
                end = length - 1L;
            }
            try (ChunkedFileSource fileSource = this.itmsPackage != null ? this.itmsPackage.chunkedFileSource(oneFileInPkg) : new RandomAccessFileSource(oneFileInPkg);){
                if (start != 0L) {
                    fileSource.seek(start);
                }
                while (!this.isStalled && success && start < length) {
                    ProgressMonitor.heartbeat(this);
                    try {
                        success = wdr.uploadFileChunkToServer(filePath, fileSource, start, end);
                        if (start != 0L && wdr.getStatusCode() == 201) {
                            Logger.error("     The upload was corrupted during transfer of the file: " + filePath);
                            wdr.deleteFileOnServer(filePath);
                            success = false;
                        }
                    }
                    catch (Throwable t) {
                        success = false;
                        Logger.error("     An error occurred while uploading the file " + destinationFilename + ".", t);
                    }
                    TransportUtil.postFileHasBeenPartiallyUploadedNotification(destinationFilename, end + 1L, length);
                    start = end + 1L;
                    if ((end += chunkSize) <= length) continue;
                    end = length - 1L;
                }
            }
        }
        if (this.isStalled) {
            throw new TransportStalledException();
        }
        if (!success) {
            Logger.error("  Failed to upload file: " + oneFileInPkg.getPath());
            return false;
        }
        Logger.info("  Successfully uploaded file: " + oneFileInPkg.getPath());
        Logger.debug("Checking file size after upload of: " + oneFileInPkg.getPath());
        Iterator<Resource> childResources = wdr.getResources();
        if (childResources == null || !childResources.hasNext()) {
            Logger.error("Could not list the contents of the package on the remote server.");
            return false;
        }
        Resource remoteResource = wdr.getResource(destinationFilename);
        if (remoteResource == null) {
            Logger.error("Could not find the file " + destinationFilename + " on the remote server.");
            return false;
        }
        if (!this.doSourceAndDestinationFileLengthsMatch(oneFileInPkg, remoteResource)) {
            Logger.error("  Post-upload file size check failed for: " + oneFileInPkg.getPath());
            return false;
        }
        if (this.itmsPackage != null) {
            TransportUtil.postFileUploadSucceededNotification(this.itmsPackage, oneFileInPkg);
        }
        Logger.info("Finished upload of file: " + oneFileInPkg.getPath() + ".");
        return true;
    }

    @Override
    public void releaseResourcesPriorToFinalization() {
    }

    @Override
    public void setDefaultLoggingLevel(String loggingLevel) {
    }

    @Override
    public void setPodAssignmentInvocation(WebServiceInvoker.Invocation<Map> invocation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performDiagnostic(boolean strict) {
        CloseableHttpClient client = null;
        try {
            String basePath = TransportUtil.remoteFilePath(this.serverName(), this.diagnosticPath, TransportType.DAV);
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().useSystemProperties().disableCookieManagement();
            Integer readTimeout = Integer.getInteger("com.apple.transporter.httpReadTimeout");
            if (readTimeout != null && readTimeout >= 0) {
                SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(readTimeout.intValue()).build();
                clientBuilder.setDefaultSocketConfig(socketConfig);
            }
            clientBuilder.disableAutomaticRetries();
            client = clientBuilder.build();
            HttpGet getRequest = new HttpGet(basePath);
            CloseableHttpResponse response = client.execute((HttpUriRequest)getRequest);
            Logger.extreme("WebDAV status: " + response.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            Logger.error("unable to verify WebDAV transport: " + e.getMessage());
            boolean bl = TransportUtil.performUnauthenticatedDiagnostic(TransportType.DAV, strict);
            return bl;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    Logger.debug("unable to close WebDAV connection: " + e.getMessage());
                }
            }
        }
        return true;
    }

    @Override
    public void setDiagnosticPath(String diagnosticPath) {
        this.diagnosticPath = diagnosticPath;
    }
}

