/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.operation.option.UsernameOption;
import com.apple.transporter.transport.AsperaTransport;
import com.apple.transporter.transport.DirectSANMoveTransport;
import com.apple.transporter.transport.SigniantTransport;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.WebDAVTransport;

public enum TransportType {
    Aspera(true, true){

        @Override
        public TransportInterface createTransport() {
            return new AsperaTransport();
        }
    }
    ,
    Signiant(true, true){

        @Override
        public TransportInterface createTransport() {
            SigniantTransport response = new SigniantTransport();
            response.setPassword(" ");
            return response;
        }
    }
    ,
    DirectSANMove(false, false){

        @Override
        public TransportInterface createTransport() {
            DirectSANMoveTransport response = new DirectSANMoveTransport();
            response.setPassword("");
            return response;
        }
    }
    ,
    DAV(false, true){

        @Override
        public TransportInterface createTransport() {
            WebDAVTransport response = new WebDAVTransport();
            response.setUsername(UsernameOption.username());
            response.setPassword(System.getProperty("p"));
            return response;
        }
    };

    private final boolean throttleCapable;
    private final boolean chainable;
    public static final String autoArgValue = "Auto";

    public boolean isThrottleCapable() {
        return this.throttleCapable;
    }

    public boolean isChainable() {
        return this.chainable;
    }

    public boolean isAspera() {
        return Aspera == this;
    }

    public boolean isSigniant() {
        return Signiant == this;
    }

    public boolean isDirectSANMove() {
        return DirectSANMove == this;
    }

    public boolean isDAV() {
        return DAV == this;
    }

    public boolean canPerformDiagnostic() {
        return !this.isDirectSANMove();
    }

    public abstract TransportInterface createTransport();

    private TransportType(boolean canThrottle, boolean chainable) {
        this.throttleCapable = canThrottle;
        this.chainable = chainable;
    }
}

