/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.TransportUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TransportPod {
    private final TransportType type;
    private final String name;
    private final String area;
    private final String user;
    private final Number port;
    private final List<String> serverNames;
    private final String certificate;
    private final String token;
    private final String path;
    private final String logLevel;
    private final String decryptionKey;
    private final String diagnosticPath;

    public String toString() {
        if (this.name != null) {
            return this.name + " (" + (Object)((Object)this.type) + ")";
        }
        return this.type.toString();
    }

    public static TransportPod createFromValidateAssetsResponse(TransportType transport, Map validateAssetsResponse) {
        String name = (String)validateAssetsResponse.get(System.getProperty("transportPodKey"));
        String area = TransportUtil.transportAreaFromAuthenticateReturnValue(validateAssetsResponse);
        String user = TransportUtil.transportUserFromAuthenticateReturnValue(validateAssetsResponse);
        String logLevel = (String)validateAssetsResponse.get(System.getProperty(transport.isSigniant() ? "signiantLoggingLevelKey" : "asperaLoggingLevelKey"));
        Integer port = TransportUtil.transportPortFromAuthenticateReturnValue(validateAssetsResponse);
        List<String> serverNames = TransportUtil.serverNamesFromAuthenticateReturnValue(validateAssetsResponse, transport);
        String path = TransportUtil.folderPathFromAuthenticateReturnValue(validateAssetsResponse, transport);
        String certificate = TransportUtil.transportCertificateFromAuthenticateReturnValue(validateAssetsResponse);
        String token = TransportUtil.transportTokenFromAuthenticateReturnValue(validateAssetsResponse);
        String decryptionKey = (String)validateAssetsResponse.get(System.getProperty("transportDecryptionKey"));
        String diagnosticPath = (String)validateAssetsResponse.get(System.getProperty("transportDiagnosticPathKey"));
        if (name == null) {
            name = System.getProperty("pod");
        }
        return new TransportPod(transport, name, serverNames.toArray(new String[serverNames.size()]), port, path, area, user, logLevel, certificate, token, decryptionKey, diagnosticPath);
    }

    public static TransportPod createFromMap(Map<String, ?> podDescription, Map<String, ?> transportDiscoveryResults) {
        String[] serverNames;
        String path;
        String mapType = (String)podDescription.get(System.getProperty("transportTypeKey"));
        TransportType type = TransportType.valueOf(mapType);
        String name = (String)podDescription.get(System.getProperty("transportPodNameKey"));
        String area = (String)podDescription.get(System.getProperty("transportAreaKey"));
        String user = (String)podDescription.get(System.getProperty("transportUserKey"));
        String logLevel = (String)transportDiscoveryResults.get(System.getProperty(type.isSigniant() ? "signiantLoggingLevelKey" : "asperaLoggingLevelKey"));
        Number port = (Number)podDescription.get(System.getProperty("transportPortKey"));
        String diagnosticPath = (String)podDescription.get(System.getProperty("transportDiagnosticPathKey"));
        String decryptionKey = null;
        if (type.isDAV()) {
            path = (String)podDescription.get(System.getProperty("webDavFolderPathKey"));
            serverNames = new String[]{(String)podDescription.get(System.getProperty("webDavServerNameKey"))};
            if (diagnosticPath == null) {
                diagnosticPath = "/";
            }
        } else {
            path = (String)podDescription.get(System.getProperty("transportPathKey"));
            Object[] mapNames = (Object[])podDescription.get(System.getProperty("transportHostsKey"));
            if (mapNames != null) {
                serverNames = new String[mapNames.length];
                System.arraycopy(mapNames, 0, serverNames, 0, mapNames.length);
            } else {
                serverNames = null;
            }
            decryptionKey = (String)podDescription.get(System.getProperty("transportDecryptionKey"));
        }
        Map certsAndTokens = (Map)transportDiscoveryResults.get(System.getProperty("transportCertsAndTokensKey"));
        String certificate = null;
        String certificateKey = (String)podDescription.get(System.getProperty("transportCertificiateKey"));
        if (certificateKey != null) {
            certificate = (String)certsAndTokens.get(certificateKey);
        }
        String token = null;
        String tokenKey = (String)podDescription.get(System.getProperty("transportTokenKey"));
        if (tokenKey != null) {
            token = (String)certsAndTokens.get(tokenKey);
        }
        return new TransportPod(type, name, serverNames, port, path, area, user, logLevel, certificate, token, decryptionKey, diagnosticPath);
    }

    private TransportPod(TransportType type, String name, String[] serverNames, Number port, String path, String area, String user, String logLevel, String certificate, String token, String encryptionKey, String diagnosticPath) {
        this.type = type;
        this.name = name;
        this.serverNames = Arrays.asList(serverNames);
        this.port = port;
        this.path = path;
        this.area = area;
        this.user = user;
        this.logLevel = logLevel;
        this.certificate = certificate;
        this.token = token;
        this.decryptionKey = encryptionKey;
        this.diagnosticPath = diagnosticPath;
    }

    public TransportType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getServerNames() {
        return this.serverNames;
    }

    public Number getPort() {
        return this.port;
    }

    public String getDiagnosticPath() {
        return this.diagnosticPath;
    }

    public TransportInterface createTransport() {
        TransportInterface response = this.getType().createTransport();
        response.setFolderPath(this.path);
        if (this.serverNames != null) {
            String forcedHost = System.getProperty("host");
            if (this.serverNames.contains(forcedHost)) {
                response.setServerNames(Arrays.asList(forcedHost));
            } else {
                response.setServerNames(this.serverNames);
            }
        }
        response.setCertificate(this.certificate);
        response.setToken(this.token);
        response.setDecryptionKey(this.decryptionKey);
        response.setDefaultLoggingLevel(this.logLevel);
        response.setDiagnosticPath(this.diagnosticPath);
        switch (this.getType()) {
            case DirectSANMove: {
                response.setUsername(this.user);
                response.setTransportArea(this.area);
                break;
            }
            case Aspera: {
                response.setUsername(this.user);
                response.setTransportPort(this.port.intValue());
                break;
            }
            case Signiant: {
                response.setUsername(this.user);
                response.setTransportPort(this.port.intValue());
            }
        }
        return response;
    }
}

