/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import java.util.ArrayList;

public class TransportConnectionSpec {
    private String[] hosts;
    private int[] tcpPorts;
    private int[] udpPorts;

    public TransportConnectionSpec(String[] hosts, int[] tcpPorts, int[] udpPorts) {
        this.hosts = hosts;
        this.tcpPorts = tcpPorts;
        this.udpPorts = udpPorts;
    }

    public TransportConnectionSpec(String hosts, String tcpPorts, String udpPorts) {
        if (!(tcpPorts != null && tcpPorts.length() != 0 || udpPorts != null && udpPorts.length() != 0)) {
            throw new IllegalArgumentException("either tcpPorts or udpPorts must be non-empty");
        }
        this.hosts = this.splitStrings(hosts);
        this.tcpPorts = this.splitInts(tcpPorts);
        this.udpPorts = this.splitInts(udpPorts);
    }

    private String[] splitStrings(String s) {
        if (s == null || s.trim().length() == 0) {
            return new String[0];
        }
        String[] strings = s.split(",");
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    private int[] splitInts(String ints) {
        String[] split1;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String s : split1 = this.splitStrings(ints)) {
            if (s == null || s.length() <= 0) continue;
            int hyphen = (s = s.trim()).indexOf("-");
            if (hyphen == -1) {
                list.add(Integer.parseInt(s));
                continue;
            }
            for (int i = Integer.parseInt(s.substring(0, hyphen).trim()); i <= Integer.parseInt(s.substring(hyphen + 1).trim()); ++i) {
                list.add(i);
            }
        }
        int i = 0;
        int[] results = new int[list.size()];
        for (Integer integer : list) {
            results[i++] = integer;
        }
        return results;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public int[] getTcpPorts() {
        return this.tcpPorts;
    }

    public int[] getUdpPorts() {
        return this.udpPorts;
    }
}

