/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.NetworkStatusReporter;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportPod;
import com.apple.transporter.transport.TransportSelectionPolicy;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.StringUtil;
import com.apple.transporter.util.TransportUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TransportByPodPolicy
implements TransportSelectionPolicy {
    Boolean resumeFlag;
    String newPkgName;
    String podNameFromServer;
    private List<TransportPod> podsToUse;
    private List<TransportPod> allPods;
    private int currentPodIndex;
    private final WebService service;
    private final TransportType transport;
    private final Map webServiceResponse;
    private final String jsonhash;

    public TransportByPodPolicy(WebService service, TransportType transport, Map webServiceResponse) {
        this.service = service;
        this.transport = transport;
        this.webServiceResponse = webServiceResponse;
        this.jsonhash = service.getLastRequestChecksum() != null ? StringUtil.byteArrayToHexString(service.getLastRequestChecksum()) : null;
        this.init();
    }

    private synchronized TransportPod getCurrentPod() {
        try {
            return this.podsToUse.get(this.currentPodIndex);
        }
        catch (RuntimeException noMorePods) {
            return null;
        }
    }

    private synchronized TransportPod findCurrentPodWithName(String podName) {
        TransportPod current = this.getCurrentPod();
        if (podName == null || current == null || podName.equals(current.getName())) {
            return current;
        }
        for (TransportPod pod : this.allPods) {
            if (!pod.getType().equals((Object)current.getType()) || !podName.equals(pod.getName())) continue;
            return pod;
        }
        return null;
    }

    private void init() {
        TransportPod pod;
        Object[] preferredPods = (Object[])this.webServiceResponse.get(System.getProperty("preferredPodsKey"));
        if (preferredPods == null) {
            Logger.debug("PreferredPod list is not given");
        }
        String forcedHost = System.getProperty("host");
        String forcedPod = System.getProperty("pod");
        ArrayList<TransportPod> podList = new ArrayList<TransportPod>();
        ArrayList<TransportPod> unfilteredPods = new ArrayList<TransportPod>();
        if (preferredPods != null) {
            for (Object podDescription : preferredPods) {
                try {
                    List<String> hostNames;
                    TransportPod pod2 = TransportPod.createFromMap((Map)podDescription, this.webServiceResponse);
                    if (!this.transport.equals((Object)pod2.getType())) continue;
                    unfilteredPods.add(pod2);
                    if (forcedPod != null && forcedPod.length() != 0 && !forcedPod.equals(pod2.getName())) {
                        Logger.extreme("ignoring pod (because of -pod option): " + pod2);
                        continue;
                    }
                    if (forcedHost != null && forcedHost.length() != 0 && ((hostNames = pod2.getServerNames()) == null || hostNames.isEmpty() || !hostNames.contains(forcedHost))) {
                        Logger.extreme("ignoring pod (because of -host option): " + pod2);
                        continue;
                    }
                    podList.add(pod2);
                }
                catch (IllegalArgumentException unknownTransportType) {
                    Logger.extreme("ignoring pod with unknown transport type", unknownTransportType);
                }
            }
        }
        this.resumeFlag = (Boolean)this.webServiceResponse.get(System.getProperty("resumeFlagKey"));
        this.newPkgName = TransportUtil.newPackageNameFromAuthenticateReturnValue(this.webServiceResponse);
        this.podNameFromServer = (String)this.webServiceResponse.get(System.getProperty("transportPodKey"));
        this.podsToUse = podList;
        this.allPods = unfilteredPods;
        if (this.podNameFromServer != null && (pod = this.findCurrentPodWithName(this.podNameFromServer)) == null) {
            pod = TransportPod.createFromValidateAssetsResponse(this.transport, this.webServiceResponse);
            podList.add(pod);
            unfilteredPods.add(pod);
        }
        if (podList.isEmpty()) {
            Logger.debug("PreferredPod list is empty");
        }
    }

    @Override
    public TransportType getTransportType() {
        return this.transport;
    }

    @Override
    public String getCurrentTransportPodName() {
        if (this.getCurrentPod() != null) {
            return this.getCurrentPod().getName();
        }
        return null;
    }

    @Override
    public boolean canPerformDiagnostic() {
        TransportPod pod = this.getCurrentPod();
        if (pod == null) {
            return false;
        }
        if (pod.getType().isDirectSANMove()) {
            return true;
        }
        if (pod.getType().isSigniant() && System.getProperty("relay") != null) {
            return true;
        }
        return this.jsonhash != null && this.jsonhash.length() != 0 && pod.getDiagnosticPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performDiagnostic(boolean strict) {
        TransportPod pod = this.getCurrentPod();
        if (pod == null) {
            return false;
        }
        if (pod.getType().isDirectSANMove()) {
            Logger.info("DirectSANMove is being used; skipping transport diagnostic test");
            return true;
        }
        if (pod.getType().isSigniant() && System.getProperty("relay") != null) {
            Logger.info("Signiant relay is being used; skipping transport diagnostic test");
            return true;
        }
        if (this.jsonhash == null || this.jsonhash.length() == 0) {
            Logger.error("The iTunes Store is experiencing an internal server error. Please retry the upload using a different transport.");
            return false;
        }
        TransportInterface aTransportObj = null;
        try {
            aTransportObj = pod.createTransport();
            aTransportObj.setSharedDecryptionSeed(this.jsonhash);
            boolean bl = aTransportObj.performDiagnostic(strict);
            return bl;
        }
        finally {
            aTransportObj.releaseResourcesPriorToFinalization();
        }
    }

    @Override
    public TransportInterface createTransportPod(ITMSPackage aPkg, final String cpuToken, boolean isRetry) {
        if (aPkg == null || this.resumeFlag == null || this.newPkgName == null) {
            Logger.error("Some package information is missing. Transporter cannot run.");
            return null;
        }
        final TransportPod pod = this.podForNameFallbackToValidateAssetsFields();
        if (pod == null) {
            Logger.error("The iTunes Store is experiencing an internal server error. Please retry the upload.");
            return null;
        }
        TransportInterface aTransportObj = pod.createTransport();
        aTransportObj.setSharedDecryptionSeed(aPkg.metadataFileChecksum() + this.newPkgName);
        aTransportObj.setResumeFlag(this.resumeFlag);
        aTransportObj.setNewPackageName(this.newPkgName);
        aTransportObj.setItmsPackage(aPkg);
        aTransportObj.setIsRetry(isRetry);
        String forcedHost = System.getProperty("host");
        final String serverName = forcedHost != null ? forcedHost : (pod.getServerNames() != null && !pod.getServerNames().isEmpty() ? pod.getServerNames().get(0) : null);
        aTransportObj.setPodAssignmentInvocation(new WebServiceInvoker.Invocation<Map>(){
            final NetworkStatusReporter netstat = new NetworkStatusReporter("Assigning transport pod to upload.");

            @Override
            public void setNetworkIsReachable(boolean isReachable) {
                this.netstat.logReachability(isReachable);
            }

            @Override
            public Map invoke() {
                return TransportByPodPolicy.this.service.assignTransportPodToUpload(TransportByPodPolicy.this.newPkgName, cpuToken, pod.getType().name(), pod.getName(), serverName);
            }
        });
        return aTransportObj;
    }

    private TransportPod podForNameFallbackToValidateAssetsFields() {
        TransportPod pod = this.getCurrentPod();
        if (this.podNameFromServer != null) {
            pod = this.findCurrentPodWithName(this.podNameFromServer);
        }
        return pod;
    }

    @Override
    public synchronized boolean hasMoreTransportPods() {
        return this.podsToUse != null && this.currentPodIndex < this.podsToUse.size();
    }

    @Override
    public synchronized void next() {
        ++this.currentPodIndex;
    }

    public static boolean webServiceResponseHasPods(Map<String, Object> webServiceResponse) {
        Object[] preferredPods = (Object[])webServiceResponse.get(System.getProperty("preferredPodsKey"));
        return preferredPods != null && preferredPods.length != 0;
    }
}

