/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.Application;
import com.apple.transporter.ServerConnectionException;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.operation.option.SigniantLoggingLevelOption;
import com.apple.transporter.transport.TransportFailedException;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportReturnValue;
import com.apple.transporter.transport.TransportStalledException;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.util.ProgressMonitor;
import com.apple.transporter.util.StringEncryptionUtil;
import com.apple.transporter.util.TransportUtil;
import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.StatusEvent;
import com.signiant.interactivetransfer.engine.TransferEngine;
import com.signiant.interactivetransfer.engine.TransferListener;
import com.signiant.interactivetransfer.engine.TransferMode;
import com.signiant.interactivetransfer.engine.Transport;
import com.signiant.interactivetransfer.engine.exceptions.ConfigurationException;
import com.signiant.interactivetransfer.engine.exceptions.RemoteAgentException;
import com.signiant.mobilize.ddsclient.connection.Port;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import sun.security.provider.certpath.SunCertPathBuilderException;

public class SigniantTransport
implements TransportInterface,
TransferListener,
ProgressMonitor.Monitorable {
    private static final int AGGRESSIVENESS_DEFAULT = 1;
    private static final String defaultLoggingLevel = "INFO";
    private static final int signiantRestartsDefault = 3;
    private static final int signiantRetriesDefault = 3;
    private boolean resumeFlag;
    private String newPackageName;
    private String transportArea;
    private int transportPort;
    private List<String> serverNames;
    private String folderPath;
    private String username;
    private String password;
    private ITMSPackage itmsPackage;
    private String certificate;
    private String token;
    private String tokenDecryption;
    private String decryptionSeed;
    private String logFileName;
    private String diagnosticPath;
    private boolean isLessStrictDiagnostic;
    private boolean isDiagnostic;
    private Long transferTimeInMilliseconds;
    private boolean isRetry;
    private boolean isStalled = false;
    private boolean didTransferFail = false;
    private String defaultSigniantLoggingLevel;
    private Boolean podAssigned;
    private WebServiceInvoker.Invocation<Map> podAssignmentInvocation;
    private boolean didAssignmentFail = false;
    private static long minimumThrottle = 16000L;
    private static final TransferEngineWrapper engineWrapper = new TransferEngineWrapper();
    private TransferEngine engine;
    private List<FileTransfer> fileTransfers;
    private boolean willRetry;

    @Override
    public void setResumeFlag(boolean value) {
        this.resumeFlag = value;
    }

    @Override
    public boolean resumeFlag() {
        return this.resumeFlag;
    }

    @Override
    public void setNewPackageName(String value) {
        this.newPackageName = value;
    }

    @Override
    public String newPackageName() {
        return this.newPackageName;
    }

    @Override
    public void setServerNames(List<String> value) {
        this.serverNames = value;
    }

    @Override
    public List<String> serverNames() {
        return this.serverNames;
    }

    @Override
    public void setFolderPath(String value) {
        this.folderPath = value;
    }

    @Override
    public String folderPath() {
        return this.folderPath;
    }

    @Override
    public void setItmsPackage(ITMSPackage value) {
        this.itmsPackage = value;
    }

    @Override
    public ITMSPackage itmsPackage() {
        return this.itmsPackage;
    }

    @Override
    public void setUsername(String value) {
        this.username = value;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public void setPassword(String value) {
        this.password = value;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public void setCertificate(String value) {
        this.certificate = value;
    }

    private String certificate() {
        return this.certificate;
    }

    @Override
    public void setToken(String value) {
        this.token = value;
    }

    private String token() {
        return this.token;
    }

    @Override
    public void setDecryptionKey(String key) {
        this.tokenDecryption = key;
    }

    @Override
    public void setSharedDecryptionSeed(String seed) {
        this.decryptionSeed = seed;
    }

    @Override
    public String transportLogFileName() {
        return this.logFileName;
    }

    @Override
    public void setTransportArea(String value) {
        this.transportArea = value;
    }

    @Override
    public String transportArea() {
        return this.transportArea;
    }

    @Override
    public void setTransportPort(int value) {
        this.transportPort = value;
    }

    @Override
    public int transportPort() {
        return this.transportPort;
    }

    public boolean isLessStrictDiagnostic() {
        return this.isLessStrictDiagnostic;
    }

    public void setLessStrictDiagnostic(boolean diagnostic) {
        this.isLessStrictDiagnostic = diagnostic;
    }

    @Override
    public Long transferTimeInMilliseconds() {
        return this.transferTimeInMilliseconds;
    }

    @Override
    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void setIsRetry(boolean value) {
        this.isRetry = value;
    }

    public String defaultSigniantLoggingLevel() {
        if (this.defaultSigniantLoggingLevel == null || this.defaultSigniantLoggingLevel.trim().length() == 0) {
            return defaultLoggingLevel;
        }
        if (!SigniantLoggingLevelOption.isValueNotFromCommandLineValid(this.defaultSigniantLoggingLevel)) {
            com.apple.transporter.log.Logger.extreme("The signiant logging level value of '" + this.defaultSigniantLoggingLevel + "' from the soap service is not valid so it will not be used.");
            return defaultLoggingLevel;
        }
        return this.defaultSigniantLoggingLevel;
    }

    public void setDefaultSigniantLoggingLevel(String value) {
        this.defaultSigniantLoggingLevel = value;
    }

    @Override
    public void setDefaultLoggingLevel(String loggingLevel) {
        this.setDefaultSigniantLoggingLevel(loggingLevel);
    }

    private String agentList() {
        String relayOption = null;
        relayOption = System.getProperty("relay");
        if (relayOption != null && (relayOption = relayOption.trim()).length() == 0) {
            relayOption = null;
        }
        if (this.transportPort() == 0 && relayOption == null) {
            com.apple.transporter.log.Logger.error("The port for the Signiant server is unknown.");
            return null;
        }
        if (this.serverNames() == null || this.serverNames().size() == 0) {
            com.apple.transporter.log.Logger.error("The Signiant server name(s) is unknown.");
            return null;
        }
        if (relayOption != null) {
            com.apple.transporter.log.Logger.info("Using the UDP relay: " + relayOption);
        }
        String hostPostInfo = null;
        hostPostInfo = relayOption == null ? "(" + this.transportPort() + ")" : "[" + relayOption + "]";
        StringBuilder returnString = new StringBuilder();
        Iterator<String> iterator = this.serverNames().iterator();
        while (iterator != null && iterator.hasNext()) {
            String aHostname = iterator.next();
            returnString.append(aHostname).append(hostPostInfo);
            if (!iterator.hasNext()) continue;
            returnString.append(' ');
        }
        return returnString.toString();
    }

    private String[] fileListArray(List<File> files) {
        if (files == null || files.size() == 0) {
            return null;
        }
        String[] filePathsArray = (String[])Array.newInstance(String.class, files.size());
        for (int index = 0; index < files.size(); ++index) {
            File file = files.get(index);
            filePathsArray[index] = file.getPath();
        }
        return filePathsArray;
    }

    private String certificateWithCorrectFormat() throws StringEncryptionUtil.EncryptionException {
        if (this.certificate() == null || this.certificate().length() == 0) {
            return null;
        }
        String signiantLineSeperator = "\r\n";
        String certificate = StringEncryptionUtil.desedeDecrypt(this.decryptionSeed + this.tokenDecryption, this.certificate());
        Object[] certLines = certificate.split("\n");
        String newCert = StringUtils.join((Object[])certLines, (String)signiantLineSeperator);
        if (newCert.endsWith(signiantLineSeperator)) {
            newCert = newCert.substring(0, newCert.length() - signiantLineSeperator.length());
        }
        return newCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransportReturnValue uploadPackage(WebService ignored, boolean willRetry) throws ServerConnectionException {
        this.engine = engineWrapper.getTransferEngineForNewTransfer();
        if (this.agentList() == null || this.agentList().trim().length() == 0 || this.username() == null || this.username().trim().length() == 0 || this.itmsPackage() == null || this.newPackageName() == null || this.newPackageName().trim().length() == 0 || this.folderPath() == null || this.folderPath().trim().length() == 0) {
            return new TransportReturnValue(false, false, this);
        }
        List<File> filesToUpload = null;
        try {
            filesToUpload = this.itmsPackage().filesToBeUploaded(new HashMap<String, Map<String, Object>>(), TransportType.Signiant);
            if (filesToUpload == null || filesToUpload.size() == 0) {
                com.apple.transporter.log.Logger.info("No files need to be uploaded in the package: " + this.itmsPackage().packageName());
                return new TransportReturnValue(true, false, this);
            }
        }
        catch (Throwable t) {
            com.apple.transporter.log.Logger.error("An error occurred while getting the files to upload.", t);
        }
        com.apple.transporter.log.Logger.info("Starting to upload the package's files (" + this.itmsPackage.packageName() + ") ...");
        TransportUtil.postPreparingToUploadFilesNotification(filesToUpload, this.itmsPackage(), this.resumeFlag(), this.isRetry());
        Map<Object, Object> alreadyUploadedFilesInfo = new HashMap();
        boolean wasSuccessful = true;
        try {
            this.willRetry = willRetry;
            if (!this.uploadFiles(filesToUpload)) {
                Application.logUnnecessaryError("An error occurred while uploading the files to Apple's remote server.");
                wasSuccessful = false;
            }
            alreadyUploadedFilesInfo = this.gatherAlreadyUploadedFilesInfo(filesToUpload);
            TransportUtil.postFinishedUploadOfFilesNotification(alreadyUploadedFilesInfo, this.itmsPackage);
        }
        catch (Throwable t) {
            if (t instanceof TransportFailedException) {
                Application.logUnnecessaryError("An error occurred while uploading a file to Apple's remote server.", t);
            } else {
                com.apple.transporter.log.Logger.error("An error occurred while uploading a file to Apple's remote server.", t);
            }
            wasSuccessful = false;
        }
        if (wasSuccessful) {
            com.apple.transporter.log.Logger.info("The package's files (" + this.itmsPackage.packageName() + ") uploaded successfully.");
        } else {
            Application.logUnnecessaryError("An error occurred while uploading the package " + this.itmsPackage.packageName() + ".");
        }
        SigniantTransport signiantTransport = this;
        synchronized (signiantTransport) {
            this.fileTransfers = null;
        }
        return new TransportReturnValue(wasSuccessful, this.assignedToUpload(), this);
    }

    private Map<String, Map<String, Object>> gatherAlreadyUploadedFilesInfo(List<File> filesToUpload) {
        HashMap<String, Map<String, Object>> returnDict = new HashMap<String, Map<String, Object>>();
        if (filesToUpload == null || filesToUpload.size() == 0) {
            return returnDict;
        }
        Date now = new Date();
        Long remoteLastModified = new Long(now.getTime());
        for (File aFile : filesToUpload) {
            String remoteFileName = aFile.getName();
            HashMap<String, Long> sizeAndDateDict = new HashMap<String, Long>();
            Long remoteSize = new Long(aFile.length());
            sizeAndDateDict.put("RemoteFileSize", remoteSize);
            sizeAndDateDict.put("RemoteFileLastModified", remoteLastModified);
            returnDict.put(remoteFileName, sizeAndDateDict);
        }
        return returnDict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFiles(List<File> files) throws TransportStalledException {
        SigniantTransport signiantTransport = this;
        synchronized (signiantTransport) {
            this.fileTransfers = null;
            this.isStalled = false;
        }
        if (files == null || files.size() == 0) {
            return true;
        }
        try {
            this.setupSigniantTransferEngine(files);
        }
        catch (ConfigurationException ce) {
            com.apple.transporter.log.Logger.error("An error occurred configuring the transfer.  The upload will not continue.", ce);
            return false;
        }
        catch (RuntimeException re) {
            com.apple.transporter.log.Logger.error("An error occurred configuring the transfer.  The upload will not continue.", re);
            return false;
        }
        ProgressMonitor.monitor(this);
        boolean wasSuccessful = false;
        Date start = new Date();
        try {
            this.engine.startTransfer();
            this.waitForTransferToComplete(start);
            ProgressMonitor.stopMonitoring(this);
            wasSuccessful = this.finalUploadStatusAndLogCompletionInfo();
            if (this.isAborted()) {
                throw new TransportStalledException();
            }
            if (this.didTransferFail()) {
                throw new TransportFailedException();
            }
        }
        catch (TransportStalledException tse) {
            wasSuccessful = false;
            throw tse;
        }
        catch (Throwable t) {
            if (this.shouldFailWithException(t)) {
                Application.logUnnecessaryError("Transfer error.", t);
                wasSuccessful = false;
            }
        }
        finally {
            ProgressMonitor.stopMonitoring(this);
            this.engine.removeTransferListener((TransferListener)this);
        }
        return wasSuccessful;
    }

    private void waitForTransferToComplete(Date start) throws TransportFailedException {
        if (this.engine == null) {
            throw new RuntimeException("The transfer engine must be setup before calling this method.");
        }
        if (start == null) {
            start = new Date();
        }
        while (!this.shouldCancelTransfer() && !this.engine.isCompleted()) {
            TransportUtil.needToSleep(200L, "Waiting to check on file uploads.", true);
            if (this.engine.getTotalBytesToTransfer() != 0L) continue;
        }
        if (this.shouldCancelTransfer() && !this.engine.isCompleted() && !engineWrapper.isAborted()) {
            this.engine.cancelTransfer();
        }
        if (this.didAssignmentFail()) {
            com.apple.transporter.log.Logger.error("The iTunes Store is experiencing an internal server error. See http://www.apple.com/support/systemstatus/ for information about major outages.");
            throw new TransportFailedException("There was an error setting the transport pod on the package");
        }
        Date end = new Date();
        this.transferTimeInMilliseconds = TransportUtil.transferTimeInMilliseconds(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean finalUploadStatusAndLogCompletionInfo() {
        if (this.engine == null) {
            throw new RuntimeException("The transfer engine must be setup before calling this method.");
        }
        if (this.isLessStrictDiagnostic()) {
            return true;
        }
        boolean foundUnsuccessfulFileTransfer = false;
        SigniantTransport signiantTransport = this;
        synchronized (signiantTransport) {
            Iterator<FileTransfer> anEnum = null;
            if (this.fileTransfers != null) {
                anEnum = this.fileTransfers.iterator();
            }
            while (anEnum != null && anEnum.hasNext()) {
                FileTransfer aFileTransfer = anEnum.next();
                String filename = aFileTransfer.getFileString();
                switch (aFileTransfer.getState()) {
                    case PENDING: {
                        com.apple.transporter.log.Logger.error("The file, " + filename + ", did not complete its upload.");
                        foundUnsuccessfulFileTransfer = true;
                        break;
                    }
                    case SKIPPED_DENIED: {
                        com.apple.transporter.log.Logger.error("The file, " + filename + ", did not upload because the transfer was denied.");
                        foundUnsuccessfulFileTransfer = true;
                        break;
                    }
                    case SKIPPED_EXISTS: {
                        com.apple.transporter.log.Logger.info("The file, " + filename + ", was skipped because it already exists on the remote server.");
                        break;
                    }
                    case TRANSFERRED: {
                        com.apple.transporter.log.Logger.info("The file, " + filename + ", was uploaded successfully.");
                        break;
                    }
                    case ERROR: {
                        com.apple.transporter.log.Logger.error("The file, " + filename + ", encountered an error during its upload.");
                        foundUnsuccessfulFileTransfer = true;
                    }
                }
            }
        }
        try {
            if (this.engine.getLocalLogfile() != null && this.logFileName == null) {
                this.logFileName = this.engine.getLocalLogfile();
            }
        }
        catch (NullPointerException npe) {
            com.apple.transporter.log.Logger.extreme("Signiant logging is off.");
        }
        boolean wasSuccessful = false;
        if (this.isAborted()) {
            com.apple.transporter.log.Logger.info("The status for the upload is FAILURE due to a stalled transfer.");
        } else {
            TransferListener.CompletionStatus status = this.engine.getCompletionStatus();
            switch (status) {
                case SUCCESSFUL: {
                    if (this.fileTransfers != null && !this.fileTransfers.isEmpty()) {
                        com.apple.transporter.log.Logger.info("The status for the upload is SUCCESSFUL.");
                        wasSuccessful = true;
                        break;
                    }
                    com.apple.transporter.log.Logger.error("No files were uploaded so this SUCCESSFUL status will be considered a failure.");
                    engineWrapper.abort();
                    break;
                }
                case WARNING: {
                    long numFilesTransferred;
                    long numFilesSkipped;
                    com.apple.transporter.log.Logger.info("The status for the upload is WARNING.");
                    String[] filenamesRequestedForUpload = this.engine.getFiles();
                    long numFilesRequestedForUpload = 0L;
                    if (filenamesRequestedForUpload != null) {
                        numFilesRequestedForUpload = filenamesRequestedForUpload.length;
                    }
                    if ((numFilesSkipped = this.engine.getFilesSkipped()) + (numFilesTransferred = this.engine.getFilesTransferred()) < numFilesRequestedForUpload || numFilesTransferred == 0L) {
                        com.apple.transporter.log.Logger.error("Not all of the files were uploaded so this WARNING status will be considered a failure.");
                        break;
                    }
                    if (foundUnsuccessfulFileTransfer) break;
                    com.apple.transporter.log.Logger.info("All the individual files uploaded successfully so this WARNING status will be considered succesful.");
                    wasSuccessful = true;
                    break;
                }
                case FAILURE: {
                    com.apple.transporter.log.Logger.info("The status for the upload is FAILURE.");
                    break;
                }
                case CANCELLED: {
                    break;
                }
                case INCOMPLETE: {
                    break;
                }
            }
        }
        return wasSuccessful;
    }

    private void setupSigniantTransferEngine(List<File> files) throws ConfigurationException {
        String signiantRestarts;
        String signiantRetries;
        String decryptedToken;
        block31: {
            this.engine.newSettings();
            com.apple.transporter.log.Logger.info("Signiant TransferEngine build " + this.engine.getBuildNumber());
            decryptedToken = this.token();
            if (this.decryptionSeed != null && this.decryptionSeed.length() != 0 && this.tokenDecryption != null && this.tokenDecryption.length() != 0) {
                try {
                    decryptedToken = StringEncryptionUtil.desedeDecrypt(this.decryptionSeed + this.tokenDecryption, this.token());
                }
                catch (Throwable t) {
                    String msg = "An error occurred while decrypting the token.";
                    com.apple.transporter.log.Logger.error(msg, t);
                    throw new RuntimeException(msg, t);
                }
            }
            if (decryptedToken == null && !this.isLessStrictDiagnostic()) {
                String msg = "The decrypted token cannot be null.";
                com.apple.transporter.log.Logger.error(msg);
                throw new RuntimeException(msg);
            }
            try {
                this.engine.setCertificate(this.certificateWithCorrectFormat());
            }
            catch (StringEncryptionUtil.EncryptionException t) {
                if (this.isLessStrictDiagnostic()) break block31;
                String msg = "An error occurred while decrypting the certificate.";
                com.apple.transporter.log.Logger.error(msg, t);
                throw new RuntimeException(msg, t);
            }
        }
        this.engine.setServiceData(decryptedToken);
        this.engine.setMode(TransferMode.SEND);
        this.engine.setTransport(this.transportMode());
        this.engine.addTransferListener((TransferListener)this);
        String loggingLevel = this.defaultSigniantLoggingLevel();
        String signiantLoggingLevelOption = System.getProperty("signiantLoggingLevel");
        if (signiantLoggingLevelOption != null && signiantLoggingLevelOption.trim().length() > 0) {
            loggingLevel = signiantLoggingLevelOption;
            com.apple.transporter.log.Logger.extreme("Using the signiant logging level of '" + signiantLoggingLevelOption + "' specified on the command line.");
        }
        this.engine.setLogging(loggingLevel);
        if (loggingLevel.equalsIgnoreCase(defaultLoggingLevel)) {
            this.logFileName = this.overrideInfoLoggingHandler(this.engine);
        }
        this.engine.setAgentList(this.agentList());
        this.engine.setUser(this.username());
        this.engine.setPassword(this.password().toCharArray());
        String remoteDir = TransportUtil.remoteFilePath(this.folderPath(), this.newPackageName(), TransportType.Signiant);
        this.engine.setDestination(remoteDir);
        this.engine.setFiles(this.fileListArray(files));
        this.engine.setEncryption(Application.disableTransportEncryption ? Port.SSLMode.UNSIGNED : Port.SSLMode.STRONG);
        this.engine.setUseTcpControlChannel(Boolean.valueOf(true));
        if (System.getProperty("signiantTrace") != null) {
            this.engine.setTrace(System.getProperty("signiantTrace"));
        }
        try {
            int aggressiveness = 1;
            String s = System.getProperty("SigniantUDPAggressiveness");
            if (s != null && (s = s.trim()).length() > 0) {
                try {
                    aggressiveness = Integer.parseInt(s);
                    if (aggressiveness < 1 || aggressiveness > 3) {
                        com.apple.transporter.log.Logger.warn("Illegal value specified for SigniantUDPAggressiveness property: value should be 1, 2 or 3");
                        aggressiveness = 1;
                    } else {
                        com.apple.transporter.log.Logger.debug("Overriding Signiant UDP aggressiveness parameter to " + aggressiveness);
                    }
                }
                catch (NumberFormatException e) {
                    com.apple.transporter.log.Logger.warn("Illegal value specified for SigniantUDPAggressiveness property: value should be 1, 2 or 3");
                }
            }
            this.engine.setAggressiveness(aggressiveness);
            this.engine.setNumberOfStreams(this.numStreams());
        }
        catch (ConfigurationException ce) {
            com.apple.transporter.log.Logger.error("An error occurred configuring the transfer.  The upload will not continue.", ce);
            throw ce;
        }
        String throttleString = System.getProperty("k");
        if (throttleString != null && throttleString.trim().length() > 0) {
            try {
                Long throttle = new Long(throttleString.trim());
                if (throttle != null) {
                    long kiloBytesPerSecond = throttle / 8L;
                    long bytesPerSecond = kiloBytesPerSecond * 1000L;
                    if (bytesPerSecond < minimumThrottle) {
                        com.apple.transporter.log.Logger.extreme("The specified throttle value, " + bytesPerSecond + " bytes per second, is less than the minimum value.  Using the minumum value.");
                        bytesPerSecond = minimumThrottle;
                    }
                    Float targetRate = new Float((float)bytesPerSecond * 1.2f);
                    this.engine.setTargetRate(targetRate.longValue());
                    this.engine.setBandwidthThrottle(bytesPerSecond);
                    com.apple.transporter.log.Logger.extreme("Setting the target rate to " + targetRate.longValue() + " bytes per second.");
                    com.apple.transporter.log.Logger.extreme("Setting the throttle to " + bytesPerSecond + " bytes per second.");
                }
            }
            catch (Throwable t) {
                com.apple.transporter.log.Logger.error("The throttle value could not be converted to a long value representing bytes per second.  Using the default throttle value.", t);
            }
        }
        if ((signiantRetries = System.getProperty("signiantRetries")) != null && signiantRetries.trim().length() > 0) {
            try {
                Integer anIntObject = new Integer(signiantRetries);
                this.engine.setRetries(anIntObject.intValue());
            }
            catch (Throwable t) {
                com.apple.transporter.log.Logger.error("The signiant retries value of '" + signiantRetries + "' could not be set.", t);
            }
        } else if (this.engine.getRetries() == 0) {
            this.engine.setRetries(3);
        }
        if ((signiantRestarts = System.getProperty("signiantRestarts")) != null && signiantRestarts.trim().length() > 0) {
            try {
                Integer anIntObject = new Integer(signiantRestarts);
                this.engine.setRestarts(anIntObject.intValue());
            }
            catch (Throwable t) {
                com.apple.transporter.log.Logger.error("The signiant restarts value of '" + signiantRestarts + "' could not be set.", t);
            }
        } else if (this.engine.getRestarts() == 0) {
            this.engine.setRestarts(3);
        }
    }

    @Override
    public synchronized void abort() {
        this.isStalled = true;
        engineWrapper.abort();
        com.apple.transporter.log.Logger.debug("Received stalled transfer notification; aborting");
    }

    public synchronized boolean isAborted() {
        return this.isStalled;
    }

    synchronized void transferFailed() {
        this.didTransferFail = true;
        engineWrapper.abort();
        com.apple.transporter.log.Logger.debug("Received failed transfer notification; aborting");
    }

    synchronized boolean didTransferFail() {
        return this.didTransferFail;
    }

    synchronized boolean didAssignmentFail() {
        return this.didAssignmentFail;
    }

    synchronized boolean shouldCancelTransfer() {
        return this.isAborted() || this.didTransferFail() || this.didAssignmentFail();
    }

    protected Transport transportMode() {
        Transport transport = Transport.UDP;
        String transportMode = System.getProperty("signiant.transport");
        if (transportMode != null && transportMode.length() > 0) {
            if (transportMode.equalsIgnoreCase("udp_then_tcp")) {
                com.apple.transporter.log.Logger.info("Using Signiant UDP_THEN_TCP transport");
                transport = Transport.UDP_THEN_TCP;
            } else {
                com.apple.transporter.log.Logger.info("Using Signiant UDP transport");
            }
        } else {
            com.apple.transporter.log.Logger.info("Using Signiant UDP transport");
        }
        return transport;
    }

    protected int numStreams() {
        return this.defaultNumStreams();
    }

    protected int defaultNumStreams() {
        return 1;
    }

    public void connectionStatusChange(TransferListener.ConnectionStatus status) {
        com.apple.transporter.log.Logger.info("The Signiant transfer engine's status is " + status);
    }

    public void exception(Exception e) {
        if (this.shouldFailWithException(e)) {
            if (this.isLessStrictDiagnostic() || this.willRetry) {
                com.apple.transporter.log.Logger.debug("An error has occurred during the upload.", e);
            } else {
                Application.logExceptionWithUnnecessaryError("An error has occurred during the upload.", e);
            }
            this.transferFailed();
        }
    }

    public void preTransfer() {
    }

    public synchronized void fileHeader(FileTransfer file) {
        if (this.fileTransfers == null) {
            this.fileTransfers = new ArrayList<FileTransfer>();
        } else {
            ArrayList<FileTransfer> transfersToRemove = new ArrayList<FileTransfer>();
            ListIterator<FileTransfer> iterator = this.fileTransfers.listIterator(this.fileTransfers.size());
            while (iterator.hasPrevious()) {
                FileTransfer aFileTransfer = iterator.previous();
                if (!aFileTransfer.getFileString().equals(file.getFileString())) continue;
                transfersToRemove.add(aFileTransfer);
            }
            this.fileTransfers.removeAll(transfersToRemove);
        }
        this.fileTransfers.add(file);
    }

    public void preFile(FileTransfer file) {
    }

    public void filePosition(FileTransfer file, long position) {
        com.apple.transporter.log.Logger.info("The file named " + file.getFileString() + " was partially uploaded previously.  This upload will start at position " + position + ".");
        TransportUtil.postFileHasBeenPartiallyUploadedNotification(file.getFileString(), position, file.getSize());
        ProgressMonitor.heartbeat(this);
        this.bailIfPodAssignmentFails();
    }

    public void fileProgress(FileTransfer file, long bytesSent) {
        TransportUtil.postFileChunkHasBeenUploadedNotification(file.getFileString(), bytesSent, this.itmsPackage == null ? file.getFile().length() : this.itmsPackage.getFileSize(file.getFile()), TransportType.Signiant);
        ProgressMonitor.heartbeat(this);
        this.bailIfPodAssignmentFails();
    }

    public void skipFile(FileTransfer file) {
        com.apple.transporter.log.Logger.info("The file named " + file.getFileString() + " has been skipped because it already exists on the remote server");
    }

    public void postFile(FileTransfer file) {
        String filename = file.getFileString();
        switch (file.getState()) {
            case PENDING: {
                com.apple.transporter.log.Logger.extreme("The status for the file, " + filename + ", is PENDING.");
                break;
            }
            case SKIPPED_DENIED: {
                com.apple.transporter.log.Logger.extreme("The status for the file, " + filename + ", is SKIPPED_DENIED.");
                break;
            }
            case SKIPPED_EXISTS: {
                com.apple.transporter.log.Logger.extreme("The status for the file, " + filename + ", is SKIPPED_EXISTS.");
                break;
            }
            case TRANSFERRED: {
                com.apple.transporter.log.Logger.extreme("The status for the file, " + filename + ", is TRANSFERRED.");
                TransportUtil.postFileUploadSucceededNotification(this.itmsPackage, file.getFile());
                this.bailIfPodAssignmentFails();
                break;
            }
            case ERROR: {
                com.apple.transporter.log.Logger.extreme("The status for the file, " + filename + ", is ERROR.");
            }
        }
    }

    public void postTransfer(TransferListener.CompletionStatus status) {
    }

    public void statusUpdate(StatusEvent status) {
        com.apple.transporter.log.Logger.info(status.getStatus());
    }

    private String overrideInfoLoggingHandler(TransferEngine engine) {
        try {
            String logger = engine.getClass().getPackage().getName() + engine.getLogInstance() + "." + engine.getClass().getSimpleName();
            Logger jLogger = Logger.getLogger(logger);
            if (jLogger != null) {
                Handler[] handlers = jLogger.getHandlers();
                if ((handlers == null || handlers.length == 0) && jLogger.getParent() != null) {
                    handlers = jLogger.getParent().getHandlers();
                }
                if (handlers != null) {
                    FileHandler oldFileHandler = null;
                    for (Handler handler : handlers) {
                        if (!(handler instanceof FileHandler)) continue;
                        oldFileHandler = (FileHandler)handler;
                        break;
                    }
                    if (oldFileHandler != null) {
                        try {
                            String newPath = engine.getLocalLogfile() + ".info";
                            File newPathFile = new File(newPath);
                            newPathFile.deleteOnExit();
                            FileOutputStream stream = new FileOutputStream(newPath);
                            StreamHandler newStreamHandler = new StreamHandler(stream, oldFileHandler.getFormatter()){

                                @Override
                                public synchronized void publish(LogRecord record) {
                                    super.publish(record);
                                    this.flush();
                                }
                            };
                            newStreamHandler.setFilter(oldFileHandler.getFilter());
                            newStreamHandler.setLevel(oldFileHandler.getLevel());
                            jLogger.addHandler(newStreamHandler);
                            return newPath;
                        }
                        catch (FileNotFoundException e) {
                            com.apple.transporter.log.Logger.debug("Failed to override log file: " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            com.apple.transporter.log.Logger.debug("Failed to set Signiant logging: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void releaseResourcesPriorToFinalization() {
        if (this.engine != null && !engineWrapper.isAborted()) {
            try {
                this.engine.cancelTransfer();
                this.engine.release();
            }
            catch (Exception ex) {
                Application.logUnnecessaryError("Error cleaning up Signiant resources", ex);
                engineWrapper.abort();
            }
        }
    }

    @Override
    public void setPodAssignmentInvocation(WebServiceInvoker.Invocation<Map> invocation) {
        this.podAssignmentInvocation = invocation;
    }

    private synchronized void bailIfPodAssignmentFails() {
        if (!this.assignedToUpload()) {
            this.didAssignmentFail = true;
            engineWrapper.abort();
        }
    }

    private synchronized boolean assignedToUpload() {
        if (this.isDiagnostic) {
            return true;
        }
        if (this.podAssigned != null) {
            return this.podAssigned;
        }
        Map returnValue = WebServiceInvoker.invokeWithRetry(this.podAssignmentInvocation);
        this.podAssigned = returnValue != null && !Application.doesContainSOAPError(returnValue);
        return this.podAssigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performDiagnostic(boolean strict) {
        boolean wasDiagnostic = this.isLessStrictDiagnostic();
        try {
            this.setLessStrictDiagnostic(!strict);
            this.isDiagnostic = true;
            ArrayList<String> allHosts = new ArrayList<String>(this.serverNames());
            boolean returnValue = true;
            for (String host : allHosts) {
                this.setServerNames(Arrays.asList(host));
                File tempFile = null;
                File tempDir = null;
                FileOutputStream tempFileOut = null;
                try {
                    File diagnosticFile;
                    String diagnosticFileText = System.getProperty("diagnosticText", "hello world");
                    tempFile = File.createTempFile(UUID.randomUUID().toString(), "diagnostic");
                    tempFile.delete();
                    tempDir = new File(tempFile.getAbsolutePath().replaceFirst("diagnostic", "dir"));
                    tempDir.mkdirs();
                    tempFile = diagnosticFile = File.createTempFile(UUID.randomUUID().toString(), ".txt", tempDir);
                    tempFileOut = new FileOutputStream(tempFile);
                    IOUtils.write((String)diagnosticFileText, (OutputStream)tempFileOut);
                    this.engine = engineWrapper.getTransferEngineForNewTransfer();
                    TransportUtil.splitDiagnosticPath(this.diagnosticPath, this);
                    if (!this.uploadFiles(Arrays.asList(tempFile))) {
                        returnValue = false;
                        continue;
                    }
                    if (strict) continue;
                    returnValue = true;
                    break;
                }
                finally {
                    if (tempFileOut != null) {
                        try {
                            tempFileOut.close();
                        }
                        catch (IOException e) {
                            com.apple.transporter.log.Logger.error("problem closing temp file", e);
                        }
                    }
                    if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                        tempFile.deleteOnExit();
                    }
                    if (tempDir == null || !tempDir.exists() || tempDir.delete()) continue;
                    tempDir.deleteOnExit();
                }
            }
            boolean bl = returnValue;
            return bl;
        }
        catch (TransportStalledException e) {
            Application.logUnnecessaryError("Unable to perform diagnostic", e);
        }
        catch (IOException e) {
            String message = "Unable to create temp file for diagnostic. Please check that there is free space on the hard drive where the temporary directory is located.";
            if (TransportUtil.isOSLinux()) {
                message = "Unable to create temp file for diagnostic. Please check that there is free space on the hard drive where /tmp is located. Please also check that there aren't an excessive amount of directories (more than 32000) in the /tmp folder.";
            }
            com.apple.transporter.log.Logger.error(message, e);
        }
        catch (Exception e) {
            Application.logUnnecessaryError("Unable to perform diagnostic", e);
        }
        finally {
            this.isDiagnostic = false;
            this.setLessStrictDiagnostic(wasDiagnostic);
        }
        return TransportUtil.performUnauthenticatedDiagnostic(TransportType.Signiant, strict);
    }

    private boolean shouldFailWithException(Throwable t) {
        if (this.isLessStrictDiagnostic()) {
            List<String> failExceptions = this.diagnosticFailExceptions();
            List<String> successExceptions = this.diagnosticSuccessExceptions();
            for (Throwable ex = t; ex != null; ex = ex.getCause()) {
                if (successExceptions.contains(ex.getClass().getName())) {
                    return false;
                }
                if (failExceptions.contains(ex.getClass().getName())) break;
            }
        }
        return true;
    }

    private List<String> diagnosticSuccessExceptions() {
        String exceptions = System.getProperty("diagnosticSuccessExceptions", SunCertPathBuilderException.class.getName() + ',' + RemoteAgentException.class.getName());
        String[] exceptionList = exceptions.split(",");
        return Arrays.asList(exceptionList);
    }

    private List<String> diagnosticFailExceptions() {
        String exceptions = System.getProperty("diagnosticFailExceptions", ConnectException.class.getName() + ',' + UnknownHostException.class.getName());
        String[] exceptionList = exceptions.split(",");
        return Arrays.asList(exceptionList);
    }

    @Override
    public void setDiagnosticPath(String diagnosticPath) {
        this.diagnosticPath = diagnosticPath;
    }

    static class TransferEngineWrapper {
        private TransferEngine wrappedEngine;
        private boolean isAborted = false;

        TransferEngineWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized TransferEngine getTransferEngineForNewTransfer() {
            if (this.isAborted) {
                TransferEngine transferEngine = this.wrappedEngine;
                synchronized (transferEngine) {
                    this.wrappedEngine.release();
                }
                this.isAborted = false;
                this.wrappedEngine = null;
                com.apple.transporter.log.Logger.info("The Signiant transport is encountering difficulties with the upload. This may be caused by a firewall or network configuration preventing access.");
            }
            if (this.wrappedEngine == null) {
                this.wrappedEngine = new TransferEngine();
            }
            return this.wrappedEngine;
        }

        synchronized void abort() {
            this.isAborted = true;
            if (this.wrappedEngine != null) {
                this.wrappedEngine.setRetries(0);
                this.wrappedEngine.setRestarts(0);
            }
        }

        public synchronized boolean isAborted() {
            return this.isAborted;
        }
    }
}

