/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.log.Logger;
import com.apple.transporter.transport.SigniantTransport;
import com.signiant.interactivetransfer.engine.Transport;

public class SigniantTCPTransport
extends SigniantTransport {
    @Override
    protected Transport transportMode() {
        Logger.info("Using Signiant TCP transport");
        return Transport.TCP;
    }

    @Override
    protected int numStreams() {
        String numStreamsValue = System.getProperty("numStreams");
        int numStreams = this.defaultNumStreams();
        if (numStreamsValue != null && numStreamsValue.trim().length() > 0) {
            try {
                numStreams = Integer.parseInt(numStreamsValue.trim());
            }
            catch (Throwable t) {
                numStreams = this.defaultNumStreams();
                Logger.error("An error occurred while getting the integer value for the numStreams value (" + numStreamsValue + ").  Using the default value of " + numStreams + ".", t);
            }
        }
        return numStreams;
    }

    @Override
    protected int defaultNumStreams() {
        return 4;
    }
}

