/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.Application;
import com.apple.transporter.ServerConnectionException;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.log.Logger;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportReturnValue;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.TransportUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectSANMoveTransport
implements TransportInterface {
    private boolean _resumeFlag;
    private String _newPackageName;
    private List<String> _serverNames;
    private String _folderPath;
    private String _username;
    private String _password;
    private int _transportPort;
    private String _transportArea;
    private ITMSPackage _itmsPackage;
    private Long _transferTimeInMilliseconds;
    private boolean isRetry;
    private Boolean podAssigned;
    private WebServiceInvoker.Invocation<Map> podAssignmentInvocation;

    @Override
    public String folderPath() {
        return this._folderPath;
    }

    @Override
    public ITMSPackage itmsPackage() {
        return this._itmsPackage;
    }

    @Override
    public String newPackageName() {
        return this._newPackageName;
    }

    @Override
    public String password() {
        return this._password;
    }

    @Override
    public boolean resumeFlag() {
        return this._resumeFlag;
    }

    @Override
    public List<String> serverNames() {
        return this._serverNames;
    }

    @Override
    public void setCertificate(String value) {
    }

    @Override
    public void setFolderPath(String value) {
        this._folderPath = value;
    }

    @Override
    public void setItmsPackage(ITMSPackage value) {
        this._itmsPackage = value;
    }

    @Override
    public void setNewPackageName(String value) {
        this._newPackageName = value;
    }

    @Override
    public void setPassword(String value) {
        this._password = value;
    }

    @Override
    public void setResumeFlag(boolean value) {
        this._resumeFlag = value;
    }

    @Override
    public void setServerNames(List<String> value) {
        this._serverNames = value;
    }

    @Override
    public void setToken(String value) {
    }

    @Override
    public void setTransportArea(String value) {
        this._transportArea = value;
    }

    @Override
    public void setTransportPort(int value) {
        this._transportPort = value;
    }

    @Override
    public void setUsername(String value) {
        this._username = value;
    }

    @Override
    public void setDecryptionKey(String key) {
    }

    @Override
    public void setSharedDecryptionSeed(String seed) {
    }

    @Override
    public String transportArea() {
        return this._transportArea;
    }

    @Override
    public String transportLogFileName() {
        return null;
    }

    @Override
    public String username() {
        return this._username;
    }

    @Override
    public int transportPort() {
        return this._transportPort;
    }

    @Override
    public Long transferTimeInMilliseconds() {
        return this._transferTimeInMilliseconds;
    }

    @Override
    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void setIsRetry(boolean value) {
        this.isRetry = value;
    }

    @Override
    public TransportReturnValue uploadPackage(WebService ignored, boolean willRetry) throws ServerConnectionException {
        if (!this.validateDirectSANAccess()) {
            return new TransportReturnValue(false, false, this);
        }
        boolean didSucceed = this.performPackageMove();
        return new TransportReturnValue(didSucceed, this.assignedToUpload(), this);
    }

    private boolean changePackagePermissions(File sourceFile) {
        try {
            FileUtil.makeFileWorldReadableAndWriteable(sourceFile, true);
        }
        catch (IOException e) {
            Logger.error("Unable to make package world readable/writable: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean performPackageMove() {
        File destinationFile = this.getTransportDestinationPackageFile();
        File sourceFile = this.getTransportSourceFile();
        if (sourceFile == null) {
            Logger.error("Unable to create a source file for the package");
            return false;
        }
        if (destinationFile == null) {
            Logger.error("Unable to create a destination file for the package");
            return false;
        }
        Logger.info("Making package world readable/writable: " + sourceFile.getPath());
        if (!this.changePackagePermissions(sourceFile)) {
            return false;
        }
        Logger.info("Performing package move from " + sourceFile.getPath() + " to " + destinationFile.getPath());
        ArrayList<File> filesToUpload = new ArrayList<File>();
        this.getPackageFiles(filesToUpload, sourceFile);
        HashMap<File, Long> filesToUploadSizes = new HashMap<File, Long>();
        for (File file : filesToUpload) {
            filesToUploadSizes.put(file, file.length());
        }
        TransportUtil.postPreparingToUploadFilesNotification(filesToUpload, this.itmsPackage(), this.resumeFlag(), this.isRetry());
        Date start = new Date();
        boolean didRenameSourceFile = sourceFile.renameTo(destinationFile);
        Date end = new Date();
        this._transferTimeInMilliseconds = TransportUtil.transferTimeInMilliseconds(start, end);
        if (!didRenameSourceFile) {
            Logger.error("Unable to move package from " + sourceFile.getPath() + " to " + destinationFile.getPath());
            return false;
        }
        if (!this.assignedToUpload()) {
            Logger.error("Unable to update the package transport");
            return false;
        }
        for (File file : filesToUpload) {
            Long size = (Long)filesToUploadSizes.get(file);
            TransportUtil.postFileHasBeenPartiallyUploadedNotification(file.getName(), size, size);
        }
        TransportUtil.postFinishedUploadOfFilesNotification(this.gatherAlreadyUploadedFilesInfo(filesToUpload), this.itmsPackage());
        Logger.info("Making package world readable/writable: " + destinationFile.getPath());
        this.changePackagePermissions(destinationFile);
        boolean isWorldRW = FileUtil.isFileWorldReadableAndWriteable(destinationFile, true);
        if (!isWorldRW) {
            Logger.error(destinationFile.getPath() + " is NOT world readable and writable but the upload will not be considered unsuccessful.");
        }
        return true;
    }

    private void getPackageFiles(List<File> files, File sourceFile) {
        if (sourceFile.isDirectory()) {
            for (File file : sourceFile.listFiles()) {
                this.getPackageFiles(files, file);
            }
        } else {
            files.add(sourceFile);
        }
    }

    private Map<String, Map<String, Object>> gatherAlreadyUploadedFilesInfo(List<File> filesToUpload) {
        HashMap<String, Map<String, Object>> returnDict = new HashMap<String, Map<String, Object>>();
        if (filesToUpload == null || filesToUpload.size() == 0) {
            return returnDict;
        }
        long remoteLastModified = System.currentTimeMillis();
        for (File file : filesToUpload) {
            String remoteFileName = file.getName();
            HashMap<String, Long> sizeAndDateDict = new HashMap<String, Long>();
            long remoteSize = file.length();
            sizeAndDateDict.put("RemoteFileSize", remoteSize);
            sizeAndDateDict.put("RemoteFileLastModified", remoteLastModified);
            returnDict.put(remoteFileName, sizeAndDateDict);
        }
        return returnDict;
    }

    private File getTransportDestinationPackageFile() {
        String transportDestinationDirectory = this.getTransportDestinationPath();
        String destinationPackageName = this.newPackageName();
        if (destinationPackageName == null) {
            Logger.error("No new package name defined for this package: " + this._itmsPackage.packageName());
            return null;
        }
        String fullPath = NSPathUtilities.stringByAppendingPathComponent(transportDestinationDirectory, destinationPackageName);
        return new File(fullPath);
    }

    private File getTransportSourceFile() {
        if (this._itmsPackage == null) {
            Logger.debug("Attempting to do a direct SAN move without a package");
            return null;
        }
        String path = this._itmsPackage.packageNameWithPath();
        if (path == null) {
            Logger.debug("Package returned a null packageNameWithPath: " + this._itmsPackage.packageName());
            return null;
        }
        return new File(path);
    }

    private boolean validateDirectSANAccess() {
        if (!this.validateDestinationDirectoriesExist()) {
            return false;
        }
        if (!this.validateDesintationDirectoryIsWritable()) {
            return false;
        }
        return this.validateSourceAndDestinationAreOnSameVolume();
    }

    private boolean validateSourceAndDestinationAreOnSameVolume() {
        return true;
    }

    private boolean validateDesintationDirectoryIsWritable() {
        Logger.debug("Validating local directory is writable");
        File transportDestinationFile = this.getTransportDestinationFile();
        if (!transportDestinationFile.canWrite()) {
            Logger.error("Destination directory is not writeble: " + transportDestinationFile.getPath());
            return false;
        }
        return true;
    }

    private boolean validateDestinationDirectoriesExist() {
        Logger.debug("Validating local directories exist");
        if (!this.validateTransportAreaDirectory()) {
            return false;
        }
        return this.validateTransportDestinationDirectory();
    }

    private boolean validateTransportDestinationDirectory() {
        File transportDestinationFile = this.getTransportDestinationFile();
        if (transportDestinationFile == null) {
            Logger.error("Unable to create transport destination file: " + this.getTransportDestinationPath());
            return false;
        }
        File parentDir = transportDestinationFile.getParentFile();
        if (!parentDir.exists()) {
            Logger.error("Parent destination transport directory doesn't exist on the local machine: " + parentDir.getPath());
            return false;
        }
        if (!transportDestinationFile.exists()) {
            Logger.debug("Creating the destination transport directory: " + transportDestinationFile.getPath());
            boolean createdDir = transportDestinationFile.mkdir();
            if (!createdDir) {
                Logger.error("Destination transport directory could not be created: " + parentDir.getPath());
                return false;
            }
            if (!transportDestinationFile.exists()) {
                Logger.error("Destination transport directory doesn't exist on the local machine: " + transportDestinationFile.getPath());
                return false;
            }
            try {
                Logger.debug("Making destination transport directory world readable/writable: " + transportDestinationFile.getPath());
                FileUtil.makeFileWorldReadableAndWriteable(transportDestinationFile, false);
            }
            catch (IOException e) {
                Logger.error("Unable to make destination transport directory world readable/writable: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean validateTransportAreaDirectory() {
        File transportAreaFile = this.getTransportAreaFile();
        if (transportAreaFile == null) {
            Logger.error("Unable to create transport area file: " + this._transportArea);
            return false;
        }
        if (!transportAreaFile.exists()) {
            Logger.error("Destination transport area doesn't exist on the local machine: " + transportAreaFile.getPath());
            return false;
        }
        return true;
    }

    private File getTransportAreaFile() {
        if (this._transportArea == null) {
            return null;
        }
        return new File(this._transportArea);
    }

    private String getTransportDestinationPath() {
        String transportArea = this._transportArea == null ? "" : this._transportArea;
        String folderPath = this._folderPath == null ? "" : this._folderPath;
        String user = this._username == null ? "" : this._username;
        String result = NSPathUtilities.stringByAppendingPathComponent(user, folderPath);
        result = NSPathUtilities.stringByAppendingPathComponent(transportArea, result);
        return result;
    }

    private File getTransportDestinationFile() {
        String path = this.getTransportDestinationPath();
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    @Override
    public void releaseResourcesPriorToFinalization() {
    }

    @Override
    public void setDefaultLoggingLevel(String loggingLevel) {
    }

    @Override
    public void setPodAssignmentInvocation(WebServiceInvoker.Invocation<Map> invocation) {
        this.podAssignmentInvocation = invocation;
    }

    private boolean assignedToUpload() {
        if (this.podAssigned != null) {
            return this.podAssigned;
        }
        Map returnValue = WebServiceInvoker.invokeWithRetry(this.podAssignmentInvocation);
        this.podAssigned = returnValue != null && !Application.doesContainSOAPError(returnValue);
        return this.podAssigned;
    }

    @Override
    public boolean performDiagnostic(boolean strict) {
        return true;
    }

    @Override
    public void setDiagnosticPath(String diagnosticPath) {
    }
}

