/*
 * Decompiled with CFR 0.152.
 */
package com.apple.transporter.transport;

import com.apple.transporter.Application;
import com.apple.transporter.ServerConnectionException;
import com.apple.transporter.WebService;
import com.apple.transporter.WebServiceInvoker;
import com.apple.transporter.foundation.Notification;
import com.apple.transporter.foundation.NotificationCenter;
import com.apple.transporter.log.Logger;
import com.apple.transporter.log.UploadProgressReporter;
import com.apple.transporter.model.ITMSPackage;
import com.apple.transporter.operation.option.AsperaLoggingLevelOption;
import com.apple.transporter.transport.TransportFailedException;
import com.apple.transporter.transport.TransportInterface;
import com.apple.transporter.transport.TransportReturnValue;
import com.apple.transporter.transport.TransportStalledException;
import com.apple.transporter.transport.TransportType;
import com.apple.transporter.transport.service.AsperaSupportService;
import com.apple.transporter.util.FileUtil;
import com.apple.transporter.util.NSPathUtilities;
import com.apple.transporter.util.ProcUtil;
import com.apple.transporter.util.ProgressMonitor;
import com.apple.transporter.util.StringEncryptionUtil;
import com.apple.transporter.util.TransportUtil;
import com.asperasoft.faspmanager.Encryption;
import com.asperasoft.faspmanager.Environment;
import com.asperasoft.faspmanager.FaspManager;
import com.asperasoft.faspmanager.FaspManagerException;
import com.asperasoft.faspmanager.FileInfo;
import com.asperasoft.faspmanager.FileState;
import com.asperasoft.faspmanager.LocalLocation;
import com.asperasoft.faspmanager.Policy;
import com.asperasoft.faspmanager.RemoteLocation;
import com.asperasoft.faspmanager.Resume;
import com.asperasoft.faspmanager.SessionState;
import com.asperasoft.faspmanager.SessionStats;
import com.asperasoft.faspmanager.TransferEvent;
import com.asperasoft.faspmanager.TransferListener;
import com.asperasoft.faspmanager.TransferOrder;
import com.asperasoft.faspmanager.Version;
import com.asperasoft.faspmanager.XferParams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class AsperaTransport
implements TransportInterface,
ProgressMonitor.Monitorable {
    public static boolean disableRegistryCheck = false;
    private static final int REGISTRY_DELETE_TIMEOUT_MS = 15000;
    private static final String defaultLoggingLevel = "DEFAULT";
    private static FaspManager faspMgr;
    private static Integer throttle;
    private static int throttleDefault;
    private static final String asperaLogDirRegistryKey = "HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir";
    private static final String queryAsperaLogDirRegistryKeyCommand = "reg query \"HKLM\\SOFTWARE\\Aspera\\FASP\" /v \"LogDir\"";
    private static final String removeAsperaLogDirRegistryKeyCommand = "reg delete \"HKLM\\SOFTWARE\\Aspera\\FASP\" /v \"LogDir\" /f";
    private static final String registerToken = "REG_SZ";
    private static final String asperaLogFileName = "aspera-scp-transfer.log";
    private static String previousPkgName;
    private static String previousLogFile;
    public static AsperaSupportService asperaSupportService;
    private boolean resumeFlag;
    private String newPackageName;
    private List<String> serverNames;
    private String folderPath;
    private int transportPort;
    private String transportArea;
    private String username;
    private String password;
    private String ppkCertificate;
    private String ppkPassphrase;
    private String ppkDecryption;
    private String decryptionSeed;
    private boolean isLessStrictDiagnostic;
    private boolean isDiagnostic;
    private String defaultAsperaLoggingLevel;
    private ITMSPackage itmsPackage;
    private String diagnosticPath;
    private static String logFileName;
    private static String oldAsperaLogDirValue;
    private Long transferTimeInMilliseconds;
    private boolean isRetry;
    private FaspManagerListener faspManagerListener;
    private Boolean podAssigned;
    private WebServiceInvoker.Invocation<Map> podAssignmentInvocation;
    private boolean didAssignmentFail = false;

    public AsperaTransport() {
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.addObserver(this, "packageUploadSucceeded", "PackageUploadSucceeded", null);
        defaultCenter.addObserver(this, "packageUploadFailed", "PackageUploadFailed", null);
    }

    @Override
    public void setTransportArea(String value) {
        this.transportArea = value;
    }

    @Override
    public String transportArea() {
        return this.transportArea;
    }

    @Override
    public void setTransportPort(int value) {
        this.transportPort = value;
    }

    @Override
    public int transportPort() {
        return this.transportPort;
    }

    @Override
    public void setResumeFlag(boolean value) {
        this.resumeFlag = value;
    }

    @Override
    public boolean resumeFlag() {
        return this.resumeFlag;
    }

    @Override
    public void setNewPackageName(String value) {
        this.newPackageName = value;
    }

    @Override
    public String newPackageName() {
        return this.newPackageName;
    }

    @Override
    public void setServerNames(List<String> value) {
        this.serverNames = value;
    }

    @Override
    public List<String> serverNames() {
        return this.serverNames;
    }

    @Override
    public void setFolderPath(String value) {
        this.folderPath = value;
    }

    @Override
    public String folderPath() {
        return this.folderPath;
    }

    @Override
    public void setItmsPackage(ITMSPackage value) {
        this.itmsPackage = value;
    }

    @Override
    public ITMSPackage itmsPackage() {
        return this.itmsPackage;
    }

    @Override
    public void setUsername(String value) {
        this.username = value;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public void setPassword(String value) {
        this.password = value;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public void setCertificate(String value) {
        this.ppkCertificate = value;
    }

    @Override
    public void setToken(String value) {
        this.ppkPassphrase = value;
    }

    @Override
    public void setDecryptionKey(String key) {
        this.ppkDecryption = key;
    }

    @Override
    public void setSharedDecryptionSeed(String seed) {
        this.decryptionSeed = seed;
    }

    public void setLessStrictDiagnostic(boolean diagnostic) {
        this.isLessStrictDiagnostic = diagnostic;
    }

    public boolean isLessStrictDiagnostic() {
        return this.isLessStrictDiagnostic;
    }

    @Override
    public String transportLogFileName() {
        if (logFileName == null) {
            boolean didMakeDir;
            String tmpDirPropertyValue = System.getProperty("java.io.tmpdir");
            String tmpDir = null;
            try {
                tmpDir = FileUtil.absolutePathForPath(tmpDirPropertyValue);
            }
            catch (IOException ioe) {
                Logger.error("An error occurred trying to get the absolute path for the 'java.io.tmpdir' System property.", ioe);
                tmpDir = null;
            }
            if (tmpDir == null || tmpDir.length() == 0) {
                Logger.error("Could not get 'java.io.tmpdir' from the System's properties.  Cannot create the aspera log file.");
                logFileName = "";
                return logFileName;
            }
            Calendar now = Calendar.getInstance();
            String parentDirName = NSPathUtilities.stringByDeletingPathExtension(this.itmsPackage() != null ? this.itmsPackage().packageName() : this.newPackageName());
            String fullDirPath = NSPathUtilities.stringByAppendingPathComponent(tmpDir, parentDirName = parentDirName + "_" + now.get(1) + now.get(2) + now.get(5) + now.get(11) + now.get(12) + now.get(13) + "_Aspera");
            File fullDirFile = new File(fullDirPath);
            if (!fullDirFile.exists() && !(didMakeDir = fullDirFile.mkdirs())) {
                Logger.error("Could not create the directory '" + fullDirPath + "'.  Cannot create the aspera log file.");
                logFileName = "";
                return logFileName;
            }
            if (!disableRegistryCheck && TransportUtil.isOSWindows()) {
                this.getCurrentAsperaLogDirRegistryValue();
                Logger.info("Removing the Registry Key HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir, if it exists.");
                Boolean wasDeleted = ProcUtil.executeWithTimeout(new ProcUtil.Executable<Boolean>(){

                    @Override
                    public Boolean execute() {
                        try {
                            Runtime.getRuntime().exec(AsperaTransport.removeAsperaLogDirRegistryKeyCommand);
                        }
                        catch (Throwable t) {
                            Logger.error("Could not remove the Registry Key HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir", t);
                            return false;
                        }
                        return true;
                    }
                }, 15000L);
                if (wasDeleted == null || !wasDeleted.booleanValue()) {
                    logFileName = "";
                    return logFileName;
                }
            }
            logFileName = NSPathUtilities.stringByAppendingPathComponent(fullDirPath, asperaLogFileName);
            try {
                logFileName = FileUtil.absolutePathForPath(logFileName);
            }
            catch (IOException ioe) {
                Logger.error("Could not get the full Aspera log file path.  No Aspera log file will be created.", ioe);
                logFileName = null;
            }
        }
        return logFileName;
    }

    @Override
    public Long transferTimeInMilliseconds() {
        return this.transferTimeInMilliseconds;
    }

    private void addTimeToTransferTimeInMilliseconds(Date start, Date end) {
        Long aDuration = TransportUtil.transferTimeInMilliseconds(start, end);
        if (aDuration == null) {
            return;
        }
        if (this.transferTimeInMilliseconds == null) {
            this.transferTimeInMilliseconds = aDuration;
        } else {
            long newTransferTime = this.transferTimeInMilliseconds + aDuration;
            this.transferTimeInMilliseconds = new Long(newTransferTime);
        }
    }

    @Override
    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void setIsRetry(boolean value) {
        this.isRetry = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransportReturnValue uploadPackage(WebService ignored, boolean wilRetry) throws ServerConnectionException {
        if (this.username() == null || this.username().trim().length() == 0 || this.itmsPackage() == null || this.newPackageName() == null || this.newPackageName().trim().length() == 0 || this.folderPath() == null || this.folderPath().trim().length() == 0) {
            return new TransportReturnValue(false, false, this);
        }
        List<File> filesToUpload = null;
        try {
            filesToUpload = this.itmsPackage().filesToBeUploaded(new HashMap<String, Map<String, Object>>(), TransportType.Aspera);
            if (filesToUpload == null || filesToUpload.size() == 0) {
                Logger.info("No files need to be uploaded in the package: " + this.itmsPackage().packageName());
                return new TransportReturnValue(true, false, this);
            }
        }
        catch (Throwable t) {
            Logger.error("An error occurred while getting the files to upload.", t);
        }
        Logger.info("Starting to upload the package's files (" + this.itmsPackage.packageName() + ") ...");
        TransportUtil.postPreparingToUploadFilesNotification(filesToUpload, this.itmsPackage(), this.resumeFlag(), this.isRetry());
        Map<Object, Object> alreadyUploadedFilesInfo = new HashMap();
        boolean wasSuccessful = false;
        try {
            if (!this.setupFaspMgr()) {
                TransportReturnValue transportReturnValue = new TransportReturnValue(false, false, this);
                return transportReturnValue;
            }
            ArrayList<String> serverNames = new ArrayList<String>(this.serverNames());
            serverNames.removeAll(TransportUtil.failedDiagnosticHostsForTransport(TransportType.Aspera));
            boolean tryAnotherHost = true;
            Random rand = new Random();
            while (tryAnotherHost && !serverNames.isEmpty()) {
                int arbitraryHost = rand.nextInt(serverNames.size());
                String aHostname = (String)serverNames.remove(arbitraryHost);
                Logger.debug("Using Aspera server '" + aHostname + "' for the upload.");
                wasSuccessful = this.uploadPackageWithHostAndPort(aHostname, this.transportPort(), filesToUpload);
                if (wasSuccessful) {
                    alreadyUploadedFilesInfo = this.gatherAlreadyUploadedFilesInfo(filesToUpload);
                    TransportUtil.postFinishedUploadOfFilesNotification(alreadyUploadedFilesInfo, this.itmsPackage);
                    tryAnotherHost = false;
                    continue;
                }
                if (!(wasSuccessful || serverNames.isEmpty() || UploadProgressReporter.totalLastLoggedBytesTransferedForAllFiles() != null && UploadProgressReporter.totalLastLoggedBytesTransferedForAllFiles() != 0L)) {
                    Logger.debug("The upload was unsuccessful.  Another Aspera server will be tried.");
                    tryAnotherHost = true;
                    continue;
                }
                tryAnotherHost = false;
            }
        }
        catch (RuntimeException re) {
            wasSuccessful = false;
            Logger.error("An error occurred while uploading the package to Apple's remote server.", re);
        }
        finally {
            this.tearDownFaspMgr();
        }
        if (wasSuccessful) {
            Logger.info("The package's files (" + this.itmsPackage.packageName() + ") uploaded successfully.");
        } else {
            Application.logUnnecessaryError("An error occurred while uploading the package " + this.itmsPackage.packageName() + ".");
        }
        return new TransportReturnValue(wasSuccessful, this.assignedToUpload(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadPackageWithHostAndPort(String hostname, int portNum, List<File> filesToUpload) {
        if (hostname == null || hostname.trim().length() == 0) {
            return false;
        }
        TransferOrder order = null;
        try {
            order = this.setupAsperaTransferOrder(filesToUpload, hostname);
        }
        catch (Throwable t) {
            Logger.error("An error occurred while uploading the package to Apple's remote server.", t);
            Application.logUnnecessaryError("An error occurred while creating the Aspera job.");
            return false;
        }
        boolean wasSuccessful = true;
        try {
            ProgressMonitor.monitor(this);
            SessionStats transferSession = this.uploadFiles(order);
            wasSuccessful = !(transferSession == null || transferSession.getState() != SessionState.FINISHED && this.shouldLogFailCode(transferSession.getErrorCode()));
        }
        catch (FaspManagerException fme) {
            Logger.error("An Aspera error occurred while uploading the package to Apple's remote server.", fme);
            wasSuccessful = false;
        }
        catch (RuntimeException re) {
            Logger.error("An error occurred while uploading the package to Apple's remote server.", re);
            wasSuccessful = false;
        }
        catch (Throwable t) {
            if (t instanceof TransportFailedException) {
                Application.logUnnecessaryError("An error occurred while uploading the package to Apple's remote server.", t);
            } else {
                Logger.error("An error occurred while uploading the package to Apple's remote server.", t);
            }
            wasSuccessful = false;
        }
        finally {
            ProgressMonitor.stopMonitoring(this);
        }
        return wasSuccessful;
    }

    private void setupAsperaEnvironment() {
        Environment.setUnicodeSupportOn((boolean)true);
        Environment.setFasp2ScpPath((String)asperaSupportService.getAscpPath());
    }

    private TransferOrder setupAsperaTransferOrder(List<File> filesToUpload, String hostname) throws StringEncryptionUtil.EncryptionException {
        LocalLocation localSourceFiles = new LocalLocation();
        for (File aFile : filesToUpload) {
            if (TransportUtil.isOSWindows()) {
                localSourceFiles.addPath("\"" + AsperaTransport.sanitizeFilePathForAspera(aFile.getPath()) + "\"");
                continue;
            }
            localSourceFiles.addPath(AsperaTransport.sanitizeFilePathForAspera(aFile.getPath()));
        }
        String certificateContents = this.decryptionSeed != null && this.decryptionSeed.length() != 0 && this.ppkDecryption != null && this.ppkDecryption.length() != 0 ? StringEncryptionUtil.desedeDecrypt(this.decryptionSeed + this.ppkDecryption, this.ppkCertificate) : (this.ppkCertificate != null && this.ppkPassphrase != null ? StringEncryptionUtil.desedeDecrypt(this.ppkPassphrase + this.transportPort(), this.ppkCertificate) : "");
        String identityFilePath = TransportUtil.identityPPKFilePathForEmbeddedFile(certificateContents);
        String verifiedIdentityFilePath = AsperaTransport.sanitizeFilePathForAspera(identityFilePath);
        if (TransportUtil.isOSWindows()) {
            verifiedIdentityFilePath = "\"" + verifiedIdentityFilePath + "\"";
        }
        String verifiedUsername = AsperaTransport.sanitizeUserNameForAspera(this.username());
        String passphrase = this.ppkPassphrase;
        if (this.decryptionSeed != null && this.decryptionSeed.length() != 0 && this.ppkDecryption != null && this.ppkDecryption.length() != 0) {
            passphrase = StringEncryptionUtil.desedeDecrypt(this.decryptionSeed + this.ppkDecryption, this.ppkPassphrase);
        }
        RemoteLocation remoteDestination = new RemoteLocation(hostname, verifiedUsername, verifiedIdentityFilePath, passphrase);
        String remoteDir = TransportUtil.remoteFilePath(this.folderPath(), this.newPackageName(), TransportType.Aspera);
        String verifiedRemoteDir = AsperaTransport.sanitizeFilePathForAspera(remoteDir);
        remoteDestination.addPath(verifiedRemoteDir);
        TransferOrder order = new TransferOrder(localSourceFiles, remoteDestination, this.myTransferParams(this.transportPort()));
        return order;
    }

    private SessionStats uploadFiles(TransferOrder order) throws FaspManagerException, TransportStalledException, TransportFailedException {
        if (order == null) {
            return null;
        }
        Date start = new Date();
        FaspManager faspManager = FaspManager.getSingleton();
        faspManager.startTransfer(order);
        SessionStats sessionForJob = this.faspManagerListener.getFinalSession();
        Date end = new Date();
        this.addTimeToTransferTimeInMilliseconds(start, end);
        long totalBytesWritten = 0L;
        if (sessionForJob != null) {
            totalBytesWritten = sessionForJob.getTotalTransferredBytes();
            Logger.info("The session's final state is " + sessionForJob.getState());
            if (sessionForJob.getState() == SessionState.FINISHED) {
                Logger.info("Number of files transferred: " + sessionForJob.getFilesComplete() + " .  Names of files transferred:");
                Collection<FileInfo> completedFileInfos = this.faspManagerListener.getFileInfoList();
                for (FileInfo aFileInfo : completedFileInfos) {
                    Logger.info("    " + aFileInfo.getName() + " - " + aFileInfo.getState());
                }
                if (sessionForJob.getFilesComplete() == 0L) {
                    Logger.error("No files were uploaded so this SUCCESSFUL status will be considered a failure.");
                    sessionForJob = null;
                }
            }
        }
        TransportUtil.postTotalBytesWrittenToServerNotification(totalBytesWritten);
        if (this.faspManagerListener.wasAborted()) {
            throw new TransportStalledException();
        }
        if (this.didAssignmentFail()) {
            Logger.error("The iTunes Store is experiencing an internal server error. See http://www.apple.com/support/systemstatus/ for information about major outages.");
            throw new TransportFailedException();
        }
        return sessionForJob;
    }

    @Override
    public void abort() {
        Logger.debug("Received stalled transfer notification; aborting");
        this.faspManagerListener.abort();
    }

    private XferParams myTransferParams(int port) {
        if (throttle == null) {
            String throttleString = System.getProperty("k");
            if (throttleString != null && throttleString.length() > 0) {
                try {
                    throttle = new Integer(throttleString);
                }
                catch (Throwable t) {
                    throttle = null;
                    Logger.error("The throttle value could not be converted to an integer value.  Using the default throttle value.", t);
                }
            }
            if (throttle == null) {
                throttle = new Integer(throttleDefault);
            }
        }
        XferParams p = new XferParams();
        p.tcpPort = port;
        p.udpPort = port;
        p.targetRateKbps = throttle;
        p.minimumRateKbps = 20;
        p.encryption = Application.disableTransportEncryption ? Encryption.NONE : Encryption.AES128;
        p.policy = Policy.FAIR;
        p.resumeCheck = Resume.SPARSE_CHECKSUM;
        p.createPath = true;
        if (this.transportLogFileName() != null && this.transportLogFileName().length() > 0) {
            String logFileDir = NSPathUtilities.stringByDeletingLastPathComponent(this.transportLogFileName());
            try {
                p.localLogDir = AsperaTransport.sanitizeFilePathForAspera(logFileDir);
            }
            catch (Exception e) {
                Logger.error("An error occurred during the process of setting the localLogDir in the transfer parameters.  Cannot create an Aspera log file.", e);
            }
        }
        p.faspVersion = Version.FASP2;
        return p;
    }

    private Map<String, Map<String, Object>> gatherAlreadyUploadedFilesInfo(List<File> filesToUpload) {
        HashMap<String, Map<String, Object>> returnDict = new HashMap<String, Map<String, Object>>();
        if (filesToUpload == null || filesToUpload.size() == 0) {
            return returnDict;
        }
        Date now = new Date();
        Long remoteLastModified = new Long(now.getTime());
        for (File aFile : filesToUpload) {
            String remoteFileName = aFile.getName();
            HashMap<String, Long> sizeAndDateDict = new HashMap<String, Long>();
            Long remoteSize = new Long(aFile.length());
            sizeAndDateDict.put("RemoteFileSize", remoteSize);
            sizeAndDateDict.put("RemoteFileLastModified", remoteLastModified);
            returnDict.put(remoteFileName, sizeAndDateDict);
        }
        return returnDict;
    }

    private static String sanitizeFilePathForAspera(String aFilePath) {
        String tempFilePath = AsperaTransport.replaceBackSlashesIfNeeded(aFilePath);
        if (tempFilePath.indexOf(58) != -1 && !TransportUtil.isOSWindows()) {
            return ':' + tempFilePath;
        }
        return tempFilePath;
    }

    private static String sanitizeUserNameForAspera(String aUserName) {
        return aUserName;
    }

    private static String replaceBackSlashesIfNeeded(String aFilePath) {
        if (aFilePath == null || aFilePath.length() == 0) {
            return aFilePath;
        }
        int windowsSlashIndex = aFilePath.indexOf("\\");
        boolean doesFilePathContainBackSlashes = false;
        if (windowsSlashIndex > -1) {
            doesFilePathContainBackSlashes = true;
        }
        if (!doesFilePathContainBackSlashes) {
            return aFilePath;
        }
        Object[] filePathParts = aFilePath.split("\\\\");
        String newFilePath = StringUtils.join((Object[])filePathParts, (String)"/");
        return newFilePath;
    }

    private boolean removeLogFile() {
        String deleteTransportLogString = System.getProperty("deleteFastTransportLog");
        boolean shouldDeleteTransportLogFile = true;
        if (deleteTransportLogString != null && deleteTransportLogString.equalsIgnoreCase("false")) {
            shouldDeleteTransportLogFile = false;
        }
        if (!shouldDeleteTransportLogFile) {
            Logger.info("The Aspera log file for this upload is located at " + logFileName);
            return true;
        }
        if (this.transportLogFileName() == null || this.transportLogFileName().length() == 0) {
            return true;
        }
        String logFileName = this.transportLogFileName();
        return AsperaTransport.removeLogFile(logFileName);
    }

    private static boolean removeLogFile(String logFileName) {
        boolean wasSuccessful = true;
        String logDirString = NSPathUtilities.stringByDeletingLastPathComponent(logFileName);
        File logDir = new File(logDirString);
        File[] filesInLogDir = logDir.listFiles();
        for (int i = 0; i < filesInLogDir.length; ++i) {
            File aFile = filesInLogDir[i];
            if (FileUtil.deleteFile(aFile, true)) continue;
            wasSuccessful = false;
            Logger.error("The file " + aFile.getName() + " could not be deleted.");
            break;
        }
        if (!wasSuccessful) {
            return false;
        }
        wasSuccessful = FileUtil.deleteFile(logDir, true);
        if (!wasSuccessful) {
            Logger.error("The directory " + logDir.getName() + " could not be deleted.");
        }
        return wasSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCurrentAsperaLogDirRegistryValue() {
        if (!TransportUtil.isOSWindows()) {
            return null;
        }
        if (oldAsperaLogDirValue != null && oldAsperaLogDirValue.length() > 0) {
            return oldAsperaLogDirValue;
        }
        try {
            Logger.info("Getting the current Registry Key value for HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir");
            Process process = Runtime.getRuntime().exec(queryAsperaLogDirRegistryKeyCommand);
            InputStream inputStream = process.getInputStream();
            StringBuilder aBuffer = new StringBuilder();
            try {
                int c;
                while ((c = inputStream.read()) != -1) {
                    aBuffer.append((char)c);
                }
            }
            catch (IOException e) {
                Logger.error("An error occurred while getting the current value of the Registry Key HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir", e);
                oldAsperaLogDirValue = null;
                String string = null;
                return string;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    Logger.error("An error occurred while getting the current value of the Registry Key HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir", ioe);
                }
            }
            int index = aBuffer.toString().indexOf(registerToken);
            if (index == -1) {
                oldAsperaLogDirValue = null;
                return oldAsperaLogDirValue;
            }
            oldAsperaLogDirValue = aBuffer.toString().substring(index + registerToken.length()).trim();
            Logger.debug("The current Registry Key value for HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir is " + oldAsperaLogDirValue);
            return oldAsperaLogDirValue;
        }
        catch (Throwable t) {
            Logger.error("An error occurred while getting the current value of the Registry Key HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir", t);
            oldAsperaLogDirValue = null;
        }
        return oldAsperaLogDirValue;
    }

    private void setAsperaLogDirRegistryValueBackToOldValue() {
        if (TransportUtil.isOSWindows() && oldAsperaLogDirValue != null && oldAsperaLogDirValue.length() > 0) {
            Logger.info("NOT setting the Registry Key HKLM\\SOFTWARE\\Aspera\\FASP\\LogDir back to its old value of " + oldAsperaLogDirValue);
        }
    }

    private static void deletePreviousLogFileForPkg(String ourPkgName, String ourLogFile) {
        if (previousPkgName != null && previousPkgName.trim().length() != 0 && previousLogFile != null && previousLogFile.trim().length() != 0) {
            if (previousPkgName.equalsIgnoreCase(ourPkgName) && !previousLogFile.equalsIgnoreCase(ourLogFile)) {
                AsperaTransport.removeLogFile(previousLogFile);
            }
            previousPkgName = null;
            previousLogFile = null;
        }
    }

    private static void setPreviousLogFileForPkg(String ourPkgName, String ourLogFile) {
        previousPkgName = ourPkgName;
        previousLogFile = ourLogFile;
    }

    public void packageUploadSucceeded(Notification aNotification) {
        String ourPkgName;
        if (aNotification == null) {
            return;
        }
        String aPkgPath = (String)aNotification.getObject();
        if (aPkgPath == null || aPkgPath.length() == 0) {
            return;
        }
        String pkgNameFromNotification = NSPathUtilities.lastPathComponent(aPkgPath);
        if (!pkgNameFromNotification.equals(ourPkgName = this.itmsPackage().packageName())) {
            return;
        }
        AsperaTransport.deletePreviousLogFileForPkg(ourPkgName, logFileName);
        this.removeLogFile();
        this.setAsperaLogDirRegistryValueBackToOldValue();
        logFileName = null;
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.removeObserver(this);
    }

    public void packageUploadFailed(Notification aNotification) {
        String ourPkgName;
        if (aNotification == null) {
            return;
        }
        String aPkgPath = (String)aNotification.getObject();
        if (aPkgPath == null || aPkgPath.length() == 0) {
            return;
        }
        String pkgNameFromNotification = NSPathUtilities.lastPathComponent(aPkgPath);
        if (!pkgNameFromNotification.equals(ourPkgName = this.itmsPackage().packageName())) {
            return;
        }
        AsperaTransport.deletePreviousLogFileForPkg(ourPkgName, logFileName);
        if (logFileName != null && logFileName.length() > 0) {
            AsperaTransport.setPreviousLogFileForPkg(ourPkgName, logFileName);
            Logger.info("The apsera log file can be found at " + logFileName);
        }
        this.setAsperaLogDirRegistryValueBackToOldValue();
        logFileName = null;
        NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
        defaultCenter.removeObserver(this);
    }

    private boolean setupFaspMgr() {
        boolean setupSuccessful = false;
        try {
            this.setupAsperaEnvironment();
            faspMgr = FaspManager.getSingleton();
            this.faspManagerListener = new FaspManagerListener();
            faspMgr.addListener((TransferListener)this.faspManagerListener);
            String loggingLevel = this.defaultAsperaLoggingLevel();
            String asperaLoggingLevelOption = System.getProperty("asperaLoggingLevel");
            if (asperaLoggingLevelOption != null && asperaLoggingLevelOption.trim().length() > 0) {
                loggingLevel = asperaLoggingLevelOption;
                Logger.extreme("Using the aspera logging level of '" + asperaLoggingLevelOption + "' specified on the command line.");
            }
            faspMgr.setFaspDebug(AsperaLoggingLevelOption.isFaspDebugOn(loggingLevel));
            faspMgr.setFaspLoggingOff(AsperaLoggingLevelOption.isFaspLoggingOff(loggingLevel));
            setupSuccessful = true;
        }
        catch (FaspManagerException fme) {
            Logger.error("An error occurred while setting up the Aspera fasp manager.", fme);
            setupSuccessful = false;
        }
        return setupSuccessful;
    }

    private void tearDownFaspMgr() {
        if (faspMgr != null) {
            FaspManager.destroy();
            if (this.faspManagerListener != null) {
                faspMgr.removeListener((TransferListener)this.faspManagerListener);
                this.faspManagerListener = null;
            }
            faspMgr = null;
        }
    }

    @Override
    public void releaseResourcesPriorToFinalization() {
        if (this.itmsPackage() == null) {
            NotificationCenter defaultCenter = NotificationCenter.defaultCenter();
            defaultCenter.removeObserver(this);
        }
    }

    @Override
    public void setDefaultLoggingLevel(String value) {
        this.defaultAsperaLoggingLevel = value;
    }

    private String defaultAsperaLoggingLevel() {
        if (this.defaultAsperaLoggingLevel == null || this.defaultAsperaLoggingLevel.trim().length() == 0) {
            return defaultLoggingLevel;
        }
        if (!AsperaLoggingLevelOption.isValueNotFromCommandLineValid(this.defaultAsperaLoggingLevel)) {
            Logger.extreme("The aspera logging level value of '" + this.defaultAsperaLoggingLevel + "' from the soap service is not valid so it will not be used.");
            return defaultLoggingLevel;
        }
        return this.defaultAsperaLoggingLevel;
    }

    @Override
    public void setPodAssignmentInvocation(WebServiceInvoker.Invocation<Map> invocation) {
        this.podAssignmentInvocation = invocation;
    }

    private synchronized boolean didAssignmentFail() {
        return this.didAssignmentFail;
    }

    private synchronized boolean assignedToUpload() {
        if (this.isDiagnostic) {
            return true;
        }
        if (this.podAssigned != null) {
            return this.podAssigned;
        }
        if (this.podAssignmentInvocation == null) {
            return true;
        }
        Map returnValue = WebServiceInvoker.invokeWithRetry(this.podAssignmentInvocation);
        this.podAssigned = returnValue != null && !Application.doesContainSOAPError(returnValue);
        this.didAssignmentFail = this.podAssigned == false;
        return this.podAssigned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean performDiagnostic(boolean strict) {
        File tempFile = null;
        File tempDir = null;
        FileOutputStream tempFileOut = null;
        boolean wasDiagnostic = this.isLessStrictDiagnostic();
        try {
            File diagnosticFile;
            this.isDiagnostic = true;
            String diagnosticFileText = System.getProperty("diagnosticText", "hello world");
            this.setLessStrictDiagnostic(!strict);
            tempFile = File.createTempFile(UUID.randomUUID().toString(), "diagnostic");
            tempFile.delete();
            tempDir = new File(tempFile.getAbsolutePath().replaceFirst("diagnostic", "dir"));
            tempDir.mkdirs();
            tempFile = diagnosticFile = File.createTempFile(UUID.randomUUID().toString(), ".txt", tempDir);
            tempFileOut = new FileOutputStream(tempFile);
            IOUtils.write((String)diagnosticFileText, (OutputStream)tempFileOut);
            tempFileOut.close();
            tempFileOut = null;
            TransportUtil.splitDiagnosticPath(this.diagnosticPath, this);
            this.setPodAssignmentInvocation(null);
            boolean returnValue = true;
            for (String serverName : this.serverNames()) {
                Logger.extreme("  testing host/port: " + serverName + "/" + this.transportPort());
                this.setupFaspMgr();
                try {
                    if (!this.uploadPackageWithHostAndPort(serverName, this.transportPort(), Arrays.asList(tempFile))) {
                        returnValue = false;
                        continue;
                    }
                    if (strict) continue;
                    returnValue = true;
                    break;
                }
                finally {
                    this.tearDownFaspMgr();
                }
            }
            boolean bl = returnValue;
            return bl;
        }
        catch (IOException e) {
            Logger.error("Unable to create temp file for diagnostic", e);
        }
        finally {
            this.isDiagnostic = false;
            this.setLessStrictDiagnostic(wasDiagnostic);
            if (tempFileOut != null) {
                try {
                    tempFileOut.close();
                }
                catch (IOException e) {
                    Logger.error("problem closing temp file", e);
                }
            }
            if (tempFile != null && !tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            if (tempDir != null && !tempDir.delete()) {
                tempDir.deleteOnExit();
            }
        }
        return TransportUtil.performUnauthenticatedDiagnostic(TransportType.Aspera, strict);
    }

    public boolean shouldLogFailCode(int errorCode) {
        List<String> successCodes;
        return !this.isLessStrictDiagnostic() || !(successCodes = this.diagnosticSuccessErrorCodes()).contains(String.valueOf(errorCode));
    }

    private List<String> diagnosticSuccessErrorCodes() {
        String errorCodes = System.getProperty("diagnosticSuccessErrorCodes", "0,6,19,43");
        String[] errorCodeList = errorCodes.split(",");
        return Arrays.asList(errorCodeList);
    }

    @Override
    public void setDiagnosticPath(String diagnosticPath) {
        this.diagnosticPath = diagnosticPath;
    }

    static {
        throttleDefault = 150000;
    }

    class FaspManagerListener
    implements TransferListener {
        private final Map<String, FileInfo> fileInfoMap = new HashMap<String, FileInfo>();
        private SessionStats finalSession;
        private boolean aborted = false;

        FaspManagerListener() {
        }

        public Collection<FileInfo> getFileInfoList() {
            return this.fileInfoMap.values();
        }

        public synchronized SessionStats getFinalSession() {
            while (this.finalSession == null && !this.aborted && !AsperaTransport.this.didAssignmentFail()) {
                TransportUtil.needToWait(this, 1000L, "Waiting to check on file uploads.", true);
            }
            return this.finalSession;
        }

        public synchronized boolean wasAborted() {
            return this.aborted;
        }

        public synchronized void abort() {
            this.aborted = true;
            this.notifyAll();
        }

        private synchronized void setFinalSession(SessionStats session) {
            this.finalSession = session;
            this.notifyAll();
        }

        public void fileSessionEvent(TransferEvent event, SessionStats session, FileInfo fileinfo) {
            try {
                ProgressMonitor.heartbeat(AsperaTransport.this);
                if (session.getState() == SessionState.FAILED && AsperaTransport.this.shouldLogFailCode(session.getErrorCode())) {
                    Logger.error("The session's status is FAILED and the error description is '" + session.getErrorDescription() + " (" + session.getErrorCode() + ")'");
                }
                if (fileinfo != null) {
                    this.fileInfoMap.put(fileinfo.getName(), fileinfo);
                    if (event != TransferEvent.SESSION_STOP && event != TransferEvent.RATE_MODIFICATION && event != TransferEvent.SESSION_ERROR) {
                        if (event == TransferEvent.FILE_START) {
                            Logger.info("The upload of the file named " + fileinfo.getName() + " has started.");
                        }
                        TransportUtil.postFileHasBeenPartiallyUploadedNotification(fileinfo.getName(), fileinfo.getWrittenBytes(), fileinfo.getSizeBytes());
                        if (!AsperaTransport.this.assignedToUpload()) {
                            Logger.error("The iTunes Store is experiencing an internal server error. See http://www.apple.com/support/systemstatus/ for information about major outages.");
                        }
                        if (fileinfo.getState() == FileState.FAILED) {
                            Logger.error("The status is FAILED for the file named " + fileinfo.getName() + " and the error description is '" + fileinfo.getErrDescription() + " (" + fileinfo.getErrCode() + ")'");
                        } else if (fileinfo.getState() == FileState.FINISHED) {
                            Logger.info("The status is FINISHED for the file named " + fileinfo.getName() + ".");
                        }
                    }
                }
                if (session.getState() == SessionState.FINISHED || session.getState() == SessionState.FAILED || session.getState() == SessionState.CANCELED) {
                    this.setFinalSession(session);
                }
            }
            catch (RuntimeException re) {
                Logger.error("An error occurred while listening to the FaspManager.", re);
            }
        }
    }
}

